/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.TargetSelectors;

import java.util.HashSet;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractVector;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.TargetSelectors.ILocationSelector;
import net.elseland.xikage.MythicMobs.Util.RandomUtil;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ConeTargeter
extends ILocationSelector {
    protected double angle;
    protected double range;
    protected int points;
    protected double rotation;

    public ConeTargeter(MythicLineConfig mlc) {
        this.angle = mlc.getDouble(new String[]{"angle", "a"}, 90.0);
        this.range = mlc.getDouble(new String[]{"range", "r"}, 16.0);
        this.points = mlc.getInteger(new String[]{"points", ""}, (int)(this.angle * this.range / 10.0));
        this.rotation = mlc.getDouble(new String[]{"rotation", "rot"}, 0.0);
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        AbstractVector dir = data.getCaster().getLocation().getDirection();
        if (this.rotation > 0.0) {
            dir.rotate((float)this.rotation);
        }
        dir.setY(0);
        double cos = Math.cos(this.angle * Math.PI / 180.0);
        double cosSq = cos * cos;
        Location location = BukkitAdapter.adapt(data.getCaster().getLocation());
        for (int i = 0; i < this.points; ++i) {
            Vector vector = RandomUtil.getRandomVector().multiply(MythicMobs.r.nextDouble() * this.range);
            location.add(vector);
            AbstractVector relative = BukkitAdapter.adapt(location).subtract(data.getCaster().getLocation()).toVector();
            relative.setY(0);
            double dot = relative.getX() * dir.getX() + relative.getY() * dir.getY() + relative.getZ() * dir.getZ();
            double value = dot * dot / relative.lengthSquared();
            if (this.angle < 180.0 && dot > 0.0 && value >= cosSq) {
                targets.add(BukkitAdapter.adapt(location));
            } else if (this.angle >= 180.0 && (dot > 0.0 || dot <= cosSq)) {
                targets.add(BukkitAdapter.adapt(location));
            }
            location.subtract(vector);
        }
        return targets;
    }
}

