/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.elseland.xikage.MythicMobs.IO.IOHandler;
import net.elseland.xikage.MythicMobs.IO.IOLoader;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.LegacySkills.LegacyMythicSkill;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ActivateSpawnerSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ArrowVolleySkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.AtomEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.BaseDamageMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.BlockMaskEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.BlockUnmaskEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.CommandSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ConsumeSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.DNAEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.DamageSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.DelaySkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.DisguiseSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.DismountSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.DopplegangerSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.EjectPassengerSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.EnderBeamMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.EnderEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.EquipSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ExplosionEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ExplosionSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.FireworkEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.FlamesEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ForcePullSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.GCDSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.GeyserEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.HealPercentMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.HealSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.IgniteSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ItemSprayEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.JumpSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.LeapSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.LightningEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.LightningSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.LungeMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.MessageJSONMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.MessageSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.MissileSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ModifyGlobalScoreMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ModifyMobScoreMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ModifyScoreMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ModifyTargetScoreMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.MountSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.MountTargetSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ParticleBoxEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ParticleEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ParticleLineEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ParticleRingEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ParticleSphereEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ParticleTornadoEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.PoseArmorStandMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.PotionSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.PrisonSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ProjectileMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.PullSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.PushButtonSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.RallySkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.RandomMessageSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.RandomSkillSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.RemountMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.RemoveSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.RunAIGoalSelectorSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.RunAITargetSelectorSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SendActionMessageSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SendTitleSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SetGlidingMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SetGlobalScoreMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SetHealthSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SetLevelSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SetMaxHealthSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SetMobScoreMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SetOwnerMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SetScoreMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SetStanceMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SetTargetScoreMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ShootFireballSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ShootMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ShootPotionSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ShootSkullSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SignalSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SkillSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SkyboxEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SmokeEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SmokeSwirlEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SoundEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SpinEffect;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SpringSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SudoSkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SuicideSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SummonSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.TeleportSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.TeleportToSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ThreatSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ThrowSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ToggleLeverSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.TotemSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.VelocitySkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.VolleyMechanic;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.WeatherSkill;
import net.elseland.xikage.MythicMobs.Skills.Skill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;

public class SkillManager {
    private List<File> skillFiles;
    private IOLoader defaultSkills;
    private List<IOLoader> skillLoaders;
    private ConcurrentHashMap<String, Skill> skills = new ConcurrentHashMap();
    private List<Runnable> secondPass = new ArrayList<Runnable>();

    public void loadSkills() {
        this.defaultSkills = new IOLoader(MythicMobs.inst(), "ExampleSkills.yml", "Skills");
        this.skillFiles = IOHandler.getAllFiles(this.defaultSkills.thefile.getParent());
        this.skillLoaders = IOHandler.getSaveLoad(this.skillFiles, "Skills");
        this.skills.clear();
        for (IOLoader sl : this.skillLoaders) {
            for (String name : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                MythicConfig mc = new MythicConfig(name, sl.getCustomConfig());
                Skill ms = new Skill(name, mc);
                this.skills.put(name, ms);
                if (sl.getCustomConfig().getStringList(name + ".LegacySkills") == null) continue;
                double cooldown = sl.getCustomConfig().getDouble(name + ".Cooldown");
                String file = sl.thefile.getName();
                List list = sl.getCustomConfig().getStringList(name + ".LegacySkills");
                List conditions = sl.getCustomConfig().getStringList(name + ".Conditions");
                MythicMobs.inst().listLegacySkills.add(new LegacyMythicSkill(name, file, list, cooldown, conditions));
            }
        }
        this.runSecondPass();
    }

    public void runSecondPass() {
        MythicMobs.debug(1, "Doing second pass on " + this.secondPass.size() + " skills.");
        this.secondPass.forEach(r -> r.run());
        this.secondPass.clear();
    }

    public void queueSecondPass(Runnable r) {
        this.secondPass.add(r);
    }

    public Optional<Skill> getSkill(String internalName) {
        if (internalName != null && this.skills.containsKey(internalName)) {
            return Optional.of(this.skills.get(internalName));
        }
        return Optional.empty();
    }

    public Collection<Skill> getSkills() {
        return this.skills.values();
    }

    public SkillMechanic getSkillMechanic(String skill) {
        MythicMobs.debug(2, "Getting MythicSkill for string: " + skill);
        if (skill.contains("}")) {
            String ns;
            String sp2;
            String sp1;
            if (skill.contains("@")) {
                if (skill.substring(0, skill.indexOf("@")).contains("}")) {
                    sp1 = skill.substring(0, skill.indexOf("}"));
                    sp2 = skill.substring(skill.indexOf("}"));
                    skill = ns = sp1.replace(" ", "") + sp2;
                }
            } else {
                sp1 = skill.substring(0, skill.indexOf("}"));
                sp2 = skill.substring(skill.indexOf("}"));
                skill = ns = sp1.replace(" ", "") + sp2;
            }
            MythicMobs.debug(2, "-- Normalized skill string to: " + skill);
        }
        String[] s = skill.split(" ");
        String name = null;
        MythicLineConfig mlc = new MythicLineConfig(s[0]);
        name = s[0].contains("{") ? s[0].substring(0, s[0].indexOf("{")) : s[0];
        MythicMobs.debug(3, "-- Matching MythicSkill type to " + name.toUpperCase());
        try {
            switch (name.toUpperCase()) {
                case "SKILL": 
                case "META": {
                    return new SkillSkill(skill, mlc);
                }
                case "SUDOSKILL": 
                case "SUDO": {
                    return new SudoSkillMechanic(skill, mlc);
                }
                case "PROJECTILE": 
                case "P": {
                    return new ProjectileMechanic(skill, mlc);
                }
                case "TOTEME": 
                case "T": {
                    return new TotemSkill(skill, mlc);
                }
                case "DELAY": {
                    return new DelaySkill(skill, mlc);
                }
                case "ACTIVATESPAWNER": 
                case "AS": {
                    return new ActivateSpawnerSkill(skill, mlc);
                }
                case "ARROWVOLLEY": {
                    return new ArrowVolleySkill(skill, mlc);
                }
                case "BASEDAMAGE": 
                case "WEAPONDAMAGE": 
                case "BD": 
                case "WD": {
                    return new BaseDamageMechanic(skill, mlc);
                }
                case "COMMAND": 
                case "CMD": {
                    return new CommandSkill(skill, mlc);
                }
                case "CONSUME": {
                    return new ConsumeSkill(skill, mlc);
                }
                case "DAMAGE": 
                case "D": {
                    return new DamageSkill(skill, mlc);
                }
                case "DISGUISE": {
                    return new DisguiseSkill(skill, mlc);
                }
                case "DOPPLEGANGER": 
                case "COPYPLAYER": {
                    return new DopplegangerSkill(skill, mlc);
                }
                case "DISMOUNT": {
                    return new DismountSkill(skill, mlc);
                }
                case "EJECT_PASSENGER": 
                case "EJECTPASSENGER": {
                    return new EjectPassengerSkill(skill, mlc);
                }
                case "EQUIP": {
                    return new EquipSkill(skill, mlc);
                }
                case "EXPLOSION": 
                case "EXPLODE": {
                    return new ExplosionSkill(skill, mlc);
                }
                case "FORCEPULL": {
                    return new ForcePullSkill(skill, mlc);
                }
                case "GCD": 
                case "SETGCD": 
                case "GLOBALCOOLDOWN": 
                case "SETGLOBALCOOLDOWN": {
                    return new GCDSkill(skill, mlc);
                }
                case "HEAL": 
                case "H": {
                    return new HealSkill(skill, mlc);
                }
                case "HEALPERCENT": 
                case "HP": {
                    return new HealPercentMechanic(skill, mlc);
                }
                case "IGNITE": {
                    return new IgniteSkill(skill, mlc);
                }
                case "JUMP": {
                    return new JumpSkill(skill, mlc);
                }
                case "LEAP": {
                    return new LeapSkill(skill, mlc);
                }
                case "LIGHTNING": {
                    return new LightningSkill(skill, mlc);
                }
                case "LUNGE": {
                    return new LungeMechanic(skill, mlc);
                }
                case "MESSAGE": 
                case "MSG": 
                case "M": {
                    return new MessageSkill(skill, mlc);
                }
                case "MESSAGEJSON": 
                case "JSONMESSAGE": 
                case "JMSG": 
                case "JM": {
                    return new MessageJSONMechanic(skill, mlc);
                }
                case "MISSILE": 
                case "MI": {
                    return new MissileSkill(skill, mlc);
                }
                case "MODIFYGLOBALSCORE": 
                case "MGS": {
                    return new ModifyGlobalScoreMechanic(skill, mlc);
                }
                case "MODIFYMOBSCORE": 
                case "MMS": {
                    return new ModifyMobScoreMechanic(skill, mlc);
                }
                case "MODIFYTARGETSCORE": 
                case "MTS": {
                    return new ModifyTargetScoreMechanic(skill, mlc);
                }
                case "MOUNT": {
                    return new MountSkill(skill, mlc);
                }
                case "MOUNTTARGET": 
                case "MOUNTPLAYER": {
                    return new MountTargetSkill(skill, mlc);
                }
                case "REMOUNT": {
                    return new RemountMechanic(skill, mlc);
                }
                case "POSEARMORSTAND": 
                case "ARMORSTANDPOSE": {
                    return new PoseArmorStandMechanic(skill, mlc);
                }
                case "POTION": {
                    return new PotionSkill(skill, mlc);
                }
                case "PRISON": {
                    return new PrisonSkill(skill, mlc);
                }
                case "PULL": {
                    return new PullSkill(skill, mlc);
                }
                case "PUSHBUTTON": {
                    return new PushButtonSkill(skill, mlc);
                }
                case "RALLY": {
                    return new RallySkill(skill, mlc);
                }
                case "RANDOMMESSAGE": 
                case "RANDOMMSG": 
                case "RM": {
                    return new RandomMessageSkill(skill, mlc);
                }
                case "RANDOMSKILL": {
                    return new RandomSkillSkill(skill, mlc);
                }
                case "REMOVE": {
                    return new RemoveSkill(skill, mlc);
                }
                case "RUNAIGOALSELECTOR": {
                    return new RunAIGoalSelectorSkill(skill, mlc);
                }
                case "RUNAITARGETSELECTOR": {
                    return new RunAITargetSelectorSkill(skill, mlc);
                }
                case "SENDACTIONMESSAGE": 
                case "ACTIONMESSAGE": 
                case "AM": {
                    return new SendActionMessageSkill(skill, mlc);
                }
                case "SENDTITLE": 
                case "TITLE": {
                    return new SendTitleSkill(skill, mlc);
                }
                case "SETHEALTH": 
                case "SETHP": {
                    return new SetHealthSkill(skill, mlc);
                }
                case "SETMAXHEALTH": 
                case "SETMAXHP": {
                    return new SetMaxHealthSkill(skill, mlc);
                }
                case "SETLEVEL": 
                case "MODIFYLEVEL": {
                    return new SetLevelSkill(skill, mlc);
                }
                case "SCORE": 
                case "MODIFYSCORE": {
                    return new ModifyScoreMechanic(skill, mlc);
                }
                case "SETSCORE": {
                    return new SetScoreMechanic(skill, mlc);
                }
                case "SETGLIDING": {
                    return new SetGlidingMechanic(skill, mlc);
                }
                case "SETGLOBALSCORE": 
                case "SGS": {
                    return new SetGlobalScoreMechanic(skill, mlc);
                }
                case "SETMOBSCORE": 
                case "SMS": {
                    return new SetMobScoreMechanic(skill, mlc);
                }
                case "SETOWNER": {
                    return new SetOwnerMechanic(skill, mlc);
                }
                case "SETTARGETSCORE": 
                case "STS": {
                    return new SetTargetScoreMechanic(skill, mlc);
                }
                case "SETSTANCE": 
                case "STANCE": {
                    return new SetStanceMechanic(skill, mlc);
                }
                case "SHOOTFIREBALL": 
                case "FIREBALL": {
                    return new ShootFireballSkill(skill, mlc);
                }
                case "SHOOTPOTION": {
                    return new ShootPotionSkill(skill, mlc);
                }
                case "SHOOTPROJECTILE": 
                case "SHOOT": {
                    return new ShootMechanic(skill, mlc);
                }
                case "SHOOTSKULL": 
                case "SKULL": 
                case "WITHERSKULL": {
                    return new ShootSkullSkill(skill, mlc);
                }
                case "SIGNAL": 
                case "SENDSIGNAL": {
                    return new SignalSkill(skill, mlc);
                }
                case "SPRING": 
                case "WATER": {
                    return new SpringSkill(skill, mlc);
                }
                case "SUICIDE": {
                    return new SuicideSkill(skill, mlc);
                }
                case "SUMMON": 
                case "SPAWNMOBS": {
                    return new SummonSkill(skill, mlc);
                }
                case "TELEPORT": 
                case "TP": {
                    return new TeleportSkill(skill, mlc);
                }
                case "TELEPORTTO": 
                case "TPT": 
                case "TELEPORTLOCATION": 
                case "TPL": {
                    return new TeleportToSkill(skill, mlc);
                }
                case "THREATCHANGE": 
                case "THREATMOD": 
                case "THREAT": {
                    return new ThreatSkill(skill, mlc);
                }
                case "THROW": {
                    return new ThrowSkill(skill, mlc);
                }
                case "TOGGLELEVER": 
                case "LEVER": {
                    return new ToggleLeverSkill(skill, mlc);
                }
                case "VELOCITY": {
                    return new VelocitySkill(skill, mlc);
                }
                case "VOLLEY": {
                    return new VolleyMechanic(skill, mlc);
                }
                case "WEATHER": {
                    return new WeatherSkill(skill, mlc);
                }
                case "EFFECT:BLOCKMASK": 
                case "E:BLOCKMASK": {
                    return new BlockMaskEffect(skill, mlc);
                }
                case "EFFECT:BLOCKUNMASK": 
                case "E:BLOCKUNMASK": {
                    return new BlockUnmaskEffect(skill, mlc);
                }
                case "EFFECT:ENDER": 
                case "ENDER": 
                case "E:ENDER": {
                    return new EnderEffect(skill, mlc);
                }
                case "EFFECT:ENDERBEAM": 
                case "ENDERBEAM": {
                    return new EnderBeamMechanic(skill, mlc);
                }
                case "EFFECT:EXPLOSION": 
                case "E:EXPLOSION": {
                    return new ExplosionEffect(skill, mlc);
                }
                case "EFFECT:FIREWORK": 
                case "E:FIREWORK": 
                case "FIREWORK": {
                    return new FireworkEffect(skill, mlc);
                }
                case "EFFECT:FLAMES": 
                case "E:FLAMES": {
                    return new FlamesEffect(skill, mlc);
                }
                case "EFFECT:GEYSER": 
                case "E:GEYSER": 
                case "GEYSER": {
                    return new GeyserEffect(skill, mlc);
                }
                case "EFFECT:LIGHTNING": 
                case "E:LIGHTNING": {
                    return new LightningEffect(skill, mlc);
                }
                case "EFFECT:ITEMSPRAY": 
                case "E:ITEMSPRAY": 
                case "ITEMSPRAY": {
                    return new ItemSprayEffect(skill, mlc);
                }
                case "EFFECT:PARTICLES": 
                case "PARTICLES": 
                case "E:PARTICLES": 
                case "E:P": {
                    return new ParticleEffect(skill, mlc);
                }
                case "EFFECT:PARTICLEBOX": 
                case "PARTICLEBOX": 
                case "E:PB": 
                case "PB": {
                    return new ParticleBoxEffect(skill, mlc);
                }
                case "EFFECT:PARTICLELINE": 
                case "PARTICLELINE": 
                case "E:PL": 
                case "PL": {
                    return new ParticleLineEffect(skill, mlc);
                }
                case "EFFECT:PARTICLERING": 
                case "PARTICLERING": 
                case "E:PR": 
                case "PR": {
                    return new ParticleRingEffect(skill, mlc);
                }
                case "EFFECT:PARTICLESPHERE": 
                case "PARTICLESPHERE": 
                case "E:PS": 
                case "PS": {
                    return new ParticleSphereEffect(skill, mlc);
                }
                case "EFFECT:PARTICLETORNADO": 
                case "PARTICLETORNADO": 
                case "E:PT": {
                    return new ParticleTornadoEffect(skill, mlc);
                }
                case "EFFECT:SKYBOX": 
                case "E:SKYBOX": {
                    return new SkyboxEffect(skill, mlc);
                }
                case "EFFECT:SMOKE": 
                case "E:SMOKE": {
                    return new SmokeEffect(skill, mlc);
                }
                case "EFFECT:SMOKESWIRL": 
                case "E:SMOKESWIRL": {
                    return new SmokeSwirlEffect(skill, mlc);
                }
                case "EFFECT:SOUND": 
                case "SOUND": 
                case "E:S": 
                case "S": {
                    return new SoundEffect(skill, mlc);
                }
                case "EFFECT:SPIN": 
                case "E:SPIN": 
                case "SPIN": {
                    return new SpinEffect(skill, mlc);
                }
                case "EFFECT:ATOM": 
                case "ATOM": 
                case "E:ATOM": {
                    return new AtomEffect(skill, mlc);
                }
                case "EFFECT:DNA": 
                case "DNA": 
                case "E:DNA": {
                    return new DNAEffect(skill, mlc);
                }
            }
            return null;
        }
        catch (Exception ex) {
            MythicMobs.error("Bad syntax! Failed to load skill line: " + skill);
            if (Configuration.debugLevel > 0) {
                ex.printStackTrace();
            }
            return null;
        }
    }
}

