/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.INoTargetSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;

public class WeatherSkill
extends SkillMechanic
implements INoTargetSkill {
    int type;
    int duration;

    public WeatherSkill(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        String t = mlc.getString("type", "sunny");
        this.duration = mlc.getInteger("duration", 500);
        switch (t) {
            case "sunny": 
            case "sun": 
            case "clear": {
                this.type = 0;
                break;
            }
            case "rain": 
            case "rainy": {
                this.type = 1;
                break;
            }
            case "stormy": 
            case "storm": 
            case "thunder": {
                this.type = 2;
                break;
            }
            default: {
                this.type = 0;
            }
        }
    }

    @Override
    public boolean cast(SkillMetadata data) {
        switch (this.type) {
            case 0: {
                data.getCaster().getEntity().getWorld().setStorm(true);
                break;
            }
            case 1: {
                data.getCaster().getEntity().getWorld().setStorm(true);
                data.getCaster().getEntity().getWorld().setThundering(false);
                break;
            }
            case 2: {
                data.getCaster().getEntity().getWorld().setStorm(true);
                data.getCaster().getEntity().getWorld().setThundering(true);
            }
        }
        data.getCaster().getEntity().getWorld().setWeatherDuration(this.duration);
        return true;
    }
}

