/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.util.HashSet;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Mobs.GenericCaster;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.SkillSkill;
import net.elseland.xikage.MythicMobs.Skills.Skill;
import net.elseland.xikage.MythicMobs.Skills.SkillCaster;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.SkillTargeter;
import net.elseland.xikage.MythicMobs.Skills.TargetSelectors.IEntitySelector;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SudoSkillMechanic
extends SkillSkill {
    private boolean casterAsTrigger = false;

    public SudoSkillMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.casterAsTrigger = mlc.getBoolean(new String[]{"setcasterastrigger", "cat"}, false);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        SkillTargeter targeter;
        HashSet<AbstractEntity> targets = data.getEntityTargets();
        if (this.targeter.isPresent() && (targeter = (SkillTargeter)this.targeter.get()) instanceof IEntitySelector) {
            targets = ((IEntitySelector)targeter).getEntities(data);
            ((IEntitySelector)targeter).filter(data, this.targetsCreativePlayers());
        }
        if (targets == null || targets.size() == 0) {
            return false;
        }
        for (AbstractEntity target : targets) {
            SkillCaster caster = MythicMobs.inst().getMobManager().isActiveMob(target) ? MythicMobs.inst().getMobManager().getMythicMobInstance(target) : new GenericCaster(target);
            final SkillMetadata newData = data.deepClone();
            newData.setCaster(caster);
            if (this.casterAsTrigger) {
                newData.setTrigger(data.getCaster().getEntity());
            }
            if (!this.metaskill.isPresent()) continue;
            final Skill ms = (Skill)this.metaskill.get();
            if (ms.isUsable(newData)) {
                MythicMobs.debug(3, "------ Executing SudoSkill " + this.skillName);
                if (this.forceSync) {
                    newData.setIsAsync(false);
                    new BukkitRunnable(){

                        public void run() {
                            newData.setIsAsync(false);
                            ms.execute(newData);
                        }
                    }.runTask((Plugin)MythicMobs.inst());
                    continue;
                }
                ms.execute(newData);
                continue;
            }
            MythicMobs.debug(3, "------ Skill is not usable at this time! Cancelling.");
            return false;
        }
        return true;
    }
}

