/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Adapters.TaskManager;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillCaster;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class SpringSkill
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private int tickDuration;
    private Material type;

    public SpringSkill(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.tickDuration = mlc.getInteger(new String[]{"duration", "d"}, 40);
        String strType = mlc.getString(new String[]{"type", "t"}, "water", new String[0]);
        this.type = strType.equalsIgnoreCase("lava") ? Material.LAVA : (strType.equalsIgnoreCase("water") ? Material.WATER : Material.WATER);
        if (this.tickDuration <= 0) {
            this.tickDuration = 10;
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data.getCaster(), target);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data.getCaster(), target.getLocation());
        return true;
    }

    protected void playEffect(SkillCaster am, AbstractLocation target) {
        Block block = BukkitAdapter.adapt(target).getBlock();
        if (block.getType() == Material.AIR) {
            block.setType(this.type, true);
            new Animator(target);
        }
    }

    private class Animator
    implements Runnable {
        private AbstractLocation location;

        public Animator(AbstractLocation location) {
            this.location = location;
            TaskManager.get().runLater(this, SpringSkill.this.tickDuration);
        }

        @Override
        public void run() {
            block2: {
                try {
                    BukkitAdapter.adapt(this.location).getBlock().setType(Material.AIR, true);
                }
                catch (Exception ex) {
                    if (Configuration.debugLevel <= 0) break block2;
                    ex.printStackTrace();
                }
            }
        }
    }
}

