/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class SmokeSwirlEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected int duration;
    protected int interval;

    public SmokeSwirlEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.duration = mlc.getInteger("duration", 5);
        this.duration = mlc.getInteger("d", this.duration);
        this.interval = mlc.getInteger("interval", 1);
        this.interval = mlc.getInteger("i", this.interval);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        new Animator(BukkitAdapter.adapt(target), this.interval, this.duration);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(BukkitAdapter.adapt(target), this.interval, this.duration);
        return false;
    }

    private class Animator
    implements Runnable {
        private Entity entity;
        private Location location;
        private int interval;
        private int duration;
        private int iteration;
        private int taskId;
        private int[] x = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
        private int[] z = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
        private int[] v = new int[]{7, 6, 3, 0, 1, 2, 5, 8};

        public Animator(Location location, int interval, int duration) {
            this(interval, duration);
            this.location = location;
        }

        public Animator(Entity entity, int interval, int duration) {
            this(interval, duration);
            this.entity = entity;
        }

        protected Animator(int interval, int duration) {
            this.interval = interval;
            this.duration = duration;
            this.iteration = 0;
            this.taskId = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)MythicMobs.plugin, (Runnable)this, 0L, (long)interval);
        }

        @Override
        public void run() {
            if (this.iteration * this.interval > this.duration) {
                Bukkit.getScheduler().cancelTask(this.taskId);
            } else {
                int i = this.iteration % 8;
                Location loc = this.location != null ? this.location : this.entity.getLocation();
                loc.getWorld().playEffect(loc.clone().add((double)this.x[i], 0.0, (double)this.z[i]), Effect.SMOKE, this.v[i]);
                ++this.iteration;
            }
        }
    }
}

