/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.util.Optional;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.IMetaSkill;
import net.elseland.xikage.MythicMobs.Skills.Skill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkillSkill
extends SkillMechanic
implements IMetaSkill {
    protected String skillName;
    protected Optional<Skill> metaskill;
    protected boolean forceSync;

    public SkillSkill(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.target_creative = true;
        this.skillName = mlc.getString(new String[]{"skill", "s", "meta", "s"});
        this.forceSync = mlc.getBoolean(new String[]{"forcesync", "sync"}, false);
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            MythicMobs.debug(3, "-- Loading SkillSkill pointing at " + this.skillName);
            this.metaskill = MythicMobs.inst().getSkillManager().getSkill(this.skillName);
            if (!this.metaskill.isPresent()) {
                MythicMobs.error("Could not find AbstractSkill " + this.skillName);
            } else {
                MythicMobs.debug(3, "---- Loaded SkillSkill successfully");
            }
        });
    }

    @Override
    public boolean cast(final SkillMetadata data) {
        if (this.metaskill.isPresent()) {
            final Skill ms = this.metaskill.get();
            if (ms.isUsable(data)) {
                MythicMobs.debug(3, "------ Executing Skill " + this.skillName);
                if (this.forceSync) {
                    data.setIsAsync(false);
                    new BukkitRunnable(){

                        public void run() {
                            data.setIsAsync(false);
                            ms.execute(data);
                        }
                    }.runTask((Plugin)MythicMobs.inst());
                } else {
                    ms.execute(data);
                }
            } else {
                MythicMobs.debug(3, "------ Skill is not usable at this time! Cancelling.");
                return false;
            }
        }
        return true;
    }
}

