/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.PotionSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.projectiles.ProjectileSource;

public class ShootPotionSkill
extends PotionSkill
implements ITargetedEntitySkill {
    protected float velocity;

    public ShootPotionSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.velocity = mlc.getFloat("velocity", 1.0f);
        this.velocity = mlc.getFloat("v", this.velocity);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        ItemStack potion = new ItemStack(Material.SPLASH_POTION);
        PotionMeta pm = (PotionMeta)potion.getItemMeta();
        pm.addCustomEffect(this.effect, true);
        potion.setItemMeta((ItemMeta)pm);
        Projectile projectile = ((LivingEntity)data.getCaster().getEntity()).launchProjectile(ThrownPotion.class);
        ((ThrownPotion)projectile).setItem(potion);
        projectile.setVelocity(BukkitAdapter.adapt(data.getCaster().getEntity()).getLocation().getDirection().multiply(this.velocity));
        projectile.setBounce(false);
        projectile.setShooter((ProjectileSource)((LivingEntity)data.getCaster().getEntity()));
        return true;
    }
}

