/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.util.HashSet;
import java.util.List;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicEntity;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RallySkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected double hRadius;
    protected double vRadius;
    protected boolean overwriteTarget;
    HashSet<MythicMob> mmTypes = new HashSet();
    HashSet<MythicEntity> meTypes = new HashSet();

    public RallySkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.hRadius = mlc.getDouble("radius", 10.0);
        this.vRadius = mlc.getDouble("radius", 10.0);
        this.hRadius = mlc.getDouble("r", this.hRadius);
        this.vRadius = mlc.getDouble("r", this.vRadius);
        this.hRadius = mlc.getDouble("hradius", this.hRadius);
        this.vRadius = mlc.getDouble("vradius", this.vRadius);
        this.overwriteTarget = mlc.getBoolean(new String[]{"overwritetarget, ot"}, true);
        String typeString = mlc.getString(new String[]{"types", "type", "t"});
        final String[] types = typeString.split(",");
        final RallySkill THIS = this;
        new BukkitRunnable(){

            public void run() {
                for (String s : types) {
                    MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(s);
                    if (mm != null) {
                        THIS.mmTypes.add(mm);
                        continue;
                    }
                    MythicEntity me = MythicEntity.getMythicEntity(s);
                    if (me != null) {
                        THIS.meTypes.add(me);
                        continue;
                    }
                    MythicMobs.skillConfigError("RALLY", s, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
                }
            }
        }.runTaskLater((Plugin)MythicMobs.plugin, 1L);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        List moblist = data.getCaster().getEntity().getBukkitEntity().getNearbyEntities(this.hRadius, this.vRadius, this.hRadius);
        block0: for (Entity e : moblist) {
            if (!(e instanceof LivingEntity)) continue;
            ActiveMob amx = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(e));
            if (amx != null && this.mmTypes.contains(amx.getType())) {
                if (!this.overwriteTarget && amx.hasTarget()) continue;
                amx.setTarget(target);
                continue;
            }
            for (MythicEntity me : this.meTypes) {
                if (!me.compare(e)) continue;
                MythicMobs.plugin.volatileCodeHandler.setTarget((LivingEntity)e, (LivingEntity)BukkitAdapter.adapt(target));
                continue block0;
            }
        }
        return true;
    }
}

