/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.SkillString;

public class MessageSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected String message;

    public MessageSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        this.message = mlc.getString("message");
        this.message = mlc.getString("msg", this.message);
        this.message = mlc.getString("m", this.message);
        try {
            this.message = this.message.substring(1, this.message.length() - 1);
        }
        catch (Exception ex) {
            MythicMobs.skillConfigError("MESSAGE", line, "The 'message' attribute is required.");
            this.message = "INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.";
            MythicMobs.plugin.handleException(ex);
        }
        MythicMobs.debug(2, "Loaded message skill with message " + this.message);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        MythicMobs.debug(2, "Executing message skill with message: " + this.message);
        String m = SkillString.parseMobVariables(this.message, data.getCaster(), target, data.getTrigger());
        if (target.isPlayer()) {
            target.asPlayer().sendMessage(m);
            return true;
        }
        return false;
    }
}

