/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.SkillAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;

public class LightningEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected boolean localized;
    protected double localizedRadius = 128.0;

    public LightningEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.localized = mlc.getBoolean(new String[]{"localized", "l"}, false);
        this.localizedRadius = mlc.getDouble(new String[]{"localizedradius", "lr", "r"}, 128.0);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (this.localized) {
            MythicMobs.inst().getVolatileCodeHandler().playLocalizedLightningEffect(target, this.localizedRadius);
        } else {
            SkillAdapter.get().strikeLightningEffect(target);
        }
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }
}

