/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.SkillAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Items.MythicItem;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.inventory.ItemStack;

public class ItemSprayEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected String itemName;
    protected ItemStack item = null;
    protected int amount;
    protected int duration;
    protected double radius;
    protected double force;
    protected double yForce;
    protected double yOffset;
    protected boolean allowPickup;

    public ItemSprayEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.itemName = mlc.getString(new String[]{"item", "i"}, "iron_sword", new String[0]);
        this.amount = mlc.getInteger(new String[]{"amount", "a"}, 10);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 20);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 0.0);
        this.force = mlc.getDouble("force", 1.0);
        this.force = mlc.getDouble("f", this.force);
        this.force = mlc.getDouble("velocity", this.force);
        this.force = mlc.getDouble("v", this.force);
        this.yForce = mlc.getDouble("yforce", this.force);
        this.yForce = mlc.getDouble("yf", this.yForce);
        this.yForce = mlc.getDouble("yvelocity", this.yForce);
        this.yForce = mlc.getDouble("yv", this.yForce);
        this.yOffset = mlc.getDouble("yoffset", 1.0);
        this.yOffset = mlc.getDouble("y", this.yOffset);
        this.allowPickup = mlc.getBoolean(new String[]{"allowpickup", "ap"}, false);
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            this.item = MythicItem.getMythicItemStack(this.itemName);
        });
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(target.getLocation());
        return false;
    }

    protected void playEffect(AbstractLocation l) {
        if (this.item == null) {
            this.item = MythicItem.getMythicItemStack(this.itemName);
        }
        SkillAdapter.get().itemSprayEffect(l, this.item, this.amount, this.duration, this.force, this.yForce, this.radius, this.yOffset, this.allowPickup);
    }
}

