/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.util.ArrayList;
import java.util.List;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Adapters.TaskManager;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class BlockUnmaskEffect
extends SkillMechanic
implements ITargetedLocationSkill {
    private Material mat;
    private int radius;
    private boolean sphere;
    private boolean noAir;
    private int radiusSq;

    public BlockUnmaskEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.radius = mlc.getInteger(new String[]{"radius", "r"}, 0);
        String shape = mlc.getString(new String[]{"shape", "s"}, "SPHERE", new String[0]).toUpperCase();
        this.sphere = shape.equals("SPHERE");
        if (this.radius < 0) {
            this.radius = 0;
        }
        this.radiusSq = this.radius * this.radius;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return true;
    }

    public void playEffect(final AbstractLocation location) {
        TaskManager.get().runAsync(new Runnable(){

            @Override
            public void run() {
                Location l = BukkitAdapter.adapt(location);
                if (BlockUnmaskEffect.this.radius == 0) {
                    for (Player p : l.getWorld().getPlayers()) {
                        p.sendBlockChange(l, l.getBlock().getType(), l.getBlock().getData());
                    }
                } else {
                    for (Location ll : BlockUnmaskEffect.this.getBlocksInRadius(l)) {
                        for (Player p : l.getWorld().getPlayers()) {
                            p.sendBlockChange(ll, ll.getBlock().getType(), ll.getBlock().getData());
                        }
                    }
                }
            }
        });
    }

    private List<Location> getBlocksInRadius(Location l) {
        ArrayList<Location> blocks = new ArrayList<Location>();
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int y = -this.radius; y <= this.radius; ++y) {
                for (int z = -this.radius; z <= this.radius; ++z) {
                    Location newloc = new Location(l.getWorld(), l.getX() + (double)x, l.getY() + (double)y, l.getZ() + (double)z);
                    if (this.sphere && l.distanceSquared(newloc) > (double)this.radiusSq) continue;
                    if (this.noAir && !newloc.getBlock().getType().equals((Object)Material.AIR)) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.noAir) continue;
                    blocks.add(newloc);
                }
            }
        }
        return blocks;
    }
}

