/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.RandomSpawning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractPlayer;
import net.elseland.xikage.MythicMobs.Adapters.AbstractWorld;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.RandomSpawning.RandomSpawnGenerator;
import net.elseland.xikage.MythicMobs.RandomSpawning.RandomSpawnPoint;
import net.elseland.xikage.MythicMobs.RandomSpawning.RandomSpawner;
import net.elseland.xikage.MythicMobs.Util.BlockUtil;
import org.bukkit.Location;

public class RandomSpawnerManager {
    public Set<RandomSpawnPoint> landSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> airSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> seaSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> lavaSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> groundSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<ActiveMob> randomlySpawnedMobs = Collections.newSetFromMap(new ConcurrentHashMap());
    RandomPointGeneratorLand generatorLand;

    public RandomSpawnerManager() {
        if (Configuration.generateRSPoints() && Configuration.getRSPointsPerSecondLand() > 0) {
            this.generatorLand = new RandomPointGeneratorLand();
        }
    }

    public void reload() {
        if (this.generatorLand != null) {
            this.generatorLand.stop();
        }
        if (Configuration.generateRSPoints() && Configuration.getRSPointsPerSecondLand() > 0) {
            this.generatorLand = new RandomPointGeneratorLand();
        }
    }

    public void shutdown() {
        if (this.generatorLand != null) {
            this.generatorLand.stop();
        }
    }

    public void spawnMobs() {
        this.landSpawnPoints.forEach(rsp -> this.doSpawns((RandomSpawnPoint)rsp));
        this.landSpawnPoints.clear();
    }

    public void doSpawns(RandomSpawnPoint rsp) {
        if (rsp == null) {
            return;
        }
        for (RandomSpawner RS : MythicMobs.plugin.listRandomSpawningA) {
            if (!RS.checkSpawn(rsp) || !RS.isValid()) continue;
            RS.spawn(rsp);
            return;
        }
    }

    public int getMobsNearPlayer(AbstractPlayer p) {
        int i = 0;
        int spawnRadius = (int)Math.pow(Configuration.getRSPlayerRadius(), 2.0);
        for (AbstractEntity e : MythicMobs.inst().getEntityManager().getLivingEntities(p.getLocation().getWorld())) {
            if (!(e.getLocation().distanceSquared(p.getLocation()) <= (double)spawnRadius)) continue;
            ++i;
        }
        return i;
    }

    public boolean isChunkLoaded(AbstractWorld world, int x, int z) {
        return MythicMobs.inst().getWorldManager().isChunkLoaded(world, x, z);
    }

    public Set<RandomSpawnPoint> getLandSpawnPoints() {
        return this.landSpawnPoints;
    }

    public class RandomPointGeneratorLand
    extends RandomSpawnGenerator {
        private final List<AbstractPlayer> players = new ArrayList<AbstractPlayer>();

        @Override
        public void generateSpawnPoints() {
            if (MythicMobs.inst().getEntityManager().getPlayers().size() <= 0) {
                return;
            }
            long startTime = System.currentTimeMillis();
            this.players.clear();
            this.players.addAll(MythicMobs.inst().getEntityManager().getPlayers());
            Collections.shuffle(this.players);
            int n = 0;
            long time = System.currentTimeMillis();
            boolean good = true;
            try {
                for (AbstractPlayer player : this.players) {
                    if (player.isInCreativeMode()) continue;
                    if (System.currentTimeMillis() - startTime <= (long)Configuration.getRSMaxGenerationTimeMillis()) {
                        for (int i = 0; i < Configuration.getRSPointsPerSecondLand(); ++i) {
                            RandomSpawnPoint point = this.findPointNearPlayer(player);
                            if (point == null) continue;
                            Iterator<RandomSpawner> it = MythicMobs.plugin.listRandomSpawningD.iterator();
                            good = true;
                            while (it.hasNext()) {
                                RandomSpawner RS = it.next();
                                if (!RS.checkSpawn(point)) continue;
                                good = false;
                                break;
                            }
                            if (!good) continue;
                            RandomSpawnerManager.this.landSpawnPoints.add(point);
                            ++n;
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @Override
        public RandomSpawnPoint findPointNearPlayer(AbstractPlayer player) {
            Location location = BukkitAdapter.adapt(player.getLocation());
            Location spawnLocation = new Location(location.getWorld(), 0.0, 0.0, 0.0);
            int spawnRadius = Configuration.getRSPlayerRadius();
            int spawnRadiusY = Configuration.getRSPlayerRadiusY();
            int minRadiusSquared = 256;
            boolean good = true;
            for (int i = 0; i < 10; ++i) {
                int nx = (int)(location.getX() - (double)spawnRadius) + MythicMobs.r.nextInt(spawnRadius * 2);
                int nz = (int)(location.getZ() - (double)spawnRadius) + MythicMobs.r.nextInt(spawnRadius * 2);
                int ny = (int)(location.getY() - (double)spawnRadiusY) + MythicMobs.r.nextInt(spawnRadiusY * 2);
                spawnLocation.setX((double)nx);
                spawnLocation.setY((double)ny);
                spawnLocation.setZ((double)nz);
                if (!RandomSpawnerManager.this.isChunkLoaded(player.getWorld(), spawnLocation.getBlockX() >> 4, spawnLocation.getBlockZ() >> 4)) {
                    MythicMobs.debug(4, "-- Skipping player, area chunks not loaded.");
                    return null;
                }
                if (spawnLocation.distanceSquared(location) < (double)minRadiusSquared) continue;
                if (BlockUtil.isBreathable(spawnLocation.getBlock().getType())) {
                    good = false;
                    for (int j = 0; j < spawnRadiusY * 2; ++j) {
                        spawnLocation.setY((double)(--ny));
                        if (BlockUtil.isBreathable(spawnLocation.getBlock().getType())) continue;
                        good = true;
                        break;
                    }
                    if (!good) continue;
                }
                good = true;
                for (int k = 1; k < 3; ++k) {
                    spawnLocation.setY(spawnLocation.getY() + 1.0);
                    if (BlockUtil.isBreathable(spawnLocation.getBlock().getType())) continue;
                    good = false;
                    break;
                }
                if (!good) continue;
                AbstractLocation returnLocation = new AbstractLocation(player.getWorld(), (double)nx + 0.5, ny + 1, (double)nz + 0.5);
                return new RandomSpawnPoint(returnLocation, RandomSpawnPoint.PointType.LAND);
            }
            return null;
        }
    }
}

