/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Mobs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractWorld;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Adapters.TaskManager;
import net.elseland.xikage.MythicMobs.IO.IOHandler;
import net.elseland.xikage.MythicMobs.IO.IOLoader;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.LegacySkills.LegacySkillHandler;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicEntity;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicEntityType;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.Mobs.MythicMobStack;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.QueuedMobSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillHelper;
import net.elseland.xikage.MythicMobs.Skills.SkillString;
import net.elseland.xikage.MythicMobs.Skills.SkillTrigger;
import net.elseland.xikage.MythicMobs.Spawners.SpawnerManager;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class MobManager {
    private List<File> mobFiles;
    private IOLoader defaultMobs;
    private IOLoader cachedMobs;
    private List<IOLoader> mobLoaders;
    private ConcurrentHashMap<String, MythicMob> mmList = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, MythicMob> mmHashcodeLookup = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MythicMob> mmDisplayLookup = new ConcurrentHashMap();
    private List<MythicMobStack> listMobStacks = new ArrayList<MythicMobStack>();
    private ConcurrentHashMap<MythicEntityType, MythicMob> mmDefaultList = new ConcurrentHashMap();
    private transient Set<UUID> mmVoidList = new HashSet<UUID>();
    private transient Set<UUID> mmRemovedList = new HashSet<UUID>();
    private ConcurrentHashMap<UUID, ActiveMob> activeMobs = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, ActiveMob> activeMobsInCombat = new ConcurrentHashMap();
    public static boolean spawnflag = false;
    public static boolean mountflag = false;

    public void loadMobs() {
        this.defaultMobs = new IOLoader(MythicMobs.inst(), "VanillaMobs.yml", "Mobs");
        this.defaultMobs = new IOLoader(MythicMobs.inst(), "ExampleMobs.yml", "Mobs");
        this.cachedMobs = new IOLoader(MythicMobs.plugin, "CachedMobs.yml", "SavedData");
        this.mobFiles = IOHandler.getAllFiles(this.defaultMobs.thefile.getParent());
        this.mobLoaders = IOHandler.getSaveLoad(this.mobFiles, "Mobs");
        this.mmList.clear();
        this.mmDefaultList.clear();
        this.mmHashcodeLookup.clear();
        this.mmDisplayLookup.clear();
        for (IOLoader sl : this.mobLoaders) {
            for (String name : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                MythicMob mm;
                MythicConfig mc = new MythicConfig(name, sl.getCustomConfig());
                String file = sl.thefile.getPath() + "/" + sl.thefile.getName();
                if (MythicEntity.getMythicEntity(name) != null) {
                    MythicEntityType met = MythicEntityType.get(name);
                    mm = new MythicMob(file, name, mc);
                    this.mmDefaultList.put(met, mm);
                    continue;
                }
                if (sl.getCustomConfig().getString(name + ".MobStack") != null) {
                    String stack = sl.getCustomConfig().getString(name + ".MobStack");
                    this.listMobStacks.add(new MythicMobStack(name, stack, file));
                    continue;
                }
                String Display = sl.getCustomConfig().getString(name + ".Display");
                Display = sl.getCustomConfig().getString(name + ".DisplayName", Display);
                mm = new MythicMob(file, name, mc);
                this.mmList.put(name, mm);
                if (!this.mmHashcodeLookup.containsKey(name.hashCode())) {
                    this.mmHashcodeLookup.put(name.hashCode(), mm);
                } else {
                    MythicMob conflict = this.mmHashcodeLookup.get(name.hashCode());
                    MythicMobs.error("WARNING: HashCode collision detected when loading mobs.");
                    MythicMobs.error("Mob 1 Hash: " + name.hashCode() + " Type: " + this.mmHashcodeLookup.get(name.hashCode()).getInternalName());
                    MythicMobs.error("Mob 2 Hash: " + conflict.getInternalName().hashCode() + " Type: " + conflict.getInternalName());
                    MythicMobs.error("We recommend changing one of these mobs' internal name to avoid issues resolving mob type.");
                }
                if (Display == null) continue;
                this.mmDisplayLookup.put(Display, mm);
            }
        }
    }

    public Collection<MythicMob> getMobTypes() {
        return this.mmList.values();
    }

    public Collection<MythicMob> getVanillaTypes() {
        return this.mmDefaultList.values();
    }

    public Optional<MythicMob> getVanillaType(MythicEntityType met) {
        return Optional.ofNullable(this.mmDefaultList.getOrDefault((Object)met, null));
    }

    public Collection<MythicMobStack> getMobStacks() {
        return this.listMobStacks;
    }

    public Collection<ActiveMob> getActiveMobs() {
        return this.activeMobs.values();
    }

    public Collection<ActiveMob> getActiveMobsInCombat() {
        return this.activeMobsInCombat.values();
    }

    public boolean isActiveMob(AbstractEntity mob) {
        return this.isActiveMob(mob.getUniqueId());
    }

    public boolean isActiveMob(UUID u) {
        if (this.activeMobs.containsKey(u)) {
            if (this.activeMobs.get(u).getType() != null) {
                return true;
            }
            this.activeMobs.remove(u);
        }
        return false;
    }

    public ActiveMob getActiveMob(UUID uuid) {
        return this.activeMobs.get(uuid);
    }

    public Set<UUID> getGarbageList() {
        return this.mmRemovedList;
    }

    public Set<UUID> getVoidList() {
        return this.mmVoidList;
    }

    public int removeAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.activeMobs.values()) {
            if (am.getType().isPersistent()) continue;
            am.setDead();
            this.unregisterActiveMob(am);
            am.getEntity().remove();
            ++amount;
        }
        return amount;
    }

    public int removeAllAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.activeMobs.values()) {
            am.setDead();
            this.unregisterActiveMob(am);
            am.getEntity().remove();
            ++amount;
        }
        return amount;
    }

    public int despawnAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.activeMobs.values()) {
            if (!am.getType().optionDespawn || am.getType().isPersistent()) continue;
            am.setDead();
            MythicMobs.inst().getMobManager().unregisterActiveMob(am);
            am.getEntity().remove();
            ++amount;
        }
        return amount;
    }

    public void ScanWorld() {
        TaskManager.get().runAsync(() -> {
            for (AbstractWorld w : MythicMobs.inst().getMinecraftServer().getWorlds()) {
                for (AbstractEntity e : MythicMobs.inst().getEntityManager().getLivingEntities(w)) {
                    if (!this.isActiveMob(e)) {
                        this.registerActiveMob(e);
                        continue;
                    }
                    this.verifyMythicMobInstance(e);
                }
            }
            for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
                if (!am.getEntity().isDead()) continue;
                am.setDead();
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.plugin, (Runnable)new QueuedMobCleanup(am), 200L);
            }
        });
    }

    public ActiveMob registerActiveMob(ActiveMob am) {
        this.activeMobs.put(am.getUniqueId(), am);
        return am;
    }

    public ActiveMob registerActiveMob(AbstractEntity l, MythicMob mm, int level) {
        ActiveMob am = new ActiveMob(l.getUniqueId(), l, mm, level);
        this.activeMobs.put(l.getUniqueId(), am);
        mm.applyMobVolatileOptions(am);
        new QueuedMobSkill(SkillTrigger.SPAWN, am, null);
        return am;
    }

    public ActiveMob registerActiveMob(AbstractEntity l) {
        if (this.mmVoidList.contains(l.getUniqueId())) {
            return null;
        }
        final MythicMob mm = this.determineMobType(l);
        if (mm == null) {
            this.mmVoidList.add(l.getUniqueId());
            return null;
        }
        UUID uUID = l.getUniqueId();
        MythicMobs.inst().getMobManager();
        final ActiveMob am = new ActiveMob(uUID, l, mm, MobManager.getMythicMobLevel(mm, l));
        this.activeMobs.put(l.getUniqueId(), am);
        new BukkitRunnable(){

            public void run() {
                mm.applyMobVolatileOptions(am);
            }
        }.runTask((Plugin)MythicMobs.inst());
        new QueuedMobSkill(SkillTrigger.SPAWN, am, null);
        return am;
    }

    public void unregisterActiveMob(UUID u) {
        if (this.activeMobs.contains(u)) {
            ActiveMob am = this.activeMobs.get(u);
            am.setDead();
            SpawnerManager.RemoveMobFromSpawners(am);
        }
        this.activeMobs.remove(u);
        this.activeMobsInCombat.remove(u);
    }

    public void unregisterActiveMob(ActiveMob am) {
        MythicMobs.debug(3, "* Unregistering ActiveMob " + am.getEntity().getUniqueId().toString());
        am.setDead();
        SpawnerManager.RemoveMobFromSpawners(am);
        this.activeMobs.remove(am.getEntity().getUniqueId());
        this.activeMobsInCombat.remove(am.getEntity().getUniqueId());
    }

    public ActiveMob getMythicMobInstance(Entity target) {
        return this.getMythicMobInstance(BukkitAdapter.adapt(target));
    }

    public ActiveMob getMythicMobInstance(AbstractEntity target) {
        ActiveMob am = this.activeMobs.get(target.getUniqueId());
        if (am != null) {
            this.defrag(am, target);
            return am;
        }
        return this.registerActiveMob(target);
    }

    public void verifyMythicMobInstance(AbstractEntity e) {
        ActiveMob am = this.activeMobs.get(e.getUniqueId());
        if (am != null) {
            this.defrag(am, e);
        }
    }

    private void defrag(ActiveMob am, AbstractEntity e) {
        if (!am.getEntity().isValid() && e.isValid()) {
            am.setEntity(e);
        }
    }

    public void cleanActiveMobs() {
        for (ActiveMob am : this.activeMobs.values()) {
            if (!am.getEntity().isDead()) continue;
            TaskManager.get().runAsyncLater(new QueuedMobCleanup(am), 20);
        }
    }

    public ActiveMob spawnMob(String MobName, Location loc) {
        return this.spawnMob(MobName, BukkitAdapter.adapt(loc), 1);
    }

    public ActiveMob spawnMob(String MobName, Location loc, int level) {
        return this.spawnMob(MobName, BukkitAdapter.adapt(loc), level);
    }

    public ActiveMob spawnMob(String MobName, AbstractLocation loc) {
        return this.spawnMob(MobName, loc, 1);
    }

    public ActiveMob spawnMob(String MobName, AbstractLocation loc, int level) {
        MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(MobName);
        if (mm != null) {
            return mm.spawn(loc, level);
        }
        MythicMobStack ms = MythicMobs.inst().getMobManager().getMythicMobStack(MobName);
        if (ms != null) {
            return ms.spawn(loc, level);
        }
        return null;
    }

    public void SetupMythicMobCompat(LivingEntity l, MythicMob mm) {
        if (spawnflag) {
            return;
        }
        if (mm.getMythicEntity() != null) {
            l = (LivingEntity)mm.getMythicEntity().applyOptions((Entity)l);
        }
        UUID uUID = l.getUniqueId();
        AbstractEntity abstractEntity = BukkitAdapter.adapt((Entity)l);
        MythicMobs.inst().getMobManager();
        ActiveMob am = new ActiveMob(uUID, abstractEntity, mm, MobManager.getMythicMobLevel(mm, BukkitAdapter.adapt((Entity)l)));
        this.activeMobs.put(l.getUniqueId(), am);
        l = (LivingEntity)mm.applyMobOptions(am, am.getLevel());
        l = (LivingEntity)mm.applyMobVolatileOptions(am);
        new QueuedMobSkill(SkillTrigger.SPAWN, am, null);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation b, int radiusXZ, int radiusY, int mob_height, boolean Ymod) {
        Location base = BukkitAdapter.adapt(b);
        if (radiusXZ <= 0) {
            radiusXZ = 1;
        }
        if (radiusY <= 0) {
            radiusY = 1;
        }
        double x = base.getX() - (double)radiusXZ + (double)MythicMobs.r.nextInt(radiusXZ * 2);
        double z = base.getZ() - (double)radiusXZ + (double)MythicMobs.r.nextInt(radiusXZ * 2);
        double y = Ymod ? base.getY() - (double)radiusY + (double)MythicMobs.r.nextInt(radiusY * 2) : base.getY() + (double)MythicMobs.r.nextInt(radiusY);
        Location loc = new Location(base.getWorld(), x, y, z);
        int j = 10;
        while (loc.getBlock().getType().isSolid()) {
            x = base.getX() - (double)radiusXZ + (double)MythicMobs.r.nextInt(radiusXZ * 2);
            z = base.getZ() - (double)radiusXZ + (double)MythicMobs.r.nextInt(radiusXZ * 2);
            y = Ymod ? base.getY() - (double)radiusY + (double)MythicMobs.r.nextInt(radiusY * 2) : base.getY() + (double)MythicMobs.r.nextInt(radiusY);
            loc = new Location(base.getWorld(), x, y, z);
            if (--j != 0) continue;
            loc = new Location(base.getWorld(), base.getX(), base.getY() + 1.0, base.getZ());
            break;
        }
        return BukkitAdapter.adapt(loc);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation base, int radiusXZ, int radiusY, int mob_height) {
        return MobManager.findSafeSpawnLocation(base, radiusXZ, radiusY, mob_height, true);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation base, int radius, int mob_height) {
        return MobManager.findSafeSpawnLocation(base, radius, radius, mob_height, true);
    }

    public Collection<ActiveMob> getMobsInCombat() {
        return this.activeMobsInCombat.values();
    }

    public boolean getInCombat(ActiveMob am) {
        return this.activeMobsInCombat.containsKey(am.getUniqueId());
    }

    public void setInCombat(ActiveMob am, boolean b) {
        if (b) {
            this.activeMobsInCombat.put(am.getUniqueId(), am);
        } else {
            this.activeMobsInCombat.remove(am.getUniqueId());
        }
    }

    public void loadCachedActiveMobs() {
        MythicMobs.debug(1, "Loading all previously active Mythic Mobs...");
        if (this.cachedMobs.getCustomConfig().contains("CachedMobs")) {
            List sList = this.cachedMobs.getCustomConfig().getStringList("CachedMobs");
            ArrayList<UUID> list = new ArrayList<UUID>();
            for (String mob : sList) {
                String[] data;
                World w;
                if (!mob.contains(":") || (w = Bukkit.getWorld((String)(data = mob.split(":"))[2])) == null) continue;
                int x = 0;
                int y = 0;
                int level = 1;
                if (data.length > 3 && StringUtils.isNumeric((String)data[3])) {
                    x = Integer.parseInt(data[3]);
                }
                if (data.length > 4 && StringUtils.isNumeric((String)data[4])) {
                    y = Integer.parseInt(data[4]);
                }
                if (data.length > 5 && StringUtils.isNumeric((String)data[5])) {
                    level = Integer.parseInt(data[5]);
                }
                for (Entity e : w.getChunkAt(x, y).getEntities()) {
                    if (!(e instanceof LivingEntity)) continue;
                    LivingEntity l = (LivingEntity)e;
                    UUID i = UUID.fromString(data[1]);
                    if (l.getUniqueId().compareTo(i) != 0) continue;
                    MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(data[0]);
                    if (mm != null) {
                        if (mm.getDespawns()) {
                            e.remove();
                            continue;
                        }
                        MythicMobs.inst().getMobManager().registerActiveMob(BukkitAdapter.adapt((Entity)l), mm, level);
                        list.add(l.getUniqueId());
                        continue;
                    }
                    this.mmRemovedList.add(l.getUniqueId());
                    e.remove();
                }
            }
            MythicMobs.debug(1, "-- Active Mythic Mobs have been loaded!");
        } else {
            MythicMobs.debug(1, "-- CachedMobs file is empty, corrupt, or does not exist! No previously active mobs loaded.");
        }
    }

    public void saveCachedActiveMobs() {
        MythicMobs.debug(1, "Saving all active Mythic Mobs...");
        ArrayList<String> mobs = new ArrayList<String>();
        for (LivingEntity i : this.getAllMythicEntities()) {
            if (i.isDead()) continue;
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)i);
            try {
                mobs.add(am.getType().getInternalName() + ":" + i.getUniqueId() + ":" + i.getWorld().getName() + ":" + i.getWorld().getChunkAt(i.getLocation()).getX() + ":" + i.getWorld().getChunkAt(i.getLocation()).getZ() + ":" + am.getLevel());
            }
            catch (Exception e) {}
        }
        this.cachedMobs.getCustomConfig().set("CachedMobs", mobs);
        this.cachedMobs.saveCustomConfig();
        MythicMobs.debug(1, "All active mobs have been saved!");
    }

    public List<LivingEntity> getAllMythicEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (World w : Bukkit.getWorlds()) {
            for (LivingEntity e : w.getLivingEntities()) {
                if (!this.activeMobs.containsKey(e.getUniqueId())) continue;
                list.add(e);
            }
        }
        return list;
    }

    public MythicMob getMythicMob(String s) {
        if (s == null) {
            return null;
        }
        if (this.mmList.containsKey(s)) {
            return this.mmList.get(s);
        }
        return null;
    }

    public MythicMobStack getMythicMobStack(String s) {
        for (MythicMobStack ML : this.listMobStacks) {
            if (!ML.getName().equals(s)) continue;
            return ML;
        }
        return null;
    }

    public static int getMythicMobLevel(MythicMob mm, AbstractEntity l) {
        int si;
        Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective o = sb.getObjective("MythicMobLevel");
        if (o != null && (si = o.getScore(l.getUniqueId().toString()).getScore()) > 0) {
            return si;
        }
        int level = 1;
        if (!(mm.lvlModHealth > 0.0)) {
            return 1;
        }
        double health = l.getMaxHealth() - mm.getHealth();
        return level += (int)(health / mm.lvlModHealth);
    }

    public static int getMythicMobLevel(LivingEntity l) {
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)l);
        if (am == null) {
            return 1;
        }
        return am.getLevel();
    }

    public static void setMetaData(AbstractEntity abstractEntity, String s, String key) {
        BukkitAdapter.adapt(abstractEntity).setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)MythicMobs.plugin, (Object)s));
    }

    public static void showHealth(ActiveMob am) {
        if (!am.getType().optionShowHealthInChat) {
            return;
        }
        int per = (int)(am.getEntity().getHealth() / am.getEntity().getMaxHealth() * 10.0) + 1;
        if (per >= 10) {
            return;
        }
        if (!LegacySkillHandler.hasUsedSkill("percentage" + per, am.getEntity())) {
            MythicMobs.inst().getMobManager();
            MobManager.setMetaData(am.getEntity(), "percentage" + per, "percentage" + per);
            String string = Configuration.ShowHealthFormat;
            string = SkillString.parseMobVariables(string, am, null, null);
            string = string.replace("<mob.hp>", "" + (int)am.getEntity().getHealth());
            string = string.replace("<mob.mhp>", "" + (int)am.getEntity().getMaxHealth());
            string = string.replace("$percent", per + "0");
            string = string.replace("$mobname", am.getEntity().getCustomName() + "");
            string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
            for (Player p : SkillHelper.getPlayersInRadius((LivingEntity)am.getEntity().getBukkitEntity(), Configuration.ShowHealthRadius)) {
                p.sendMessage(string);
            }
        }
    }

    public MythicMob determineMobType(AbstractEntity l) {
        int hashCode;
        Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective o = sb.getObjective("MythicMobType");
        if (o == null) {
            o = sb.registerNewObjective("MythicMobType", "dummy");
        }
        if (this.mmHashcodeLookup.containsKey(hashCode = o.getScore(l.getUniqueId().toString()).getScore())) {
            return this.mmHashcodeLookup.get(hashCode);
        }
        List list = l.getBukkitEntity().getMetadata("mobname");
        MythicMob mm = null;
        for (MetadataValue mv : list) {
            MythicMobs.debug(5, "-- Analyzing Meta Value: " + mv + "");
            mm = this.mmList.get(mv);
            if (mm == null) continue;
            return mm;
        }
        if (l.getCustomName() == null) {
            return null;
        }
        MythicMobs.debug(3, "-- Attempting to match untracked mob by display name: " + l.getCustomName());
        mm = this.mmDisplayLookup.get(l.getCustomName());
        if (mm != null) {
            return mm;
        }
        for (MythicMob MM : this.mmList.values()) {
            if (MM.getDisplayName() == null) continue;
            String search = MM.getDisplayName();
            search = search.replace("[", "\\[");
            search = search.replace("]", "\\]");
            search = search.replace("?", "\\?");
            search = search.replace("$level", "[0-9]*");
            search = search.replace("<mob.level>", "[0-9]*");
            search = ChatColor.translateAlternateColorCodes((char)'&', (String)search);
            MythicMobs.debug(4, "---- Matching mob to name " + search);
            try {
                if (!l.getCustomName().toString().matches(search) || !(MM.getHealth() <= l.getMaxHealth())) continue;
                MythicMobs.debug(3, "---- Matched mob to name " + search + " with health check " + MM.getHealth());
                l.setHealth(l.getMaxHealth());
                return MM;
            }
            catch (Exception e) {
                e.printStackTrace();
                MythicMobs.debug(2, "ERROR");
            }
        }
        return null;
    }

    public MythicMob getMythicMobByDisplayCompat(AbstractEntity l) {
        if (l.getCustomName() == null) {
            return null;
        }
        MythicMobs.debug(3, "-- Attempting to match mob for compatibility: " + l.getCustomName().toString());
        MythicMob mm = this.mmDisplayLookup.get(l.getCustomName());
        if (mm != null) {
            return mm;
        }
        mm = this.determineMobType(l);
        if (mm != null) {
            return mm;
        }
        for (MythicMob MM : this.mmList.values()) {
            if (MM.getDisplayName() == null) continue;
            String search = MM.getDisplayName();
            search = search.replace("?", "\\?");
            search = search.replace("$level", "[0-9]*");
            search = ChatColor.translateAlternateColorCodes((char)'&', (String)search);
            MythicMobs.debug(4, "---- Matching mob to name " + search);
            try {
                String name = ChatColor.translateAlternateColorCodes((char)'&', (String)l.getCustomName().toString());
                if (!name.matches(search)) continue;
                MythicMobs.debug(3, "---- Matched mob to name " + search);
                l.setHealth(l.getMaxHealth());
                return MM;
            }
            catch (Exception e) {
                e.printStackTrace();
                MythicMobs.debug(2, "ERROR");
            }
        }
        return null;
    }

    public static String convertMobTypeAliases(String s) {
        s = s.toLowerCase();
        s = s.replace("zombievillager", "ZOMBIE_VILLAGER");
        s = s.replace("villagezombie", "ZOMBIE_VILLAGER");
        s = s.replace("babyvillagezombie", "BABY_ZOMBIE_VILLAGER");
        s = s.replace("babypigzombie", "BABY_PIG_ZOMBIE");
        s = s.replace("babyzombiepig", "BABY_PIG_ZOMBIE");
        s = s.replace("babyzombiepigman", "BABY_PIG_ZOMBIE");
        s = s.replace("babypigzombievillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s = s.replace("babyzombiepigvillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s = s.replace("babyzombiepigmanvillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s = s.replace("babyzombie", "BABY_ZOMBIE");
        s = s.replace("cavespider", "CAVE_SPIDER");
        s = s.replace("enderdragon", "ENDER_DRAGON");
        s = s.replace("irongolem", "IRON_GOLEM");
        s = s.replace("lavaslime", "MAGMA_CUBE");
        s = s.replace("magmacube", "MAGMA_CUBE");
        s = s.replace("mooshroom", "MUSHROOM_COW");
        s = s.replace("mushroomcow", "MUSHROOM_COW");
        s = s.replace("pigzombie", "PIG_ZOMBIE");
        s = s.replace("zombiepig", "PIG_ZOMBIE");
        s = s.replace("zombiepigman", "PIG_ZOMBIE");
        s = s.replace("pigzombievillager", "PIG_ZOMBIE_VILLAGER");
        s = s.replace("zombiepigvillager", "PIG_ZOMBIE_VILLAGER");
        s = s.replace("zombiepigmanvillager", "PIG_ZOMBIE_VILLAGER");
        if ((s = s.replace("tnt", "PRIMED_TNT")).equals("cat")) {
            s = s.replace("cat", "OCELOT");
        }
        s = s.replace("witherskeleton", "WITHER_SKELETON");
        return s;
    }

    public static class QueuedMobCleanup
    implements Runnable {
        private ActiveMob mob;

        public QueuedMobCleanup(ActiveMob mob) {
            this.mob = mob;
            MythicMobs.debug(3, "* Queued CleanUp for mob " + mob.getEntity().getUniqueId().toString());
        }

        @Override
        public void run() {
            MythicMobs.inst().getMobManager().unregisterActiveMob(this.mob);
        }
    }
}

