/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Mobs;

import java.util.Arrays;
import java.util.List;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Drops.DropHandler;
import net.elseland.xikage.MythicMobs.Drops.MythicDropTable;
import net.elseland.xikage.MythicMobs.Drops.MythicEquipable;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;

public class EquipmentManager {
    public static void setEquipment(ActiveMob am) {
        if (am.getType().getEquipment() == null) {
            return;
        }
        MythicEquipable helmet = null;
        MythicEquipable chest = null;
        MythicEquipable leggings = null;
        MythicEquipable boots = null;
        MythicEquipable hand = null;
        MythicEquipable offhand = null;
        LivingEntity l = (LivingEntity)BukkitAdapter.adapt(am.getEntity());
        EntityEquipment ee = l.getEquipment();
        ee.setItemInHandDropChance(0.0f);
        ee.setHelmetDropChance(0.0f);
        ee.setChestplateDropChance(0.0f);
        ee.setLeggingsDropChance(0.0f);
        ee.setBootsDropChance(0.0f);
        MythicMobs.debug(3, "Applying equipment to Mythic Mob...");
        for (String s : am.getType().getEquipment()) {
            MythicDropTable dt;
            MythicMobs.debug(3, "-- Parsing equipment: " + s);
            String prefix = "";
            if (s.contains(":")) {
                String[] split = s.split(":");
                dt = DropHandler.getMythicDropTable(split[0]);
                prefix = split[1];
            } else {
                dt = DropHandler.getMythicDropTable(s);
            }
            if (dt != null) {
                MythicMobs.debug(3, "---- Retrieved Drop Table: " + dt.dtName);
            } else {
                MythicMobs.debug(3, "------ Attempting to parse as pseudo-droptable");
                try {
                    List<String> baseEquipmentList = Arrays.asList(s);
                    dt = new MythicDropTable(baseEquipmentList, null, null, null, null);
                }
                catch (Exception e) {
                    MythicMobs.error(am.getType().getInternalName() + " appears to have invalid equipment configured for it. Please check the formatting! Equipment: " + s);
                }
            }
            if (dt == null) continue;
            dt.parseTable(am);
            MythicMobs.debug(3, "---- Drop Table Parsed, equipping items...");
            for (MythicEquipable is : dt.equipablesList) {
                MythicMobs.debug(4, "------ Loaded item in slot " + is.getSlot() + " with Item Stack: " + is.getItemStack().toString());
                if (!(MythicMobs.r.nextFloat() <= is.getChance())) continue;
                if (is.getSlot() == 0 && EquipmentManager.CompareEquipment(is, hand)) {
                    hand = is;
                    if (prefix.equals("!")) {
                        ee.setItemInHandDropChance(1.0f);
                    }
                }
                if (is.getSlot() == 1 && EquipmentManager.CompareEquipment(is, boots)) {
                    boots = is;
                    if (prefix.equals("!")) {
                        ee.setBootsDropChance(1.0f);
                    }
                }
                if (is.getSlot() == 2 && EquipmentManager.CompareEquipment(is, leggings)) {
                    leggings = is;
                    if (prefix.equals("!")) {
                        ee.setLeggingsDropChance(1.0f);
                    }
                }
                if (is.getSlot() == 3 && EquipmentManager.CompareEquipment(is, chest)) {
                    chest = is;
                    if (prefix.equals("!")) {
                        ee.setChestplateDropChance(1.0f);
                    }
                }
                if (is.getSlot() == 4 && EquipmentManager.CompareEquipment(is, helmet)) {
                    helmet = is;
                    if (prefix.equals("!")) {
                        ee.setHelmetDropChance(1.0f);
                    }
                }
                if (is.getSlot() != 5 || !EquipmentManager.CompareEquipment(is, offhand)) continue;
                offhand = is;
            }
        }
        if (helmet != null) {
            ee.setHelmet(helmet.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Helm to: " + helmet.getItemStack().toString());
        }
        if (chest != null) {
            ee.setChestplate(chest.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Chest to: " + chest.getItemStack().toString());
        }
        if (leggings != null) {
            ee.setLeggings(leggings.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Legs to: " + leggings.getItemStack().toString());
        }
        if (boots != null) {
            ee.setBoots(boots.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Boots to: " + boots.getItemStack().toString());
        }
        if (hand != null) {
            if (MythicMobs.inst().getMinecraftVersion() <= 8) {
                ee.setItemInHand(hand.getItemStack());
            } else {
                ee.setItemInMainHand(hand.getItemStack());
            }
            MythicMobs.debug(3, "-- Set Mob Hand to: " + hand.getItemStack().toString());
        }
        if (offhand != null) {
            ee.setItemInOffHand(offhand.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Hand to: " + offhand.getItemStack().toString());
        }
    }

    public static boolean CompareEquipment(MythicEquipable stack, MythicEquipable old) {
        if (old == null) {
            return true;
        }
        return old.getChance() >= stack.getChance();
    }
}

