/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.LegacySkills.OldSkills;

import java.lang.reflect.Array;
import net.elseland.xikage.MythicMobs.MythicMobs;
import org.bukkit.Effect;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class SkillShootProjectile {
    private static Class<? extends Projectile> projectileClass;

    public static void ExecuteSkill(LivingEntity l, String skill, LivingEntity target) {
        Projectile projectile;
        int maxdistance;
        if (target == null) {
            return;
        }
        String[] base = skill.split(" ");
        String[] data = base[1].split(":");
        String projectileType = Array.getLength(data) > 0 ? data[0] : "arrow";
        int damage = Array.getLength(data) > 1 ? Integer.parseInt(data[1]) : 1;
        float velocity = Array.getLength(data) > 2 ? Float.parseFloat(data[2]) : 1.0f;
        int n = maxdistance = Array.getLength(data) > 3 ? Integer.parseInt(data[3]) : 64;
        if (l.getLocation().distance(target.getLocation()) > (double)maxdistance) {
            return;
        }
        if (projectileType.equalsIgnoreCase("arrow")) {
            projectileClass = Arrow.class;
            l.getWorld().playEffect(l.getLocation(), Effect.BOW_FIRE, 0);
        } else if (projectileType.equalsIgnoreCase("snowball")) {
            projectileClass = Snowball.class;
            l.getWorld().playEffect(l.getLocation(), Effect.BOW_FIRE, 0);
        } else if (projectileType.equalsIgnoreCase("egg")) {
            projectileClass = Egg.class;
            l.getWorld().playEffect(l.getLocation(), Effect.BOW_FIRE, 0);
        } else {
            projectileClass = projectileType.equalsIgnoreCase("enderpearl") ? EnderPearl.class : Arrow.class;
        }
        if (l instanceof Creature && ((Creature)l).getTarget() == target) {
            projectile = l.launchProjectile(projectileClass);
            projectile.setVelocity(l.getLocation().getDirection().multiply(velocity));
        } else {
            projectile = l.launchProjectile(projectileClass);
            Vector facing = target.getLocation().toVector().subtract(l.getLocation().toVector()).normalize().multiply(velocity);
            projectile.setVelocity(facing);
        }
        projectile.setBounce(false);
        projectile.setShooter((ProjectileSource)l);
        projectile.setMetadata("MythicMobsProjectile", (MetadataValue)new FixedMetadataValue((Plugin)MythicMobs.plugin, (Object)new ProjectileData(damage)));
    }

    public static class ProjectileData {
        public int damage;

        public ProjectileData(int damage) {
            this.damage = damage;
        }
    }
}

