/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Compatibility;

import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArmorStandWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.DroppedItemWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.EndermanWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.HorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.OcelotWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SheepWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.VillagerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WolfWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.SkillString;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LibsDisguisesSupport2 {
    public boolean enabled = false;
    public LibsDisguises ld = (LibsDisguises)Bukkit.getPluginManager().getPlugin("LibsDisguises");

    public Disguise getDisguise(String disguise, MythicConfig mc, MythicMob mm) {
        try {
            if (disguise == null) {
                disguise = mc.getString("Options.Disguise");
            }
            String[] split = disguise.split(":");
            String dn = split[0];
            String data = null;
            if (split.length > 1) {
                data = split[1];
            }
            MobDisguise d = null;
            switch (dn.toLowerCase()) {
                case "armor_stand": {
                    d = new MobDisguise(DisguiseType.ARMOR_STAND);
                    boolean has_arms = mc.getBoolean("Disguise.HasArms", true);
                    boolean small = mc.getBoolean("Disguise.Small", false);
                    boolean invisible = mc.getBoolean("Disguise.Invisible", false);
                    boolean baseplate = mc.getBoolean("Disguise.HideBasePlate", false);
                    ArmorStandWatcher asw = (ArmorStandWatcher)d.getWatcher();
                    asw.setShowArms(has_arms);
                    asw.setSmall(small);
                    asw.setInvisible(invisible);
                    asw.setNoBasePlate(baseplate);
                    break;
                }
                case "arrow": {
                    d = new MiscDisguise(DisguiseType.ARROW);
                    break;
                }
                case "bat": {
                    d = new MobDisguise(DisguiseType.BAT, true);
                    break;
                }
                case "boat": {
                    d = new MiscDisguise(DisguiseType.BOAT);
                    break;
                }
                case "blaze": {
                    d = new MobDisguise(DisguiseType.BLAZE, true);
                    break;
                }
                case "block": 
                case "falling_block": {
                    String block_id = mc.getString("Disguise.Block", data);
                    short block_dv = (short)mc.getInt("Disguise.BlockData", 0);
                    d = new MiscDisguise(DisguiseType.FALLING_BLOCK);
                    FallingBlockWatcher fbw = (FallingBlockWatcher)d.getWatcher();
                    Material m = Material.getMaterial((String)block_id.toUpperCase());
                    if (m == null) {
                        return d;
                    }
                    ItemStack i = new ItemStack(m, 1, block_dv);
                    i.setDurability(block_dv);
                    fbw.setBlock(i);
                    break;
                }
                case "cave_spider": {
                    d = new MobDisguise(DisguiseType.CAVE_SPIDER, true);
                    break;
                }
                case "chicken": {
                    d = new MobDisguise(DisguiseType.CHICKEN, true);
                    break;
                }
                case "cow": {
                    d = new MobDisguise(DisguiseType.COW, true);
                    break;
                }
                case "baby_cow": {
                    d = new MobDisguise(DisguiseType.COW, true);
                    AgeableWatcher cww = (AgeableWatcher)d.getWatcher();
                    cww.setBaby();
                    break;
                }
                case "creeper": {
                    d = new MobDisguise(DisguiseType.CREEPER, true);
                    break;
                }
                case "donkey": {
                    d = new MobDisguise(DisguiseType.DONKEY, true);
                    HorseWatcher hwd = (HorseWatcher)d.getWatcher();
                    if (mm.horseStyle != null) {
                        hwd.setStyle(Horse.Style.valueOf((String)mm.horseStyle));
                    }
                    if (mm.color != null) {
                        hwd.setColor(Horse.Color.valueOf((String)mm.color));
                    }
                    if (mm.horseArmor != null) {
                        switch (mm.horseArmor.toLowerCase()) {
                            case "diamond": {
                                hwd.setHorseArmor(new ItemStack(Material.DIAMOND_BARDING, 1, 0));
                                break;
                            }
                            case "gold": 
                            case "golden": {
                                hwd.setHorseArmor(new ItemStack(Material.GOLD_BARDING, 1, 0));
                                break;
                            }
                            default: {
                                hwd.setHorseArmor(new ItemStack(Material.IRON_BARDING, 1, 0));
                            }
                        }
                    }
                    if (mm.horseSaddled) {
                        hwd.setSaddled(true);
                    }
                    if (!mm.horseChest) break;
                    hwd.setCarryingChest(true);
                    break;
                }
                case "egg": {
                    d = new MiscDisguise(DisguiseType.EGG);
                    break;
                }
                case "enderman": 
                case "endermen": {
                    d = new MobDisguise(DisguiseType.ENDERMAN, true);
                    if (data == null) break;
                    EndermanWatcher enw = (EndermanWatcher)d.getWatcher();
                    ItemStack itemstack = new ItemStack(Material.valueOf((String)data.toUpperCase()));
                    enw.setItemInHand(itemstack);
                    break;
                }
                case "endercrystal": 
                case "ender_crystal": {
                    d = new MiscDisguise(DisguiseType.ENDER_CRYSTAL);
                    break;
                }
                case "enderdragon": 
                case "ender_dragon": {
                    d = new MobDisguise(DisguiseType.ENDER_DRAGON, true);
                    break;
                }
                case "endermite": {
                    d = new MobDisguise(DisguiseType.ENDERMITE, true);
                    break;
                }
                case "elder_guardian": {
                    d = new MobDisguise(DisguiseType.ELDER_GUARDIAN, true);
                    break;
                }
                case "fireball": {
                    d = new MiscDisguise(DisguiseType.FIREBALL);
                    break;
                }
                case "ghast": {
                    d = new MobDisguise(DisguiseType.GHAST, true);
                    break;
                }
                case "giant": {
                    d = new MobDisguise(DisguiseType.GIANT, true);
                    break;
                }
                case "guardian": {
                    d = new MobDisguise(DisguiseType.GUARDIAN, true);
                    break;
                }
                case "horse": {
                    d = new MobDisguise(DisguiseType.HORSE, true);
                    HorseWatcher hw = (HorseWatcher)d.getWatcher();
                    if (mm.horseStyle != null) {
                        hw.setStyle(Horse.Style.valueOf((String)mm.horseStyle));
                    }
                    if (mm.color != null) {
                        hw.setColor(Horse.Color.valueOf((String)mm.color));
                    }
                    if (mm.horseArmor != null) {
                        switch (mm.horseArmor) {
                            case "diamond": {
                                hw.setHorseArmor(new ItemStack(Material.DIAMOND_BARDING, 1, 0));
                                break;
                            }
                            case "gold": 
                            case "golden": {
                                hw.setHorseArmor(new ItemStack(Material.GOLD_BARDING, 1, 0));
                                break;
                            }
                            default: {
                                hw.setHorseArmor(new ItemStack(Material.IRON_BARDING, 1, 0));
                            }
                        }
                    }
                    if (mm.horseSaddled) {
                        hw.setSaddled(true);
                    }
                    if (!mm.horseChest) break;
                    hw.setCarryingChest(true);
                    break;
                }
                case "item": 
                case "dropped_item": {
                    d = new MiscDisguise(DisguiseType.DROPPED_ITEM);
                    String item_id = mc.getString("Disguise.Item", data);
                    short item_dv = (short)mc.getInt("Disguise.ItemData", 0);
                    DroppedItemWatcher diw = (DroppedItemWatcher)d.getWatcher();
                    ItemStack ditemstack = new ItemStack(Material.valueOf((String)item_id.toUpperCase()), 1, item_dv);
                    diw.setItemStack(ditemstack);
                    break;
                }
                case "iron_golem": 
                case "irongolem": {
                    d = new MobDisguise(DisguiseType.IRON_GOLEM, true);
                    break;
                }
                case "itemframe": 
                case "item_frame": {
                    d = new MiscDisguise(DisguiseType.ITEM_FRAME);
                    break;
                }
                case "magmacube": 
                case "lavaslime": {
                    d = new MobDisguise(DisguiseType.MAGMA_CUBE, true);
                    SlimeWatcher mcw = (SlimeWatcher)d.getWatcher();
                    int slimesize = 2;
                    if (data.matches("[0-9]+")) {
                        slimesize = Integer.parseInt(data);
                    }
                    slimesize = mc.getInt("Disguise.Size", slimesize);
                    mcw.setSize(slimesize);
                    break;
                }
                case "minecart": {
                    d = new MiscDisguise(DisguiseType.MINECART);
                    break;
                }
                case "minecart_chest": {
                    d = new MiscDisguise(DisguiseType.MINECART_CHEST);
                    break;
                }
                case "minecart_furnace": {
                    d = new MiscDisguise(DisguiseType.MINECART_FURNACE);
                    break;
                }
                case "minecart_hopper": {
                    d = new MiscDisguise(DisguiseType.MINECART_HOPPER);
                    break;
                }
                case "minecart_mob_spawner": {
                    d = new MiscDisguise(DisguiseType.MINECART_MOB_SPAWNER);
                    break;
                }
                case "minecart_tnt": {
                    d = new MiscDisguise(DisguiseType.MINECART_TNT);
                    break;
                }
                case "mooshroom": 
                case "mushroom_cow": {
                    d = new MobDisguise(DisguiseType.MUSHROOM_COW, true);
                    break;
                }
                case "mule": {
                    d = new MobDisguise(DisguiseType.MULE, true);
                    HorseWatcher hws = (HorseWatcher)d.getWatcher();
                    if (mm.horseStyle != null) {
                        hws.setStyle(Horse.Style.valueOf((String)mm.horseStyle));
                    }
                    if (mm.color != null) {
                        hws.setColor(Horse.Color.valueOf((String)mm.color));
                    }
                    if (mm.horseArmor != null) {
                        switch (mm.horseArmor) {
                            case "diamond": {
                                hws.setHorseArmor(new ItemStack(Material.DIAMOND_BARDING, 1, 0));
                                break;
                            }
                            case "gold": 
                            case "golden": {
                                hws.setHorseArmor(new ItemStack(Material.GOLD_BARDING, 1, 0));
                                break;
                            }
                            default: {
                                hws.setHorseArmor(new ItemStack(Material.IRON_BARDING, 1, 0));
                            }
                        }
                    }
                    if (mm.horseSaddled) {
                        hws.setSaddled(true);
                    }
                    if (!mm.horseChest) break;
                    hws.setCarryingChest(true);
                    break;
                }
                case "ocelot": {
                    d = new MobDisguise(DisguiseType.OCELOT, true);
                    OcelotWatcher ow = (OcelotWatcher)d.getWatcher();
                    String catType = mc.getString("Disguise.CatType", mm.catType);
                    if (catType == null) break;
                    ow.setType(Ocelot.Type.valueOf((String)catType.toUpperCase()));
                    break;
                }
                case "painting": {
                    if (data == null) {
                        return null;
                    }
                    if (!data.matches("[0-9]*")) {
                        return null;
                    }
                    d = new MiscDisguise(DisguiseType.PAINTING, Integer.parseInt(data));
                    break;
                }
                case "pig": {
                    d = new MobDisguise(DisguiseType.PIG, true);
                    break;
                }
                case "pigzombie": {
                    d = new MobDisguise(DisguiseType.PIG_ZOMBIE, true);
                    break;
                }
                case "babypigzombie": {
                    d = new MobDisguise(DisguiseType.PIG_ZOMBIE, true);
                    ZombieWatcher w = (ZombieWatcher)d.getWatcher();
                    w.setBaby();
                    break;
                }
                case "player": {
                    String player;
                    String skin = player = data;
                    if (split.length > 2) {
                        skin = split[2];
                    }
                    player = mc.getString("Disguise.Player", player);
                    skin = mc.getString("Disguise.Skin", skin);
                    if (player == null) {
                        return d;
                    }
                    player = ChatColor.translateAlternateColorCodes((char)'&', (String)player);
                    d = new PlayerDisguise(player);
                    PlayerWatcher pw = (PlayerWatcher)d.getWatcher();
                    if (split.length > 2) {
                        pw.setSkin(split[2]);
                        break;
                    }
                    pw.setSkin(skin);
                    break;
                }
                case "doppleganger": {
                    String player2;
                    String skin2 = player2 = data;
                    if (split.length > 2) {
                        skin2 = split[2];
                    }
                    if (player2 == null) {
                        return d;
                    }
                    player2 = ChatColor.translateAlternateColorCodes((char)'&', (String)player2);
                    d = new PlayerDisguise(player2);
                    PlayerWatcher pw2 = (PlayerWatcher)d.getWatcher();
                    if (split.length > 2) {
                        pw2.setSkin(split[2]);
                        break;
                    }
                    pw2.setSkin(skin2);
                    break;
                }
                case "rabbit": {
                    d = new MobDisguise(DisguiseType.RABBIT, true);
                    break;
                }
                case "sheep": {
                    d = new MobDisguise(DisguiseType.SHEEP);
                    SheepWatcher shw = (SheepWatcher)d.getWatcher();
                    if (mm.color == null) break;
                    shw.setColor(AnimalColor.valueOf((String)mm.color));
                    break;
                }
                case "silverfish": {
                    d = new MobDisguise(DisguiseType.SILVERFISH, true);
                    break;
                }
                case "skeleton": {
                    d = new MobDisguise(DisguiseType.SKELETON);
                    break;
                }
                case "slime": {
                    d = new MobDisguise(DisguiseType.SLIME, true);
                    SlimeWatcher slw = (SlimeWatcher)d.getWatcher();
                    int slimessize = 2;
                    if (data.matches("[0-9]+")) {
                        slimessize = Integer.parseInt(data);
                    }
                    int slimesize = mc.getInt("Disguise.Size", slimessize);
                    slw.setSize(slimessize);
                    break;
                }
                case "snowman": {
                    d = new MobDisguise(DisguiseType.SNOWMAN, true);
                    break;
                }
                case "spider": {
                    d = new MobDisguise(DisguiseType.SPIDER, true);
                    break;
                }
                case "skeleton_horse": {
                    d = new MobDisguise(DisguiseType.SKELETON_HORSE, true);
                    HorseWatcher hws3 = (HorseWatcher)d.getWatcher();
                    if (mm.horseStyle != null) {
                        hws3.setStyle(Horse.Style.valueOf((String)mm.horseStyle));
                    }
                    if (mm.color != null) {
                        hws3.setColor(Horse.Color.valueOf((String)mm.color));
                    }
                    if (mm.horseArmor != null) {
                        switch (mm.horseArmor) {
                            case "diamond": {
                                hws3.setHorseArmor(new ItemStack(Material.DIAMOND_BARDING, 1, 0));
                                break;
                            }
                            case "gold": 
                            case "golden": {
                                hws3.setHorseArmor(new ItemStack(Material.GOLD_BARDING, 1, 0));
                                break;
                            }
                            default: {
                                hws3.setHorseArmor(new ItemStack(Material.IRON_BARDING, 1, 0));
                            }
                        }
                    }
                    if (mm.horseSaddled) {
                        hws3.setSaddled(true);
                    }
                    if (!mm.horseChest) break;
                    hws3.setCarryingChest(true);
                    break;
                }
                case "squid": {
                    d = new MobDisguise(DisguiseType.SQUID, true);
                    break;
                }
                case "thrown_xp_bottle": 
                case "xp_bottle": {
                    d = new MiscDisguise(DisguiseType.THROWN_EXP_BOTTLE);
                    break;
                }
                case "experience_orb": 
                case "exp": 
                case "xp": 
                case "xporb": {
                    d = new MiscDisguise(DisguiseType.EXPERIENCE_ORB);
                    break;
                }
                case "villager": {
                    d = new MobDisguise(DisguiseType.VILLAGER, true);
                    VillagerWatcher vw = (VillagerWatcher)d.getWatcher();
                    if (mm.villagerType == null) break;
                    vw.setProfession(Villager.Profession.valueOf((String)mm.villagerType));
                    break;
                }
                case "babyvillager": {
                    d = new MobDisguise(DisguiseType.VILLAGER, true);
                    VillagerWatcher vwb = (VillagerWatcher)d.getWatcher();
                    vwb.setBaby();
                    if (mm.villagerType == null) break;
                    vwb.setProfession(Villager.Profession.valueOf((String)mm.villagerType));
                    break;
                }
                case "witch": {
                    d = new MobDisguise(DisguiseType.WITCH, true);
                    break;
                }
                case "wither": {
                    d = new MobDisguise(DisguiseType.WITHER, true);
                    break;
                }
                case "witherskeleton": 
                case "wither_skeleton": {
                    d = new MobDisguise(DisguiseType.WITHER_SKELETON);
                    break;
                }
                case "witherskull": 
                case "wither_skull": {
                    d = new MiscDisguise(DisguiseType.WITHER_SKULL);
                    break;
                }
                case "wolf": {
                    d = new MobDisguise(DisguiseType.WOLF, true);
                    WolfWatcher ww = (WolfWatcher)d.getWatcher();
                    boolean angry = mc.getBoolean("Disguise.Angry", false);
                    ww.setAngry(angry);
                    break;
                }
                case "babywolf": {
                    d = new MobDisguise(DisguiseType.WOLF, true);
                    WolfWatcher bww = (WolfWatcher)d.getWatcher();
                    boolean angry2 = mc.getBoolean("Disguise.Angry", false);
                    bww.setBaby();
                    bww.setAngry(angry2);
                    break;
                }
                case "undead_horse": 
                case "zombie_horse": {
                    d = new MobDisguise(DisguiseType.UNDEAD_HORSE, true);
                    HorseWatcher hwz = (HorseWatcher)d.getWatcher();
                    if (mm.horseStyle != null) {
                        hwz.setStyle(Horse.Style.valueOf((String)mm.horseStyle));
                    }
                    if (mm.color != null) {
                        hwz.setColor(Horse.Color.valueOf((String)mm.color));
                    }
                    if (mm.horseArmor != null) {
                        switch (mm.horseArmor) {
                            case "diamond": {
                                hwz.setHorseArmor(new ItemStack(Material.DIAMOND_BARDING, 1, 0));
                                break;
                            }
                            case "gold": 
                            case "golden": {
                                hwz.setHorseArmor(new ItemStack(Material.GOLD_BARDING, 1, 0));
                                break;
                            }
                            default: {
                                hwz.setHorseArmor(new ItemStack(Material.IRON_BARDING, 1, 0));
                            }
                        }
                    }
                    if (mm.horseSaddled) {
                        hwz.setSaddled(true);
                    }
                    if (!mm.horseChest) break;
                    hwz.setCarryingChest(true);
                    break;
                }
                case "zombie": {
                    d = new MobDisguise(DisguiseType.ZOMBIE, true);
                    break;
                }
                case "zombievillager": 
                case "villagezombie": {
                    d = new MobDisguise(DisguiseType.ZOMBIE, true);
                    ZombieWatcher zw = (ZombieWatcher)d.getWatcher();
                    if (MythicMobs.inst().getMinecraftVersion() < 9) break;
                    zw.setProfession(Villager.Profession.FARMER);
                    break;
                }
                case "babyzombie": {
                    d = new MobDisguise(DisguiseType.ZOMBIE, true);
                    ZombieWatcher zwb = (ZombieWatcher)d.getWatcher();
                    zwb.setBaby();
                    break;
                }
                case "babyzombievillager": 
                case "babyvillagezombie": {
                    d = new MobDisguise(DisguiseType.ZOMBIE, true);
                    ZombieWatcher zwbv = (ZombieWatcher)d.getWatcher();
                    zwbv.setProfession(Villager.Profession.FARMER);
                    zwbv.setBaby();
                    break;
                }
                default: {
                    d = new PlayerDisguise("Xikage");
                }
            }
            if (d instanceof PlayerDisguise) {
                PlayerWatcher pw = (PlayerWatcher)d.getWatcher();
                pw.setCustomName(data);
            }
            FlagWatcher fw = d.getWatcher();
            if (mc.getBoolean("Disguise.Burning", false)) {
                fw.setBurning(true);
            }
            if (mc.getBoolean("Disguise.Invisible", false)) {
                fw.setInvisible(true);
            }
            if (mc.getBoolean("Disguise.Glowing", false)) {
                fw.setGlowing(true);
            }
            if (mc.getBoolean("Disguise.Gliding", false)) {
                fw.setFlyingWithElytra(true);
            }
            if (mc.getBoolean("Disguise.Blocking", false)) {
                fw.setRightClicking(true);
            }
            if (mc.getBoolean("Disguise.Sneaking", false)) {
                fw.setSneaking(true);
            }
            if (mc.getBoolean("Disguise.Sprinting", false)) {
                fw.setSprinting(true);
            }
            if (!mc.getBoolean("Disguise.ModifyBoundingBox", true)) {
                d.setModifyBoundingBox(false);
            }
            return d;
        }
        catch (Exception ex) {
            MythicMobs.error("Failed to process Disguise: " + disguise);
            ex.printStackTrace();
            return new MobDisguise(DisguiseType.ZOMBIE, true);
        }
    }

    public void setDisguise(ActiveMob am, Disguise d) {
        if (d == null) {
            d = new PlayerDisguise("Ashijin");
        }
        final LivingEntity e = am.getLivingEntity();
        final Disguise fd = d;
        if (fd instanceof PlayerDisguise) {
            PlayerWatcher pw = (PlayerWatcher)fd.getWatcher();
            String name = SkillString.parseMobVariables(((PlayerDisguise)d).getName(), am, null, null);
            if (name != null) {
                name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
            }
            d = new PlayerDisguise(name);
            d.setWatcher((FlagWatcher)pw);
        } else if (fd instanceof MobDisguise) {
            if (am.getType().getConfig().getBoolean("Disguise.ShowName", true)) {
                FlagWatcher watcher = fd.getWatcher();
                try {
                    watcher.setCustomName(SkillString.parseMobVariables(am.getType().getDisplayName(), am, null, null));
                    watcher.setCustomNameVisible(true);
                }
                catch (NoSuchMethodError ex) {
                    MythicMobs.plugin.handleError(ex);
                }
            }
        } else if (am.getType().getConfig().getBoolean("Disguise.ShowName", false)) {
            FlagWatcher watcher = fd.getWatcher();
            try {
                watcher.setCustomName(SkillString.parseMobVariables(am.getType().getDisplayName(), am, null, null));
                watcher.setCustomNameVisible(true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        DisguiseAPI.disguiseToAll((Entity)e, (Disguise)fd);
        new BukkitRunnable(){

            public void run() {
                DisguiseAPI.disguiseToAll((Entity)e, (Disguise)fd);
            }
        }.runTaskLater((Plugin)MythicMobs.plugin, 5L);
    }
}

