/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Adapters.Bukkit.Commands;

import java.util.Set;
import java.util.UUID;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Commands.CommandHandler;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.WorldScaling;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.SkillString;
import net.elseland.xikage.MythicMobs.Util.MythicUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class UtilityCommands {
    public static void menuCommands(CommandSender sender) {
        sender.sendMessage(MythicMobs.menu_header);
        sender.sendMessage(ChatColor.YELLOW + "" + ChatColor.ITALIC + "Command argumnts in <>'s are optional");
        sender.sendMessage(ChatColor.GOLD + "/mm utility GetBlockCoords" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Gives you the exact coordinates of the block you're looking at.");
        sender.sendMessage(ChatColor.GOLD + "/mm utility GetTargetInfo" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Gives you info about the target you're looking at.");
        sender.sendMessage(ChatColor.GOLD + "/mm utility ListItemNBT" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Lists the NBT data of the item you are holding.");
        sender.sendMessage(ChatColor.GOLD + "/mm utility ListRegisteredEntities" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Lists all entities registered in Bukkit (mainly for modded versions).");
        sender.sendMessage(ChatColor.GOLD + "/mm utility PrintVoidList" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Prints UUIDs of mobs in the void list.");
        sender.sendMessage(ChatColor.GOLD + "/mm utility GetSpawnLevel" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Tells you what level a vanilla mob would be spawning at your current location.");
    }

    public static void parseCommands(CommandSender sender, Command cmd, String commandlabel, String[] args) {
        if (args.length == 1) {
            UtilityCommands.menuCommands(sender);
            return;
        }
        switch (args[1].toLowerCase()) {
            case "broadcast": 
            case "b": {
                UtilityCommands.cmdBroadcast(sender, args);
                break;
            }
            case "getblockcoords": 
            case "blockcoords": 
            case "gbc": {
                UtilityCommands.cmdGetBlockCoords(sender, args);
                break;
            }
            case "gettargetinfo": 
            case "targetinfo": 
            case "gti": {
                UtilityCommands.cmdGetTargetInfo(sender, args);
                break;
            }
            case "getspawnlevel": 
            case "gsl": {
                UtilityCommands.cmdGetSpawnLevel(sender, args);
                break;
            }
            case "listregisteredentities": 
            case "listentities": 
            case "lre": {
                UtilityCommands.cmdListRegisteredEntities(sender, args);
                break;
            }
            case "listitemnbt": {
                UtilityCommands.cmdListItemNBT(sender, args);
                break;
            }
            case "printvoidlist": 
            case "voidlist": {
                UtilityCommands.cmdPrintVoidList(sender, args);
                break;
            }
            default: {
                UtilityCommands.menuCommands(sender);
            }
        }
    }

    private static void cmdGetSpawnLevel(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        Player p = (Player)sender;
        AbstractLocation l = BukkitAdapter.adapt(p.getLocation());
        WorldScaling.getLevelBonus(l);
        sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Distance from Spawn: " + ChatColor.WHITE + l.distance2D(l.getWorld().getSpawnLocation()));
        sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Blocks per Level: " + ChatColor.WHITE + WorldScaling.get(l.getWorld().getName()).getScaleFactor_BlocksFromSpawn());
        sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawn Level for your location: " + ChatColor.WHITE + "1 + " + WorldScaling.getLevelBonus(l));
    }

    public static void cmdBroadcast(CommandSender sender, String[] args) {
        String s = "";
        for (int i = 2; i < args.length; ++i) {
            s = s.concat(args[i]) + " ";
        }
        s = SkillString.parseMessageSpecialChars(s);
        s = ChatColor.translateAlternateColorCodes((char)'&', (String)s);
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            p.sendMessage(s);
        }
    }

    public static void cmdGetBlockCoords(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        Player p = (Player)sender;
        Location location = p.getTargetBlock((Set)null, 64).getLocation();
        if (location == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must target a valid block!");
            return;
        }
        sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Coordinates you are targeting: " + ChatColor.AQUA + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ() + ChatColor.GREEN + " (x,y,z)");
    }

    public static void cmdGetTargetInfo(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        Player p = (Player)sender;
        LivingEntity l = MythicUtil.getTargetedEntity(p);
        if (l == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must target a valid entity!");
            return;
        }
        sender.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "Information About Target Mod:");
        sender.sendMessage(ChatColor.GOLD + "UUID: " + ChatColor.GRAY + l.getUniqueId());
        if (MythicMobs.inst().getMobManager().isActiveMob(l.getUniqueId())) {
            sender.sendMessage(ChatColor.GOLD + "Is Active MythicMob: " + ChatColor.GRAY + "TRUE");
        } else {
            sender.sendMessage(ChatColor.GOLD + "Is Active MythicMob: " + ChatColor.GRAY + "FALSE");
        }
        if (MythicMobs.inst().getMobManager().getVoidList().contains(l.getUniqueId())) {
            sender.sendMessage(ChatColor.GOLD + "Is In Void List: " + ChatColor.GRAY + "TRUE");
        } else {
            sender.sendMessage(ChatColor.GOLD + "Is In Void List: " + ChatColor.GRAY + "FALSE");
        }
        if (MythicMobs.inst().getMobManager().isActiveMob(l.getUniqueId())) {
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)l);
            am.remountSpawner();
            sender.sendMessage(ChatColor.GOLD + "EntityType: " + ChatColor.GRAY + am.getType().getEntityType());
            sender.sendMessage(ChatColor.GOLD + "MythicType: " + ChatColor.GRAY + am.getType().getInternalName());
            sender.sendMessage(ChatColor.GOLD + "Level: " + ChatColor.GRAY + am.getLevel());
            sender.sendMessage(ChatColor.GOLD + "TypeHealth: " + ChatColor.GRAY + am.getType().getBaseHealth());
            sender.sendMessage(ChatColor.GOLD + "+LevelHealth: " + ChatColor.GRAY + am.getType().getPerLevelHealth());
            sender.sendMessage(ChatColor.GOLD + "TargetHealth: " + ChatColor.GRAY + am.getEntity().getHealth());
            sender.sendMessage(ChatColor.GOLD + "TypeDamage: " + ChatColor.GRAY + am.getType().getBaseDamage());
            sender.sendMessage(ChatColor.GOLD + "TargetDamage: " + ChatColor.GRAY + am.getDamage());
            sender.sendMessage(ChatColor.GOLD + "+LevelPower: " + ChatColor.GRAY + am.getType().getPerLevelPower());
            sender.sendMessage(ChatColor.GOLD + "TargetPower: " + ChatColor.GRAY + am.getPower());
            sender.sendMessage(ChatColor.GOLD + "Current Stance: " + ChatColor.GRAY + am.getStance());
            if (am.getSpawner() == null) {
                sender.sendMessage(ChatColor.GOLD + "FromSpawner: " + ChatColor.GRAY + "FALSE");
            } else {
                sender.sendMessage(ChatColor.GOLD + "FromSpawner: " + ChatColor.AQUA + am.getSpawner().getInternalName());
            }
            if (am.isDead()) {
                sender.sendMessage(ChatColor.GOLD + "Marked as Dead: " + ChatColor.GRAY + "TRUE");
            } else {
                sender.sendMessage(ChatColor.GOLD + "Marked as Dead: " + ChatColor.GRAY + "FALSE");
            }
            if (am.getEntity().isValid()) {
                sender.sendMessage(ChatColor.GOLD + "Marked as Valid: " + ChatColor.GRAY + "TRUE");
            } else {
                sender.sendMessage(ChatColor.GOLD + "Marked as Valid: " + ChatColor.GRAY + "FALSE");
            }
            if (am.hasThreatTable()) {
                sender.sendMessage(ChatColor.GOLD + "Using ThreatTable: " + ChatColor.GRAY + "TRUE");
                if (am.getThreatTable().inCombat()) {
                    sender.sendMessage(ChatColor.GOLD + "Top Threat Target: " + ChatColor.GRAY + am.getThreatTable().getTopThreatHolder().getName() + " (" + am.getThreatTable().getTopTargetThreat() + ")");
                    sender.sendMessage(ChatColor.GOLD + "Total Threat: " + ChatColor.GRAY + am.getThreatTable().getTotalThreat());
                    sender.sendMessage(ChatColor.GOLD + "-- Threat Targets: ");
                    for (AbstractEntity le : am.getThreatTable().getAllThreatTargets()) {
                        sender.sendMessage(ChatColor.GOLD + "* " + le.getName() + " (" + am.getThreatTable().getThreat(le) + ")");
                    }
                } else {
                    sender.sendMessage(ChatColor.GOLD + "-- Mob Not In Combat");
                }
            } else {
                sender.sendMessage(ChatColor.GOLD + "Using ThreatTable: " + ChatColor.GRAY + "FALSE");
            }
        }
    }

    public static void cmdListItemNBT(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Finding NBT Data of Item in Hand...");
        MythicMobs.plugin.volatileCodeHandler.listItemAttributes((Player)sender);
    }

    public static void cmdListRegisteredEntities(CommandSender sender, String[] args) {
        sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Printing registered LivingEntity types...");
        for (EntityType type : EntityType.values()) {
            sender.sendMessage(ChatColor.GOLD + "- " + ChatColor.WHITE + type.toString());
        }
        sender.sendMessage("" + ChatColor.RED + ChatColor.ITALIC + "* Note: Remember, only 'living' entity types can be used in MythicMobs. Do not use non-living types!");
    }

    public static void cmdPrintVoidList(CommandSender sender, String[] args) {
        sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Printing UUIDs in Void List...");
        for (UUID u : MythicMobs.inst().getMobManager().getVoidList()) {
            sender.sendMessage(ChatColor.GOLD + "- " + ChatColor.WHITE + u.toString());
        }
    }
}

