/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Adapters.Bukkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.elseland.xikage.MythicMobs.API.Bukkit.Events.MythicMobDeathEvent;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractPlayer;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Adapters.TaskManager;
import net.elseland.xikage.MythicMobs.Compatibility.CompatibilityManager;
import net.elseland.xikage.MythicMobs.Drops.DropHandler;
import net.elseland.xikage.MythicMobs.Drops.MythicDropTable;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.MobManager;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.QueuedMobSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillString;
import net.elseland.xikage.MythicMobs.Skills.SkillTrigger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class BukkitSkillTriggers
implements Listener {
    @EventHandler(priority=EventPriority.NORMAL)
    public void onDamagedTrigger(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof LivingEntity) || e.getEntity() instanceof Player) {
            return;
        }
        if (MythicMobs.inst().getMobManager().getVoidList().contains(e.getEntity().getUniqueId())) {
            return;
        }
        final LivingEntity damaged = (LivingEntity)e.getEntity();
        final ActiveMob am = !MythicMobs.inst().getMobManager().isActiveMob(damaged.getUniqueId()) ? MythicMobs.inst().getMobManager().registerActiveMob(BukkitAdapter.adapt((Entity)damaged)) : MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)damaged);
        if (am == null) {
            return;
        }
        MythicMobs.debug(3, "-- MythicMob " + am.getType().getInternalName() + " took damage!");
        if (am.hasImmunityTable() && !(e instanceof EntityDamageByEntityEvent)) {
            if (am.getImmunityTable().onCooldown(null)) {
                e.setCancelled(true);
                MythicMobs.debug(3, "---- MythicMob is currently immune to damage from non-player sources!");
                return;
            }
            am.getImmunityTable().setCooldown(null);
            MythicMobs.debug(3, "---- Setting MythicMob immune to damage from non-player sources!");
        }
        if (am.getType().getIsInvincible()) {
            MythicMobs.debug(3, "---- MythicMob is optionInvincible, canceling damage.");
            e.setCancelled(true);
            return;
        }
        double damage = e.getDamage();
        if (am.getArmor() > 0.0) {
            MythicMobs.debug(3, "---- Modifying damage based on armor: " + am.getArmor());
            damage -= am.getArmor();
            if (damage < 1.0) {
                damage = 1.0;
            }
            e.setDamage(damage);
        }
        if (am.getType().getDamageModifiers() != null) {
            for (String dm : am.getType().getDamageModifiers()) {
                String[] split = dm.split(" ");
                try {
                    if (EntityDamageEvent.DamageCause.valueOf((String)split[0]) != e.getCause()) continue;
                    if ((damage *= Double.parseDouble(split[1])) > 0.0) {
                        e.setDamage(damage);
                        continue;
                    }
                    if (damage == 0.0) {
                        e.setDamage(0.0);
                        continue;
                    }
                    if (!(damage < 0.0)) continue;
                    e.setDamage(0.0);
                    e.setCancelled(true);
                    if (damaged.getHealth() - damage > damaged.getMaxHealth()) {
                        damaged.setHealth(damaged.getMaxHealth());
                        continue;
                    }
                    damaged.setHealth(damaged.getHealth() - damage);
                }
                catch (Exception exception) {}
            }
        }
        if (am.hasImmunityTable()) {
            TaskManager.get().runLater(new Runnable(){

                @Override
                public void run() {
                    damaged.setNoDamageTicks(0);
                }
            }, 1);
        } else if (am.getNoDamageTicks() != 20) {
            TaskManager.get().runLater(new Runnable(){

                @Override
                public void run() {
                    damaged.setNoDamageTicks(am.getNoDamageTicks());
                }
            }, 1);
        }
        if (am.getType().digout && e.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION) {
            Location Loc = damaged.getLocation().add(0.0, 2.0, 0.0);
            damaged.teleport(Loc);
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInteractTrigger(PlayerInteractAtEntityEvent e) {
        if (MythicMobs.inst().getMinecraftVersion() >= 9 && e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Entity l = e.getRightClicked();
        if (!MythicMobs.inst().getMobManager().isActiveMob(l.getUniqueId())) {
            return;
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(l));
        new QueuedMobSkill(SkillTrigger.INTERACT, am, BukkitAdapter.adapt(e.getPlayer()), true);
        if (!am.getType().getIsInteractable()) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDeathTrigger(EntityDeathEvent e) {
        boolean good = true;
        AbstractEntity killedEntity = BukkitAdapter.adapt((Entity)e.getEntity());
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(killedEntity);
        if (am != null) {
            LivingEntity killerLE;
            MythicMob mm = am.getType();
            Player killer = BukkitSkillTriggers.getPlayerKiller(e);
            if (killer == null && (killerLE = this.getKiller(e)) != null && MythicMobs.inst().getMobManager().isActiveMob(killerLE.getUniqueId())) {
                ActiveMob amkiller = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killerLE));
                if (!killedEntity.isPlayer() && amkiller.getType().preventMobKillDrops) {
                    e.getDrops().clear();
                    good = false;
                }
            }
            new QueuedMobSkill(SkillTrigger.DEATH, am, BukkitAdapter.adapt(killer));
            if (mm.preventOtherDrops) {
                e.getDrops().clear();
                e.setDroppedExp(0);
            }
            ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
            int exp = 0;
            int cexp = 0;
            int hexp = 0;
            int sexp = 0;
            int mexp = 0;
            boolean modExp = false;
            double money = 0.0;
            if (mm.getDrops() == null) {
                good = false;
            }
            if (good) {
                for (String string : mm.getDrops()) {
                    MythicMobs.debug(2, "-- Parsing drops: " + string);
                    MythicDropTable dt = DropHandler.getMythicDropTable(string);
                    if (dt == null) {
                        List<String> baseEquipmentList = Arrays.asList(string);
                        dt = new MythicDropTable(baseEquipmentList, null, null, null, null);
                    }
                    dt.parseTable(am, BukkitAdapter.adapt(killer));
                    for (ItemStack iS : dt.getDrops()) {
                        loot.add(iS);
                    }
                    if (dt.modifiesExperience()) {
                        modExp = true;
                    }
                    exp += dt.getExp();
                    cexp += dt.getChampionsExp();
                    hexp += dt.getHeroesExp();
                    sexp += dt.getSkillAPIExp();
                    mexp += dt.getMcMMOExp();
                    money += dt.getMoney();
                }
                if (mm.getDropsPerLevel() != null) {
                    for (int i = 0; i < am.getLevel(); ++i) {
                        for (String s : mm.getDropsPerLevel()) {
                            Object dt = DropHandler.getMythicDropTable(s);
                            if (dt == null) {
                                List<String> baseEquipmentList = Arrays.asList(s);
                                dt = new MythicDropTable(baseEquipmentList, null, null, null, null);
                            }
                            ((MythicDropTable)dt).parseTable(am, BukkitAdapter.adapt(killer));
                            for (ItemStack iS : ((MythicDropTable)dt).getDrops()) {
                                loot.add(iS);
                            }
                            if (((MythicDropTable)dt).modifiesExperience()) {
                                modExp = true;
                            }
                            exp += ((MythicDropTable)dt).getExp();
                            cexp += ((MythicDropTable)dt).getChampionsExp();
                            hexp += ((MythicDropTable)dt).getHeroesExp();
                            sexp += ((MythicDropTable)dt).getSkillAPIExp();
                            mexp += ((MythicDropTable)dt).getMcMMOExp();
                            money += ((MythicDropTable)dt).getMoney();
                        }
                    }
                }
            }
            Player eKiller = killer == null ? e.getEntity().getKiller() : killer;
            AbstractEntity abstractEntity = BukkitAdapter.adapt((Entity)eKiller);
            MythicMobs.debug(1, "Calling MythicMobDeathEvent for " + killedEntity.getCustomName() + " (loot: " + ((Object)loot).toString() + " , exp: " + exp + ")");
            MythicMobDeathEvent event = new MythicMobDeathEvent(am, (LivingEntity)eKiller, loot, exp, money);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            for (ItemStack iS : event.getDrops()) {
                e.getDrops().add(iS);
            }
            if (modExp) {
                e.setDroppedExp(event.getExp());
            }
            if (killer != null) {
                String message;
                if (CompatibilityManager.Champions != null && cexp > 0) {
                    MythicMobs.debug(2, "Granting " + cexp + " Champions EXP to " + killer.getName());
                    CompatibilityManager.Champions.giveExp(BukkitAdapter.adapt(killer), cexp);
                }
                if (CompatibilityManager.Heroes != null && hexp > 0) {
                    MythicMobs.debug(2, "Granting " + hexp + " Heroes EXP to " + killer.getName());
                    CompatibilityManager.Heroes.giveHeroesExp(am, killer, hexp);
                }
                if (CompatibilityManager.SkillAPI != null && sexp > 0) {
                    MythicMobs.debug(2, "Granting " + sexp + " SkillAPI EXP to " + killer.getName());
                    CompatibilityManager.SkillAPI.giveExp(killer, sexp);
                    if (Configuration.compatSkillAPIShowXPMessage) {
                        message = Configuration.compatSkillAPIXPMessageFormat;
                        message = SkillString.parseMobVariables(message, am, null, abstractEntity);
                        message = message.replace("<drops.xp>", String.valueOf(sexp));
                        killer.sendMessage(message);
                    }
                }
                if (CompatibilityManager.Vault != null && money > 0.0) {
                    MythicMobs.debug(2, "Granting " + event.getCurrency() + " Money to " + killer.getName());
                    CompatibilityManager.Vault.giveMoney(killer, event.getCurrency());
                    if (Configuration.compatVaultShowMoneyMessage) {
                        message = Configuration.compatVaultMoneyMessageFormat;
                        message = SkillString.parseMobVariables(message, am, null, abstractEntity);
                        message = message.replace("<drops.money>", String.valueOf(event.getCurrency()));
                        killer.sendMessage(message);
                    }
                }
                if (CompatibilityManager.mcMMO != null && mexp > 0) {
                    String skilltype = "unarmed";
                    if (e.getEntity().getKiller() instanceof Projectile) {
                        skilltype = "archery";
                    } else {
                        Material m = killer.getEquipment().getItemInHand().getType();
                        if (m == Material.STONE_SWORD || m == Material.WOOD_SWORD || m == Material.IRON_SWORD || m == Material.DIAMOND_SWORD) {
                            skilltype = "swords";
                        }
                    }
                    CompatibilityManager.mcMMO.giveExp(killer, mexp, skilltype);
                    if (Configuration.compatMcMMOShowXPMessage) {
                        String message2 = Configuration.compatMcMMOXPMessageFormat;
                        message2 = SkillString.parseMobVariables(message2, am, null, abstractEntity);
                        message2 = message2.replace("<drops.mcmmo>", String.valueOf(money));
                        killer.sendMessage(message2);
                    }
                }
            }
            if (!good) {
                e.setDroppedExp(0);
                e.getDrops().clear();
            }
            if (mm.getDisplayName() != null) {
                String display = SkillString.parseMobVariables(mm.getDisplayName(), am, null, abstractEntity);
                killedEntity.getBukkitEntity().setCustomName(display);
            }
            am.setDead();
            MobManager.QueuedMobCleanup mclup = new MobManager.QueuedMobCleanup(am);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.plugin, (Runnable)mclup, 200L);
        } else {
            LivingEntity killerLE = this.getKiller(e);
            if (killerLE != null && MythicMobs.inst().getMobManager().isActiveMob(killerLE.getUniqueId())) {
                ActiveMob amkiller = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killerLE));
                if (!killedEntity.isPlayer() && amkiller.getType().preventMobKillDrops) {
                    e.getDrops().clear();
                    e.setDroppedExp(0);
                    MythicMobs.debug(2, "A mob was killed by MythicMob with PreventKillDrops, cancelling drops!");
                }
            }
        }
        MythicMobs.inst().getMobManager().getActiveMobsInCombat().forEach(mob -> {
            if (mob.getEntity().isValid() && mob.getType().usesThreatTable()) {
                mob.getThreatTable().observeDeath(killedEntity);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerKillTrigger(PlayerDeathEvent e) {
        EntityDamageEvent entityDamageEvent;
        MythicMobs.debug(3, "Player was killed!");
        Player p = e.getEntity();
        Player k = p.getKiller();
        AbstractPlayer player = BukkitAdapter.adapt(p);
        if (Configuration.KillMessagePrefix != null && e.getDeathMessage() != null) {
            e.setDeathMessage(Configuration.KillMessagePrefix + e.getDeathMessage());
        }
        if (k == null && (entityDamageEvent = e.getEntity().getLastDamageCause()) != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            k = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
        }
        if (k instanceof LivingEntity) {
            MythicMobs.debug(3, "-- Player killed by Mob");
            LivingEntity killer = (LivingEntity)k;
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killer));
            if (am != null) {
                MythicMobs.debug(3, "---- Mob was a MythicMob!");
                new QueuedMobSkill(SkillTrigger.KILLPLAYER, am, player);
                am.incrementPlayerKills();
                if (am.getType().hasKillMessages()) {
                    String km = am.getType().getKillMessage();
                    km = SkillString.parseMobVariables(km, am, player, player);
                    e.setDeathMessage(km);
                }
            }
        } else if (k instanceof Projectile) {
            MythicMobs.debug(3, "-- Player killed by Projectile");
            ProjectileSource ps = ((Projectile)k).getShooter();
            if (ps instanceof LivingEntity) {
                LivingEntity shooter = (LivingEntity)ps;
                ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)shooter));
                if (am != null) {
                    MythicMobs.debug(3, "---- Projectile was fired by a MythicMob!");
                    new QueuedMobSkill(SkillTrigger.KILLPLAYER, am, player);
                    am.incrementPlayerKills();
                    if (am.getType().hasKillMessages()) {
                        String km = am.getType().getKillMessage();
                        km = SkillString.parseMobVariables(km, am, player, player);
                        e.setDeathMessage(km);
                    }
                }
            }
        } else {
            MythicMobs.debug(3, "-- Player killed by ????");
        }
    }

    private static Player getPlayerKiller(EntityDeathEvent event) {
        EntityDamageEvent entityDamageEvent = event.getEntity().getLastDamageCause();
        if (entityDamageEvent != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            Entity damager = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
            if (damager instanceof Projectile) {
                if (((Projectile)damager).getShooter() instanceof LivingEntity) {
                    LivingEntity shooter = (LivingEntity)((Projectile)damager).getShooter();
                    if (shooter != null && shooter instanceof Player) {
                        return (Player)shooter;
                    }
                } else {
                    return null;
                }
            }
            if (damager instanceof Player) {
                return (Player)damager;
            }
        }
        return null;
    }

    private LivingEntity getKiller(EntityDeathEvent event) {
        EntityDamageEvent entityDamageEvent = event.getEntity().getLastDamageCause();
        if (entityDamageEvent != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            Entity damager = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
            if (damager instanceof Projectile) {
                if (((Projectile)damager).getShooter() instanceof LivingEntity) {
                    LivingEntity shooter = (LivingEntity)((Projectile)damager).getShooter();
                    if (shooter != null && shooter instanceof LivingEntity) {
                        return shooter;
                    }
                } else {
                    return null;
                }
            }
            if (damager instanceof LivingEntity) {
                return (LivingEntity)damager;
            }
        }
        return null;
    }
}

