/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class AsciiCompass {
    public static Point getCompassPointForDirection(double inDegrees) {
        double degrees = (inDegrees - 180.0) % 360.0;
        if (degrees < 0.0) {
            degrees += 360.0;
        }
        if (0.0 <= degrees && degrees < 22.5) {
            return Point.S;
        }
        if (22.5 <= degrees && degrees < 67.5) {
            return Point.SE;
        }
        if (67.5 <= degrees && degrees < 112.5) {
            return Point.E;
        }
        if (112.5 <= degrees && degrees < 157.5) {
            return Point.NE;
        }
        if (157.5 <= degrees && degrees < 202.5) {
            return Point.N;
        }
        if (202.5 <= degrees && degrees < 247.5) {
            return Point.SW;
        }
        if (247.5 <= degrees && degrees < 292.5) {
            return Point.W;
        }
        if (292.5 <= degrees && degrees < 337.5) {
            return Point.NW;
        }
        if (337.5 <= degrees && degrees < 360.0) {
            return Point.S;
        }
        return null;
    }

    public static Point getCardinalDirection(Player player) {
        double rotation = (player.getLocation().getYaw() - 90.0f) % 360.0f;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        if (0.0 <= rotation && rotation < 22.5) {
            return Point.W;
        }
        if (22.5 <= rotation && rotation < 67.5) {
            return Point.NW;
        }
        if (67.5 <= rotation && rotation < 112.5) {
            return Point.N;
        }
        if (112.5 <= rotation && rotation < 157.5) {
            return Point.NE;
        }
        if (157.5 <= rotation && rotation < 202.5) {
            return Point.E;
        }
        if (202.5 <= rotation && rotation < 247.5) {
            return Point.SE;
        }
        if (247.5 <= rotation && rotation < 292.5) {
            return Point.S;
        }
        if (292.5 <= rotation && rotation < 337.5) {
            return Point.SW;
        }
        if (337.5 <= rotation && rotation < 360.0) {
            return Point.W;
        }
        return null;
    }

    public static ArrayList<String> getAsciiCompass(Point point, ChatColor colorActive, String colorDefault) {
        ArrayList<String> ret = new ArrayList<String>();
        String row = "";
        row = String.valueOf(row) + Point.NW.toString(Point.NW == point, colorActive, colorDefault);
        row = String.valueOf(row) + Point.W.toString(Point.W == point, colorActive, colorDefault);
        row = String.valueOf(row) + Point.SW.toString(Point.NE == point, colorActive, colorDefault);
        ret.add(row);
        row = "";
        row = String.valueOf(row) + Point.N.toString(Point.N == point, colorActive, colorDefault);
        row = String.valueOf(row) + colorDefault + "+";
        row = String.valueOf(row) + Point.S.toString(Point.S == point, colorActive, colorDefault);
        ret.add(row);
        row = "";
        row = String.valueOf(row) + Point.NE.toString(Point.SW == point, colorActive, colorDefault);
        row = String.valueOf(row) + Point.E.toString(Point.E == point, colorActive, colorDefault);
        row = String.valueOf(row) + Point.SE.toString(Point.SE == point, colorActive, colorDefault);
        ret.add(row);
        return ret;
    }

    public static ArrayList<String> getAsciiCompass(double inDegrees, ChatColor colorActive, String colorDefault) {
        return AsciiCompass.getAsciiCompass(AsciiCompass.getCompassPointForDirection(inDegrees), colorActive, colorDefault);
    }

    public static enum Point {
        N('N'),
        NE('/'),
        E('E'),
        SE('\\'),
        S('S'),
        SW('/'),
        W('W'),
        NW('\\');

        public final char asciiChar;

        private Point(char asciiChar) {
            this.asciiChar = asciiChar;
        }

        public String toString() {
            return String.valueOf(this.asciiChar);
        }

        public String toString(boolean isActive, ChatColor colorActive, String colorDefault) {
            return (isActive ? colorActive : colorDefault) + String.valueOf(this.asciiChar);
        }
    }
}

