/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.PowerUp;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.gui.GUIManagement;
import org.kingdoms.utils.LoreOrganizer;

public class NexusGUIManager
extends Manager
implements Listener {
    public static Map<ItemStack, Integer> whiteListed = new HashMap<ItemStack, Integer>();
    public static ArrayList<ItemStack> blackListed = null;
    public static Map<ItemStack, Integer> specials = new HashMap<ItemStack, Integer>();

    public NexusGUIManager(Plugin plugin) {
        super(plugin);
        this.init();
    }

    private void init() {
        if (Kingdoms.config.useWhiteList) {
            int i = 0;
            while (i < Kingdoms.config.whitelist_items.size()) {
                String str = Kingdoms.config.whitelist_items.get(i);
                if (str != null) {
                    String[] split = Kingdoms.config.whitelist_items.get(i).split(",");
                    if (split.length != 2) {
                        Kingdoms.logInfo((String)("[ERROR]: Your whitelist item, " + Kingdoms.config.whitelist_items.get(i) + " needs to be in the format of [MATERIAL],[ITEM VALUE]"));
                    } else {
                        try {
                            ItemStack item = null;
                            int point = Integer.parseInt(split[1]);
                            String[] matSplit = split[0].split(":");
                            item = matSplit.length == 2 ? new ItemStack(Material.valueOf((String)matSplit[0]), 1, (short)((byte)Integer.parseInt(matSplit[1]))) : new ItemStack(Material.valueOf((String)split[0]), 1);
                            whiteListed.put(item, point);
                        }
                        catch (NumberFormatException e) {
                            Kingdoms.logInfo((String)("[ERROR]: Your whitelist item, " + Kingdoms.config.whitelist_items.get(i) + " has invalid point value [" + split[1] + "]"));
                        }
                        catch (IllegalArgumentException e) {
                            Kingdoms.logInfo((String)("[ERROR]: Your whitelist item, " + Kingdoms.config.whitelist_items.get(i) + " has unknown material name [" + split[0] + "]"));
                        }
                    }
                }
                ++i;
            }
        } else {
            ArrayList<ItemStack> blacklists = new ArrayList<ItemStack>();
            for (String matName : Kingdoms.config.blacklist_items) {
                try {
                    ItemStack item = null;
                    String[] matNameSplit = matName.split(":");
                    item = matNameSplit.length == 2 ? new ItemStack(Material.valueOf((String)matNameSplit[0]), 1, (short)((byte)Integer.parseInt(matNameSplit[1]))) : new ItemStack(Material.valueOf((String)matName), 1);
                    blacklists.add(item);
                }
                catch (NumberFormatException e) {
                    Kingdoms.logInfo((String)("[ERROR]: Your blacklisted item " + matName + " has an invalid item value"));
                }
                catch (IllegalArgumentException e) {
                    Kingdoms.logInfo((String)("[ERROR]: Your blacklisted item " + matName + " is an unknown material name."));
                }
            }
            if (!blacklists.isEmpty()) {
                blackListed = blacklists;
            } else {
                blacklists.add(new ItemStack(Material.AIR));
                blackListed = blacklists;
            }
            int i = 0;
            while (i < Kingdoms.config.special_items.size()) {
                String str = Kingdoms.config.special_items.get(i);
                if (str != null) {
                    String[] split = Kingdoms.config.special_items.get(i).split(",");
                    if (split.length != 2) {
                        Kingdoms.logInfo((String)("[ERROR]: Your special item, " + Kingdoms.config.special_items.get(i) + " needs to be in the format of [MATERIAL],[ITEM VALUE]"));
                    } else {
                        try {
                            ItemStack item = null;
                            int point = Integer.parseInt(split[1]);
                            String[] matSplit = split[0].split(":");
                            item = matSplit.length == 2 ? new ItemStack(Material.valueOf((String)matSplit[0]), 1, (short)((byte)Integer.parseInt(matSplit[1]))) : new ItemStack(Material.valueOf((String)split[0]), 1);
                            specials.put(item, point);
                        }
                        catch (NumberFormatException e) {
                            Kingdoms.logInfo((String)("[ERROR]: Your special item, " + Kingdoms.config.special_items.get(i) + " has invalid point value [" + split[1] + "]"));
                        }
                        catch (IllegalArgumentException e) {
                            Kingdoms.logInfo((String)("[ERROR]: Your special item, " + Kingdoms.config.special_items.get(i) + " has unknown material name [" + split[0] + "]"));
                        }
                    }
                }
                ++i;
            }
        }
    }

    @EventHandler
    public void onBackBtnMove(InventoryClickEvent event) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)event.getWhoClicked());
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Back_Btn))) {
            event.setCancelled(true);
            kp.getPlayer().closeInventory();
            this.openNexusGui(kp);
            return;
        }
    }

    @EventHandler
    public void onInventoryMove(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)event.getWhoClicked());
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        if (!event.getInventory().getName().endsWith(ChatColor.AQUA + kp.getKingdom().getKingdomName() + "'s nexus")) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getLore() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!Kingdoms.config.allowingNexusAccessForGameModes.contains(kp.getPlayer().getGameMode().name())) {
            kp.sendMessage(LanguageSupport.Languages.Misc_IllegalGamemode);
            return;
        }
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        List lores = event.getCurrentItem().getItemMeta().getLore();
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_KingdomChest_Title))) {
            if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getChest())) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getChest().toString()));
                return;
            }
            this.openKingdomChest(kp);
            return;
        }
        if (lores.contains(ChatColor.LIGHT_PURPLE + "Nexus Upgrade")) {
            if (!kp.getRank().isHigherOrEqualTo(Rank.MODS)) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", "MODS"));
                return;
            }
            int cost = 0;
            int max = 1;
            int resourcePoint = kingdom.getResourcepoints();
            PowerUp powerup = kingdom.getPowerUp();
            if (displayName.equalsIgnoreCase(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_DamageReduction_Title))) {
                cost = Kingdoms.config.nexusupgrades_dmg_reduc_cost;
                max = Kingdoms.config.nexusupgrades_dmg_reduc_max;
                if (resourcePoint - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (powerup.getDmgreduction() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(resourcePoint - cost);
                powerup.setDmgreduction(powerup.getDmgreduction() + 1);
                kingdom.sendAnnouncement(kp, ChatColor.GOLD + "DamageReduction: " + ChatColor.DARK_GREEN + powerup.getDmgreduction(), false);
            } else if (displayName.equalsIgnoreCase(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regeneration_Title))) {
                cost = Kingdoms.config.nexusupgrades_regen_boost_cost;
                max = Kingdoms.config.nexusupgrades_regen_boost_max;
                if (resourcePoint - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (powerup.getRegenboost() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(resourcePoint - cost);
                powerup.setRegenboost(powerup.getRegenboost() + 1);
                kingdom.sendAnnouncement(kp, ChatColor.GOLD + "RegenBoost: " + ChatColor.DARK_GREEN + powerup.getRegenboost(), false);
            } else if (displayName.equalsIgnoreCase(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_DamageBoost_Title))) {
                cost = Kingdoms.config.nexusupgrades_dmg_boost_cost;
                max = Kingdoms.config.nexusupgrades_dmg_boost_max;
                if (resourcePoint - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (powerup.getDmgboost() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(resourcePoint - cost);
                powerup.setDmgboost(powerup.getDmgboost() + 1);
                kingdom.sendAnnouncement(kp, ChatColor.GOLD + "DamageBoost: " + ChatColor.DARK_GREEN + powerup.getDmgboost(), false);
            } else if (displayName.equalsIgnoreCase(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ArrowDamage_Title))) {
                cost = Kingdoms.config.nexusupgrades_arrow_boost_cost;
                max = Kingdoms.config.nexusupgrades_arrow_boost_max;
                if (resourcePoint - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (powerup.getArrowboost() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(resourcePoint - cost);
                powerup.setArrowboost(powerup.getArrowboost() + 1);
                kingdom.sendAnnouncement(kp, ChatColor.GOLD + "ArrowBoost: " + ChatColor.DARK_GREEN + powerup.getArrowboost(), false);
            } else if (displayName.equalsIgnoreCase(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_MaxMembers_Title))) {
                cost = Kingdoms.config.nexusupgrades_maxmembers_cost;
                max = Kingdoms.config.nexusupgrades_maxmembers_max;
                if (resourcePoint - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getMaxMember() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(resourcePoint - cost);
                kingdom.setMaxMember(kingdom.getMaxMember() + 1);
                kingdom.sendAnnouncement(kp, ChatColor.GOLD + "MaxMembers: " + ChatColor.DARK_GREEN + (kingdom.getMaxMember() + 10), false);
            } else if (displayName.equalsIgnoreCase(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_KingdomChestSize_Title))) {
                cost = 30;
                max = 27;
                if (resourcePoint - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChestsize() + 9 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(resourcePoint - cost);
                kingdom.setChestsize(kingdom.getChestsize() + 9);
                kingdom.sendAnnouncement(kp, ChatColor.GOLD + "ChestSize: " + ChatColor.DARK_GREEN + kingdom.getChestsize(), false);
            }
            kingdom.setPowerUp(powerup);
            this.openNexusGui(kp);
        }
        if (lores.contains(ChatColor.LIGHT_PURPLE + "Nexus Option")) {
            if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getRPConvert())) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getRPConvert().toString()));
                return;
            }
            if (displayName.equals(ChatColor.AQUA + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePointsConverter))) {
                Inventory inv = Bukkit.createInventory(null, (int)54, (String)(ChatColor.DARK_BLUE + "Close inventory to confirm."));
                kp.getPlayer().openInventory(inv);
            }
            return;
        }
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Conquests_Title))) {
            GUIManagement.getConquestGUIManager().openMenu(kp);
            return;
        }
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Logs_Title))) {
            GUIManagement.getLogManager().openMenu(kp);
            return;
        }
        if (!kp.getRank().isHigherOrEqualTo(Rank.MODS)) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", "MODS"));
            return;
        }
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_ChampionUpgrades_Title))) {
            GUIManagement.getChampGUIManager().openMenu(kp);
            return;
        }
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_MiscUpgrades_Title))) {
            GUIManagement.getMisGUIManager().openMenu(kp);
            return;
        }
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Turrets_Title))) {
            GUIManagement.getTurretGUIManager().openMenu(kp);
            return;
        }
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Structures_Title))) {
            GUIManagement.getStructureGUIManager().openMenu(kp);
            return;
        }
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Permissions_Title))) {
            GUIManagement.getPermissionsGUIManager().openMenu(kp);
            return;
        }
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Members_Title))) {
            GUIManagement.getMemberManager().openMenu(kp);
            return;
        }
        if (!kp.getRank().isHigherOrEqualTo(Rank.KING)) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", "KING"));
            return;
        }
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Neutral_Title))) {
            if (kingdom.hasInvaded()) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Neutral));
                return;
            }
            kingdom.setNeutral(!kingdom.isNeutral());
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Neutral_Toggled));
            this.openNexusGui(kp);
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)event.getPlayer());
        String invName = event.getInventory().getName();
        if (invName.equals(ChatColor.DARK_BLUE + "Close inventory to confirm.")) {
            int donatedamt = this.consumeDonationItems(event.getInventory().getContents(), kp);
            kp.getKingdom().setResourcepoints(kp.getKingdom().getResourcepoints() + donatedamt);
            kp.sendMessage(ChatColor.GREEN + "Your kingdom gained " + donatedamt + " resource points");
            kp.setLastTimeDonated(new Date());
            kp.setDonatedAmt(kp.getDonatedAmt() + donatedamt);
            kp.setLastDonatedAmt(donatedamt);
            return;
        }
        if (invName.startsWith(ChatColor.DARK_BLUE + "Donate to " + ChatColor.DARK_GREEN)) {
            String[] nsplit = event.getInventory().getName().split(" ");
            String sentKingdomName = ChatColor.stripColor((String)nsplit[nsplit.length - 1]);
            Kingdom sentTo = GameManagement.getKingdomManager().getOrLoadKingdom(sentKingdomName);
            int donatedamt = this.consumeDonationItems(event.getInventory().getContents(), kp);
            sentTo.setResourcepoints(sentTo.getResourcepoints() + donatedamt);
            kp.sendMessage(ChatColor.GREEN + sentKingdomName + " has gained " + donatedamt + " resource points. Thank you for your donation!");
            sentTo.sendAnnouncement(null, ChatColor.GREEN + kp.getPlayer().getName() + " has donated " + donatedamt + " resource points", true);
            return;
        }
        if (invName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_KingdomChest_Title))) {
            return;
        }
    }

    public boolean isSimilarMaterial(ItemStack item1, ItemStack item) {
        return item.getType().equals((Object)item1.getType()) && item.getDurability() == item1.getDurability();
    }

    private int isWhiteListed(ItemStack IS) {
        int i = 0;
        while (i < Kingdoms.config.whitelist_items.size()) {
            if (Kingdoms.config.whitelist_items.get(i) != null) {
                String[] split = Kingdoms.config.whitelist_items.get(i).split(",");
                if (split.length != 2) {
                    Kingdoms.logInfo((String)("[ERROR]: Your whitelist item, " + Kingdoms.config.whitelist_items.get(i) + " needs to be in the format of [MATERIAL],[ITEM VALUE]"));
                } else if (split[0].equalsIgnoreCase(IS.getType().toString())) {
                    return Integer.parseInt(split[1]);
                }
            }
            ++i;
        }
        return -1;
    }

    private int isSpecialItem(ItemStack IS) {
        int i = 0;
        while (i < Kingdoms.config.special_items.size()) {
            if (Kingdoms.config.special_items.get(i) != null) {
                String[] split = Kingdoms.config.special_items.get(i).split(",");
                if (split.length != 2) {
                    Kingdoms.logInfo((String)("[ERROR]: Your special item, " + Kingdoms.config.special_items.get(i) + " needs to be in the format of [MATERIAL],[ITEM VALUE]"));
                } else if (split[0].equalsIgnoreCase(IS.getType().toString())) {
                    return Integer.parseInt(split[1]);
                }
            }
            ++i;
        }
        return -1;
    }

    public int consumeDonationItems(ItemStack[] items, KingdomPlayer p) {
        ItemStack type;
        ItemStack item;
        int n;
        int n2;
        ItemStack[] itemStackArray;
        ArrayList<ItemStack> returningIS = new ArrayList<ItemStack>();
        int itemworth = 0;
        int itemsperrp = Kingdoms.config.items_needed_for_one_resource_point;
        if (Kingdoms.config.useWhiteList) {
            itemStackArray = items;
            n2 = items.length;
            n = 0;
            while (n < n2) {
                item = itemStackArray[n];
                if (item != null) {
                    type = new ItemStack(item.clone().getType(), 1, item.getDurability());
                    if (whiteListed.containsKey(type)) {
                        itemworth += item.getAmount() * whiteListed.get(type);
                    } else {
                        returningIS.add(item);
                    }
                }
                ++n;
            }
        } else {
            itemStackArray = items;
            n2 = items.length;
            n = 0;
            while (n < n2) {
                item = itemStackArray[n];
                if (item != null) {
                    Kingdoms.logDebug((String)(String.valueOf(item.getType().toString()) + "," + item.getAmount()));
                    type = new ItemStack(item.clone().getType(), 1, item.getDurability());
                    if (blackListed.contains(type)) {
                        String message = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Be_Traded_For_Points).replaceAll("%item%", item.getType().name());
                        if (type.getDurability() != 0) {
                            message = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Be_Traded_For_Points).replaceAll("%item%", String.valueOf(item.getType().name()) + ":" + item.getDurability());
                        }
                        p.sendMessage(message);
                        returningIS.add(item);
                    } else {
                        itemworth = specials.containsKey(type) ? (itemworth += item.getAmount() * specials.get(type)) : (itemworth += item.getAmount());
                    }
                }
                ++n;
            }
        }
        if (itemworth % Kingdoms.config.items_needed_for_one_resource_point != 0) {
            int itemoverflow = itemworth % Kingdoms.config.items_needed_for_one_resource_point;
            ItemStack[] itemStackArray2 = items;
            int n3 = items.length;
            n2 = 0;
            while (n2 < n3) {
                ItemStack item2 = itemStackArray2[n2];
                if (item2 != null) {
                    ItemStack type2 = new ItemStack(item2.clone().getType(), 1, item2.getDurability());
                    int worth = 1;
                    if (specials.containsKey(type2)) {
                        worth = specials.get(type2);
                    }
                    int originalAmount = item2.getAmount();
                    int removedAmount = 0;
                    while (itemworth % Kingdoms.config.items_needed_for_one_resource_point != 0 && itemworth - worth >= itemworth / Kingdoms.config.items_needed_for_one_resource_point * Kingdoms.config.items_needed_for_one_resource_point && originalAmount - removedAmount > 0) {
                        itemworth -= worth;
                        returningIS.add(type2);
                        ++removedAmount;
                    }
                    if (itemworth % Kingdoms.config.items_needed_for_one_resource_point == 0) break;
                }
                ++n2;
            }
        }
        if (itemworth % Kingdoms.config.items_needed_for_one_resource_point != 0) {
            returningIS.clear();
            ItemStack[] itemStackArray3 = items;
            n2 = items.length;
            int item2 = 0;
            while (item2 < n2) {
                ItemStack item3 = itemStackArray3[item2];
                if (item3 != null) {
                    p.getPlayer().getWorld().dropItemNaturally(p.getPlayer().getLocation(), item3);
                }
                ++item2;
            }
            p.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_RP_Trade_Insufficient_Itemcount).replaceAll("%amount%", "" + (Kingdoms.config.items_needed_for_one_resource_point - itemworth % Kingdoms.config.items_needed_for_one_resource_point)));
            return 0;
        }
        int returned = returningIS.size();
        if (returned != 0) {
            p.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_RP_Trade_Overflowing_Itemcount).replaceAll("%amount%", "" + returned));
        }
        for (ItemStack item4 : returningIS) {
            Kingdoms.logDebug((String)(String.valueOf(item4.getType().toString()) + "," + item4.getAmount()));
            p.getPlayer().getWorld().dropItemNaturally(p.getPlayer().getLocation(), item4);
        }
        return itemworth / Kingdoms.config.items_needed_for_one_resource_point;
    }

    private ArrayList<ItemStack> getItemsByNumberFromSet(ArrayList<ItemStack> items, int number) {
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
        int left = number;
        for (ItemStack item : items) {
            if (item == null) continue;
            if (left == 0) break;
            if (item.getAmount() <= left) {
                newItems.add(item);
                left -= item.getAmount();
                continue;
            }
            ItemStack newItem = item.clone();
            newItem.setAmount(left);
            newItems.add(newItem);
            left = 0;
        }
        return newItems;
    }

    public void openNexusGui(KingdomPlayer kp) {
        Kingdom kingdom = kp.getKingdom();
        PowerUp powerup = kingdom.getPowerUp();
        Inventory nexusgui = Bukkit.createInventory(null, (int)27, (String)(ChatColor.AQUA + kp.getKingdom().getKingdomName() + "'s nexus"));
        kp.getPlayer().openInventory(nexusgui);
        ItemStack i1 = new ItemStack(Material.WHEAT);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(ChatColor.AQUA + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePointsConverter));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePointsConverter_Lore1));
        i1l.add(ChatColor.LIGHT_PURPLE + "Nexus Option");
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        ItemStack i2 = new ItemStack(Material.IRON_CHESTPLATE);
        ItemMeta i2m = i2.getItemMeta();
        i2m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_DamageReduction_Title));
        ArrayList<String> i2l = new ArrayList<String>();
        i2l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_DamageReduction_Description));
        i2l.add(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_DamageReduction_CurrLevel) + powerup.getDmgreduction() + "%");
        String cost = "" + Kingdoms.config.nexusupgrades_dmg_reduc_cost;
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i2l.add(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Max) + Kingdoms.config.nexusupgrades_dmg_reduc_max);
        i2l.add(ChatColor.LIGHT_PURPLE + "Nexus Upgrade");
        i2m.setLore(LoreOrganizer.organize(i2l));
        i2.setItemMeta(i2m);
        if (!Kingdoms.config.nexusupgrades_dmg_reduc_enabled) {
            i2 = new ItemStack(Material.AIR);
        }
        ItemStack i3 = new ItemStack(Material.RED_ROSE);
        ItemMeta i3m = i3.getItemMeta();
        i3m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regeneration_Title));
        ArrayList<String> i3l = new ArrayList<String>();
        i3l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regeneration_Description));
        i3l.add(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regeneration_CurrLevel) + powerup.getRegenboost() + "%");
        cost = "" + Kingdoms.config.nexusupgrades_regen_boost_cost;
        i3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i3l.add(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Max) + Kingdoms.config.nexusupgrades_regen_boost_max);
        i3l.add(ChatColor.LIGHT_PURPLE + "Nexus Upgrade");
        i3m.setLore(LoreOrganizer.organize(i3l));
        i3.setItemMeta(i3m);
        if (!Kingdoms.config.nexusupgrades_regen_boost_enabled) {
            i3 = new ItemStack(Material.AIR);
        }
        ItemStack i4 = new ItemStack(Material.IRON_SWORD);
        ItemMeta i4m = i4.getItemMeta();
        i4m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_DamageBoost_Title));
        ArrayList<String> i4l = new ArrayList<String>();
        i4l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_DamageBoost_Description));
        i4l.add(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_DamageBoost_CurrLevel) + powerup.getDmgboost() + "%");
        cost = "" + Kingdoms.config.nexusupgrades_dmg_boost_cost;
        i4l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i4l.add(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Max) + Kingdoms.config.nexusupgrades_dmg_boost_max);
        i4l.add(ChatColor.LIGHT_PURPLE + "Nexus Upgrade");
        i4m.setLore(LoreOrganizer.organize(i4l));
        i4.setItemMeta(i4m);
        if (!Kingdoms.config.nexusupgrades_dmg_boost_enabled) {
            i4 = new ItemStack(Material.AIR);
        }
        ItemStack i4p1 = new ItemStack(Material.ARROW);
        ItemMeta i4p1m = i4p1.getItemMeta();
        i4p1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ArrowDamage_Title));
        ArrayList<String> i4p1l = new ArrayList<String>();
        i4p1l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ArrowDamage_Description));
        i4p1l.add(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ArrowDamage_CurrLevel) + powerup.getArrowboost() + "%");
        cost = "" + Kingdoms.config.nexusupgrades_arrow_boost_cost;
        i4p1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i4p1l.add(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Max) + Kingdoms.config.nexusupgrades_arrow_boost_max);
        i4p1l.add(ChatColor.LIGHT_PURPLE + "Nexus Upgrade");
        i4p1m.setLore(LoreOrganizer.organize(i4p1l));
        i4p1.setItemMeta(i4p1m);
        if (!Kingdoms.config.nexusupgrades_arrow_boost_enabled) {
            i4p1 = new ItemStack(Material.AIR);
        }
        ItemStack i4p2 = new ItemStack(Material.BOAT);
        ItemMeta i4p2m = i4p2.getItemMeta();
        i4p2m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_MaxMembers_Title));
        ArrayList<String> i4p2l = new ArrayList<String>();
        i4p2l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_MaxMembers_Description));
        i4p2l.add(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_MaxMembers_CurrMaxMem) + kingdom.getMaxMember());
        cost = "" + Kingdoms.config.nexusupgrades_maxmembers_cost;
        i4p2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i4p2l.add(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Max) + Kingdoms.config.nexusupgrades_maxmembers_max);
        i4p2l.add(ChatColor.LIGHT_PURPLE + "Nexus Upgrade");
        i4p2m.setLore(LoreOrganizer.organize(i4p2l));
        i4p2.setItemMeta(i4p2m);
        ItemStack i5 = new ItemStack(Material.BLAZE_ROD);
        ItemMeta i5m = i5.getItemMeta();
        i5m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_ChampionUpgrades_Title));
        ArrayList<String> i5l = new ArrayList<String>();
        i5l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_ChampionUpgrades_Desc));
        i5m.setLore(LoreOrganizer.organize(i5l));
        i5.setItemMeta(i5m);
        ItemStack i6 = new ItemStack(Material.MONSTER_EGG);
        ItemMeta i6m = i6.getItemMeta();
        i6m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_MiscUpgrades_Title));
        ArrayList<String> i6l = new ArrayList<String>();
        i6l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_MiscUpgrades_Desc));
        i6m.setLore(LoreOrganizer.organize(i6l));
        i6.setItemMeta(i6m);
        ItemStack i7 = new ItemStack(Material.ENDER_PORTAL_FRAME);
        ItemMeta i7m = i7.getItemMeta();
        i7m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_KingdomChestSize_Title));
        ArrayList<String> i7l = new ArrayList<String>();
        i7l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_KingdomChestSize_Description));
        i7l.add(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_KingdomChestSize_CurrLevel) + kingdom.getChestsize() + " slots");
        cost = "30";
        i7l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i7l.add(ChatColor.LIGHT_PURPLE + "Nexus Upgrade");
        i7m.setLore(LoreOrganizer.organize(i7l));
        i7.setItemMeta(i7m);
        ItemStack i8 = new ItemStack(Material.DISPENSER);
        ItemMeta i8m = i8.getItemMeta();
        i8m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Turrets_Title));
        ArrayList<String> i8l = new ArrayList<String>();
        i8l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Turrets_Desc));
        i8m.setLore(LoreOrganizer.organize(i8l));
        i8.setItemMeta(i8m);
        ItemStack i9 = new ItemStack(Material.MAP);
        ItemMeta i9m = i9.getItemMeta();
        i9m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Conquests_Title));
        ArrayList<String> i9l = new ArrayList<String>();
        i9l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Conquests_Desc));
        i9m.setLore(LoreOrganizer.organize(i9l));
        i9.setItemMeta(i9m);
        ItemStack i10 = new ItemStack(Material.BEACON);
        ItemMeta i10m = i10.getItemMeta();
        i10m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Structures_Title));
        ArrayList<String> i10l = new ArrayList<String>();
        i10l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Structures_Desc));
        i10m.setLore(LoreOrganizer.organize(i10l));
        i10.setItemMeta(i10m);
        ItemStack i11 = new ItemStack(Material.WOOL, 1, (short)DyeColor.BLUE.getWoolData());
        ItemMeta i11m = i11.getItemMeta();
        i11m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Permissions_Title));
        ArrayList<String> i11l = new ArrayList<String>();
        i11l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Permissions_Desc));
        i11m.setLore(LoreOrganizer.organize(i11l));
        i11.setItemMeta(i11m);
        ItemStack i12 = new ItemStack(Material.WOOL, 1, (short)DyeColor.GREEN.getWoolData());
        ItemMeta i12m = i12.getItemMeta();
        i12m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Members_Title));
        ArrayList<String> i12l = new ArrayList<String>();
        i12l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Members_Desc));
        i12m.setLore(LoreOrganizer.organize(i12l));
        i12.setItemMeta(i12m);
        ItemStack i13 = new ItemStack(Material.BOOK);
        ItemMeta i13m = i13.getItemMeta();
        i13m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Logs_Title));
        ArrayList<String> i13l = new ArrayList<String>();
        i13l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Logs_Description));
        i13l.add(ChatColor.LIGHT_PURPLE + "Nexus Function");
        i13m.setLore(LoreOrganizer.organize(i13l));
        i13.setItemMeta(i13m);
        ItemStack chest = new ItemStack(Material.CHEST);
        ItemMeta chestm = chest.getItemMeta();
        chestm.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_KingdomChest_Title));
        ArrayList<String> chestl = new ArrayList<String>();
        chestl.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_KingdomChest_Desc));
        chestm.setLore(LoreOrganizer.organize(chestl));
        chest.setItemMeta(chestm);
        ItemStack masswarstatus = new ItemStack(Material.AIR);
        masswarstatus = GameManagement.getMasswarManager().isMassWarOn() ? new ItemStack(Material.WOOL, 1, 5) : new ItemStack(Material.WOOL, 1, 14);
        ItemMeta masswarstatusm = masswarstatus.getItemMeta();
        masswarstatusm.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_MassWarStatus_Title));
        ArrayList<String> masswarstatusl = new ArrayList<String>();
        if (GameManagement.getMasswarManager().isMassWarOn()) {
            masswarstatusl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_MassWarStatus_On));
        } else {
            masswarstatusl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_MassWarStatus_Off));
        }
        masswarstatusl.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_MassWarStatus_Desc1));
        masswarstatusl.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_MassWarStatus_Desc2));
        masswarstatusl.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_MassWarStatus_Desc3).replaceAll("%time%", GameManagement.getMasswarManager().getTimeLeftInString()));
        masswarstatusm.setLore(masswarstatusl);
        masswarstatus.setItemMeta(masswarstatusm);
        ItemStack r = new ItemStack(Material.HAY_BLOCK);
        ItemMeta rm = r.getItemMeta();
        rm.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Title));
        ArrayList<String> rl = new ArrayList<String>();
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Desc));
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Count).replaceAll("%amount%", "" + kingdom.getResourcepoints()));
        rm.setLore(LoreOrganizer.organize(rl));
        r.setItemMeta(rm);
        ItemStack neutral = new ItemStack(Material.WOOL, 1, (short)DyeColor.WHITE.getWoolData());
        ItemMeta neutralm = neutral.getItemMeta();
        neutralm.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Neutral_Title));
        ArrayList<String> neutrall = new ArrayList<String>();
        neutrall.add(ChatColor.YELLOW + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Neutral_Desc));
        neutrall.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Neutral_Status).replaceAll("%status%", "" + kingdom.isNeutral()));
        neutralm.setLore(LoreOrganizer.organize(neutrall));
        neutral.setItemMeta(neutralm);
        nexusgui.setItem(0, i1);
        nexusgui.setItem(6, i13);
        Kingdoms.getManagers();
        if (GameManagement.getConquestManager() != null) {
            nexusgui.setItem(7, i9);
        }
        nexusgui.setItem(8, masswarstatus);
        nexusgui.setItem(9, i2);
        nexusgui.setItem(10, i3);
        nexusgui.setItem(11, i4);
        nexusgui.setItem(12, i4p1);
        nexusgui.setItem(13, i7);
        nexusgui.setItem(14, i10);
        nexusgui.setItem(15, i11);
        nexusgui.setItem(16, i12);
        nexusgui.addItem(new ItemStack[]{i4p2});
        if (Kingdoms.config.pacifistEnabled) {
            nexusgui.addItem(new ItemStack[]{neutral});
        }
        nexusgui.setItem(20, i8);
        nexusgui.setItem(18, i5);
        nexusgui.setItem(19, i6);
        nexusgui.setItem(17, r);
        nexusgui.setItem(26, chest);
        kp.getPlayer().openInventory(nexusgui);
    }

    public void openSurvivabilityShop(KingdomPlayer kp) {
        Kingdom kingdom = kp.getKingdom();
        Inventory champions = Bukkit.createInventory(null, (int)27, (String)(ChatColor.AQUA + "Survivability Shop"));
        ItemStack i1 = new ItemStack(Material.BED);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(ChatColor.AQUA + "Belonging");
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(ChatColor.GREEN + "Be able to use your kingdom home, even if");
        i1l.add(ChatColor.GREEN + "your home's land is no longer your land.");
        i1l.add(ChatColor.RED + "Cost: 100 resource points");
        i1l.add(ChatColor.LIGHT_PURPLE + "Survivability Upgrade");
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        ItemStack i2 = new ItemStack(Material.MAGMA_CREAM);
        ItemMeta i2m = i2.getItemMeta();
        i2m.setDisplayName(ChatColor.AQUA + "Nexus Tower");
        ArrayList<String> i2l = new ArrayList<String>();
        i2l.add(ChatColor.GREEN + "Converts the nexus into a powerful");
        i2l.add(ChatColor.GREEN + "area turret. Strikes nearby targets");
        i2l.add(ChatColor.GREEN + "with the power of lightning");
        i2l.add(ChatColor.RED + "Cost: 100 resource points");
        i2l.add(ChatColor.LIGHT_PURPLE + "Survivability Upgrade");
        i2m.setLore(LoreOrganizer.organize(i2l));
        i2.setItemMeta(i2m);
        ItemStack i3 = new ItemStack(Material.EYE_OF_ENDER);
        ItemMeta i3m = i3.getItemMeta();
        i3m.setDisplayName(ChatColor.AQUA + "Detector");
        ArrayList<String> i3l = new ArrayList<String>();
        i3l.add(ChatColor.GREEN + "Invisibility users in the nexus");
        i3l.add(ChatColor.GREEN + "chunk will have their invisibility");
        i3l.add(ChatColor.GREEN + "removed.");
        i3l.add(ChatColor.RED + "Cost: 100 resource points");
        i3l.add(ChatColor.LIGHT_PURPLE + "Survivability Upgrade");
        i3m.setLore(LoreOrganizer.organize(i3l));
        i3.setItemMeta(i3m);
        ItemStack r = new ItemStack(Material.HAY_BLOCK);
        ItemMeta rm = r.getItemMeta();
        rm.setDisplayName(ChatColor.AQUA + "Resource Points");
        ArrayList<String> rl = new ArrayList<String>();
        rl.add(ChatColor.GREEN + "Your kingdom currently has");
        rl.add(ChatColor.DARK_AQUA + kingdom.getResourcepoints() + ChatColor.GREEN + " Resource Points");
        rm.setLore(LoreOrganizer.organize(rl));
        r.setItemMeta(rm);
        ItemStack backbtn = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta backbtnmeta = backbtn.getItemMeta();
        backbtnmeta.setDisplayName(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Back_Btn));
        backbtn.setItemMeta(backbtnmeta);
        champions.addItem(new ItemStack[]{i1});
        champions.setItem(15, r);
        champions.setItem(26, backbtn);
        kp.getPlayer().openInventory(champions);
    }

    public void openKingdomChest(KingdomPlayer kp, Kingdom kingdom) {
        if (kingdom == null) {
            return;
        }
        if (!GameManagement.getChestManager().useKingdomChest(kp, kingdom)) {
            kp.sendMessage(ChatColor.RED + "Someone else is using the kingdom chest!");
            return;
        }
    }

    public void openKingdomChest(KingdomPlayer kp) {
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getChest())) {
            kp.sendMessage(ChatColor.RED + "You are not high-ranking enough to use this function!");
            return;
        }
        if (!GameManagement.getChestManager().useKingdomChest(kp, kingdom)) {
            kp.sendMessage(ChatColor.RED + "Someone else is using the kingdom chest!");
            return;
        }
    }

    @Override
    public void onDisable() {
        whiteListed.clear();
        specials.clear();
        if (blackListed != null) {
            blackListed.clear();
        }
    }
}

