/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.conquest.ConquestLand;
import org.kingdoms.constants.conquest.ConquestMap;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.KingdomCooldown;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.ConquestManager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.utils.LoreOrganizer;

public class ConquestMapGUIManager
extends Manager
implements Listener {
    public HashMap<KingdomPlayer, ConquestLand> selectedLands = new HashMap();

    protected ConquestMapGUIManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onConquestButtonClick(InventoryClickEvent event) {
        int cost;
        ConquestLand land;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)event.getWhoClicked();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        if (event.getInventory().getName() == null) {
            return;
        }
        if (!ConquestManager.maps.containsKey(event.getInventory().getName().toLowerCase())) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getLore() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getLore().contains(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_ButtonLore))) {
            land = this.titleToLand(event.getCurrentItem().getItemMeta().getDisplayName());
            this.updateLandDetails(land, kingdom, kp, event.getClickedInventory());
            this.selectedLands.put(kp, land);
        }
        if (event.getCurrentItem().getItemMeta().getLore().contains(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Click_A_Land))) {
            return;
        }
        if (!this.selectedLands.containsKey(kp)) {
            return;
        }
        land = ConquestLand.getLandAt(ConquestManager.maps.get(this.selectedLands.get((Object)kp).map), this.selectedLands.get((Object)kp).x, this.selectedLands.get((Object)kp).y);
        if (this.containsLore(event.getCurrentItem(), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Attack_Area))) {
            if (this.containsLore(event.getCurrentItem(), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_On_Cooldown))) {
                this.updateLandDetails(land, kingdom, kp, event.getClickedInventory());
                return;
            }
            if (!land.canBeAttackedBy(kingdom)) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Attack_Encircled));
                this.updateLandDetails(land, kingdom, kp, event.getClickedInventory());
                return;
            }
            if (land.isUnderSiege) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Attack_Already_Ongoing));
                this.updateLandDetails(land, kingdom, kp, event.getClickedInventory());
                return;
            }
            int cost2 = Kingdoms.config.conquestLandAttackEmptyCost;
            if (land.getOwner() != null) {
                if (land.getOwner().equals(kingdom.getKingdomName())) {
                    this.openMenu(kp, ConquestManager.maps.get(land.map));
                    return;
                }
                if (kingdom.getAlliesList().contains(land.getOwner())) {
                    this.openMenu(kp, ConquestManager.maps.get(land.map));
                    return;
                }
            } else {
                this.openMenu(kp, ConquestManager.maps.get(land.map));
                return;
            }
            if (land.isCapital()) {
                cost2 = Kingdoms.config.conquestLandAttackCapitalCost;
                if (kingdom.getResourcepoints() >= cost2) {
                    kingdom.setResourcepoints(kingdom.getResourcepoints() - cost2);
                    ConquestManager.startOffensive(kp, kingdom, land);
                    kingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Conquests_Kingdom_Attacking_Land).replaceAll("%land%", this.capitalize(land.getDataID())), true);
                    return;
                }
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost2));
                return;
            }
            cost2 = Kingdoms.config.conquestLandAttackEnemyCost;
            if (kingdom.getResourcepoints() >= cost2) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost2);
                ConquestManager.startOffensive(kp, kingdom, land);
                kingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Conquests_Kingdom_Attacking_Land).replaceAll("%land%", this.capitalize(land.getDataID())), true);
                return;
            }
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost2));
            return;
        }
        if (this.containsLore(event.getCurrentItem(), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Claim_Land))) {
            if (this.containsLore(event.getCurrentItem(), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_On_Cooldown))) {
                this.updateLandDetails(land, kingdom, kp, event.getClickedInventory());
                return;
            }
            if (!land.canBeAttackedBy(kingdom)) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Attack_Encircled));
                this.updateLandDetails(land, kingdom, kp, event.getClickedInventory());
                return;
            }
            if (land.isUnderSiege) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Attack_Already_Ongoing));
                this.updateLandDetails(land, kingdom, kp, event.getClickedInventory());
                return;
            }
            int cost3 = Kingdoms.config.conquestLandAttackEmptyCost;
            if (land.getOwner() != null) {
                this.openMenu(kp, ConquestManager.maps.get(land.map));
                return;
            }
            if (land.isCapital()) {
                cost3 = Kingdoms.config.conquestLandClaimCapitalCost;
            }
            if (kingdom.getResourcepoints() >= cost3) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost3);
                land.setOwner(kingdom.getKingdomName());
                KingdomCooldown cooldown = new KingdomCooldown(kingdom.getKingdomName(), "attackcd", 60 * Kingdoms.config.conquestAttackCooldown);
                cooldown.start();
                this.openMenu(kp, ConquestManager.maps.get(land.map));
                kingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Conquests_Kingdom_Conquered_Land).replaceAll("%land%", this.capitalize(land.getDataID())), true);
                return;
            }
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost3));
            return;
        }
        if (event.getCurrentItem().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Attack).replaceAll("%cost%", "" + Kingdoms.config.conquestLandClaimCapitalCost)) && this.containsLore(event.getCurrentItem(), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Claim_Capital))) {
            int cost4 = Kingdoms.config.conquestLandClaimCapitalCost;
            if (land.getOwner() == null) {
                if (kingdom.getResourcepoints() >= cost4) {
                    kingdom.setResourcepoints(kingdom.getResourcepoints() - cost4);
                    land.setOwner(kingdom.getKingdomName());
                    KingdomCooldown cooldown = new KingdomCooldown(kingdom.getKingdomName(), "attackcd", 60 * Kingdoms.config.conquestAttackCooldown);
                    cooldown.start();
                    this.openMenu(kp, ConquestManager.maps.get(land.map));
                    kingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Conquests_Kingdom_Joined_Map).replaceAll("%map%", this.capitalize(land.map)), true);
                    return;
                }
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost4));
            } else {
                this.openMenu(kp, ConquestManager.maps.get(land.map));
                return;
            }
        }
        ItemStack item = event.getCurrentItem();
        if (land.getOwner() != null && !land.getOwner().equals(kingdom.getKingdomName())) {
            return;
        }
        List lore = event.getCurrentItem().getItemMeta().getLore();
        if (item.getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Wall))) {
            cost = Kingdoms.config.conquestWallCost;
            if (this.containsLore(item, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Buy).replaceAll("%cost%", "" + cost).replaceAll("%upkeep%", "" + Kingdoms.config.conquestWallUpkeep)) || this.containsLore(item, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost))) {
                if (land.getWalllevel() >= 3) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                if (kingdom.getResourcepoints() >= cost) {
                    kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                    land.setWalllevel(land.getWalllevel() + 1);
                    this.updateLandDetails(land, kingdom, kp, event.getInventory());
                    return;
                }
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                return;
            }
        }
        if (item.getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Spawner))) {
            cost = Kingdoms.config.conquestSpawnerCost;
            if (this.containsLore(item, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Buy).replaceAll("%cost%", "" + cost).replaceAll("%upkeep%", "" + Kingdoms.config.conquestSpawnerUpkeep)) || this.containsLore(item, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost))) {
                if (land.getSpawnerlevel() >= 8) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                if (kingdom.getResourcepoints() >= cost) {
                    kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                    land.setSpawnerlevel(land.getSpawnerlevel() + 1);
                    this.updateLandDetails(land, kingdom, kp, event.getInventory());
                    return;
                }
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                return;
            }
        }
        boolean isBuyingTurret = false;
        int turretSelected = 0;
        if (item.getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "1"))) {
            isBuyingTurret = true;
            turretSelected = 1;
        } else if (item.getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "2"))) {
            isBuyingTurret = true;
            turretSelected = 2;
        } else if (item.getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "3"))) {
            isBuyingTurret = true;
            turretSelected = 3;
        } else if (item.getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "4"))) {
            isBuyingTurret = true;
            turretSelected = 4;
        }
        if (isBuyingTurret) {
            if (land.getTurretLevelAtSlot(turretSelected) >= 15) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                return;
            }
            int cost5 = Kingdoms.config.conquestTurretCost;
            if (kingdom.getResourcepoints() >= cost5) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost5);
                land.setTurretLevelAtSlot(turretSelected, land.getTurretLevelAtSlot(turretSelected) + 1);
                this.updateLandDetails(land, kingdom, kp, event.getClickedInventory());
                return;
            }
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost5));
            return;
        }
        int sellAmount = (int)(0.5 * (double)(land.getWalllevel() * Kingdoms.config.conquestWallCost + land.getSpawnerlevel() * Kingdoms.config.conquestSpawnerCost + land.getTurretLevelAtSlot(1) * Kingdoms.config.conquestTurretCost + land.getTurretLevelAtSlot(2) * Kingdoms.config.conquestTurretCost + land.getTurretLevelAtSlot(3) * Kingdoms.config.conquestTurretCost + land.getTurretLevelAtSlot(4) * Kingdoms.config.conquestTurretCost));
        if (item.getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Sell).replaceAll("%amount%", "" + sellAmount))) {
            land.setSpawnerlevel(0);
            land.setWalllevel(0);
            land.setTurretLevelAtSlot(1, 0);
            land.setTurretLevelAtSlot(2, 0);
            land.setTurretLevelAtSlot(3, 0);
            land.setTurretLevelAtSlot(4, 0);
            kingdom.setResourcepoints(kingdom.getResourcepoints() + sellAmount);
            this.updateLandDetails(land, kingdom, kp, event.getClickedInventory());
            return;
        }
        int cost6 = Kingdoms.config.maxSupplyLand - land.getSupplylevel();
        if (item.getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Resupply).replaceAll("%cost%", "" + cost6))) {
            if (kingdom.getResourcepoints() >= cost6) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost6);
                land.setSupplylevel(land.getSupplylevel() + cost6);
                this.updateLandDetails(land, kingdom, kp, event.getClickedInventory());
                return;
            }
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost6));
            return;
        }
        this.updateLandDetails(land, kingdom, kp, event.getClickedInventory());
    }

    public void updateLandDetails(ConquestLand land, Kingdom kingdom, KingdomPlayer kp, Inventory invMap) {
        DyeColor dye = DyeColor.YELLOW;
        ChatColor color = ChatColor.YELLOW;
        int maxSupply = Kingdoms.config.maxSupplyLand;
        if ((double)land.getSupplylevel() >= (double)maxSupply * 0.9) {
            color = ChatColor.GREEN;
        } else if ((double)land.getSupplylevel() >= (double)maxSupply * 0.5) {
            color = ChatColor.YELLOW;
        } else if ((double)land.getSupplylevel() < (double)maxSupply * 0.5) {
            color = ChatColor.RED;
        } else if (land.getSupplylevel() == 0) {
            color = ChatColor.DARK_RED;
        }
        ItemStack selected = this.makeButton(Material.STAINED_GLASS_PANE, dye, this.coordsToTitle(land), color + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Supplies).replaceAll("%amount%", "" + land.getSupplylevel()).replaceAll("%max%", String.valueOf(maxSupply)));
        if (land.isEncircled()) {
            dye = DyeColor.RED;
            selected = this.makeButton(Material.STAINED_GLASS_PANE, dye, this.coordsToTitle(land), color + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Supplies).replaceAll("%amount%", "" + land.getSupplylevel()).replaceAll("%max%", String.valueOf(maxSupply)), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Encircled));
        }
        if (land.getOwner() == null) {
            dye = DyeColor.YELLOW;
            color = ChatColor.GRAY;
        } else if (land.getOwner().equals(kingdom.getKingdomName())) {
            dye = DyeColor.LIME;
            color = ChatColor.GREEN;
        } else if (kingdom.getAlliesList().contains(land.getOwner())) {
            dye = DyeColor.MAGENTA;
            color = ChatColor.LIGHT_PURPLE;
        } else {
            dye = DyeColor.RED;
            color = ChatColor.RED;
        }
        String ownername = land.getOwner();
        if (ownername == null) {
            ownername = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Unoccupied);
        }
        ItemStack owner = this.makeButton(Material.STAINED_GLASS_PANE, dye, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Owned_By), color + ownername);
        int cost = Kingdoms.config.conquestWallCost;
        String costText = "";
        if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
            costText = land.getWalllevel() == 0 ? Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Buy).replaceAll("%cost%", "" + cost).replaceAll("%upkeep%", "" + Kingdoms.config.conquestWallUpkeep) : Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost);
        }
        ItemStack wall = this.makeButton(Material.COBBLESTONE, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Wall), ChatColor.RED + "Lvl " + land.getWalllevel(), costText);
        String status = "-";
        cost = Kingdoms.config.conquestTurretCost;
        costText = "";
        if (land.getTurretLevelAtSlot(1) > 0 && land.getSupplylevel() > 0) {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_Online).replaceAll("%level%", "" + land.getTurretLevelAtSlot(1));
        } else if (land.getTurretLevelAtSlot(1) > 0) {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_No_Supplies).replaceAll("%level%", "" + land.getTurretLevelAtSlot(1));
        } else {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Buy).replaceAll("%cost%", "" + cost).replaceAll("%upkeep%", "" + Kingdoms.config.conquestTurretUpkeepPerTurret);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_Offline);
        }
        ItemStack turret1 = this.makeButton(Material.ARROW, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "1"), status, costText);
        if (land.getTurretLevelAtSlot(2) > 0 && land.getSupplylevel() > 0) {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_Online).replaceAll("%level%", "" + land.getTurretLevelAtSlot(2));
        } else if (land.getTurretLevelAtSlot(2) > 0) {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_No_Supplies).replaceAll("%level%", "" + land.getTurretLevelAtSlot(2));
        } else {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Buy).replaceAll("%cost%", "" + cost).replaceAll("%upkeep%", "" + Kingdoms.config.conquestTurretUpkeepPerTurret);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_Offline);
        }
        ItemStack turret2 = this.makeButton(Material.ARROW, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "2"), status, costText);
        if (land.getTurretLevelAtSlot(3) > 0 && land.getSupplylevel() > 0) {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_Online).replaceAll("%level%", "" + land.getTurretLevelAtSlot(3));
        } else if (land.getTurretLevelAtSlot(3) > 0) {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_No_Supplies).replaceAll("%level%", "" + land.getTurretLevelAtSlot(3));
        } else {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Buy).replaceAll("%cost%", "" + cost).replaceAll("%upkeep%", "" + Kingdoms.config.conquestTurretUpkeepPerTurret);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_Offline);
        }
        ItemStack turret3 = this.makeButton(Material.ARROW, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "3"), status, costText);
        if (land.getTurretLevelAtSlot(4) > 0 && land.getSupplylevel() > 0) {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_Online).replaceAll("%level%", "" + land.getTurretLevelAtSlot(4));
        } else if (land.getTurretLevelAtSlot(4) > 0) {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_No_Supplies).replaceAll("%level%", "" + land.getTurretLevelAtSlot(4));
        } else {
            if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName())) {
                costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Buy).replaceAll("%cost%", "" + cost).replaceAll("%upkeep%", "" + Kingdoms.config.conquestTurretUpkeepPerTurret);
            }
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret_Status_Offline);
        }
        ItemStack turret4 = this.makeButton(Material.ARROW, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "4"), status, costText);
        int sellAmount = (int)(0.5 * (double)(land.getWalllevel() * Kingdoms.config.conquestWallCost + land.getSpawnerlevel() * Kingdoms.config.conquestSpawnerCost + land.getTurretLevelAtSlot(1) * Kingdoms.config.conquestTurretCost + land.getTurretLevelAtSlot(2) * Kingdoms.config.conquestTurretCost + land.getTurretLevelAtSlot(3) * Kingdoms.config.conquestTurretCost + land.getTurretLevelAtSlot(4) * Kingdoms.config.conquestTurretCost));
        ItemStack sellAll = this.makeButton(Material.GOLD_INGOT, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Sell).replaceAll("%amount%", "" + sellAmount), "");
        cost = Kingdoms.config.conquestSpawnerCost;
        int upkeep = Kingdoms.config.conquestSpawnerUpkeep;
        if (land.getSpawnerlevel() > 0 && land.getSupplylevel() > 0) {
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Spawner_Status_Online).replaceAll("%level%", "" + land.getSpawnerlevel());
            costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost);
        } else if (land.getSpawnerlevel() > 0) {
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Spawner_Status_No_Supplies).replaceAll("%level%", "" + land.getSpawnerlevel());
            costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Upgrade).replaceAll("%cost%", "" + cost);
        } else {
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Spawner_Status_Offline);
            costText = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Buy).replaceAll("%cost%", "" + cost).replaceAll("%upkeep%", "" + upkeep);
        }
        if (land.getOwner() == null || !land.getOwner().equals(kingdom.getKingdomName())) {
            costText = "";
        }
        ItemStack spawner = this.makeButton(Material.MOB_SPAWNER, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Spawner), status, costText);
        boolean hasFoothold = false;
        for (ConquestLand l : ConquestManager.maps.get((Object)land.map).lands) {
            if (l.getOwner() == null || !l.getOwner().equals(kingdom.getKingdomName())) continue;
            hasFoothold = true;
        }
        cost = 0;
        String addon = "";
        if (land.getOwner() != null) {
            if (land.getOwner().equals(kingdom.getKingdomName())) {
                status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Cannot_Attack_Own_Land);
                cost = 0;
            } else {
                status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Attack_Area);
                cost = Kingdoms.config.conquestLandAttackEnemyCost;
            }
        } else if (land.isCapital() && !hasFoothold) {
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Claim_Capital);
            cost = Kingdoms.config.conquestLandClaimCapitalCost;
        } else if (hasFoothold) {
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Claim_Land);
            cost = Kingdoms.config.conquestLandAttackEmptyCost;
            if (land.isCapital()) {
                cost = Kingdoms.config.conquestLandClaimCapitalCost;
            }
        }
        if (!land.anyCloseBy(kingdom) && hasFoothold) {
            status = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Attack_Out_Of_Range);
            addon = "";
        }
        String cd = "";
        String timecd = "";
        if (KingdomCooldown.isInCooldown(kingdom.getKingdomName(), "attackcd")) {
            int timeleftSecs = KingdomCooldown.getTimeLeft(kingdom.getKingdomName(), "attackcd") / 60;
            cd = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_On_Cooldown);
            timecd = ChatColor.RED + timeleftSecs + "min";
        }
        ItemStack attack = this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.RED, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Attack).replaceAll("%cost%", "" + cost), status, addon, cd, timecd);
        cost = maxSupply - land.getSupplylevel();
        ItemStack resupply = this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.LIME, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Resupply).replaceAll("%cost%", "" + cost), "");
        invMap.setItem(7, selected);
        invMap.setItem(8, owner);
        invMap.setItem(16, wall);
        invMap.setItem(17, spawner);
        invMap.setItem(25, turret1);
        invMap.setItem(26, turret2);
        invMap.setItem(34, turret3);
        invMap.setItem(35, turret4);
        if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName()) && sellAmount > 0) {
            invMap.setItem(44, sellAll);
        } else {
            invMap.setItem(44, new ItemStack(Material.AIR));
        }
        if (land.getOwner() != null && land.getOwner().equals(kingdom.getKingdomName()) && land.getSupplylevel() < maxSupply) {
            invMap.setItem(52, resupply);
        } else {
            invMap.setItem(52, new ItemStack(Material.AIR));
        }
        invMap.setItem(53, attack);
        kp.getPlayer().updateInventory();
    }

    public void openMenu(KingdomPlayer kp, final ConquestMap map) {
        final Kingdom kingdom = kp.getKingdom();
        ArrayList conquests = new ArrayList();
        final Inventory invMap = Bukkit.createInventory(null, (int)54, (String)this.capitalize(map.name));
        int y = 0;
        while (y < 6) {
            ItemStack buffer = new ItemStack(Material.THIN_GLASS);
            ItemMeta meta = buffer.getItemMeta();
            meta.setDisplayName("" + ChatColor.GRAY);
            buffer.setItemMeta(meta);
            invMap.setItem(y * 9 + 6, buffer);
            ++y;
        }
        ItemStack selected = this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.BLACK, ChatColor.GRAY + "[-,-]", Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Click_A_Land));
        ItemStack owner = this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.GRAY, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Owned_By), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Click_A_Land));
        ItemStack wall = this.makeButton(Material.COBBLESTONE, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Wall), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Click_A_Land));
        ItemStack turret1 = this.makeButton(Material.ARROW, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "1"), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Click_A_Land));
        ItemStack turret2 = this.makeButton(Material.ARROW, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "2"), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Click_A_Land));
        ItemStack turret3 = this.makeButton(Material.ARROW, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "3"), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Click_A_Land));
        ItemStack turret4 = this.makeButton(Material.ARROW, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Turret).replaceAll("%number%", "4"), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Click_A_Land));
        ItemStack spawner = this.makeButton(Material.MOB_SPAWNER, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Spawner), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Click_A_Land));
        ItemStack attack = this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.RED, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Attack).replaceAll("%cost%", "0"), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Click_A_Land));
        invMap.setItem(7, selected);
        invMap.setItem(8, owner);
        invMap.setItem(16, wall);
        invMap.setItem(17, spawner);
        invMap.setItem(25, turret1);
        invMap.setItem(26, turret2);
        invMap.setItem(34, turret3);
        invMap.setItem(35, turret4);
        invMap.setItem(53, attack);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                boolean hasFoothold = false;
                for (ConquestLand land : map.lands) {
                    if (land.getOwner() == null || !land.getOwner().equals(kingdom.getKingdomName())) continue;
                    hasFoothold = true;
                }
                final boolean hasFootHold = hasFoothold;
                for (final ConquestLand land : map.lands) {
                    Bukkit.getScheduler().runTask((Plugin)ConquestMapGUIManager.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            int guiX = land.x;
                            if (land.y == 1) {
                                guiX += 9;
                            }
                            if (land.y == 2) {
                                guiX += 18;
                            }
                            if (land.y == 3) {
                                guiX += 27;
                            }
                            if (land.y == 4) {
                                guiX += 36;
                            }
                            if (land.y == 5) {
                                guiX += 45;
                            }
                            ItemStack item = null;
                            if (land.getOwner() == null) {
                                item = ConquestMapGUIManager.this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.GRAY, ConquestMapGUIManager.this.coordsToTitle(land), LanguageSupport.Languages.Guis_ConquestMap_ButtonLore, new String[]{ChatColor.GRAY + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Unoccupied)});
                            } else if (land.getOwner().equals(kingdom.getKingdomName())) {
                                item = ConquestMapGUIManager.this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.LIME, ConquestMapGUIManager.this.coordsToTitle(land), LanguageSupport.Languages.Guis_ConquestMap_ButtonLore, new String[]{ChatColor.GREEN + kingdom.getKingdomName()});
                            } else {
                                Kingdoms.getManagers();
                                item = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner()).isAllianceWith(kingdom) ? ConquestMapGUIManager.this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.MAGENTA, ConquestMapGUIManager.this.coordsToTitle(land), LanguageSupport.Languages.Guis_ConquestMap_ButtonLore, new String[]{ChatColor.LIGHT_PURPLE + land.getOwner()}) : ConquestMapGUIManager.this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.RED, ConquestMapGUIManager.this.coordsToTitle(land), LanguageSupport.Languages.Guis_ConquestMap_ButtonLore, new String[]{ChatColor.RED + land.getOwner()});
                            }
                            if (land.isCapital()) {
                                if (land.getOwner() == null && !hasFootHold) {
                                    item = ConquestMapGUIManager.this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.YELLOW, ConquestMapGUIManager.this.coordsToTitle(land), LanguageSupport.Languages.Guis_ConquestMap_ButtonLore, new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ConquestMap_Claim_Capital)});
                                } else if (land.getOwner() == null && hasFootHold) {
                                    item = ConquestMapGUIManager.this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.BLACK, ConquestMapGUIManager.this.coordsToTitle(land), LanguageSupport.Languages.Guis_ConquestMap_ButtonLore, new String[]{ChatColor.GRAY + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Unoccupied)});
                                } else if (land.getOwner().equals(kingdom.getKingdomName())) {
                                    item = ConquestMapGUIManager.this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.GREEN, ConquestMapGUIManager.this.coordsToTitle(land), LanguageSupport.Languages.Guis_ConquestMap_ButtonLore, new String[]{ChatColor.GREEN + kingdom.getKingdomName()});
                                } else {
                                    Kingdoms.getManagers();
                                    item = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner()).isAllianceWith(kingdom) ? ConquestMapGUIManager.this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.PURPLE, ConquestMapGUIManager.this.coordsToTitle(land), LanguageSupport.Languages.Guis_ConquestMap_ButtonLore, new String[]{ChatColor.LIGHT_PURPLE + land.getOwner()}) : ConquestMapGUIManager.this.makeButton(Material.STAINED_GLASS_PANE, DyeColor.PINK, ConquestMapGUIManager.this.coordsToTitle(land), LanguageSupport.Languages.Guis_ConquestMap_ButtonLore, new String[]{ChatColor.RED + land.getOwner()});
                                }
                            }
                            invMap.setItem(guiX, item);
                        }
                    });
                }
            }
        });
        kp.getPlayer().openInventory(invMap);
    }

    private String coordsToTitle(ConquestLand land) {
        if (!land.isCapital()) {
            return ChatColor.AQUA + "[" + ChatColor.YELLOW + this.capitalize(land.getDataID()) + ChatColor.AQUA + "]";
        }
        return ChatColor.YELLOW + "Capital " + ChatColor.AQUA + "[" + ChatColor.YELLOW + this.capitalize(land.getDataID()) + ChatColor.AQUA + "]";
    }

    private ConquestLand titleToLand(String title) {
        ConquestLand duplicate = new ConquestLand(ChatColor.stripColor((String)title.toLowerCase()).replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("capital ", ""));
        return ConquestMap.getLandAt(ConquestManager.maps.get(duplicate.map), duplicate.x, duplicate.y);
    }

    private ItemStack makeButton(Material mat, DyeColor color, String title, LanguageSupport.Languages btnType, String ... lore) {
        ItemStack IS = new ItemStack(mat, 1, (short)color.getWoolData());
        ItemMeta IM = IS.getItemMeta();
        IM.setDisplayName(title);
        ArrayList<String> l = new ArrayList<String>();
        String[] stringArray = lore;
        int n = lore.length;
        int n2 = 0;
        while (n2 < n) {
            String lores = stringArray[n2];
            if (!lore.equals("")) {
                l.add(lores);
            }
            ++n2;
        }
        l.add(Kingdoms.getLang().parseFirstString(btnType));
        IM.setLore(LoreOrganizer.organize(l));
        IS.setItemMeta(IM);
        return IS;
    }

    private boolean containsLore(ItemStack item, String string) {
        List<String> lore = LoreOrganizer.organize((List<String>)new ArrayList<String>(string){
            {
                this.add(string);
            }
        });
        for (String partlore : lore) {
            if (item.getItemMeta().getLore().contains(partlore)) continue;
            return false;
        }
        return true;
    }

    private ItemStack makeButton(Material mat, DyeColor color, String title, String ... lore) {
        ItemStack IS = new ItemStack(mat, 1, (short)color.getWoolData());
        ItemMeta IM = IS.getItemMeta();
        IM.setDisplayName(title);
        ArrayList<String> l = new ArrayList<String>();
        String[] stringArray = lore;
        int n = lore.length;
        int n2 = 0;
        while (n2 < n) {
            String lores = stringArray[n2];
            if (!lore.equals("")) {
                l.add(lores);
            }
            ++n2;
        }
        IM.setLore(LoreOrganizer.organize(l));
        IS.setItemMeta(IM);
        return IS;
    }

    private ItemStack makeButton(Material mat, String title, String ... lore) {
        ItemStack IS = new ItemStack(mat);
        ItemMeta IM = IS.getItemMeta();
        IM.setDisplayName(title);
        ArrayList<String> l = new ArrayList<String>();
        String[] stringArray = lore;
        int n = lore.length;
        int n2 = 0;
        while (n2 < n) {
            String lores = stringArray[n2];
            if (!lore.equals("")) {
                l.add(lores);
            }
            ++n2;
        }
        IM.setLore(LoreOrganizer.organize(l));
        IS.setItemMeta(IM);
        return IS;
    }

    @Override
    public void onDisable() {
    }

    private String capitalize(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }
}

