/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.generallib.strings.utils.LoreOrganizer;
import org.kingdoms.constants.TurretType;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.land.Turret;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.LandLoadEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.LandManager;
import org.kingdoms.utils.TurretUtil;

public class TurretManager
extends Manager
implements Listener {
    private static final String META_ARROW = "arrowturret";
    private static final String META_NEXUS = "nexustower";
    private static final String META_FLAME = "flameturret";
    private static final String META_HEAL = "healingstation";
    private static final String META_PSIONIC = "psionictotem";
    private static final String META_HELLFIRE = "hellfireturret";
    private static final String META_SOLDIER = "soldierspawner";
    private static final String META_HEATBEAM = "heatbeamturret";
    private static final String META_MINE_PRESSURE = "pressuremine";
    private static final String META_MINE_CHEMICAL = "chemicalmine";
    boolean fas = false;

    protected TurretManager(Plugin plugin) {
        super(plugin);
        plugin.getServer().getScheduler().scheduleSyncRepeatingTask(plugin, new Runnable(){

            @Override
            public void run() {
                for (Map.Entry<SimpleChunkLocation, Land> entry : LandManager.landList.entrySet()) {
                    if (entry.getValue().getOwner() == null) continue;
                    Iterator<Turret> iter = entry.getValue().getTurrets().iterator();
                    while (iter.hasNext()) {
                        Turret turret = iter.next();
                        if (turret == null) continue;
                        if (turret.getType() == null) {
                            iter.remove();
                            continue;
                        }
                        if (turret.getLoc() == null || turret.getLoc().toLocation() == null || !turret.getLoc().toLocation().getChunk().isLoaded() || turret.getType() != TurretType.MINE_PRESSURE && turret.getType() != TurretType.MINE_CHEMICAL && !turret.getLoc().toLocation().getBlock().getRelative(0, -1, 0).getType().toString().endsWith("FENCE")) continue;
                        turret.tick();
                    }
                }
            }
        }, 0L, 1L);
        new Thread(new TurretUtil()).start();
    }

    @EventHandler
    public void onPistonPushTurret(BlockPistonExtendEvent e) {
        for (Block block : e.getBlocks()) {
            if (block == null || block.getType() == Material.AIR || !TurretManager.isTurret(block)) continue;
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonPullTurret(BlockPistonRetractEvent e) {
        for (Block block : e.getBlocks()) {
            if (block == null || block.getType() == Material.AIR || !TurretManager.isTurret(block)) continue;
            e.setCancelled(true);
            return;
        }
    }

    public static boolean isTurret(Block block) {
        return block.hasMetadata(META_ARROW) || block.hasMetadata(META_FLAME) || block.hasMetadata(META_HEAL) || block.hasMetadata(META_HEATBEAM) || block.hasMetadata(META_HELLFIRE) || block.hasMetadata(META_MINE_CHEMICAL) || block.hasMetadata(META_MINE_PRESSURE) || block.hasMetadata(META_NEXUS) || block.hasMetadata(META_PSIONIC) || block.hasMetadata(META_SOLDIER);
    }

    public ItemStack getArrowTurretDisk() {
        ItemStack i1 = new ItemStack(Material.RECORD_9);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_ArrowTurret_Name));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_ArrowTurret_Desc));
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Range)) + Kingdoms.config.turret_arrow_range + " blocks");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Damage)) + (double)Kingdoms.config.turret_arrow_damage / 2.0 + " \u2764");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_AttackSpeed)) + "1/sec");
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Target_Random_In_Range));
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        return i1;
    }

    public ItemStack getFlameTurretDisk() {
        ItemStack i1 = new ItemStack(Material.RECORD_9);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_FlameTurret_Name));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_FlameTurret_Desc));
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Range)) + Kingdoms.config.turret_flameturret_range + " blocks");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Damage)) + (double)Kingdoms.config.turret_flameturret_damage / 2.0 + " \u2764");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_AttackSpeed)) + "2/sec");
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Target_Random_In_Range));
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        return i1;
    }

    public ItemStack getSoldierTurretDisk() {
        ItemStack i1 = new ItemStack(Material.RECORD_9);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_SoldierTurret_Name));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_SoldierTurret_Desc));
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Range)) + Kingdoms.config.turret_soldierspawner_range + " blocks");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Damage)) + "-");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_AttackSpeed)) + "0.2/sec");
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Target_Random_Player_Range));
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        return i1;
    }

    public ItemStack getHellfireTurretDisk() {
        ItemStack i1 = new ItemStack(Material.RECORD_9);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_HellfireTurret_Name));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_HellfireTurret_Desc));
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Range)) + Kingdoms.config.turret_hellfire_range + " blocks");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Damage)) + (double)Kingdoms.config.turret_hellfire_damage / 2.0 + " \u2764");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_AttackSpeed)) + "2/sec");
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Target_Random_In_Range));
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        return i1;
    }

    public ItemStack getHeatbeamTurretDisk() {
        ItemStack i1 = new ItemStack(Material.RECORD_9);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_HeatbeamTurret_Name));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_HeatbeamTurret_Desc));
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Range)) + Kingdoms.config.turret_heatbeam_range + " blocks");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Damage)) + (double)Kingdoms.config.turret_heatbeam_damage / 2.0 + " \u2764");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_AttackSpeed)) + "4/sec");
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Target_Random_In_Range));
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        return i1;
    }

    public ItemStack getPressureMineDisk() {
        ItemStack i1 = new ItemStack(Material.RECORD_9);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_PressureMine_Name));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_PressureMine_Desc));
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Range)) + "3 blocks");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Damage)) + "-");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_AttackSpeed)) + "one use");
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Target_All_Player_Range));
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        return i1;
    }

    public ItemStack getChemicalMineDisk() {
        ItemStack i1 = new ItemStack(Material.RECORD_9);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_ChemicalMine_Name));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_ChemicalMine_Desc));
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Range)) + "-");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Damage)) + "-");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_AttackSpeed)) + "one use");
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Target_Single));
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        return i1;
    }

    public ItemStack getHealingStationDisk() {
        ItemStack i1 = new ItemStack(Material.RECORD_9);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_HealingTurret_Name));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_HealingTurret_Desc));
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Range)) + Kingdoms.config.turret_healingtower_range + " blocks");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Damage)) + "-");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_AttackSpeed)) + "0.33/sec");
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Target_All_Player_Range));
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        return i1;
    }

    public ItemStack getPsionicTotemDisk() {
        ItemStack i1 = new ItemStack(Material.RECORD_9);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_PsionicTotem_Name));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_PsionicTotem_Desc));
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Range)) + Kingdoms.config.turret_psionictotem_range + " blocks");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Damage)) + (double)Kingdoms.config.turret_psionictotem_damage / 2.0 + " \u2764");
        i1l.add(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_AttackSpeed)) + "0.66/sec");
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_Target_Random_Player_Range));
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        return i1;
    }

    public void breakTurret(Turret turret) {
        TurretType type = turret.getType();
        World world = turret.getLoc().toLocation().getBlock().getWorld();
        switch (type) {
            case ARROW: {
                turret.getLoc().toLocation().getBlock().removeMetadata(META_ARROW, (Plugin)this.plugin);
                world.dropItemNaturally(turret.getLoc().toLocation(), this.getArrowTurretDisk());
                break;
            }
            case NEXUS: {
                break;
            }
            case FLAME: {
                turret.getLoc().toLocation().getBlock().removeMetadata(META_FLAME, (Plugin)this.plugin);
                world.dropItemNaturally(turret.getLoc().toLocation(), this.getFlameTurretDisk());
                break;
            }
            case HEALING: {
                turret.getLoc().toLocation().getBlock().removeMetadata(META_HEAL, (Plugin)this.plugin);
                world.dropItemNaturally(turret.getLoc().toLocation(), this.getHealingStationDisk());
                break;
            }
            case PSIONIC: {
                turret.getLoc().toLocation().getBlock().removeMetadata(META_PSIONIC, (Plugin)this.plugin);
                world.dropItemNaturally(turret.getLoc().toLocation(), this.getPsionicTotemDisk());
                break;
            }
            case HELLFIRE: {
                turret.getLoc().toLocation().getBlock().removeMetadata(META_HELLFIRE, (Plugin)this.plugin);
                world.dropItemNaturally(turret.getLoc().toLocation(), this.getHellfireTurretDisk());
                break;
            }
            case SOLDIER: {
                turret.getLoc().toLocation().getBlock().removeMetadata(META_SOLDIER, (Plugin)this.plugin);
                world.dropItemNaturally(turret.getLoc().toLocation(), this.getSoldierTurretDisk());
                break;
            }
            case HEATBEAM: {
                turret.getLoc().toLocation().getBlock().removeMetadata(META_HEATBEAM, (Plugin)this.plugin);
                world.dropItemNaturally(turret.getLoc().toLocation(), this.getHeatbeamTurretDisk());
                break;
            }
            case MINE_PRESSURE: {
                turret.getLoc().toLocation().getBlock().removeMetadata(META_MINE_PRESSURE, (Plugin)this.plugin);
                world.dropItemNaturally(turret.getLoc().toLocation(), this.getPressureMineDisk());
                break;
            }
            case MINE_CHEMICAL: {
                turret.getLoc().toLocation().getBlock().removeMetadata(META_MINE_CHEMICAL, (Plugin)this.plugin);
                world.dropItemNaturally(turret.getLoc().toLocation(), this.getChemicalMineDisk());
            }
        }
        turret.getLoc().toLocation().getBlock().setType(Material.AIR);
        turret.setType(null);
    }

    private void handleTurretBreakEvent(BlockBreakEvent e, String meta, ItemStack drop) {
        SimpleLocation loc = new SimpleLocation(e.getBlock().getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getTurret(loc) == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            Turret turret = land.getTurret(loc);
            turret.setType(null);
            e.getBlock().removeMetadata(meta, (Plugin)this.plugin);
            e.getBlock().setType(Material.AIR);
            World world = e.getBlock().getWorld();
            world.dropItemNaturally(e.getBlock().getLocation(), drop);
            return;
        }
        if (!kp.isAdminMode() && kp.getKingdom() == null) {
            kp.sendMessage(ChatColor.RED + "This land doesn't belong to your kingdom!");
            return;
        }
        if (kp.isAdminMode() || kingdom.equals(kp.getKingdom())) {
            if (!kp.isAdminMode() && !kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getTurret())) {
                kp.sendMessage(ChatColor.RED + "Permission denied.");
                kp.sendMessage(ChatColor.GOLD + "Required: " + (Object)((Object)kingdom.getPermissionsInfo().getTurret()));
                return;
            }
        } else {
            kp.sendMessage(ChatColor.RED + "This land doesn't belong to your kingdom!");
            return;
        }
        Turret turret = land.getTurret(loc);
        turret.setType(null);
        e.getBlock().removeMetadata(meta, (Plugin)this.plugin);
        e.getBlock().setType(Material.AIR);
        World world = e.getBlock().getWorld();
        world.dropItemNaturally(e.getBlock().getLocation(), drop);
    }

    @EventHandler
    public void onBreakArrowTurret(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!e.getBlock().hasMetadata(META_ARROW)) {
            return;
        }
        e.setCancelled(true);
        this.handleTurretBreakEvent(e, META_ARROW, this.getArrowTurretDisk());
    }

    @EventHandler
    public void onBreakFlameTurret(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!e.getBlock().hasMetadata(META_FLAME)) {
            return;
        }
        e.setCancelled(true);
        this.handleTurretBreakEvent(e, META_FLAME, this.getFlameTurretDisk());
    }

    @EventHandler
    public void onBreakSoldierTurret(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!e.getBlock().hasMetadata(META_SOLDIER)) {
            return;
        }
        e.setCancelled(true);
        this.handleTurretBreakEvent(e, META_SOLDIER, this.getSoldierTurretDisk());
    }

    @EventHandler
    public void onBreakHellFireTurret(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!e.getBlock().hasMetadata(META_HELLFIRE)) {
            return;
        }
        e.setCancelled(true);
        this.handleTurretBreakEvent(e, META_HELLFIRE, this.getHellfireTurretDisk());
    }

    @EventHandler
    public void onBreakHeatBeamTurret(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!e.getBlock().hasMetadata(META_HEATBEAM)) {
            return;
        }
        e.setCancelled(true);
        this.handleTurretBreakEvent(e, META_HEATBEAM, this.getHeatbeamTurretDisk());
    }

    @EventHandler
    public void onBreakPressureMineTurret(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!e.getBlock().hasMetadata(META_MINE_PRESSURE)) {
            return;
        }
        e.setCancelled(true);
        this.handleTurretBreakEvent(e, META_MINE_PRESSURE, this.getPressureMineDisk());
    }

    @EventHandler
    public void onBreakChemicalMineTurret(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!e.getBlock().hasMetadata(META_MINE_CHEMICAL)) {
            return;
        }
        e.setCancelled(true);
        this.handleTurretBreakEvent(e, META_MINE_CHEMICAL, this.getChemicalMineDisk());
    }

    @EventHandler
    public void onBreakHealingTurret(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!e.getBlock().hasMetadata(META_HEAL)) {
            return;
        }
        e.setCancelled(true);
        this.handleTurretBreakEvent(e, META_HEAL, this.getHealingStationDisk());
    }

    @EventHandler
    public void onBreakPsionicTurret(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!e.getBlock().hasMetadata(META_PSIONIC)) {
            return;
        }
        e.setCancelled(true);
        this.handleTurretBreakEvent(e, META_PSIONIC, this.getPsionicTotemDisk());
    }

    private void handleTurretSetEvent(PlayerInteractEvent e, TurretType type, String meta, String owner, SkullType skull) {
        if (e.getBlockFace() != BlockFace.UP) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            kp.sendMessage("You must be in a kingdom first in order to use this item.");
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!e.getClickedBlock().getType().toString().endsWith("FENCE")) {
            kp.sendMessage(ChatColor.RED + "Turrets must be set on a fence!");
            return;
        }
        Block turretBlock = e.getClickedBlock().getRelative(0, 1, 0);
        if (turretBlock.getType() != Material.AIR) {
            kp.sendMessage("There is something on the fence already.");
            return;
        }
        SimpleLocation loc = new SimpleLocation(turretBlock.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null || !land.getOwner().equals(kingdom.getKingdomName())) {
            kp.sendMessage(ChatColor.RED + "This land is not owned by your kingdom!.");
            return;
        }
        int amount = e.getPlayer().getItemInHand().getAmount();
        if (amount > 1) {
            e.getPlayer().getItemInHand().setAmount(amount - 1);
        } else {
            e.getPlayer().setItemInHand(null);
        }
        turretBlock.setType(Material.SKULL);
        turretBlock.setData((byte)1);
        turretBlock.setMetadata(meta, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)kingdom.getKingdomName()));
        Skull s = (Skull)turretBlock.getState();
        if (owner != null) {
            s.setOwner(owner);
        }
        if (skull != null) {
            s.setSkullType(skull);
        }
        s.update();
        Turret turret = new Turret(loc, type);
        land.addTurret(turret);
    }

    public int getNumberOfTurretsInLand(Land land, TurretType type) {
        int i = 0;
        for (Turret t : land.getTurrets()) {
            if (t.getType() == null || !t.getType().equals((Object)type)) continue;
            ++i;
        }
        return i;
    }

    public boolean isMaxHitInLand(Land land, TurretType type) {
        switch (type) {
            case ARROW: {
                int max = Kingdoms.config.turret_arrow_max;
                if (this.getNumberOfTurretsInLand(land, type) < max) break;
                return true;
            }
            case FLAME: {
                int max = Kingdoms.config.turret_flameturret_max;
                if (this.getNumberOfTurretsInLand(land, type) < max) break;
                return true;
            }
            case HEALING: {
                int max = Kingdoms.config.turret_healingtower_max;
                if (this.getNumberOfTurretsInLand(land, type) < max) break;
                return true;
            }
            case HEATBEAM: {
                int max = Kingdoms.config.turret_heatbeam_max;
                if (this.getNumberOfTurretsInLand(land, type) < max) break;
                return true;
            }
            case HELLFIRE: {
                int max = Kingdoms.config.turret_hellfire_max;
                if (this.getNumberOfTurretsInLand(land, type) < max) break;
                return true;
            }
            case MINE_CHEMICAL: {
                int max = Kingdoms.config.turret_chemicalmine_max;
                if (this.getNumberOfTurretsInLand(land, type) < max) break;
                return true;
            }
            case MINE_PRESSURE: {
                int max = Kingdoms.config.turret_pressuremine_max;
                if (this.getNumberOfTurretsInLand(land, type) < max) break;
                return true;
            }
            case NEXUS: {
                break;
            }
            case PSIONIC: {
                int max = Kingdoms.config.turret_psionictotem_max;
                if (this.getNumberOfTurretsInLand(land, type) < max) break;
                return true;
            }
            case SOLDIER: {
                int max = Kingdoms.config.turret_soldierspawner_max;
                if (this.getNumberOfTurretsInLand(land, type) < max) break;
                return true;
            }
        }
        return false;
    }

    public boolean shouldRemoveTurret(Land land, TurretType type) {
        switch (type) {
            case ARROW: {
                int max = Kingdoms.config.turret_arrow_max;
                if (this.getNumberOfTurretsInLand(land, type) <= max) break;
                return true;
            }
            case FLAME: {
                int max = Kingdoms.config.turret_flameturret_max;
                if (this.getNumberOfTurretsInLand(land, type) <= max) break;
                return true;
            }
            case HEALING: {
                int max = Kingdoms.config.turret_healingtower_max;
                if (this.getNumberOfTurretsInLand(land, type) <= max) break;
                return true;
            }
            case HEATBEAM: {
                int max = Kingdoms.config.turret_heatbeam_max;
                if (this.getNumberOfTurretsInLand(land, type) <= max) break;
                return true;
            }
            case HELLFIRE: {
                int max = Kingdoms.config.turret_hellfire_max;
                if (this.getNumberOfTurretsInLand(land, type) <= max) break;
                return true;
            }
            case MINE_CHEMICAL: {
                int max = Kingdoms.config.turret_chemicalmine_max;
                if (this.getNumberOfTurretsInLand(land, type) <= max) break;
                return true;
            }
            case MINE_PRESSURE: {
                int max = Kingdoms.config.turret_pressuremine_max;
                if (this.getNumberOfTurretsInLand(land, type) <= max) break;
                return true;
            }
            case NEXUS: {
                break;
            }
            case PSIONIC: {
                int max = Kingdoms.config.turret_psionictotem_max;
                if (this.getNumberOfTurretsInLand(land, type) <= max) break;
                return true;
            }
            case SOLDIER: {
                int max = Kingdoms.config.turret_soldierspawner_max;
                if (this.getNumberOfTurretsInLand(land, type) <= max) break;
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void onSetArrowTurret(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!e.getClickedBlock().getType().isSolid()) {
            return;
        }
        if (e.getPlayer().getItemInHand() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!e.getPlayer().getItemInHand().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_ArrowTurret_Name))) {
            return;
        }
        if (e.getClickedBlock().getType() == Material.JUKEBOX) {
            e.setCancelled(true);
            return;
        }
        int max = Kingdoms.config.turret_arrow_max;
        Kingdoms.getManagers();
        if (this.isMaxHitInLand(GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getClickedBlock().getChunk())), TurretType.ARROW)) {
            e.getPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Turret_Limit).replaceAll("%type%", "Arrow").replaceAll("%number%", "" + max));
            return;
        }
        this.handleTurretSetEvent(e, TurretType.ARROW, META_ARROW, null, null);
    }

    @EventHandler
    public void onSetFlameTurret(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!e.getClickedBlock().getType().isSolid()) {
            return;
        }
        if (e.getPlayer().getItemInHand() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!e.getPlayer().getItemInHand().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_FlameTurret_Name))) {
            return;
        }
        if (e.getClickedBlock().getType() == Material.JUKEBOX) {
            e.setCancelled(true);
            return;
        }
        int max = Kingdoms.config.turret_flameturret_max;
        Kingdoms.getManagers();
        if (this.isMaxHitInLand(GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getClickedBlock().getChunk())), TurretType.FLAME)) {
            e.getPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Turret_Limit).replaceAll("%type%", "Flame").replaceAll("%number%", "" + max));
            return;
        }
        this.handleTurretSetEvent(e, TurretType.FLAME, META_FLAME, null, SkullType.WITHER);
    }

    @EventHandler
    public void onSetHealingStatin(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!e.getClickedBlock().getType().isSolid()) {
            return;
        }
        if (e.getPlayer().getItemInHand() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!e.getPlayer().getItemInHand().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_HealingTurret_Name))) {
            return;
        }
        if (e.getClickedBlock().getType() == Material.JUKEBOX) {
            e.setCancelled(true);
            return;
        }
        int max = Kingdoms.config.turret_healingtower_max;
        Kingdoms.getManagers();
        if (this.isMaxHitInLand(GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getClickedBlock().getChunk())), TurretType.HEALING)) {
            e.getPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Turret_Limit).replaceAll("%type%", "Healing").replaceAll("%number%", "" + max));
            return;
        }
        this.handleTurretSetEvent(e, TurretType.HEALING, META_HEAL, null, SkullType.ZOMBIE);
    }

    @EventHandler
    public void onSetPressureMine(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!e.getClickedBlock().getType().isSolid()) {
            return;
        }
        if (e.getPlayer().getItemInHand() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!e.getPlayer().getItemInHand().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_PressureMine_Name))) {
            return;
        }
        if (e.getClickedBlock().getType() == Material.JUKEBOX) {
            e.setCancelled(true);
            return;
        }
        if (e.getBlockFace() != BlockFace.UP) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            kp.sendMessage("You must be in a kingdom first in order to use this item.");
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        Block turretBlock = e.getClickedBlock().getRelative(0, 1, 0);
        SimpleLocation loc = new SimpleLocation(turretBlock.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null || !land.getOwner().equals(kingdom.getKingdomName())) {
            kp.sendMessage(ChatColor.RED + "This land is not owned by your kingdom!.");
            return;
        }
        int max = Kingdoms.config.turret_pressuremine_max;
        if (this.isMaxHitInLand(land, TurretType.MINE_PRESSURE)) {
            e.getPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Turret_Limit).replaceAll("%type%", "Pressure Mine").replaceAll("%number%", "" + max));
            return;
        }
        int amount = e.getPlayer().getItemInHand().getAmount();
        if (amount > 1) {
            e.getPlayer().getItemInHand().setAmount(amount - 1);
        } else {
            e.getPlayer().setItemInHand(null);
        }
        turretBlock.setType(Material.STONE_PLATE);
        turretBlock.setMetadata(META_MINE_PRESSURE, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)kingdom.getKingdomName()));
        Turret turret = new Turret(loc, TurretType.MINE_PRESSURE);
        land.addTurret(turret);
    }

    @EventHandler
    public void onSetChemicalMine(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!e.getClickedBlock().getType().isSolid()) {
            return;
        }
        if (e.getPlayer().getItemInHand() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!e.getPlayer().getItemInHand().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_ChemicalMine_Name))) {
            return;
        }
        if (e.getClickedBlock().getType() == Material.JUKEBOX) {
            e.setCancelled(true);
            return;
        }
        if (e.getBlockFace() != BlockFace.UP) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            kp.sendMessage("You must be in a kingdom first in order to use this item.");
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        Block turretBlock = e.getClickedBlock().getRelative(0, 1, 0);
        SimpleLocation loc = new SimpleLocation(turretBlock.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null || !land.getOwner().equals(kingdom.getKingdomName())) {
            kp.sendMessage(ChatColor.RED + "This land is not owned by your kingdom!.");
            return;
        }
        int max = Kingdoms.config.turret_chemicalmine_max;
        if (this.isMaxHitInLand(land, TurretType.MINE_CHEMICAL)) {
            e.getPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Turret_Limit).replaceAll("%type%", "Chemical Mine").replaceAll("%number%", "" + max));
            return;
        }
        int amount = e.getPlayer().getItemInHand().getAmount();
        if (amount > 1) {
            e.getPlayer().getItemInHand().setAmount(amount - 1);
        } else {
            e.getPlayer().setItemInHand(null);
        }
        turretBlock.setType(Material.WOOD_PLATE);
        turretBlock.setMetadata(META_MINE_CHEMICAL, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)kingdom.getKingdomName()));
        Turret turret = new Turret(loc, TurretType.MINE_CHEMICAL);
        land.addTurret(turret);
    }

    @EventHandler
    public void onSetPsionicTotem(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!e.getClickedBlock().getType().isSolid()) {
            return;
        }
        if (e.getPlayer().getItemInHand() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!e.getPlayer().getItemInHand().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_PsionicTotem_Name))) {
            return;
        }
        if (e.getClickedBlock().getType() == Material.JUKEBOX) {
            e.setCancelled(true);
            return;
        }
        int max = Kingdoms.config.turret_psionictotem_max;
        Kingdoms.getManagers();
        if (this.isMaxHitInLand(GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getClickedBlock().getChunk())), TurretType.PSIONIC)) {
            e.getPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Turret_Limit).replaceAll("%type%", "Psionic").replaceAll("%number%", "" + max));
            return;
        }
        this.handleTurretSetEvent(e, TurretType.PSIONIC, META_PSIONIC, null, SkullType.CREEPER);
    }

    @EventHandler
    public void onSetSoldierSpawner(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!e.getClickedBlock().getType().isSolid()) {
            return;
        }
        if (e.getPlayer().getItemInHand() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!e.getPlayer().getItemInHand().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_SoldierTurret_Name))) {
            return;
        }
        if (e.getClickedBlock().getType() == Material.JUKEBOX) {
            e.setCancelled(true);
            return;
        }
        int max = Kingdoms.config.turret_soldierspawner_max;
        Kingdoms.getManagers();
        if (this.isMaxHitInLand(GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getClickedBlock().getChunk())), TurretType.SOLDIER)) {
            e.getPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Turret_Limit).replaceAll("%type%", "Soldier").replaceAll("%number%", "" + max));
            return;
        }
        this.handleTurretSetEvent(e, TurretType.SOLDIER, META_SOLDIER, "CybermanAC", null);
    }

    @EventHandler
    public void onSetHellfireTurret(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!e.getClickedBlock().getType().isSolid()) {
            return;
        }
        if (e.getPlayer().getItemInHand() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!e.getPlayer().getItemInHand().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_HellfireTurret_Name))) {
            return;
        }
        if (e.getClickedBlock().getType() == Material.JUKEBOX) {
            e.setCancelled(true);
            return;
        }
        int max = Kingdoms.config.turret_hellfire_max;
        Kingdoms.getManagers();
        if (this.isMaxHitInLand(GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getClickedBlock().getChunk())), TurretType.HELLFIRE)) {
            e.getPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Turret_Limit).replaceAll("%type%", "Hellfire").replaceAll("%number%", "" + max));
            return;
        }
        this.handleTurretSetEvent(e, TurretType.HELLFIRE, META_HELLFIRE, "BadLuck", null);
    }

    @EventHandler
    public void onSetHeatbeamTurret(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!e.getClickedBlock().getType().isSolid()) {
            return;
        }
        if (e.getPlayer().getItemInHand() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta() == null) {
            return;
        }
        if (e.getPlayer().getItemInHand().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!e.getPlayer().getItemInHand().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Turrets_HeatbeamTurret_Name))) {
            return;
        }
        if (e.getClickedBlock().getType() == Material.JUKEBOX) {
            e.setCancelled(true);
            return;
        }
        int max = Kingdoms.config.turret_heatbeam_max;
        Kingdoms.getManagers();
        if (this.isMaxHitInLand(GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getClickedBlock().getChunk())), TurretType.HEATBEAM)) {
            e.getPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Turret_Limit).replaceAll("%type%", "Heatbeam").replaceAll("%number%", "" + max));
            return;
        }
        this.handleTurretSetEvent(e, TurretType.HEATBEAM, META_HEATBEAM, "captain_fishy", null);
    }

    @EventHandler
    public void onStepOnPressureMine(PlayerInteractEvent e) {
        if (e.getAction() != Action.PHYSICAL) {
            return;
        }
        if (e.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (e.getPlayer().getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (e.getClickedBlock().getType() != Material.STONE_PLATE) {
            return;
        }
        if (!e.getClickedBlock().hasMetadata(META_MINE_PRESSURE)) {
            return;
        }
        e.setCancelled(true);
        SimpleLocation loc = new SimpleLocation(e.getClickedBlock().getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            Kingdoms.logDebug((String)"no kingdom");
        } else {
            if (kingdom.equals(kp.getKingdom())) {
                Kingdoms.logDebug((String)"same kingdom");
                return;
            }
            if (kingdom.isAllianceWith(kp.getKingdom())) {
                Kingdoms.logDebug((String)"ally kingdom");
                return;
            }
            if (kingdom.isEnemyWith(kp.getKingdom())) {
                Kingdoms.logDebug((String)"enemy kingdom");
            } else {
                Kingdoms.logDebug((String)"unknown kingdom");
            }
        }
        Turret turret = land.getTurret(loc);
        turret.setType(null);
        e.getClickedBlock().setTypeId(0);
        e.getClickedBlock().getWorld().createExplosion((double)loc.getX(), (double)loc.getY(), (double)loc.getZ(), (float)Kingdoms.config.turret_pressuremine_damage, false, false);
        if (kingdom.getTurretUpgrades().isConcentratedBlast()) {
            e.getClickedBlock().getWorld().createExplosion((double)loc.getX(), (double)loc.getY(), (double)loc.getZ(), (float)((double)Kingdoms.config.turret_pressuremine_damage * 0.5), false, false);
        }
        kp.sendMessage(ChatColor.RED + "Kaboom!");
    }

    @EventHandler
    public void onStepOnChemicalMine(PlayerInteractEvent e) {
        if (e.getAction() != Action.PHYSICAL) {
            return;
        }
        if (e.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (e.getPlayer().getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (e.getClickedBlock().getType() != Material.WOOD_PLATE) {
            return;
        }
        if (!e.getClickedBlock().hasMetadata(META_MINE_CHEMICAL)) {
            return;
        }
        e.setCancelled(true);
        SimpleLocation loc = new SimpleLocation(e.getClickedBlock().getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            Kingdoms.logDebug((String)"no kingdom");
        } else {
            if (kingdom.equals(kp.getKingdom())) {
                Kingdoms.logDebug((String)"same kingdom");
                return;
            }
            if (kingdom.isAllianceWith(kp.getKingdom())) {
                Kingdoms.logDebug((String)"ally kingdom");
                return;
            }
            if (kingdom.isEnemyWith(kp.getKingdom())) {
                Kingdoms.logDebug((String)"enemy kingdom");
            } else {
                Kingdoms.logDebug((String)"unknown kingdom");
            }
        }
        Turret turret = land.getTurret(loc);
        turret.setType(null);
        e.getClickedBlock().setTypeId(0);
        int dur = 100;
        if (kingdom.getTurretUpgrades().isVirulentPlague()) {
            dur = 200;
        }
        e.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 100, 1));
        e.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 200, 1));
        e.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.POISON, dur, Kingdoms.config.turret_chemicalmine_damage));
        kp.sendMessage(ChatColor.RED + "A pungent gas fills the air!");
    }

    @EventHandler
    public void onFinalService(EntityDeathEvent e) {
        if (e.getEntity().hasMetadata("finalservice") && e.getEntity().getKiller() != null) {
            e.getEntity().getKiller().damage(6.0, (Entity)e.getEntity());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onNexusBlockBreakUnNatural(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getBlock() == null) {
            return;
        }
        if (e.getBlock().getType() != Kingdoms.config.nexusMaterial) {
            return;
        }
        Block nexusBlock = e.getBlock();
        if (!(nexusBlock.hasMetadata(META_ARROW) || nexusBlock.hasMetadata(META_FLAME) || nexusBlock.hasMetadata(META_HEAL) || nexusBlock.hasMetadata(META_HEATBEAM) || nexusBlock.hasMetadata(META_HELLFIRE) || nexusBlock.hasMetadata(META_MINE_CHEMICAL) || nexusBlock.hasMetadata(META_MINE_PRESSURE) || nexusBlock.hasMetadata(META_NEXUS) || nexusBlock.hasMetadata(META_PSIONIC) || nexusBlock.hasMetadata(META_SOLDIER))) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onTurretVolleyFire(EntityDamageByEntityEvent e) {
        if (!(e.getDamager() instanceof Projectile)) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        Projectile a = (Projectile)e.getDamager();
        if (a.hasMetadata("flamesnowballs")) {
            e.getEntity().setFireTicks(e.getEntity().getFireTicks() + 20);
        }
    }

    @EventHandler
    public void onArrowDamageAllyOrMember(EntityDamageByEntityEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        if (ExternalManager.isCitizen(e.getEntity())) {
            return;
        }
        if (!(e.getDamager() instanceof Projectile)) {
            return;
        }
        Player p = (Player)e.getEntity();
        Projectile a = (Projectile)e.getDamager();
        if (a.getMetadata("shooter") == null) {
            return;
        }
        if (a.getMetadata("shooter").size() < 1) {
            return;
        }
        String shooterKingdom = ((MetadataValue)a.getMetadata("shooter").get(0)).asString();
        if (shooterKingdom == null) {
            return;
        }
        KingdomPlayer damaged = GameManagement.getPlayerManager().getSession(p);
        if (damaged == null) {
            return;
        }
        Kingdom kDamaged = damaged.getKingdom();
        if (kDamaged == null) {
            return;
        }
        Kingdom kDamager = GameManagement.getKingdomManager().getOrLoadKingdom(shooterKingdom);
        if (kDamager == null) {
            return;
        }
        if (kDamager.equals(kDamaged) || kDamager.isAllianceWith(kDamaged)) {
            e.setDamage(0.0);
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onArrowHit(EntityDamageByEntityEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        if (ExternalManager.isCitizen(e.getEntity())) {
            return;
        }
        if (!(e.getDamager() instanceof Projectile)) {
            return;
        }
        Player p = (Player)e.getEntity();
        Projectile a = (Projectile)e.getDamager();
        if (a.getMetadata("shooter") == null) {
            return;
        }
        if (a.getMetadata("shooter").size() < 1) {
            return;
        }
        if (a.getMetadata("damage") == null) {
            return;
        }
        try {
            if (a.getMetadata("damage").size() > 0) {
                double damage = ((MetadataValue)a.getMetadata("damage").get(0)).asDouble();
                e.setDamage(damage);
            }
        }
        catch (NumberFormatException er) {
            er.printStackTrace();
        }
        if (!a.getLocation().getChunk().isLoaded()) {
            a.getLocation().getChunk().load();
        }
        a.remove();
    }

    @EventHandler
    public void onMobExplode(EntityExplodeEvent event) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Block b : event.blockList()) {
            if (!TurretManager.isTurret(b)) continue;
            blocks.add(b);
        }
        for (Block b : blocks) {
            event.blockList().remove(b);
        }
    }

    @EventHandler
    public void onBlockPlace(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getPlayer().getItemInHand() != null && event.getPlayer().getItemInHand().getType() == Material.WATER_BUCKET && TurretManager.isTurret(event.getClickedBlock().getRelative(event.getBlockFace()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onWaterPassThrough(BlockFromToEvent event) {
        if (TurretManager.isTurret(event.getToBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLandLoad(LandLoadEvent e) {
        for (Turret turret : e.getLand().getTurrets()) {
            if (turret == null) continue;
            this.initTurret(e.getLand(), turret);
        }
    }

    private synchronized void initTurret(Land land, Turret turret) {
        SimpleLocation loc = turret.getLoc();
        if (land.getOwner() == null) {
            return;
        }
        if (turret.getType() == null) {
            return;
        }
        if (turret.getLoc() == null) {
            Kingdoms.logInfo((String)"[Severe]: Turret initation failed!");
            return;
        }
        if (turret.getLoc().toLocation() == null) {
            Kingdoms.logInfo((String)"[Severe]: Turret initation failed!");
            return;
        }
        if (turret.getLoc().toLocation().getBlock().getType() != Material.SKULL && turret.getLoc().toLocation().getBlock().getType() != Material.STONE_PLATE && turret.getLoc().toLocation().getBlock().getType() != Material.WOOD_PLATE) {
            Kingdoms.logInfo((String)("[Severe]: Tried to load turret at " + turret.getLoc().toString() + ", but turret is air! Replacing turret."));
            turret.getLoc().toLocation().getBlock().setType(Material.SKULL);
        }
        if (this.shouldRemoveTurret(land, turret.getType())) {
            Kingdoms.logInfo((String)(String.valueOf(turret.getType().toString()) + " turret removed from " + land.getOwner() + " on land, " + land.getLoc().toString()));
            land.getTurret(turret.getLoc()).setType(null);
            Location turretLoc = new Location(Bukkit.getWorld((String)turret.getLoc().getWorld()), (double)turret.getLoc().getX(), (double)turret.getLoc().getY(), (double)turret.getLoc().getZ());
            if (!turretLoc.getChunk().isLoaded()) {
                turretLoc.getChunk().load();
            }
            turretLoc.getBlock().setType(Material.AIR);
            Kingdoms.getManagers();
            Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
            kingdom.setResourcepoints(kingdom.getResourcepoints() + Kingdoms.config.turret_arrow_cost);
            return;
        }
        switch (turret.getType()) {
            case ARROW: {
                turret.getLoc().toLocation().getBlock().setMetadata(META_ARROW, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)land.getOwner()));
                Block turretBlock = turret.getLoc().toLocation().getBlock();
                turretBlock.setType(Material.SKULL);
                turretBlock.setData((byte)1);
                Skull s = (Skull)turretBlock.getState();
                s.setSkullType(SkullType.SKELETON);
                s.update();
                break;
            }
            case NEXUS: {
                turret.getLoc().toLocation().getBlock().setMetadata(META_NEXUS, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)land.getOwner()));
                break;
            }
            case FLAME: {
                turret.getLoc().toLocation().getBlock().setMetadata(META_FLAME, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)land.getOwner()));
                Block turretBlock = turret.getLoc().toLocation().getBlock();
                turretBlock.setType(Material.SKULL);
                turretBlock.setData((byte)1);
                Skull s = (Skull)turretBlock.getState();
                s.setSkullType(SkullType.WITHER);
                s.update();
                break;
            }
            case HEALING: {
                turret.getLoc().toLocation().getBlock().setMetadata(META_HEAL, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)land.getOwner()));
                Block turretBlock = turret.getLoc().toLocation().getBlock();
                turretBlock.setType(Material.SKULL);
                turretBlock.setData((byte)1);
                Skull s = (Skull)turretBlock.getState();
                s.setSkullType(SkullType.ZOMBIE);
                s.update();
                break;
            }
            case PSIONIC: {
                turret.getLoc().toLocation().getBlock().setMetadata(META_PSIONIC, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)land.getOwner()));
                Block turretBlock = turret.getLoc().toLocation().getBlock();
                turretBlock.setType(Material.SKULL);
                turretBlock.setData((byte)1);
                Skull s = (Skull)turretBlock.getState();
                s.setSkullType(SkullType.CREEPER);
                s.update();
                break;
            }
            case HELLFIRE: {
                turret.getLoc().toLocation().getBlock().setMetadata(META_HELLFIRE, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)land.getOwner()));
                Block turretBlock = turret.getLoc().toLocation().getBlock();
                turretBlock.setType(Material.SKULL);
                turretBlock.setData((byte)1);
                Skull s = (Skull)turretBlock.getState();
                s.setOwner("BadLuck");
                s.update();
                break;
            }
            case SOLDIER: {
                turret.getLoc().toLocation().getBlock().setMetadata(META_SOLDIER, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)land.getOwner()));
                Block turretBlock = turret.getLoc().toLocation().getBlock();
                turretBlock.setType(Material.SKULL);
                turretBlock.setData((byte)1);
                Skull s = (Skull)turretBlock.getState();
                s.setOwner("CybermanAC");
                s.update();
                break;
            }
            case HEATBEAM: {
                turret.getLoc().toLocation().getBlock().setMetadata(META_HEATBEAM, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)land.getOwner()));
                Block turretBlock = turret.getLoc().toLocation().getBlock();
                turretBlock.setType(Material.SKULL);
                turretBlock.setData((byte)1);
                Skull s = (Skull)turretBlock.getState();
                s.setOwner("captain_fishy");
                s.update();
                break;
            }
            case MINE_PRESSURE: {
                turret.getLoc().toLocation().getBlock().setMetadata(META_MINE_PRESSURE, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)land.getOwner()));
                break;
            }
            case MINE_CHEMICAL: {
                turret.getLoc().toLocation().getBlock().setMetadata(META_MINE_CHEMICAL, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)land.getOwner()));
            }
        }
        Kingdoms.logDebug((String)("turret init at " + loc.toString()));
    }

    @Override
    public void onDisable() {
    }
}

