/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import org.bukkit.entity.Animals;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.Regulator;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;

public class RegulatorManager
extends Manager
implements Listener {
    RegulatorManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteractRegulatorCheck(PlayerInteractEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            Kingdoms.getManagers();
            Land land = GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getClickedBlock().getChunk()));
            if (land == null) {
                return;
            }
            if (land.getOwner() == null) {
                return;
            }
            if (land.getStructure() == null) {
                return;
            }
            if (land.getStructure() instanceof Regulator) {
                Regulator reg = (Regulator)land.getStructure();
                Kingdoms.getManagers();
                KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
                if (kp.getKingdom() != null && kp.getKingdom().getKingdomName().equals(land.getOwner())) {
                    if (kp.getRank().isHigherOrEqualTo(kp.getKingdom().getPermissionsInfo().getOverrideRegulator())) {
                        return;
                    }
                    if (!reg.getWhoCanInteract().contains(kp.getUuid())) {
                        e.setCancelled(true);
                        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Regulator_Cannot_Interact));
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBuildRegulatorCheck(BlockPlaceEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            Kingdoms.getManagers();
            Land land = GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getBlock().getChunk()));
            if (land == null) {
                return;
            }
            if (land.getOwner() == null) {
                return;
            }
            if (land.getStructure() == null) {
                return;
            }
            if (land.getStructure() instanceof Regulator) {
                Regulator reg = (Regulator)land.getStructure();
                Kingdoms.getManagers();
                KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
                if (kp.getKingdom() != null && kp.getKingdom().getKingdomName().equals(land.getOwner())) {
                    if (kp.getRank().isHigherOrEqualTo(kp.getKingdom().getPermissionsInfo().getOverrideRegulator())) {
                        return;
                    }
                    if (!reg.getWhoCanBuild().contains(kp.getUuid())) {
                        e.setCancelled(true);
                        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Regulator_Cannot_Build));
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBreakRegulatorCheck(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            Kingdoms.getManagers();
            Land land = GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getBlock().getChunk()));
            if (land == null) {
                return;
            }
            if (land.getOwner() == null) {
                return;
            }
            if (land.getStructure() == null) {
                return;
            }
            if (land.getStructure() instanceof Regulator) {
                Regulator reg = (Regulator)land.getStructure();
                Kingdoms.getManagers();
                KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
                if (kp.getKingdom() != null && kp.getKingdom().getKingdomName().equals(land.getOwner())) {
                    if (kp.getRank().isHigherOrEqualTo(kp.getKingdom().getPermissionsInfo().getOverrideRegulator())) {
                        return;
                    }
                    if (!reg.getWhoCanBuild().contains(kp.getUuid())) {
                        e.setCancelled(true);
                        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Regulator_Cannot_Build));
                    }
                }
            }
        }
    }

    @EventHandler
    public void onBucketEmptyRegulatorCheck(PlayerBucketEmptyEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            Kingdoms.getManagers();
            Land land = GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getBlockClicked().getRelative(e.getBlockFace()).getChunk()));
            if (land == null) {
                return;
            }
            if (land.getOwner() == null) {
                return;
            }
            if (land.getStructure() == null) {
                return;
            }
            if (land.getStructure() instanceof Regulator) {
                Regulator reg = (Regulator)land.getStructure();
                Kingdoms.getManagers();
                KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
                if (kp.getKingdom() != null && kp.getKingdom().getKingdomName().equals(land.getOwner())) {
                    if (kp.getRank().isHigherOrEqualTo(kp.getKingdom().getPermissionsInfo().getOverrideRegulator())) {
                        return;
                    }
                    if (!reg.getWhoCanBuild().contains(kp.getUuid())) {
                        e.setCancelled(true);
                        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Regulator_Cannot_Build));
                    }
                }
            }
        }
    }

    @EventHandler
    public void onBucketFillRegulatorCheck(PlayerBucketFillEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            Kingdoms.getManagers();
            Land land = GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getBlockClicked().getRelative(e.getBlockFace()).getChunk()));
            if (land == null) {
                return;
            }
            if (land.getOwner() == null) {
                return;
            }
            if (land.getStructure() == null) {
                return;
            }
            if (land.getStructure() instanceof Regulator) {
                Regulator reg = (Regulator)land.getStructure();
                Kingdoms.getManagers();
                KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
                if (kp.getKingdom() != null && kp.getKingdom().getKingdomName().equals(land.getOwner())) {
                    if (kp.getRank().isHigherOrEqualTo(kp.getKingdom().getPermissionsInfo().getOverrideRegulator())) {
                        return;
                    }
                    if (!reg.getWhoCanBuild().contains(kp.getUuid())) {
                        e.setCancelled(true);
                        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Regulator_Cannot_Build));
                    }
                }
            }
        }
    }

    @EventHandler
    public void onMobSpawnRegulatorCheck(CreatureSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
            return;
        }
        if (!(event.getEntity() instanceof Monster || event.getEntity() instanceof Animals || event.getEntity() instanceof Slime || event.getEntity() instanceof MagmaCube)) {
            return;
        }
        if (event.getEntity() instanceof EnderDragon || event.getEntity() instanceof Wither) {
            return;
        }
        if (Kingdoms.config.worlds.contains(event.getEntity().getWorld().getName())) {
            Kingdoms.getManagers();
            Land land = GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(event.getEntity().getLocation().getChunk()));
            if (land == null) {
                return;
            }
            if (land.getOwner() == null) {
                return;
            }
            if (land.getStructure() == null) {
                return;
            }
            if (land.getStructure() instanceof Regulator) {
                Regulator reg = (Regulator)land.getStructure();
                if ((event.getEntity() instanceof Monster || event.getEntity() instanceof Slime || event.getEntity() instanceof MagmaCube) && !reg.isAllowMonsterSpawning()) {
                    event.setCancelled(true);
                }
                if (event.getEntity() instanceof Animals && !reg.isAllowAnimalSpawning()) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @Override
    public void onDisable() {
    }
}

