/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.generallib.database.Database;
import org.generallib.database.file.DatabaseFile;
import org.generallib.database.mysql.DatabaseMysql;
import org.generallib.database.tasks.DatabaseTransferTask;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.events.KingdomPlayerLoginEvent;
import org.kingdoms.events.KingdomPlayerLogoffEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.GameManagement;

public class PlayerManager
extends Manager
implements Listener {
    public static final File PLAYERFOLDER = new File(Kingdoms.getInstance().getDataFolder(), Kingdoms.config.playerTable);
    protected static Map<UUID, OfflineKingdomPlayer> userList = new ConcurrentHashMap<UUID, OfflineKingdomPlayer>();
    private static Database<OfflineKingdomPlayer> db;
    private final Thread autoSaveThread;
    public static Queue<KingdomPlayer> loadQueue;

    static {
        loadQueue = new LinkedList<KingdomPlayer>();
    }

    /*
     * Unable to fully structure code
     */
    PlayerManager(Plugin plugin) {
        block14: {
            block13: {
                block12: {
                    super(plugin);
                    if (!Kingdoms.config.mysqlEnabled) break block13;
                    try {
                        try {
                            if (Kingdoms.config.grabPlayersFromFileDB) {
                                Kingdoms.config.grabPlayersFromFileDB = false;
                                pairs = new ArrayList<DatabaseTransferTask.TransferPair>();
                                pairs.add(new DatabaseTransferTask.TransferPair(this.createFileDB(), this.createMysqlDB()));
                                new Thread((Runnable)new DatabaseTransferTask((Plugin)Kingdoms.getInstance(), pairs)).start();
                            }
                            PlayerManager.db = this.createMysqlDB();
                            Kingdoms.logInfo((String)"Mysql Connection Success!");
                            Kingdoms.logInfo((String)("Using " + Kingdoms.config.dbAddress + " with user " + Kingdoms.config.dbUser));
                            break block12;
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException | NamingException e) {
                            Kingdoms.logInfo((String)"Mysql Connection Failed!");
                            Kingdoms.logInfo((String)("Using " + Kingdoms.config.dbAddress + " with user " + Kingdoms.config.dbUser));
                            Kingdoms.logInfo((String)e.getMessage());
                            Kingdoms.config.grabPlayersFromFileDB = true;
                            if (PlayerManager.db == null) {
                                PlayerManager.db = this.createFileDB();
                                Kingdoms.logInfo((String)"Using file database for Player data");
                            }
                            PlayerManager.userList.clear();
                            ** for (player : Bukkit.getOnlinePlayers())
                        }
                    }
                    catch (Throwable var3_11) {
                        if (PlayerManager.db == null) {
                            PlayerManager.db = this.createFileDB();
                            Kingdoms.logInfo((String)"Using file database for Player data");
                        }
                        PlayerManager.userList.clear();
                        ** for (player : Bukkit.getOnlinePlayers())
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.onJoin(new PlayerJoinEvent(player, null));
                        continue;
                    }
lbl27:
                    // 1 sources

                    this.autoSaveThread = new Thread(new AutoSaveTask());
                    this.autoSaveThread.setPriority(1);
                    this.autoSaveThread.start();
                    new Thread(new SynchronizedKingdomLoad()).start();
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        this.onJoin(new PlayerJoinEvent(player, null));
                        continue;
                    }
lbl40:
                    // 1 sources

                    this.autoSaveThread = new Thread(new AutoSaveTask());
                    this.autoSaveThread.setPriority(1);
                    this.autoSaveThread.start();
                    new Thread(new SynchronizedKingdomLoad()).start();
                    throw var3_11;
                }
                if (PlayerManager.db == null) {
                    PlayerManager.db = this.createFileDB();
                    Kingdoms.logInfo((String)"Using file database for Player data");
                }
                PlayerManager.userList.clear();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.onJoin(new PlayerJoinEvent(player, null));
                }
                this.autoSaveThread = new Thread(new AutoSaveTask());
                this.autoSaveThread.setPriority(1);
                this.autoSaveThread.start();
                new Thread(new SynchronizedKingdomLoad()).start();
                break block14;
            }
            PlayerManager.db = this.createFileDB();
            Kingdoms.logInfo((String)"Using file database for Player data");
            PlayerManager.userList.clear();
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.onJoin(new PlayerJoinEvent(player, null));
            }
            this.autoSaveThread = new Thread(new AutoSaveTask());
            this.autoSaveThread.setPriority(1);
            this.autoSaveThread.start();
            new Thread(new SynchronizedKingdomLoad()).start();
        }
    }

    public DatabaseFile<OfflineKingdomPlayer> createFileDB() {
        return new DatabaseFile(new File(this.plugin.getDataFolder(), Kingdoms.config.playerTable), KingdomPlayer.class);
    }

    public DatabaseMysql<OfflineKingdomPlayer> createMysqlDB() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NamingException {
        return new DatabaseMysql(Kingdoms.config.dbAddress, Kingdoms.config.dbName, Kingdoms.config.playerTable, Kingdoms.config.dbUser, Kingdoms.config.dbPassword, KingdomPlayer.class);
    }

    public DatabaseTransferTask.TransferPair<OfflineKingdomPlayer> getTransferPair(Database<OfflineKingdomPlayer> from) {
        return new DatabaseTransferTask.TransferPair(from, db);
    }

    private synchronized void saveAll() {
        for (Map.Entry<UUID, OfflineKingdomPlayer> entry : userList.entrySet()) {
            UUID id = entry.getKey();
            OfflineKingdomPlayer okp = entry.getValue();
            Kingdoms.logColor((String)("Saving player" + okp.getName()));
            try {
                db.save(id.toString(), (Object)okp);
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("[Kingdoms] Failed autosave!");
            }
            if (okp instanceof KingdomPlayer) continue;
            Kingdoms.logDebug((String)(id + " is saved and removed."));
            Kingdoms.logDebug((String)okp.getKingdomName());
            Kingdoms.logDebug((String)("" + (Object)((Object)okp.getRank())));
            userList.remove(id);
        }
    }

    public OfflineKingdomPlayer getOfflineKingdomPlayer(UUID uuid) {
        return this.loadOfflineKingdomPlayer(uuid);
    }

    public OfflineKingdomPlayer getOfflineKingdomPlayer(OfflinePlayer p) {
        return this.loadOfflineKingdomPlayer(p.getUniqueId());
    }

    private OfflineKingdomPlayer loadOfflineKingdomPlayer(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        Kingdoms.logColor((String)("Getting session of offline player, " + uuid.toString()));
        if (userList.containsKey(uuid)) {
            return userList.get(uuid);
        }
        OfflineKingdomPlayer okp = (OfflineKingdomPlayer)db.load(uuid.toString(), null);
        if (okp != null) {
            userList.put(uuid, okp);
        }
        return okp;
    }

    public boolean isOnline(UUID uuid) {
        if (!userList.containsKey(uuid)) {
            return false;
        }
        KingdomPlayer kp = userList.get(uuid).getKingdomPlayer();
        if (kp.getPlayer() == null) {
            return false;
        }
        return userList.get(uuid).getKingdomPlayer().getPlayer().isOnline();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onJoin(PlayerJoinEvent e) {
        KingdomPlayer kp;
        Player player = e.getPlayer();
        if (userList.containsKey(player.getUniqueId())) {
            db.save(player.getUniqueId().toString(), (Object)userList.remove(player.getUniqueId()));
        }
        if ((kp = this.loadKingdomPlayer(player)) != null) {
            userList.put(player.getUniqueId(), kp);
        }
        loadQueue.add(kp);
    }

    public KingdomPlayer loadKingdomPlayer(Player player) {
        Kingdoms.logColor((String)("Loading player, " + player.getName()));
        KingdomPlayer kp = null;
        if (userList.containsKey(player.getUniqueId())) {
            db.save(player.getUniqueId().toString(), (Object)userList.remove(player.getUniqueId()));
        }
        try {
            kp = (KingdomPlayer)db.load(player.getUniqueId().toString(), null);
        }
        catch (IllegalStateException e) {
            Kingdoms.logInfo((String)("[ERROR]: The file, " + player.getUniqueId().toString() + " under Players is corrupted."));
            return new KingdomPlayer(Bukkit.getPlayer((UUID)player.getUniqueId()));
        }
        catch (JsonSyntaxException e) {
            Kingdoms.logInfo((String)("[ERROR]: The file, " + player.getUniqueId().toString() + " under Players is corrupted."));
            return new KingdomPlayer(Bukkit.getPlayer((UUID)player.getUniqueId()));
        }
        if (kp != null) {
            kp.setPlayer(player);
        } else {
            kp = new KingdomPlayer(player);
        }
        if (!Kingdoms.config.defaultMarkersOn) {
            kp.setMarkDisplaying(false);
        }
        return kp;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRespawn(PlayerRespawnEvent event) {
        Kingdom kingdom;
        KingdomPlayer kp;
        if (!Kingdoms.config.respawn_in_khome) {
            return;
        }
        if (Kingdoms.config.worlds.contains(event.getPlayer().getWorld().getName()) && (kp = this.getSession(event.getPlayer())).getKingdom() != null && (kingdom = kp.getKingdom()).getHome_loc() != null) {
            event.setRespawnLocation(kingdom.getHome_loc());
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        OfflineKingdomPlayer okp = userList.remove(player.getUniqueId());
        db.save(player.getUniqueId().toString(), (Object)okp);
        if (okp instanceof KingdomPlayer) {
            this.plugin.getServer().getPluginManager().callEvent((Event)new KingdomPlayerLogoffEvent((KingdomPlayer)okp));
        }
    }

    public KingdomPlayer getSession(Player player) {
        if (player == null) {
            return null;
        }
        Kingdoms.logColor((String)("Getting session of player, " + player.getName()));
        if (ExternalManager.isCitizen((Entity)player)) {
            return null;
        }
        if (userList.get(player.getUniqueId()) instanceof KingdomPlayer) {
            return (KingdomPlayer)userList.get(player.getUniqueId());
        }
        KingdomPlayer kp = this.loadKingdomPlayer(player);
        if (kp != null) {
            userList.put(player.getUniqueId(), kp);
        }
        loadQueue.add(kp);
        return kp;
    }

    public KingdomPlayer getSession(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        Kingdoms.logColor((String)("Getting session of player uuid, " + uuid.toString()));
        if (userList.get(uuid) instanceof KingdomPlayer) {
            return (KingdomPlayer)userList.get(uuid);
        }
        return null;
    }

    @Override
    public synchronized void onDisable() {
        this.autoSaveThread.interrupt();
        try {
            this.autoSaveThread.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        Kingdoms.logInfo((String)("Saving [" + userList.size() + "] loaded players..."));
        try {
            this.saveAll();
            Kingdoms.logInfo((String)"Done!");
        }
        catch (Exception e) {
            Kingdoms.logInfo((String)"SQL connection failed! Saving to file DB");
            db = this.createFileDB();
            this.saveAll();
            Kingdoms.config.grabPlayersFromFileDB = true;
        }
        userList.clear();
    }

    private class AutoSaveTask
    implements Runnable {
        private AutoSaveTask() {
        }

        @Override
        public void run() {
            while (PlayerManager.this.plugin.isEnabled()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Kingdoms.logInfo((String)"Player auto save is interrupted.");
                    return;
                }
                PlayerManager.this.saveAll();
            }
        }
    }

    private class PreLoadTask
    implements Runnable {
        private PreLoadTask() {
        }

        @Override
        public void run() {
            OfflinePlayer[] list = (OfflinePlayer[])Bukkit.getOfflinePlayers().clone();
            int max = list.length - 1;
            int i = 0;
            while (i < max) {
                OfflinePlayer p = list[i];
                PlayerManager.this.loadOfflineKingdomPlayer(p.getUniqueId());
                ++i;
            }
            Kingdoms.logInfo((String)("Loaded " + i + " players"));
        }
    }

    private class SynchronizedKingdomLoad
    implements Runnable {
        private SynchronizedKingdomLoad() {
        }

        @Override
        public void run() {
            while (PlayerManager.this.plugin.isEnabled()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.perform();
            }
        }

        private void perform() {
            if (loadQueue.isEmpty()) {
                return;
            }
            KingdomPlayer kp = loadQueue.poll();
            if (kp.getKingdomName() == null) {
                return;
            }
            Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(kp.getKingdomName());
            kp.setKingdom(kingdom);
            PlayerManager.this.plugin.getServer().getPluginManager().callEvent((Event)new KingdomPlayerLoginEvent(kp));
        }
    }
}

