/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.StructureType;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.land.Structure;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomPlayerPlaceNexusEvent;
import org.kingdoms.events.PlayerChangeChunkEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.TurretManager;
import org.kingdoms.manager.gui.GUIManagement;

public class NexusManager
extends Manager
implements Listener {
    private static final List<KingdomPlayer> placingNexusList = new ArrayList<KingdomPlayer>();

    protected NexusManager(Plugin plugin) {
        super(plugin);
    }

    public void startNexusSet(KingdomPlayer kp) {
        placingNexusList.add(kp);
    }

    @EventHandler
    public void onChunkChange(PlayerChangeChunkEvent e) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (!placingNexusList.contains(kp)) {
            return;
        }
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Nexus_Setting_Disabled));
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Nexus_Setting_Different_Land));
        placingNexusList.remove(kp);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onQuit(PlayerQuitEvent e) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (!placingNexusList.contains(kp)) {
            return;
        }
        placingNexusList.remove(kp);
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock().getType() != Kingdoms.config.nexusMaterial) {
            return;
        }
        if (!event.getClickedBlock().hasMetadata("nexusblock")) {
            return;
        }
        KingdomPlayer clicked = GameManagement.getPlayerManager().getSession(event.getPlayer());
        if (clicked == null) {
            Kingdoms.logInfo((String)"kp is null!");
            return;
        }
        event.setCancelled(true);
        if (!Kingdoms.config.allowingNexusAccessForGameModes.contains(event.getPlayer().getGameMode().name())) {
            clicked.sendMessage(LanguageSupport.Languages.Misc_IllegalGamemode);
            return;
        }
        if (clicked.getKingdom() == null) {
            clicked.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        Block nexusBlock = event.getClickedBlock();
        SimpleLocation loc = new SimpleLocation(nexusBlock.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land == null) {
            Kingdoms.logInfo((String)("clicked nexus in [" + chunk + "] but land was null!"));
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            clicked.sendMessage(ChatColor.RED + "Kingdom [" + land.getOwner() + "] not found!");
            clicked.sendMessage(ChatColor.RED + "Something is glitched; please report");
            nexusBlock.setType(Material.AIR);
            return;
        }
        if (kingdom.isAllianceWith(clicked.getKingdom())) {
            Inventory dumpgui = Bukkit.createInventory(null, (int)54, (String)(ChatColor.DARK_BLUE + "Donate to " + ChatColor.DARK_GREEN + kingdom.getKingdomName()));
            clicked.getPlayer().openInventory(dumpgui);
        } else if (kingdom.equals(clicked.getKingdom())) {
            if (clicked.getPlayer().getGameMode() == GameMode.CREATIVE && !Kingdoms.config.gmcUseNexus && !clicked.getPlayer().isOp()) {
                clicked.sendMessage(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Use_Nexus_In_GMC));
                return;
            }
            GUIManagement.getNexusGUIManager().openNexusGui(clicked);
        } else {
            clicked.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Use_Other_Nexus));
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlaceNexusBlock(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (!placingNexusList.contains(kp)) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        GameManagement.getApiManager();
        if (!ExternalManager.canBuild(kp.getPlayer(), e.getClickedBlock())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Claim_In_WG));
            return;
        }
        SimpleChunkLocation clickedChunk = new SimpleChunkLocation(e.getClickedBlock().getChunk());
        Land land = GameManagement.getLandManager().getOrLoadLand(clickedChunk);
        if (land.getOwner() == null || !land.getOwner().equals(kingdom.getKingdomName())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Break_In_Other_Land));
            return;
        }
        Block clicked = e.getClickedBlock();
        if (TurretManager.isTurret(clicked)) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Nexus_Setting_Cannot_Replace));
            return;
        }
        if (Kingdoms.config.unreplaceableblocks.contains(clicked.getType().toString())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Nexus_Setting_Cannot_Replace));
            return;
        }
        placingNexusList.remove(kp);
        KingdomPlayerPlaceNexusEvent lce = new KingdomPlayerPlaceNexusEvent(kp, kingdom, clicked.getLocation(), land.getLoc());
        Bukkit.getPluginManager().callEvent((Event)lce);
        this.setNexus(land, clicked);
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Nexus_Setting_Success));
    }

    public void setNexus(Land land, Block target) {
        SimpleLocation loc;
        if (land.getOwner() == null) {
            Kingdoms.logInfo((String)Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Nexus_Setting_Not_In_Land));
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom.getNexus_loc() != null) {
            loc = new SimpleLocation(kingdom.getNexus_loc());
            SimpleChunkLocation chunk = loc.toSimpleChunk();
            Land previousNexusLand = GameManagement.getLandManager().getOrLoadLand(chunk);
            previousNexusLand.setStructure(null);
            Block previous_nexus = kingdom.getNexus_loc().getBlock();
            previous_nexus.setType(Material.AIR);
        }
        if (land.getStructure() != null) {
            ItemStack IS;
            if (land.getStructure().getType() == StructureType.OUTPOST) {
                IS = GameManagement.getStructureManager().getOutpostDisk();
                Block outpostBlock = land.getStructure().getLoc().toLocation().getBlock();
                outpostBlock.setType(Material.AIR);
                outpostBlock.getWorld().dropItemNaturally(outpostBlock.getLocation(), IS);
            } else if (land.getStructure().getType() == StructureType.POWERCELL) {
                IS = GameManagement.getStructureManager().getPowerCellDisk();
                Block powercellBlock = land.getStructure().getLoc().toLocation().getBlock();
                powercellBlock.setType(Material.AIR);
                powercellBlock.getWorld().dropItemNaturally(powercellBlock.getLocation(), IS);
            } else if (land.getStructure().getType() == StructureType.EXTRACTOR) {
                IS = GameManagement.getStructureManager().getExtractorDisk();
                Block extractorBlock = land.getStructure().getLoc().toLocation().getBlock();
                extractorBlock.setType(Material.AIR);
                extractorBlock.getWorld().dropItemNaturally(extractorBlock.getLocation(), IS);
            } else if (land.getStructure().getType() == StructureType.WARPPAD) {
                IS = GameManagement.getStructureManager().getWarpPadDisk();
                Block warppadBlock = land.getStructure().getLoc().toLocation().getBlock();
                warppadBlock.setType(Material.AIR);
                warppadBlock.getWorld().dropItemNaturally(warppadBlock.getLocation(), IS);
            }
        }
        loc = new SimpleLocation(target.getLocation());
        Structure structure = new Structure(loc, StructureType.NEXUS);
        land.setStructure(structure);
        target.setMetadata("nexusblock", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)kingdom.getKingdomName()));
        target.setType(Kingdoms.config.nexusMaterial);
        kingdom.setNexus_loc(loc.toLocation());
    }

    @EventHandler
    public void onCancelPlaceBlock(PlayerInteractEvent e) {
        if (e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            placingNexusList.remove(kp);
            return;
        }
        if (!placingNexusList.contains(kp)) {
            return;
        }
        placingNexusList.remove(kp);
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Nexus_Setting_Disabled));
    }

    @EventHandler
    public void onNexusBlockBreakUnNatural2(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getBlock() == null) {
            return;
        }
        if (e.getBlock().getType() != Kingdoms.config.nexusMaterial) {
            return;
        }
        Block nexusBlock = e.getBlock();
        if (!nexusBlock.hasMetadata("nexusblock")) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onNexusMining(BlockBreakEvent e) {
        Kingdoms.logDebug((String)"nexus mine event 1");
        if (e.getBlock() == null) {
            return;
        }
        if (e.getBlock().getType() != Kingdoms.config.nexusMaterial) {
            return;
        }
        Block nexusBlock = e.getBlock();
        if (!nexusBlock.hasMetadata("nexusblock")) {
            return;
        }
        KingdomPlayer invader = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (invader == null) {
            return;
        }
        Kingdom kInvader = invader.getKingdom();
        if (kInvader == null) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(nexusBlock.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Kingdoms.logDebug((String)"nexus mine event 2");
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land == null) {
            return;
        }
        if (land.getOwner() == null) {
            Kingdoms.logInfo((String)("There was a nexus at [" + chunk.toString() + "] but no owner."));
            Kingdoms.logInfo((String)"Removed nexus.");
            e.getBlock().setType(Material.AIR);
            e.setCancelled(true);
            return;
        }
        Kingdoms.logDebug((String)"nexus mine event 3");
        Kingdom kNexusOwner = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kNexusOwner == null) {
            return;
        }
        Kingdoms.logDebug((String)"nexus mine event 4");
        if (kInvader.isAllianceWith(kNexusOwner)) {
            invader.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Nexus_Mining_isAlliance));
            return;
        }
        if (kInvader.getKingdomName().equals(kNexusOwner.getKingdomName())) {
            invader.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Nexus_Mining_isOwn));
            return;
        }
        Kingdoms.logDebug((String)"nexus mine event 4");
        int rp = kNexusOwner.getResourcepoints();
        if (rp > Kingdoms.config.nexusMiningAmount) {
            kNexusOwner.setResourcepoints(rp - Kingdoms.config.nexusMiningAmount);
            kInvader.setResourcepoints(kInvader.getResourcepoints() + Kingdoms.config.nexusMiningAmount);
            Kingdoms.getLang().addInteger(Kingdoms.config.nexusMiningAmount);
            invader.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Nexus_Mining_EarnedRP));
        } else {
            int earned = kNexusOwner.getResourcepoints();
            kNexusOwner.setResourcepoints(0);
            if (earned > 0) {
                kInvader.setResourcepoints(kInvader.getResourcepoints() + earned);
                Kingdoms.getLang().addInteger(earned);
                invader.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Nexus_Mining_EarnedRP));
            }
        }
        GameManagement.getApiManager();
        if (ExternalManager.getScoreboardManager() != null) {
            ExternalManager.getScoreboardManager().updateScoreboard(invader);
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onEntityExplodeInKingdomLand(EntityExplodeEvent e) {
        Iterator iter = e.blockList().iterator();
        while (iter.hasNext()) {
            Block nexusBlock;
            Block block = (Block)iter.next();
            if (block == null || block.getType() == Material.AIR || block.getType() != Kingdoms.config.nexusMaterial || !(nexusBlock = block).hasMetadata("nexusblock")) continue;
            iter.remove();
        }
    }

    public void breakNexus(Land land) {
        if (land.getStructure() == null) {
            Kingdoms.logInfo((String)("Could not break nexus at [" + land.getLoc().toString() + "]"));
            Kingdoms.logInfo((String)"There is no structure in this land.");
            return;
        }
        if (land.getStructure().getType() != StructureType.NEXUS) {
            Kingdoms.logInfo((String)("Could not break nexus at [" + land.getLoc().toString() + "]"));
            Kingdoms.logInfo((String)"Structure is not nexus.");
            return;
        }
        Block nexusBlock = land.getStructure().getLoc().toLocation().getBlock();
        SimpleLocation nexusLoc = land.getStructure().getLoc();
        SimpleChunkLocation chunk = nexusLoc.toSimpleChunk();
        if (land.getOwner() == null) {
            Kingdoms.logInfo((String)("The nexus is destroyed but nobody owns the land [" + chunk + "]!"));
            return;
        }
        if (land.getStructure() == null) {
            Kingdoms.logInfo((String)("The nexus destroy is requested at [" + chunk + "] but no structure in that land!"));
            return;
        }
        if (land.getStructure().getType() != StructureType.NEXUS) {
            Kingdoms.logInfo((String)("The nexus destroy is requested at [" + chunk + "] but structure is not nexus!"));
            return;
        }
        land.setStructure(null);
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        kingdom.setNexus_loc(null);
        nexusBlock.setType(Material.AIR);
        this.createNexusBlast(nexusBlock.getLocation(), this.plugin);
    }

    private void createNexusBlast(final Location loc, Kingdoms plugin) {
        loc.getWorld().strikeLightningEffect(loc);
        loc.getWorld().strikeLightningEffect(loc);
        loc.getWorld().strikeLightningEffect(loc);
        loc.getWorld().strikeLightningEffect(loc);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
            }
        }, 10L);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
            }
        }, 20L);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
            }
        }, 30L);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
                loc.getWorld().strikeLightningEffect(loc);
            }
        }, 40L);
    }

    @Override
    public void onDisable() {
        placingNexusList.clear();
    }
}

