/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.MisupgradeInfo;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.GameManagement;

public class MisupManager
extends Manager
implements Listener {
    protected MisupManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onExplosionDamage(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        if (ExternalManager.isCitizen(e.getEntity())) {
            return;
        }
        if (e.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(e.getEntity().getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land == null) {
            return;
        }
        if (land.getOwner() == null) {
            return;
        }
        KingdomPlayer target = GameManagement.getPlayerManager().getSession((Player)e.getEntity());
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        if (!kingdom.getMisupgradeInfo().isAnticreeper() || !Kingdoms.config.misc_upgrades_anticreeper_enabled) {
            return;
        }
        if (kingdom.equals(target.getKingdom())) {
            e.setDamage(0.0);
            e.setCancelled(true);
            return;
        }
        if (kingdom.isAllianceWith(target.getKingdom())) {
            e.setDamage(0.0);
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onTrample(PlayerInteractEvent e) {
        if (e.getAction() != Action.PHYSICAL) {
            return;
        }
        if (e.getClickedBlock().getType() != Material.SOIL) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(e.getClickedBlock().getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land == null) {
            return;
        }
        if (land.getOwner() == null) {
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        if (kingdom.getMisupgradeInfo().isAntitrample() && Kingdoms.config.misc_upgrades_antitrample_enabled) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onExpGain(EntityDeathEvent e) {
        Player p = e.getEntity().getKiller();
        if (p == null) {
            return;
        }
        if (ExternalManager.isCitizen((Entity)p)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
        if (kp == null) {
            return;
        }
        if (kp.getKingdom() == null) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(p.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land == null) {
            return;
        }
        if (land.getOwner() == null) {
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        if (!kingdom.getMisupgradeInfo().isGlory()) {
            return;
        }
        if (!kingdom.equals(kp.getKingdom())) {
            return;
        }
        if (kingdom.getMisupgradeInfo().isGlory() && Kingdoms.config.misc_upgrades_glory_enabled) {
            e.setDroppedExp(e.getDroppedExp() * 3);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onNexusMined(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!Kingdoms.config.misc_upgrades_nexusguard_enabled) {
            return;
        }
        if (e.getBlock() == null) {
            return;
        }
        if (e.getBlock().getType() != Kingdoms.config.nexusMaterial) {
            return;
        }
        Block nexusBlock = e.getBlock();
        if (!nexusBlock.hasMetadata("nexusblock")) {
            return;
        }
        KingdomPlayer invader = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (invader == null) {
            return;
        }
        Kingdom kInvader = invader.getKingdom();
        if (kInvader == null) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(nexusBlock.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land == null) {
            return;
        }
        if (land.getOwner() == null) {
            Kingdoms.logInfo((String)("There was a nexus at [" + chunk.toString() + "] but no owner."));
            Kingdoms.logInfo((String)"Removed nexus.");
            e.getBlock().setType(Material.AIR);
            e.setCancelled(true);
            return;
        }
        Kingdom kNexusOwner = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kNexusOwner == null) {
            return;
        }
        if (kInvader.getKingdomName().equals(kNexusOwner.getKingdomName())) {
            invader.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Nexus_Mining_isOwn));
            return;
        }
        if (!kNexusOwner.getMisupgradeInfo().isNexusguard()) {
            return;
        }
        Kingdoms.getManagers();
        GameManagement.getGuardsManager().spawnNexusGuard(invader.getPlayer().getLocation(), kNexusOwner, invader);
    }

    @EventHandler
    public void onAntiCreeperTrigger(EntityExplodeEvent e) {
        if (!Kingdoms.config.misc_upgrades_anticreeper_enabled) {
            return;
        }
        if (e.getEntity().getType() != EntityType.CREEPER) {
            return;
        }
        Iterator iter = e.blockList().iterator();
        while (iter.hasNext()) {
            MisupgradeInfo info;
            Kingdom kingdom;
            Block block = (Block)iter.next();
            if (block == null || block.getType() == Material.AIR) continue;
            SimpleLocation loc = new SimpleLocation(block.getLocation());
            SimpleChunkLocation chunk = loc.toSimpleChunk();
            Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
            if (land.getOwner() == null || (kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner())) == null || !(info = kingdom.getMisupgradeInfo()).isAnticreeper()) continue;
            iter.remove();
        }
    }

    @EventHandler
    public void onExplodeWhileBombshard(EntityExplodeEvent e) {
        if (e.getEntity().getType() != EntityType.PRIMED_TNT) {
            return;
        }
        Iterator iter = e.blockList().iterator();
        while (iter.hasNext()) {
            MisupgradeInfo info;
            Kingdom kingdom;
            Block block = (Block)iter.next();
            if (block == null || block.getType() == Material.AIR) continue;
            SimpleLocation loc = new SimpleLocation(block.getLocation());
            SimpleChunkLocation chunk = loc.toSimpleChunk();
            Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
            if (land.getOwner() == null || (kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner())) == null || !(info = kingdom.getMisupgradeInfo()).isBombshards() || !Kingdoms.config.misc_upgrades_bombshards_enabled) continue;
            iter.remove();
        }
    }

    @EventHandler
    public void onExplodeDamageWhileBombshard(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        if (ExternalManager.isCitizen(e.getEntity())) {
            return;
        }
        if (e.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(e.getEntity().getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land == null) {
            return;
        }
        if (land.getOwner() == null) {
            return;
        }
        KingdomPlayer target = GameManagement.getPlayerManager().getSession((Player)e.getEntity());
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        if (!kingdom.getMisupgradeInfo().isBombshards() || !Kingdoms.config.misc_upgrades_bombshards_enabled) {
            return;
        }
        if (kingdom.equals(target.getKingdom())) {
            e.setDamage(0.0);
            e.setCancelled(true);
            return;
        }
        if (kingdom.isAllianceWith(target.getKingdom())) {
            e.setDamage(0.0);
            e.setCancelled(true);
            return;
        }
        e.setDamage(e.getDamage() + 5.0);
    }

    @Override
    public void onDisable() {
    }
}

