/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.generallib.database.Database;
import org.generallib.database.file.DatabaseFile;
import org.generallib.database.mysql.DatabaseMysql;
import org.generallib.database.tasks.DatabaseTransferTask;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.LandClaimEvent;
import org.kingdoms.events.LandLoadEvent;
import org.kingdoms.events.PlayerChangeChunkEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.ConquestManager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.OldUnusedLandManager;
import org.kingdoms.manager.gui.GUIManagement;

public class LandManager
extends Manager
implements Listener {
    public static Map<SimpleChunkLocation, Land> landList = new ConcurrentHashMap<SimpleChunkLocation, Land>();
    private static final File LANDFOLDER = new File(Kingdoms.getInstance().getDataFolder(), Kingdoms.config.landTable);
    private static Database<Land> db;
    private final Thread autoSaveThread;
    public static final String SAFEZONE = "SafeZone";
    public static final String WARZONE = "WarZone";

    LandManager(Plugin plugin) throws IOException {
        block12: {
            super(plugin);
            if (Kingdoms.config.mysqlEnabled) {
                try {
                    try {
                        if (Kingdoms.config.grabLandFromFileDB) {
                            Kingdoms.config.grabLandFromFileDB = false;
                            ArrayList<DatabaseTransferTask.TransferPair> pairs = new ArrayList<DatabaseTransferTask.TransferPair>();
                            pairs.add(new DatabaseTransferTask.TransferPair(this.createFileDB(), this.createMysqlDB()));
                            new Thread((Runnable)new DatabaseTransferTask((Plugin)Kingdoms.getInstance(), pairs)).start();
                        }
                        db = this.createMysqlDB();
                        Kingdoms.logInfo((String)"Mysql Connection Success!");
                        Kingdoms.logInfo((String)("Using " + Kingdoms.config.dbAddress + " with user " + Kingdoms.config.dbUser));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException | NamingException e) {
                        Kingdoms.logInfo((String)"Mysql Connection Failed!");
                        Kingdoms.logInfo((String)("Using " + Kingdoms.config.dbAddress + " with user " + Kingdoms.config.dbUser));
                        Kingdoms.logInfo((String)e.getMessage());
                        Kingdoms.config.grabLandFromFileDB = true;
                        if (db == null) {
                            db = this.createFileDB();
                            Kingdoms.logInfo((String)"Using file database for Land data");
                        }
                        landList.clear();
                        this.initLands();
                        this.autoSaveThread = new Thread(new autoSaveTask());
                        this.autoSaveThread.setPriority(1);
                        this.autoSaveThread.start();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (db == null) {
                        db = this.createFileDB();
                        Kingdoms.logInfo((String)"Using file database for Land data");
                    }
                    landList.clear();
                    this.initLands();
                    this.autoSaveThread = new Thread(new autoSaveTask());
                    this.autoSaveThread.setPriority(1);
                    this.autoSaveThread.start();
                    throw throwable;
                }
                if (db == null) {
                    db = this.createFileDB();
                    Kingdoms.logInfo((String)"Using file database for Land data");
                }
                landList.clear();
                this.initLands();
                this.autoSaveThread = new Thread(new autoSaveTask());
                this.autoSaveThread.setPriority(1);
                this.autoSaveThread.start();
            } else {
                db = this.createFileDB();
                Kingdoms.logInfo((String)"Using file database for Land data");
                landList.clear();
                this.initLands();
                this.autoSaveThread = new Thread(new autoSaveTask());
                this.autoSaveThread.setPriority(1);
                this.autoSaveThread.start();
            }
        }
        if (Kingdoms.config.rpToGivePerHourEachLand > 0) {
            Bukkit.getScheduler().scheduleAsyncRepeatingTask(plugin, (Runnable)new LandLogisticsTask(this), 0L, 72000L);
        }
    }

    public DatabaseFile<Land> createFileDB() {
        return new DatabaseFile(LANDFOLDER, Land.class);
    }

    public DatabaseMysql<Land> createMysqlDB() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NamingException {
        return new DatabaseMysql(Kingdoms.config.dbAddress, Kingdoms.config.dbName, Kingdoms.config.landTable, Kingdoms.config.dbUser, Kingdoms.config.dbPassword, Land.class);
    }

    public DatabaseTransferTask.TransferPair<Land> getTransferPair(Database<Land> from) {
        return new DatabaseTransferTask.TransferPair(from, db);
    }

    private void initLands() throws IOException {
        Set keys = db.getKeys();
        if (keys.contains("LandData") && keys.size() == 1) {
            OldUnusedLandManager oldUnusedLandManager = new OldUnusedLandManager(this.plugin, this);
        }
        for (String landName : keys) {
            if (landName.equals("LandData")) continue;
            Kingdoms.logColor((String)("Loading land: " + landName));
            try {
                SimpleChunkLocation chunk = SimpleChunkLocation.chunkStrToLoc(landName);
                Land land = (Land)db.load(landName, null);
                if (land.getOwner() != null) {
                    Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
                    if (kingdom == null && !land.getOwner().equals(SAFEZONE) && !land.getOwner().equals(WARZONE)) {
                        Kingdoms.logInfo((String)("Land data [" + landName + "] is corrupted! ignoring..."));
                        Kingdoms.logInfo((String)("The land owner is [" + land.getOwner() + "] but no such kingdom with the name exists"));
                    } else {
                        Kingdoms.logDebug((String)("Before: " + kingdom.getLand()));
                        Kingdoms.logDebug((String)("After: " + kingdom.getLand()));
                    }
                }
                if (!landList.containsKey(chunk)) {
                    landList.put(chunk, land);
                }
                Kingdoms.queuePostLoadEvent((Event)new LandLoadEvent(land));
            }
            catch (Exception e) {
                Kingdoms.logInfo((String)("Land data [" + landName + "] is corrupted! ignoring..."));
                if (!Kingdoms.config.isDebugging) continue;
                e.printStackTrace();
            }
        }
        db.save("LandData", null);
        Kingdoms.logInfo((String)("Total of [" + this.getAllLandLoc().size() + "] lands are initialized"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveAll() throws InterruptedException {
        Kingdoms.logDebug((String)"Beginning Land Save");
        HashSet<String> saved = new HashSet<String>();
        Map<SimpleChunkLocation, Land> map = landList;
        synchronized (map) {
            for (Map.Entry<SimpleChunkLocation, Land> entry : landList.entrySet()) {
                String landName = entry.getKey().toString();
                Kingdoms.logColor((String)("Saving land: " + landName));
                Land land = entry.getValue();
                if (land.getOwner() == null && land.getTurrets().size() <= 0 && land.getStructure() == null) {
                    db.save(landName, null);
                    landList.remove(entry.getKey());
                    continue;
                }
                try {
                    db.save(landName, (Object)land);
                    saved.add(landName);
                }
                catch (Exception e) {
                    Bukkit.getLogger().severe("[Kingdoms] Failed autosave for a piece of land!");
                }
            }
        }
        Kingdoms.logDebug((String)"Finished.");
    }

    public Set<SimpleChunkLocation> getAllLandLoc() {
        return landList.keySet();
    }

    public Land getOrLoadLand(SimpleChunkLocation loc) {
        if (loc == null) {
            return null;
        }
        Kingdoms.logColor((String)("Fetching info for land: " + loc.toString()));
        Land land = landList.get(loc);
        if (land == null) {
            land = new Land(loc);
            if (!landList.containsKey(loc)) {
                landList.put(loc, land);
            }
        }
        return land;
    }

    public void claimSafeZone(SimpleChunkLocation chunk) {
        Land land = this.getOrLoadLand(chunk);
        land.setOwner(SAFEZONE);
        land.setClaimTime(new Date().getTime());
        if (GameManagement.getDynmapManager() != null) {
            GameManagement.getDynmapManager().updateClaimMarker(chunk);
        }
    }

    public void claimWarZone(SimpleChunkLocation chunk) {
        Land land = this.getOrLoadLand(chunk);
        land.setOwner(WARZONE);
        land.setClaimTime(new Date().getTime());
        if (GameManagement.getDynmapManager() != null) {
            GameManagement.getDynmapManager().updateClaimMarker(chunk);
        }
    }

    public void claimLand(SimpleChunkLocation chunk, Kingdom kingdom) {
        Land land = this.getOrLoadLand(chunk);
        LandClaimEvent lce = new LandClaimEvent(land, kingdom);
        Bukkit.getPluginManager().callEvent((Event)lce);
        if (lce.isCancelled()) {
            return;
        }
        land.setClaimTime(new Date().getTime());
        land.setOwner(kingdom.getKingdomName());
        kingdom.setMight(kingdom.getMight() + 5);
        kingdom.setLand(kingdom.getLand() + 1);
        if (GameManagement.getDynmapManager() != null) {
            GameManagement.getDynmapManager().updateClaimMarker(chunk);
        }
    }

    public void unclaimLand(SimpleChunkLocation chunk, Kingdom kingdom) {
        final Land land = this.getOrLoadLand(chunk);
        if (land == null) {
            return;
        }
        LandClaimEvent lce = new LandClaimEvent(land, kingdom);
        Bukkit.getPluginManager().callEvent((Event)lce);
        if (lce.isCancelled()) {
            return;
        }
        land.setClaimTime(0L);
        land.setOwner(null);
        if (land.getStructure() != null) {
            new BukkitRunnable(){

                public void run() {
                    land.getStructure().getLoc().toLocation().getBlock().setType(Material.AIR);
                    land.setStructure(null);
                }
            }.runTask((Plugin)this.plugin);
        }
        if (kingdom != null) {
            kingdom.setMight(kingdom.getMight() - 5);
            kingdom.setLand(kingdom.getLand() - 1);
        }
        if (GameManagement.getDynmapManager() != null) {
            GameManagement.getDynmapManager().updateClaimMarker(chunk);
        }
    }

    public synchronized void unclaimAllExistingLand() {
        for (OfflineKingdom kingdom : GameManagement.getKingdomManager().getKingdomList().values()) {
            this.unclaimAllLand(GameManagement.getKingdomManager().getOrLoadKingdom(kingdom.getKingdomName()));
        }
    }

    public synchronized int unclaimAllLand(Kingdom kingdom) {
        int count = 0;
        for (SimpleChunkLocation chunk : this.getAllLandLoc()) {
            final Land land = this.getOrLoadLand(chunk);
            if (land.getOwner() == null || !land.getOwner().equals(kingdom.getKingdomName())) continue;
            LandClaimEvent lce = new LandClaimEvent(land, kingdom);
            Bukkit.getPluginManager().callEvent((Event)lce);
            if (lce.isCancelled()) continue;
            land.setClaimTime(0L);
            land.setOwner(null);
            if (land.getStructure() != null) {
                new BukkitRunnable(){

                    public void run() {
                        land.getStructure().getLoc().toLocation().getBlock().setType(Material.AIR);
                        land.setStructure(null);
                    }
                }.runTask((Plugin)this.plugin);
            }
            ++count;
            if (GameManagement.getDynmapManager() == null) continue;
            GameManagement.getDynmapManager().addMarkerUpdateQueue(chunk);
        }
        if (kingdom != null) {
            kingdom.setMight(0);
            kingdom.setLand(0);
        }
        return count;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onJoin(PlayerJoinEvent e) {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkChange(final PlayerChangeChunkEvent e) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.isKMapOn()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Kingdoms.getInstance(), new Runnable(){

                @Override
                public void run() {
                    GUIManagement.getMapManager().displayMap(e.getPlayer());
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInteractOnOtherKingdom(PlayerInteractEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getClickedBlock() == null) {
            return;
        }
        if (e.getPlayer().isSneaking() && (e.getClickedBlock().getType() != Material.DROPPER && e.getClickedBlock().getType() != Material.DISPENSER && e.getClickedBlock().getType() != Material.HOPPER && e.getClickedBlock().getType() != Material.TRAPPED_CHEST && e.getClickedBlock().getType() != Material.CHEST && e.getClickedBlock().getType() != Material.FURNACE && e.getClickedBlock().getType() != Material.WOOD_DOOR && e.getClickedBlock().getType() != Material.IRON_DOOR && e.getClickedBlock().getType() != Material.ACACIA_DOOR && e.getClickedBlock().getType() != Material.BIRCH_DOOR && e.getClickedBlock().getType() != Material.DARK_OAK_DOOR && e.getClickedBlock().getType() != Material.JUNGLE_DOOR && e.getClickedBlock().getType() != Material.SPRUCE_DOOR && e.getClickedBlock().getType() != Material.TRAP_DOOR && e.getClickedBlock().getType() != Material.LEVER && e.getClickedBlock().getType() != Material.WOOD_BUTTON && e.getClickedBlock().getType() != Material.STONE_BUTTON && e.getClickedBlock().getType() != Material.ANVIL && e.getClickedBlock().getType() != Material.WORKBENCH && e.getClickedBlock().getType() != Material.ENCHANTMENT_TABLE && e.getClickedBlock().getType() != Material.BURNING_FURNACE || Kingdoms.config.canOpenChestInRegions)) {
            if (e.getPlayer().getItemInHand() == null) {
                return;
            }
            if (e.getPlayer().getItemInHand().getType() != Material.ARMOR_STAND && e.getPlayer().getItemInHand().getType() != Material.ITEM_FRAME) {
                return;
            }
        }
        if (e.getPlayer().getItemInHand() != null && (e.getClickedBlock().getType() != Material.DROPPER && e.getClickedBlock().getType() != Material.DISPENSER && e.getClickedBlock().getType() != Material.HOPPER && e.getClickedBlock().getType() != Material.TRAPPED_CHEST && e.getClickedBlock().getType() != Material.CHEST && e.getClickedBlock().getType() != Material.FURNACE && e.getClickedBlock().getType() != Material.WOOD_DOOR && e.getClickedBlock().getType() != Material.IRON_DOOR && e.getClickedBlock().getType() != Material.ACACIA_DOOR && e.getClickedBlock().getType() != Material.BIRCH_DOOR && e.getClickedBlock().getType() != Material.DARK_OAK_DOOR && e.getClickedBlock().getType() != Material.JUNGLE_DOOR && e.getClickedBlock().getType() != Material.SPRUCE_DOOR && e.getClickedBlock().getType() != Material.TRAP_DOOR && e.getClickedBlock().getType() != Material.LEVER && e.getClickedBlock().getType() != Material.WOOD_BUTTON && e.getClickedBlock().getType() != Material.STONE_BUTTON && e.getClickedBlock().getType() != Material.ANVIL && e.getClickedBlock().getType() != Material.WORKBENCH && e.getClickedBlock().getType() != Material.ENCHANTMENT_TABLE && e.getClickedBlock().getType() != Material.BURNING_FURNACE || Kingdoms.config.canOpenChestInRegions)) {
            for (String mat : Kingdoms.config.allowedToUseInOtherKingdomLand) {
                if (!mat.toLowerCase().equals(e.getPlayer().getItemInHand().getType().toString().toLowerCase())) continue;
                return;
            }
        }
        Location bukkitLoc = e.getClickedBlock().getLocation();
        SimpleLocation loc = new SimpleLocation(bukkitLoc);
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.isAdminMode()) {
            return;
        }
        if (land.getOwner().equals(WARZONE) && Kingdoms.config.warzoneenabledtouch.contains(e.getClickedBlock().getType().toString())) {
            return;
        }
        if (land.getOwner().equals(SAFEZONE) && Kingdoms.config.safezoneenabledtouch.contains(e.getClickedBlock().getType().toString())) {
            return;
        }
        if (kp.getKingdom() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Break_In_Other_Land));
            e.setCancelled(true);
        } else {
            Kingdom kingdom = kp.getKingdom();
            String kingdomName = kingdom.getKingdomName();
            if (!kingdomName.equals(land.getOwner())) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Break_In_Other_Land));
                e.setCancelled(true);
                return;
            }
            if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getBuildInNexus())) {
                e.setCancelled(true);
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low_NexusBuild).replaceAll("%rank%", kingdom.getPermissionsInfo().getBuildInNexus().toString()));
                return;
            }
        }
    }

    @EventHandler
    public void onSpecialLandExplode(EntityExplodeEvent e) {
        Iterator iter = e.blockList().iterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            if (block == null || block.getType() == Material.AIR) continue;
            SimpleLocation loc = new SimpleLocation(block.getLocation());
            SimpleChunkLocation chunk = loc.toSimpleChunk();
            Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
            if (land.getOwner() == null) continue;
            if (land.getOwner().equals(WARZONE)) {
                iter.remove();
                continue;
            }
            if (!land.getOwner().equals(SAFEZONE)) continue;
            iter.remove();
        }
    }

    @EventHandler
    public void onBucketEmptyOnUnoccupiedLand(PlayerBucketEmptyEvent event) {
        if (!Kingdoms.config.worlds.contains(event.getBlockClicked().getWorld().getName())) {
            return;
        }
        if (!Kingdoms.config.cannotBuildInNonLand.contains(event.getBlockClicked().getWorld().getName())) {
            return;
        }
        Location bukkitLoc = event.getBlockClicked().getRelative(event.getBlockFace()).getLocation();
        SimpleLocation loc = new SimpleLocation(bukkitLoc);
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(event.getPlayer());
        if (land.getOwner() == null && !kp.isAdminMode()) {
            event.setCancelled(true);
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Build_In_Unoccupied_Land));
        }
    }

    @EventHandler
    public void onBucketFillOnUnoccupiedLand(PlayerBucketFillEvent event) {
        if (!Kingdoms.config.worlds.contains(event.getBlockClicked().getWorld().getName())) {
            return;
        }
        if (!Kingdoms.config.cannotBuildInNonLand.contains(event.getBlockClicked().getWorld().getName())) {
            return;
        }
        Location bukkitLoc = event.getBlockClicked().getRelative(event.getBlockFace()).getLocation();
        SimpleLocation loc = new SimpleLocation(bukkitLoc);
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(event.getPlayer());
        if (land.getOwner() == null && !kp.isAdminMode()) {
            event.setCancelled(true);
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Build_In_Unoccupied_Land));
        }
    }

    @EventHandler
    public void onBreakBlockUnoccupied(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!Kingdoms.config.worlds.contains(e.getBlock().getWorld().getName())) {
            return;
        }
        if (e.getBlock() == null) {
            return;
        }
        if (!Kingdoms.config.cannotBuildInNonLand.contains(e.getBlock().getWorld().getName())) {
            return;
        }
        Kingdoms.getManagers();
        if (GameManagement.getConquestManager() != null && e.getBlock().getWorld().equals(ConquestManager.world)) {
            return;
        }
        Location bukkitLoc = e.getBlock().getLocation();
        SimpleLocation loc = new SimpleLocation(bukkitLoc);
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (land.getOwner() == null && !kp.isAdminMode()) {
            e.setCancelled(true);
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Build_In_Unoccupied_Land));
        }
    }

    @EventHandler
    public void onBuildBlockUnoccupied(BlockPlaceEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!Kingdoms.config.worlds.contains(e.getBlock().getWorld().getName())) {
            return;
        }
        if (e.getBlock() == null) {
            return;
        }
        if (!Kingdoms.config.cannotBuildInNonLand.contains(e.getBlock().getWorld().getName())) {
            return;
        }
        Kingdoms.getManagers();
        if (GameManagement.getConquestManager() != null && e.getBlock().getWorld().equals(ConquestManager.world)) {
            return;
        }
        Location bukkitLoc = e.getBlock().getLocation();
        SimpleLocation loc = new SimpleLocation(bukkitLoc);
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (land.getOwner() == null && !kp.isAdminMode()) {
            e.setCancelled(true);
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Build_In_Unoccupied_Land));
        }
    }

    @EventHandler
    public void onBreakBlockOnOtherKingdom(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!Kingdoms.config.worlds.contains(e.getBlock().getWorld().getName())) {
            return;
        }
        if (e.getBlock() == null) {
            return;
        }
        Location bukkitLoc = e.getBlock().getLocation();
        SimpleLocation loc = new SimpleLocation(bukkitLoc);
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.isAdminMode()) {
            return;
        }
        if (kp.getKingdom() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Break_In_Other_Land));
            e.setCancelled(true);
        } else {
            Kingdom kingdom = kp.getKingdom();
            String kingdomName = kingdom.getKingdomName();
            if (!kingdomName.equals(land.getOwner())) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Break_In_Other_Land));
                e.setCancelled(true);
                return;
            }
            if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getBuildInNexus())) {
                e.setCancelled(true);
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low_NexusBuild).replaceAll("%rank%", kingdom.getPermissionsInfo().getBuildInNexus().toString()));
                return;
            }
        }
    }

    @EventHandler
    public void onBucketEmptyOnOtherKingdom(PlayerBucketEmptyEvent event) {
        Location bukkitLoc = event.getBlockClicked().getLocation();
        SimpleLocation loc = new SimpleLocation(bukkitLoc);
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = this.getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(event.getPlayer());
        if (kp.isAdminMode()) {
            return;
        }
        if (kp.getKingdom() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Break_In_Other_Land));
            event.setCancelled(true);
        } else if (!land.getOwner().equals(kp.getKingdom().getKingdomName())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Break_In_Other_Land));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBucketFillOnOtherKingdom(PlayerBucketFillEvent event) {
        Location bukkitLoc = event.getBlockClicked().getLocation();
        SimpleLocation loc = new SimpleLocation(bukkitLoc);
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = this.getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(event.getPlayer());
        if (kp.isAdminMode()) {
            return;
        }
        if (kp.getKingdom() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Break_In_Other_Land));
            event.setCancelled(true);
        } else if (!land.getOwner().equals(kp.getKingdom().getKingdomName())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Break_In_Other_Land));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlaceOnOtherKingdom(BlockPlaceEvent e) {
        if (e.getBlock() == null) {
            return;
        }
        Location bukkitLoc = e.getBlock().getLocation();
        SimpleLocation loc = new SimpleLocation(bukkitLoc);
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.isAdminMode()) {
            return;
        }
        if (kp.getKingdom() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Break_In_Other_Land));
            e.setCancelled(true);
        } else {
            Kingdom kingdom = kp.getKingdom();
            String kingdomName = kingdom.getKingdomName();
            if (!kingdomName.equals(land.getOwner())) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Break_In_Other_Land));
                e.setCancelled(true);
                return;
            }
            if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getBuildInNexus())) {
                e.setCancelled(true);
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low_NexusBuild).replaceAll("%rank%", kingdom.getPermissionsInfo().getBuildInNexus().toString()));
                return;
            }
        }
    }

    @EventHandler
    public void onFlowIntoKingdomLand(BlockFromToEvent e) {
        if (!Kingdoms.config.disableFlowIntoLand) {
            return;
        }
        SimpleLocation locFrom = new SimpleLocation(e.getBlock().getLocation());
        SimpleLocation locTo = new SimpleLocation(e.getToBlock().getLocation());
        Land landFrom = GameManagement.getLandManager().getOrLoadLand(locFrom.toSimpleChunk());
        Land landTo = GameManagement.getLandManager().getOrLoadLand(locTo.toSimpleChunk());
        if (landFrom.getOwner() == null) {
            if (landTo.getOwner() != null) {
                e.setCancelled(true);
            }
        } else if (!landFrom.getOwner().equals(landTo.getOwner())) {
            e.setCancelled(true);
        }
    }

    @Override
    public void onDisable() {
        this.autoSaveThread.interrupt();
        try {
            this.autoSaveThread.join();
        }
        catch (InterruptedException e1) {
            Kingdoms.logInfo((String)"Still saving land data!");
        }
        Kingdoms.logInfo((String)("Saving [" + landList.size() + "] lands to db..."));
        try {
            this.saveAll();
            Kingdoms.logInfo((String)"Done!");
        }
        catch (Exception e) {
            Kingdoms.logInfo((String)"SQL connection failed! Saving to file DB");
            db = this.createFileDB();
            try {
                this.saveAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Kingdoms.config.grabLandFromFileDB = true;
        }
        landList.clear();
    }

    private class LandLogisticsTask
    implements Runnable {
        LandManager manager;

        public LandLogisticsTask(LandManager manager) {
            this.manager = manager;
        }

        @Override
        public void run() {
            Kingdoms.logDebug((String)"LandLogistics Loop Initiate");
            for (Land land : landList.values()) {
                if (land.getOwner() == null) continue;
                Kingdoms.getManagers();
                Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
                kingdom.setResourcepoints(kingdom.getResourcepoints() + Kingdoms.config.rpToGivePerHourEachLand);
            }
        }
    }

    private class autoSaveTask
    implements Runnable {
        private autoSaveTask() {
        }

        @Override
        public void run() {
            while (LandManager.this.plugin.isEnabled() && !Thread.interrupted()) {
                try {
                    Thread.sleep(100000L);
                }
                catch (InterruptedException e) {
                    Kingdoms.logInfo((String)"Land auto save is interrupted.");
                    return;
                }
                try {
                    LandManager.this.saveAll();
                }
                catch (InterruptedException e) {
                    Kingdoms.logInfo((String)"Land auto save is interrupted.");
                    return;
                }
            }
        }
    }
}

