/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.naming.NamingException;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.generallib.database.Database;
import org.generallib.database.file.DatabaseFile;
import org.generallib.database.mysql.DatabaseMysql;
import org.generallib.database.tasks.DatabaseTransferTask;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.KingdomCooldown;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.events.KingdomCreateEvent;
import org.kingdoms.events.KingdomDeleteEvent;
import org.kingdoms.events.KingdomLoadEvent;
import org.kingdoms.events.KingdomMemberJoinEvent;
import org.kingdoms.events.KingdomMemberLeaveEvent;
import org.kingdoms.events.KingdomPlayerLoginEvent;
import org.kingdoms.events.KingdomPlayerLogoffEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.PlayerManager;

public class KingdomManager
extends Manager
implements Listener {
    public static Map<String, OfflineKingdom> kingdomList = new ConcurrentSkipListMap<String, OfflineKingdom>(String.CASE_INSENSITIVE_ORDER);
    private static Database<OfflineKingdom> db;
    private final Thread autoSaveThread;
    boolean isProcessing = false;

    KingdomManager(Plugin plugin) {
        super(plugin);
        if (Kingdoms.config.mysqlEnabled) {
            try {
                try {
                    if (Kingdoms.config.grabKingdomsFromFileDB) {
                        Kingdoms.config.grabKingdomsFromFileDB = false;
                        ArrayList<DatabaseTransferTask.TransferPair> pairs = new ArrayList<DatabaseTransferTask.TransferPair>();
                        pairs.add(new DatabaseTransferTask.TransferPair(this.createFileDB(), this.createMysqlDB()));
                        new Thread((Runnable)new DatabaseTransferTask((Plugin)Kingdoms.getInstance(), pairs)).start();
                    }
                    db = this.createMysqlDB();
                    Kingdoms.logInfo((String)"Mysql Connection Success!");
                    Kingdoms.logInfo((String)("Using " + Kingdoms.config.dbAddress + " with user " + Kingdoms.config.dbUser));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException | NamingException e) {
                    Kingdoms.logInfo((String)"Mysql Connection Failed!");
                    Kingdoms.logInfo((String)("Using " + Kingdoms.config.dbAddress + " with user " + Kingdoms.config.dbUser));
                    Kingdoms.logInfo((String)e.getMessage());
                    Kingdoms.config.grabKingdomsFromFileDB = true;
                    if (db == null) {
                        db = this.createFileDB();
                        Kingdoms.logInfo((String)"Using file database for Kingdom data");
                    }
                    kingdomList.clear();
                    this.autoSaveThread = new Thread(new AutoSaveTask());
                    this.autoSaveThread.setPriority(1);
                    this.autoSaveThread.start();
                }
            }
            finally {
                if (db == null) {
                    db = this.createFileDB();
                    Kingdoms.logInfo((String)"Using file database for Kingdom data");
                }
                kingdomList.clear();
                this.autoSaveThread = new Thread(new AutoSaveTask());
                this.autoSaveThread.setPriority(1);
                this.autoSaveThread.start();
            }
        } else {
            db = this.createFileDB();
            Kingdoms.logInfo((String)"Using file database for Kingdom data");
            kingdomList.clear();
            this.autoSaveThread = new Thread(new AutoSaveTask());
            this.autoSaveThread.setPriority(1);
            this.autoSaveThread.start();
        }
    }

    public DatabaseFile<OfflineKingdom> createFileDB() {
        return new DatabaseFile(new File(this.plugin.getDataFolder(), Kingdoms.config.kingdomTable), Kingdom.class);
    }

    public DatabaseMysql<OfflineKingdom> createMysqlDB() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NamingException {
        return new DatabaseMysql(Kingdoms.config.dbAddress, Kingdoms.config.dbName, Kingdoms.config.kingdomTable, Kingdoms.config.dbUser, Kingdoms.config.dbPassword, Kingdom.class);
    }

    public DatabaseTransferTask.TransferPair<OfflineKingdom> getTransferPair(Database<OfflineKingdom> from) {
        return new DatabaseTransferTask.TransferPair(from, db);
    }

    public void debugDeleteKingdom(String name) {
        db.save(name, null);
        if (kingdomList.containsKey(name)) {
            kingdomList.remove(name);
        }
        Kingdoms.getManagers();
        GameManagement.getPlayerManager();
        for (UUID uuid : PlayerManager.userList.keySet()) {
            Kingdoms.getManagers();
            GameManagement.getPlayerManager();
            OfflineKingdomPlayer player = PlayerManager.userList.get(uuid);
            if (player.getKingdomName() == null || !player.getKingdomName().equals(name)) continue;
            player.setKingdomName(null);
            Kingdoms.getManagers();
            GameManagement.getPlayerManager();
            PlayerManager.userList.remove(uuid);
            Kingdoms.getManagers();
            GameManagement.getPlayerManager();
            PlayerManager.userList.put(uuid, player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveAll() {
        Map<String, OfflineKingdom> map = kingdomList;
        synchronized (map) {
            for (Map.Entry<String, OfflineKingdom> entry : kingdomList.entrySet()) {
                String kname = entry.getKey();
                OfflineKingdom kingdom = entry.getValue();
                Kingdoms.logColor((String)("Saving kingdom, " + kname));
                if (KingdomCooldown.isInCooldown(kname, "attackcd")) {
                    kingdom.timeLeftToNextInvasion = KingdomCooldown.getTimeLeft(kname, "attackcd");
                }
                if (kingdom.getKing() == null) {
                    db.save(kname, null);
                    continue;
                }
                try {
                    db.save(kname, (Object)kingdom);
                }
                catch (Exception e) {
                    Bukkit.getLogger().severe("[Kingdoms] Failed autosave for a kingdom!");
                }
            }
        }
    }

    public Kingdom getOrLoadKingdom(String kingdomName) {
        if (kingdomName == null) {
            return null;
        }
        Kingdoms.logColor((String)("Fetching info for kingdom, " + kingdomName));
        Kingdom kingdom = null;
        if (kingdomList.containsKey(kingdomName)) {
            OfflineKingdom temp = kingdomList.get(kingdomName);
            if (temp instanceof Kingdom) {
                kingdom = (Kingdom)temp;
            }
            if (temp != null && temp.getKing() == null) {
                db.save(kingdomName, null);
                return null;
            }
        }
        if (kingdom == null) {
            kingdom = this.loadKingdom(kingdomName);
        }
        this.checkUpgrades(kingdom);
        return kingdom;
    }

    private Kingdom loadKingdom(String kingdomName) {
        Kingdom kingdom = null;
        Kingdoms.logColor((String)("Loading kingdom, " + kingdomName));
        if (kingdomList.containsKey(kingdomName)) {
            db.save(kingdomName, (Object)kingdomList.remove(kingdomName));
        }
        if ((kingdom = (Kingdom)db.load(kingdomName, null)) != null) {
            if (!Kingdoms.config.pacifistEnabled) {
                kingdom.setNeutral(false);
            }
            if (kingdom.timeLeftToNextInvasion != 0) {
                KingdomCooldown cooldown = new KingdomCooldown(kingdomName, "attackcd", kingdom.timeLeftToNextInvasion);
                cooldown.start();
                kingdom.timeLeftToNextInvasion = 0;
            }
            kingdomList.put(kingdomName, kingdom);
            this.plugin.getServer().getPluginManager().callEvent((Event)new KingdomLoadEvent(kingdom));
        }
        return kingdom;
    }

    public void checkUpgrades(final Kingdom kingdom) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (kingdom == null) {
                    return;
                }
                if (kingdom.getTurretUpgrades().isSimplifiedModel()) {
                    kingdom.getTurretUpgrades().setSimplifiedModel(Kingdoms.config.turretupgrade_simplified_enabled);
                }
                if (kingdom.getTurretUpgrades().isFlurry()) {
                    kingdom.getTurretUpgrades().setFlurry(Kingdoms.config.turretupgrade_flurry_enabled);
                }
                if (kingdom.getTurretUpgrades().isConcentratedBlast()) {
                    kingdom.getTurretUpgrades().setConcentratedBlast(Kingdoms.config.turretupgrade_concentrated_enabled);
                }
                if (kingdom.getTurretUpgrades().isVirulentPlague()) {
                    kingdom.getTurretUpgrades().setVirulentPlague(Kingdoms.config.turretupgrade_virulent_enabled);
                }
                if (kingdom.getTurretUpgrades().isImprovedHeal()) {
                    kingdom.getTurretUpgrades().setImprovedHeal(Kingdoms.config.turretupgrade_improvedhealing_enabled);
                }
                if (kingdom.getTurretUpgrades().isVoodoo()) {
                    kingdom.getTurretUpgrades().setVoodoo(Kingdoms.config.turretupgrade_voodoo_enabled);
                }
                if (kingdom.getTurretUpgrades().isFinalService()) {
                    kingdom.getTurretUpgrades().setFinalService(Kingdoms.config.turretupgrade_finalservice_enabled);
                }
                if (kingdom.getTurretUpgrades().isHellstorm()) {
                    kingdom.getTurretUpgrades().setHellstorm(Kingdoms.config.turretupgrade_hellstorm_enabled);
                }
                if (kingdom.getTurretUpgrades().isUnrelentingGaze()) {
                    kingdom.getTurretUpgrades().setUnrelentingGaze(Kingdoms.config.turretupgrade_unrelenting_enabled);
                }
                if (kingdom.getMisupgradeInfo().isAnticreeper()) {
                    kingdom.getMisupgradeInfo().setAnticreeper(Kingdoms.config.misc_upgrades_anticreeper_enabled);
                }
                if (kingdom.getMisupgradeInfo().isAntitrample()) {
                    kingdom.getMisupgradeInfo().setAntitrample(Kingdoms.config.misc_upgrades_antitrample_enabled);
                }
                if (kingdom.getMisupgradeInfo().isBombshards()) {
                    kingdom.getMisupgradeInfo().setBombshards(Kingdoms.config.misc_upgrades_bombshards_enabled);
                }
                if (kingdom.getMisupgradeInfo().isGlory()) {
                    kingdom.getMisupgradeInfo().setGlory(Kingdoms.config.misc_upgrades_glory_enabled);
                }
                if (kingdom.getMisupgradeInfo().isNexusguard()) {
                    kingdom.getMisupgradeInfo().setNexusguard(Kingdoms.config.misc_upgrades_nexusguard_enabled);
                }
                if (kingdom.getMisupgradeInfo().isPsioniccore()) {
                    kingdom.getMisupgradeInfo().setPsioniccore(Kingdoms.config.misc_upgrades_psioniccore_enabled);
                }
                if (kingdom.getPowerUp().getDmgboost() > Kingdoms.config.nexusupgrades_dmg_boost_max) {
                    kingdom.getPowerUp().setDmgboost(Kingdoms.config.nexusupgrades_dmg_boost_max);
                }
                if (kingdom.getPowerUp().getDmgreduction() > Kingdoms.config.nexusupgrades_dmg_reduc_max) {
                    kingdom.getPowerUp().setDmgreduction(Kingdoms.config.nexusupgrades_dmg_reduc_max);
                }
                if (kingdom.getPowerUp().getArrowboost() > Kingdoms.config.nexusupgrades_arrow_boost_max) {
                    kingdom.getPowerUp().setArrowboost(Kingdoms.config.nexusupgrades_arrow_boost_max);
                }
                if (kingdom.getPowerUp().getRegenboost() > Kingdoms.config.nexusupgrades_regen_boost_max) {
                    kingdom.getPowerUp().setRegenboost(Kingdoms.config.nexusupgrades_regen_boost_max);
                }
                if (kingdom.getMaxMember() > Kingdoms.config.nexusupgrades_maxmembers_max) {
                    kingdom.setMaxMember(Kingdoms.config.nexusupgrades_maxmembers_max);
                }
                if (kingdom.getChampionInfo().getHealth() > Kingdoms.config.champion_upgrade_health_max) {
                    kingdom.getChampionInfo().setHealth(Kingdoms.config.champion_upgrade_health_max);
                }
                if (kingdom.getChampionInfo().getSpeed() > Kingdoms.config.champion_upgrade_speed_max) {
                    kingdom.getChampionInfo().setSpeed(Kingdoms.config.champion_upgrade_speed_max);
                }
                if (kingdom.getChampionInfo().getResist() > Kingdoms.config.champion_upgrade_resist_max) {
                    kingdom.getChampionInfo().setResist(Kingdoms.config.champion_upgrade_resist_max);
                }
                if (kingdom.getChampionInfo().getWeapon() > Kingdoms.config.champion_upgrade_weapon_max) {
                    kingdom.getChampionInfo().setWeapon(Kingdoms.config.champion_upgrade_weapon_max);
                }
                if (kingdom.getChampionInfo().getDrag() > Kingdoms.config.champion_upgrade_drag_max) {
                    kingdom.getChampionInfo().setDrag(Kingdoms.config.champion_upgrade_drag_max);
                }
                if (kingdom.getChampionInfo().getMock() > Kingdoms.config.champion_upgrade_mock_max) {
                    kingdom.getChampionInfo().setMock(Kingdoms.config.champion_upgrade_mock_max);
                }
                if (kingdom.getChampionInfo().getAqua() > 0 && !Kingdoms.config.champion_upgrade_aqua_enabled || Enchantment.getByName((String)"DEPTH_STRIDER") == null) {
                    kingdom.getChampionInfo().setAqua(0);
                }
                if (kingdom.getChampionInfo().getDuel() > Kingdoms.config.champion_upgrade_duel_max) {
                    kingdom.getChampionInfo().setDuel(Kingdoms.config.champion_upgrade_duel_max);
                }
                if (kingdom.getChampionInfo().getThor() > Kingdoms.config.champion_upgrade_thor_max) {
                    kingdom.getChampionInfo().setThor(Kingdoms.config.champion_upgrade_thor_max);
                }
                if (kingdom.getChampionInfo().getStrength() > Kingdoms.config.champion_upgrade_strength_max) {
                    kingdom.getChampionInfo().setStrength(Kingdoms.config.champion_upgrade_strength_max);
                }
            }
        });
    }

    public boolean hasKingdom(String kingdomName) {
        return db.has(kingdomName);
    }

    public OfflineKingdom getOfflineKingdom(String kingdomName) {
        Kingdoms.logColor((String)("Fetching info for offline kingdom, " + kingdomName));
        OfflineKingdom kingdom = this.loadOfflineKingdom(kingdomName);
        if (kingdom != null && kingdom.getKing() == null) {
            db.save(kingdomName, null);
            return null;
        }
        return kingdom;
    }

    private OfflineKingdom loadOfflineKingdom(String kingdomName) {
        Kingdom kingdom = null;
        Kingdoms.logColor((String)("Loading offline kingdom, " + kingdomName));
        if (kingdomList.containsKey(kingdomName)) {
            return kingdomList.get(kingdomName);
        }
        Kingdoms.logDebug((String)("Loading kingdom:" + kingdomName));
        kingdom = (Kingdom)db.load(kingdomName, null);
        if (kingdom != null) {
            if (!Kingdoms.config.pacifistEnabled) {
                kingdom.setNeutral(false);
            }
            kingdomList.put(kingdomName, kingdom);
        }
        return kingdom;
    }

    public Map<String, Integer> getAllByResourcePointsFromDB() {
        HashMap<String, Integer> points = new HashMap<String, Integer>();
        Set keys = db.getKeys();
        if (keys.isEmpty()) {
            return points;
        }
        for (String key : keys) {
            Kingdom kingdom = this.getOrLoadKingdom(key);
            if (kingdom == null) continue;
            points.put(key, kingdom.getResourcepoints());
        }
        return points;
    }

    public boolean createNewKingdom(String kingdomName, KingdomPlayer king) {
        if (king.isProcessing()) {
            return false;
        }
        king.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Kingdom_Creation_Loading));
        king.setProcessing(true);
        new Thread(new NewKingdomCreateTask(kingdomList, kingdomName, king)).start();
        return true;
    }

    public boolean deleteKingdom(String kingdomName, KingdomPlayer king) {
        if (king.isProcessing()) {
            return false;
        }
        Kingdom kingdom = this.getOrLoadKingdom(kingdomName);
        if (kingdom == null) {
            king.sendMessage("No kingdom found named [" + kingdomName + "].");
            king.setProcessing(false);
            return true;
        }
        king.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Kingdom_Deleting));
        king.setProcessing(true);
        new Thread(new KingdomDeleteTask(kingdomList, kingdom, king)).start();
        return true;
    }

    public boolean deleteKingdom(String kingdomName) {
        Kingdom kingdom = this.getOrLoadKingdom(kingdomName);
        if (kingdom == null) {
            return false;
        }
        new Thread(new KingdomDeleteTask(kingdomList, kingdom)).start();
        return true;
    }

    public Map<String, OfflineKingdom> getKingdomList() {
        return kingdomList;
    }

    public boolean isOnline(String kingdomName) {
        if (!kingdomList.containsKey(kingdomName)) {
            return false;
        }
        return kingdomList.get(kingdomName) instanceof Kingdom;
    }

    @EventHandler
    public void onMemberAttacksKingdomMember(EntityDamageByEntityEvent event) {
        Land att;
        if (!Kingdoms.config.worlds.contains(event.getEntity().getWorld().getName())) {
            return;
        }
        KingdomPlayer attacked = null;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(event.getEntity())) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(event.getDamager())) {
            return;
        }
        if (event.getDamager().getUniqueId().equals(event.getEntity().getUniqueId())) {
            return;
        }
        if (event.getDamager() instanceof Projectile) {
            if (((Projectile)event.getDamager()).getType() == EntityType.ENDER_PEARL) {
                return;
            }
            if (((Projectile)event.getDamager()).getShooter() != null && ((Projectile)event.getDamager()).getShooter() instanceof Player) {
                GameManagement.getApiManager();
                if (ExternalManager.isCitizen((Entity)((Projectile)event.getDamager()).getShooter())) {
                    return;
                }
                attacked = GameManagement.getPlayerManager().getSession((Player)((Projectile)event.getDamager()).getShooter());
            }
        } else if (event.getDamager() instanceof Player) {
            attacked = GameManagement.getPlayerManager().getSession((Player)event.getDamager());
        }
        if (attacked == null) {
            return;
        }
        if (attacked.isAdminMode()) {
            return;
        }
        if (attacked.getKingdom() == null) {
            return;
        }
        KingdomPlayer damaged = GameManagement.getPlayerManager().getSession((Player)event.getEntity());
        if (Kingdoms.config.freePvPInWarZone && (att = GameManagement.getLandManager().getOrLoadLand(damaged.getLoc())).getOwner() != null && att.getOwner().equals("WarZone")) {
            return;
        }
        if (damaged.getKingdom() == null) {
            return;
        }
        if (attacked.getKingdom().equals(damaged.getKingdom())) {
            event.setDamage(0.0);
            attacked.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Attack_Own_Member));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onMemberAttacksAllyMembers(EntityDamageByEntityEvent event) {
        Land att;
        if (!Kingdoms.config.worlds.contains(event.getEntity().getWorld().getName())) {
            return;
        }
        KingdomPlayer attacked = null;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(event.getEntity())) {
            return;
        }
        if (event.getDamager().getUniqueId().equals(event.getEntity().getUniqueId())) {
            return;
        }
        if (event.getDamager() instanceof Projectile) {
            if (((Projectile)event.getDamager()).getShooter() != null && ((Projectile)event.getDamager()).getShooter() instanceof Player) {
                GameManagement.getApiManager();
                if (ExternalManager.isCitizen((Entity)((Projectile)event.getDamager()).getShooter())) {
                    return;
                }
                attacked = GameManagement.getPlayerManager().getSession((Player)((Projectile)event.getDamager()).getShooter());
            }
        } else if (event.getDamager() instanceof Player) {
            GameManagement.getApiManager();
            if (ExternalManager.isCitizen(event.getDamager())) {
                return;
            }
            attacked = GameManagement.getPlayerManager().getSession((Player)event.getDamager());
        }
        if (attacked == null) {
            return;
        }
        if (attacked.isAdminMode()) {
            return;
        }
        if (attacked.getKingdom() == null) {
            return;
        }
        KingdomPlayer damaged = GameManagement.getPlayerManager().getSession((Player)event.getEntity());
        if (Kingdoms.config.freePvPInWarZone && (att = GameManagement.getLandManager().getOrLoadLand(damaged.getLoc())).getOwner() != null && att.getOwner().equals("WarZone")) {
            return;
        }
        if (damaged.getKingdom() == null) {
            return;
        }
        if (attacked.getKingdom().isAllianceWith(damaged.getKingdom())) {
            event.setDamage(0.0);
            attacked.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Attack_Own_Ally));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onKingdomPlayerCommand(PlayerCommandPreprocessEvent e) {
        if (!Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        Kingdoms.logDebug((String)("command: " + e.getMessage()));
        if (e.isCancelled()) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp == null) {
            return;
        }
        Land land = GameManagement.getLandManager().getOrLoadLand(kp.getLoc());
        if (land.getOwner() == null) {
            return;
        }
        Kingdom kingdom = this.getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        if (kp.getKingdom() == null) {
            if (Kingdoms.config.deniedCommandsInOtherKingdom.contains(e.getMessage())) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Kingdom_Command_Denied_Other));
                e.setCancelled(true);
            }
        } else if (kingdom.isEnemyMember(kp) || kp.getKingdom().isEnemyWith(kingdom)) {
            if (Kingdoms.config.deniedCommandsInEnemyKingdom.contains(e.getMessage())) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Kingdom_Command_Denied_Enemy));
                e.setCancelled(true);
            }
        } else if (!kingdom.isMember(kp) && !kingdom.isAllyMember(kp) && Kingdoms.config.deniedCommandsInOtherKingdom.contains(e.getMessage())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Kingdom_Command_Denied_Other));
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onJoin(KingdomPlayerLoginEvent e) {
        Kingdoms.logDebug((String)("onJoin? kp received: " + e.getKp()));
        for (Map.Entry<String, OfflineKingdom> entry : kingdomList.entrySet()) {
            if (!(entry.getValue() instanceof Kingdom)) continue;
            Kingdom value = (Kingdom)entry.getValue();
            value.onKingdomPlayerLogin(e.getKp());
        }
    }

    @EventHandler
    public void onQuit(KingdomPlayerLogoffEvent e) {
        Kingdoms.logDebug((String)"onQuit?");
        for (Map.Entry<String, OfflineKingdom> entry : kingdomList.entrySet()) {
            if (!(entry.getValue() instanceof Kingdom)) continue;
            Kingdom value = (Kingdom)entry.getValue();
            value.onKingdomPlayerLogout(e.getKp());
        }
    }

    @EventHandler
    public void onKingdomDelete(KingdomDeleteEvent e) {
        Kingdoms.logDebug((String)"kdelete event");
        for (Map.Entry<String, OfflineKingdom> entry : kingdomList.entrySet()) {
            if (!(entry.getValue() instanceof Kingdom)) continue;
            Kingdom value = (Kingdom)entry.getValue();
            value.onKingdomDelete(e.getKingdom());
        }
    }

    @EventHandler
    public void onKingdomMemberJoinEvent(KingdomMemberJoinEvent event) {
        Kingdoms.logDebug((String)"memberjoin");
        for (Map.Entry<String, OfflineKingdom> entry : kingdomList.entrySet()) {
            if (!(entry.getValue() instanceof Kingdom)) continue;
            Kingdom value = (Kingdom)entry.getValue();
            value.onMemberJoinKingdom(event.getKp());
        }
    }

    @EventHandler
    public void onKingdomMemberQuitEvent(KingdomMemberLeaveEvent e) {
        Kingdoms.logDebug((String)"memberquit");
        for (Map.Entry<String, OfflineKingdom> entry : kingdomList.entrySet()) {
            if (!(entry.getValue() instanceof Kingdom)) continue;
            String key = entry.getKey();
            Kingdom value = (Kingdom)entry.getValue();
            value.onMemberQuitKingdom(e.getKp());
        }
    }

    @Override
    public synchronized void onDisable() {
        this.autoSaveThread.interrupt();
        try {
            this.autoSaveThread.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        Kingdoms.logInfo((String)("Saving [" + kingdomList.size() + "] loaded kingdoms..."));
        try {
            this.saveAll();
            Kingdoms.logInfo((String)"Done!");
        }
        catch (Exception e) {
            Kingdoms.logInfo((String)"SQL connection failed! Saving to file DB");
            db = this.createFileDB();
            this.saveAll();
            Kingdoms.config.grabKingdomsFromFileDB = true;
        }
        kingdomList.clear();
    }

    public static int getRandomColor() {
        Random random = new Random();
        int color = 0;
        int r = random.nextInt(255);
        int g = random.nextInt(255);
        int b = random.nextInt(255);
        color = (r << 16) + (g << 8) + b;
        return color;
    }

    public static String serializeUUIDList(List<UUID> list) {
        String str = "";
        for (UUID uuid : list) {
            str = String.valueOf(str) + uuid.toString() + ",";
        }
        return str;
    }

    public static List<UUID> deserializeUUIDList(String list) {
        String[] splits = list.split(",");
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        String[] stringArray = splits;
        int n = splits.length;
        int n2 = 0;
        while (n2 < n) {
            String uuid = stringArray[n2];
            if (uuid != null) {
                uuids.add(UUID.fromString(uuid));
            }
            ++n2;
        }
        return uuids;
    }

    public static String serializeStringList(List<String> list) {
        String str = "";
        for (String s : list) {
            str = String.valueOf(str) + s + ",";
        }
        return str;
    }

    public static List<String> deserializeStringList(String list) {
        String[] splits = list.split(",");
        ArrayList<String> strings = new ArrayList<String>();
        String[] stringArray = splits;
        int n = splits.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                strings.add(s);
            }
            ++n2;
        }
        return strings;
    }

    private class AutoSaveTask
    implements Runnable {
        private AutoSaveTask() {
        }

        @Override
        public void run() {
            while (KingdomManager.this.plugin.isEnabled()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Kingdoms.logInfo((String)"Kingdom auto save is interrupted.");
                    return;
                }
                KingdomManager.this.saveAll();
            }
        }
    }

    private class KingdomDeleteTask
    implements Runnable {
        Map<String, OfflineKingdom> kingdomList;
        Kingdom kingdom;
        KingdomPlayer king;

        public KingdomDeleteTask(Map<String, OfflineKingdom> kingdomList2, Kingdom kingdom, KingdomPlayer king) {
            this.kingdomList = kingdomList2;
            this.kingdom = kingdom;
            this.king = king;
        }

        public KingdomDeleteTask(Map<String, OfflineKingdom> kingdomList, Kingdom kingdom) {
            this.kingdomList = kingdomList;
            this.kingdom = kingdom;
            this.king = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    String kingdomName = this.kingdom.getKingdomName();
                    if (this.king != null) {
                        this.king.setKingdom(null);
                        this.king.setRank(Rank.ALL);
                    } else {
                        OfflineKingdomPlayer kingdomking = GameManagement.getPlayerManager().getOfflineKingdomPlayer(this.kingdom.getKing());
                        if (kingdomking != null) {
                            if (kingdomking.isOnline()) {
                                kingdomking.getKingdomPlayer().setKingdom(null);
                                kingdomking.getKingdomPlayer().setRank(Rank.ALL);
                                if (ExternalManager.getScoreboardManager() != null) {
                                    ExternalManager.getScoreboardManager().updateScoreboard((KingdomPlayer)kingdomking);
                                }
                            } else {
                                kingdomking.setKingdomName(null);
                                kingdomking.setRank(Rank.ALL);
                            }
                        }
                    }
                    GameManagement.getLandManager().unclaimAllLand(this.kingdom);
                    for (UUID uuid : this.kingdom.getMembersList()) {
                        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(uuid);
                        if (kp == null) continue;
                        if (kp.isOnline()) {
                            kp.getKingdomPlayer().setKingdom(null);
                            kp.getKingdomPlayer().setRank(Rank.ALL);
                            if (ExternalManager.getScoreboardManager() == null) continue;
                            ExternalManager.getScoreboardManager().updateScoreboard(kp.getKingdomPlayer());
                            continue;
                        }
                        kp.setKingdomName(null);
                        kp.setRank(Rank.ALL);
                    }
                    Map<String, OfflineKingdom> map = this.kingdomList;
                    synchronized (map) {
                        this.kingdomList.remove(kingdomName);
                        db.save(kingdomName, null);
                    }
                    KingdomManager.this.plugin.getServer().getPluginManager().callEvent((Event)new KingdomDeleteEvent(this.kingdom));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.king != null) {
                        this.king.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Kingdom_Deleted));
                        this.king.setProcessing(false);
                    }
                }
            }
            finally {
                if (this.king != null) {
                    this.king.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Kingdom_Deleted));
                    this.king.setProcessing(false);
                }
            }
        }
    }

    private class NewKingdomCreateTask
    implements Runnable {
        Map<String, OfflineKingdom> kingdomList;
        String kingdomName;
        KingdomPlayer king;

        public NewKingdomCreateTask(Map<String, OfflineKingdom> kingdomList2, String kingdomName, KingdomPlayer king) {
            this.kingdomList = kingdomList2;
            this.kingdomName = kingdomName;
            this.king = king;
        }

        @Override
        public void run() {
            Kingdom kingdom = new Kingdom(this.kingdomName);
            kingdom.setKingdomName(this.kingdomName);
            kingdom.setKing(this.king.getUuid());
            if (Kingdoms.config.pacifistDefaultOn) {
                kingdom.setNeutral(true);
            }
            kingdom.addMember(this.king.getUuid());
            kingdom.getOnlineMembers().add(this.king);
            kingdom.giveShield();
            this.king.setRank(Rank.KING);
            this.king.setKingdom(kingdom);
            this.kingdomList.put(this.kingdomName, kingdom);
            this.king.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Kingdom_Creation_Success).replaceAll("%kingdom%", this.kingdomName));
            this.king.setProcessing(false);
            KingdomManager.this.plugin.getServer().getPluginManager().callEvent((Event)new KingdomCreateEvent(kingdom));
        }
    }
}

