/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.KingdomChest;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;

public class KingdomChestManager
extends Manager
implements Listener {
    HashMap<KingdomPlayer, Kingdom> userChest = new HashMap();

    protected KingdomChestManager(Plugin plugin) {
        super(plugin);
    }

    public boolean useKingdomChest(KingdomPlayer kp, Kingdom kingdom) {
        KingdomChest chest = kingdom.getKingdomChest();
        if (chest.getUsing() != null) {
            return false;
        }
        chest.setUsing(kp);
        this.userChest.put(kp, kingdom);
        Inventory kchest = Bukkit.createInventory(null, (int)27, (String)Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_KingdomChest_Title));
        if (kp.getKingdom() != null) {
            kchest = Bukkit.createInventory(null, (int)kp.getKingdom().getChestsize(), (String)Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_KingdomChest_Title));
        }
        if (chest.getInv() != null) {
            for (ItemStack item : chest.getInv()) {
                kchest.addItem(new ItemStack[]{item});
            }
        }
        kp.getPlayer().openInventory(kchest);
        return true;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onKingdomChestClose(InventoryCloseEvent e) {
        String invName = e.getInventory().getName();
        if (invName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_KingdomChest_Title))) {
            if (!(e.getPlayer() instanceof Player)) {
                return;
            }
            Kingdoms.logDebug((String)"instance");
            KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)e.getPlayer());
            if (this.userChest.get(kp).getKingdomChest() == null) {
                return;
            }
            Kingdoms.logDebug((String)"kingdomchest not null");
            KingdomChest chest = this.userChest.get(kp).getKingdomChest();
            ArrayList<ItemStack> ISs = new ArrayList<ItemStack>();
            ItemStack[] itemStackArray = e.getInventory().getContents();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack IS = itemStackArray[n2];
                if (IS != null) {
                    ISs.add(IS);
                }
                ++n2;
            }
            chest.setInv(ISs);
            chest.setUsing(null);
            this.userChest.remove(kp);
        }
    }

    @Override
    public void onDisable() {
    }
}

