/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.plugin.Plugin;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.Manager;

public class DataZipper
extends Manager {
    protected DataZipper(Plugin plugin) {
        super(plugin);
    }

    @Override
    public void onDisable() {
        AppZip.main();
    }

    public static class AppZip {
        List<String> fileList = new ArrayList<String>();
        private static final String SOURCE_FOLDER = String.valueOf(new File(".").getAbsolutePath()) + File.separator + Kingdoms.getInstance().getDataFolder().getPath();

        public static void main() {
            if (!Kingdoms.config.backup) {
                return;
            }
            File output = new File(String.valueOf(Kingdoms.getInstance().getDataFolder().getPath()) + File.separator + "backups");
            if (!output.exists()) {
                output.mkdirs();
            }
            AppZip appZip = new AppZip();
            appZip.generateFileList(new File(SOURCE_FOLDER));
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
            String name = dateFormat.format(date);
            String OUTPUT_ZIP_FILE = String.valueOf(Kingdoms.getInstance().getDataFolder().getPath()) + File.separator + "backups" + File.separator + name + ".zip";
            appZip.zipIt(OUTPUT_ZIP_FILE);
        }

        public void zipIt(String zipFile) {
            byte[] buffer = new byte[1024];
            try {
                FileOutputStream fos = new FileOutputStream(zipFile);
                ZipOutputStream zos = new ZipOutputStream(fos);
                Kingdoms.logInfo((String)("Saving new backup to: " + zipFile));
                int i = 0;
                for (String file : this.fileList) {
                    int len;
                    ++i;
                    ZipEntry ze = new ZipEntry(file);
                    zos.putNextEntry(ze);
                    FileInputStream in = new FileInputStream(String.valueOf(SOURCE_FOLDER) + File.separator + file);
                    while ((len = in.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    in.close();
                }
                Kingdoms.logInfo((String)(String.valueOf(i) + " files backed up"));
                zos.closeEntry();
                zos.close();
                Kingdoms.logInfo((String)"Done");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public void generateFileList(File node) {
            if (node.isFile()) {
                this.fileList.add(this.generateZipEntry(node.getAbsoluteFile().toString()));
            }
            if (node.isDirectory()) {
                String[] subNote;
                if (node.getName().equals("backups")) {
                    return;
                }
                String[] stringArray = subNote = node.list();
                int n = subNote.length;
                int n2 = 0;
                while (n2 < n) {
                    String filename = stringArray[n2];
                    this.generateFileList(new File(node, filename));
                    ++n2;
                }
            }
        }

        private String generateZipEntry(String file) {
            return file.substring(SOURCE_FOLDER.length() + 1, file.length());
        }
    }

    private class autoBackupTask
    implements Runnable {
        private autoBackupTask() {
        }

        @Override
        public void run() {
            while (DataZipper.this.plugin.isEnabled()) {
                try {
                    Thread.sleep(60000L * (long)Kingdoms.config.minPerBackup);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                AppZip.main();
            }
        }
    }
}

