/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.Iterator;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.conquest.ActiveConquestBattle;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.ConquestManager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.GuardsManager;

public class ActiveConquestBattleManager
extends Manager
implements Listener {
    protected ActiveConquestBattleManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onMobSpawn(CreatureSpawnEvent event) {
        if (event.getEntity().getWorld().equals(ConquestManager.world) && (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL || event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CHUNK_GEN)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player p = event.getPlayer();
        Kingdoms.getManagers();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
        Kingdom kingdom = kp.getKingdom();
        ActiveConquestBattle battle = ConquestManager.kingdomsMissions.get(kingdom);
        if (battle != null && battle.invaders.contains(kp)) {
            battle.modifiedBlocks.add(event.getBlock().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(event.getEntity())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Player p = (Player)event.getEntity();
            if (event.getFinalDamage() >= p.getHealth()) {
                Kingdoms.getManagers();
                KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
                Kingdom kingdom = kp.getKingdom();
                ActiveConquestBattle battle = ConquestManager.kingdomsMissions.get(kingdom);
                if (battle != null && battle.invaders.contains(kp)) {
                    ItemStack item;
                    event.setCancelled(true);
                    ItemStack[] itemStackArray = kp.getPlayer().getInventory().getContents();
                    int n = itemStackArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        item = itemStackArray[n2];
                        if (item != null && item.getType() != Material.AIR) {
                            battle.moblist.add((Entity)ConquestManager.world.dropItemNaturally(kp.getPlayer().getLocation(), item));
                        }
                        ++n2;
                    }
                    itemStackArray = kp.getPlayer().getInventory().getArmorContents();
                    n = itemStackArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        item = itemStackArray[n2];
                        if (item != null && item.getType() != Material.AIR) {
                            battle.moblist.add((Entity)ConquestManager.world.dropItemNaturally(kp.getPlayer().getLocation(), item));
                        }
                        ++n2;
                    }
                    kp.getPlayer().getInventory().clear();
                    kp.getPlayer().getInventory().setHelmet(null);
                    kp.getPlayer().getInventory().setChestplate(null);
                    kp.getPlayer().getInventory().setLeggings(null);
                    kp.getPlayer().getInventory().setBoots(null);
                    ConquestManager.leaveOffensive(kp);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommandWhileFight(PlayerCommandPreprocessEvent e) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        Kingdom kingdom = kp.getKingdom();
        ActiveConquestBattle battle = ConquestManager.kingdomsMissions.get(kingdom);
        if (battle != null && battle.invaders.contains(kp)) {
            if (!kp.getPlayer().getWorld().equals(ConquestManager.world)) {
                battle.invaders.remove(kp);
                return;
            }
            e.setCancelled(true);
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Conquests_Kingdom_No_Commands));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player p = event.getPlayer();
        Kingdoms.getManagers();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
        Kingdom kingdom = kp.getKingdom();
        ActiveConquestBattle battle = ConquestManager.kingdomsMissions.get(kingdom);
        if (battle != null && battle.invaders.contains(kp)) {
            ConquestManager.leaveOffensive(kp);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getBlock().getWorld().equals(ConquestManager.world)) {
            event.setCancelled(true);
            Kingdoms.getManagers();
            KingdomPlayer kp = GameManagement.getPlayerManager().getSession(event.getPlayer());
            Kingdom kingdom = kp.getKingdom();
            if (ConquestManager.kingdomsMissions.get(kingdom) != null) {
                Kingdoms.logDebug((String)"ActiveBattle not null");
                ActiveConquestBattle battle = ConquestManager.kingdomsMissions.get(kingdom);
                if (event.getBlock().getType() == Material.BEACON) {
                    Kingdoms.logDebug((String)"Block is beacon");
                    battle.concludeVictory();
                }
                if (battle.modifiedBlocks.contains(event.getBlock().getLocation())) {
                    event.setCancelled(false);
                    return;
                }
                if (this.canBeDestroyed(event.getBlock())) {
                    event.getBlock().setType(Material.AIR);
                }
            }
        }
    }

    @EventHandler
    public void onBlockExplode(EntityExplodeEvent event) {
        if (event.getEntity().getWorld().equals(ConquestManager.world)) {
            Iterator iter = event.blockList().iterator();
            while (iter.hasNext()) {
                Block block = (Block)iter.next();
                iter.remove();
                if (block == null || block.getType() == Material.AIR || !this.canBeDestroyed(block)) continue;
                block.setType(Material.AIR);
            }
        }
    }

    @EventHandler
    public void onTurretDamageGuard(EntityDamageByEntityEvent event) {
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(event.getEntity())) {
            return;
        }
        if (ConquestManager.world.equals(event.getEntity().getWorld()) && event.getEntity() instanceof Monster && ((Monster)event.getEntity()).getCustomName().equals(GuardsManager.GUARDNAME) && event.getDamager().hasMetadata("CONQUESTARROW")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPistonPushTurret(BlockPistonExtendEvent e) {
        if (!e.getBlock().getWorld().equals(ConquestManager.world)) {
            return;
        }
        for (Block block : e.getBlocks()) {
            if (block == null || block.getType() == Material.AIR || this.canBeDestroyed(block)) continue;
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonPullTurret(BlockPistonRetractEvent e) {
        if (!e.getBlock().getWorld().equals(ConquestManager.world)) {
            return;
        }
        for (Block block : e.getBlocks()) {
            if (block == null || block.getType() == Material.AIR || this.canBeDestroyed(block)) continue;
            e.setCancelled(true);
            return;
        }
    }

    public boolean canBeDestroyed(Block block) {
        Chunk c = block.getChunk();
        if (!block.getType().isSolid()) {
            return true;
        }
        if (block.getType() == Material.SKULL) {
            return true;
        }
        if (block.getType() == Material.FENCE) {
            return true;
        }
        if (block.getY() < 101) {
            Kingdoms.logDebug((String)"canBeDestroyed - false1");
            return false;
        }
        if (block.getY() > 107) {
            Kingdoms.logDebug((String)"canBeDestroyed - false2");
            return false;
        }
        int edgeX = c.getBlock(0, 0, 0).getX();
        if (block.getX() == edgeX) {
            Kingdoms.logDebug((String)"canBeDestroyed - false3");
            return false;
        }
        if (block.getX() == edgeX + 15) {
            Kingdoms.logDebug((String)"canBeDestroyed - false4");
            return false;
        }
        if (c.getBlock(block.getX(), block.getY(), 14).getLocation().equals((Object)block.getLocation()) && c.getBlock(block.getX(), 100, 15).getLocation().getBlock().getType() == Material.AIR) {
            Kingdoms.logDebug((String)"canBeDestroyed - false5");
            return false;
        }
        if (c.getBlock(block.getX(), block.getY(), 0).getLocation().equals((Object)block.getLocation())) {
            Kingdoms.logDebug((String)"canBeDestroyed - false6");
            return false;
        }
        Kingdoms.logDebug((String)"canBeDestroyed - true");
        return true;
    }

    @Override
    public void onDisable() {
    }
}

