/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.external;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.ResidenceApi;
import com.bekvon.bukkit.residence.event.ResidenceCreationEvent;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.ResidenceManager;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.Manager;

public class ResidenceManager
extends Manager
implements Listener {
    private static Residence residence;

    protected ResidenceManager(Plugin plugin) {
        super(plugin);
        residence = (Residence)plugin.getServer().getPluginManager().getPlugin("Residence");
        if (residence != null) {
            Kingdoms.logInfo((String)"Residence Hooked!");
            Kingdoms.logInfo((String)("Version: " + residence.getDescription().getVersion()));
            if (!residence.isEnabled()) {
                Kingdoms.logInfo((String)"Residence is not enabled!");
                Kingdoms.logInfo((String)"Disabled support for Residence.");
            }
        }
    }

    @EventHandler
    public void onResidenceClaim(ResidenceCreationEvent event) {
        if (event.getPlayer().isOp()) {
            return;
        }
        for (ResidenceManager.ChunkRef chunkRef : event.getPhysicalArea().getChunks()) {
        }
    }

    @Override
    public void onDisable() {
    }

    public static boolean canBuild(Player p, Location loc) {
        return true;
    }

    public static boolean isInRegion(Location loc) {
        if (residence != null) {
            ResidenceApi api = residence.getAPI();
            ClaimedResidence res = ResidenceApi.getResidenceManager().getByLoc(loc);
            if (res != null) {
                return true;
            }
        }
        return false;
    }
}

