/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.main;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.kingdoms.main.Kingdoms;

public class KingdomsConfig {
    private Kingdoms plugin;
    private FileConfiguration config;
    private File saveFile;
    public final Material nexusMaterial = Material.BEACON;
    public boolean pacifistEnabled = false;
    public boolean pacifistDefaultOn = false;
    public boolean isPluginEnabled = true;
    public boolean isDebugging = false;
    public boolean isMonitoring = false;
    public boolean allowSpecialCharactersInNamingKingdoms = false;
    public boolean gmcUseNexus = true;
    public boolean grabPlayersFromFileDB = false;
    public boolean grabKingdomsFromFileDB = false;
    public boolean grabConquestMapsFromFileDB = false;
    public boolean grabLandFromFileDB = false;
    public String lang = "eng";
    public int minPerBackup;
    public boolean canOnlyInvadeDuringMasswar = false;
    public boolean mysqlEnabled = false;
    public String dbAddress = "localhost:3306";
    public String dbName = "KingdomsDB";
    public String landTable = "Lands";
    public String kingdomTable = "kingdoms";
    public String playerTable = "Players";
    public String dbUser = "root";
    public String dbPassword = "1234";
    public List<String> worlds = new ArrayList<String>();
    public boolean noRegionClaim = true;
    public boolean freePvPInWarZone = false;
    public boolean canOpenChestInRegions = false;
    public int kingdomExpireDays = 999;
    public List<String> deniedCommandsInOtherKingdom = new ArrayList<String>();
    public List<String> deniedCommandsInEnemyKingdom = new ArrayList<String>();
    public boolean disableFlowIntoLand = true;
    public boolean showLandEnterMessage = true;
    public String tableName = "kingdoms";
    public int nexusMiningAmount = 20;
    public boolean privateChestsEnabled = true;
    public boolean privateChestsExplosionImmune = true;
    public List<String> warzoneenabledtouch = new ArrayList<String>();
    public List<String> safezoneenabledtouch = new ArrayList<String>();
    public boolean useWorldguardSupport = true;
    public boolean useResidenceSupport = true;
    public boolean useTitleAPISupport = true;
    public boolean useActionBarAPISupport = true;
    public boolean useScoreboardStatsSupport = true;
    public boolean usePlaceHolderAPISupport = true;
    public boolean useMVdWPlaceHolderAPISupport = true;
    public boolean useDynmapSupport = true;
    public boolean useHolographicSupport = true;
    public boolean protectNeutralLandFromExplosions;
    public boolean kingdomHomeCannotBeUnclaimed = false;
    public boolean landMustBeConnected = false;
    public String serverName = "yourServer";
    public double championThorTimer;
    public double dragRange;
    public boolean defaultMarkersOn = true;
    public boolean economyEnabled = false;
    public int items_needed_for_one_resource_point;
    public int claimcost;
    public int invadecost;
    public int rpToGivePerHourEachLand;
    public boolean backup;
    public int beginnerKingdomShieldTime;
    public int minerewardtime;
    public int minerewardamt;
    public boolean regulatorAllowMonsterToggle;
    public boolean regulatorAllowAnimalToggle;
    public int minMembersOnlineForInvasion;
    public int kingdom_char_tag_limit;
    public int land_per_member;
    public int maximum_land_claims;
    public boolean respawn_in_khome;
    public int nexusupgrades_dmg_reduc_cost;
    public int nexusupgrades_regen_boost_cost;
    public int nexusupgrades_dmg_boost_cost;
    public int nexusupgrades_arrow_boost_cost;
    public int nexusupgrades_maxmembers_cost;
    public int misc_upgrades_anticreeper_cost;
    public int misc_upgrades_antitrample_cost;
    public int misc_upgrades_bombshards_cost;
    public int misc_upgrades_glory_cost;
    public int misc_upgrades_nexusguard_cost;
    public int misc_upgrades_psioniccore_cost;
    public int champion_upgrade_health_cost;
    public int champion_upgrade_speed_cost;
    public int champion_upgrade_resist_cost;
    public int champion_upgrade_weapon_cost;
    public int champion_upgrade_duel_cost;
    public int champion_upgrade_drag_cost;
    public int champion_upgrade_mock_cost;
    public int champion_upgrade_thor_cost;
    public int champion_upgrade_damagecap_cost;
    public int champion_upgrade_plow_cost;
    public int champion_upgrade_strength_cost;
    public int champion_upgrade_armor_cost;
    public int champion_upgrade_reinforcements_cost;
    public int champion_upgrade_mimic_cost;
    public int champion_upgrade_focus_cost;
    public int champion_upgrade_aqua_cost;
    public int champion_upgrade_determination_cost;
    public int nexusupgrades_dmg_reduc_max;
    public int nexusupgrades_regen_boost_max;
    public int nexusupgrades_dmg_boost_max;
    public int nexusupgrades_arrow_boost_max;
    public int nexusupgrades_maxmembers_max;
    public int champion_upgrade_health_max;
    public int champion_upgrade_determination_max;
    public int champion_upgrade_speed_max;
    public int champion_upgrade_resist_max;
    public int champion_upgrade_weapon_max;
    public int champion_upgrade_duel_max;
    public int champion_upgrade_drag_max;
    public int champion_upgrade_mock_max;
    public int champion_upgrade_thor_max;
    public int champion_upgrade_damagecap_max;
    public int champion_upgrade_plow_max;
    public int champion_upgrade_strength_max;
    public int champion_upgrade_armor_max;
    public int champion_upgrade_reinforcements_max;
    public int champion_upgrade_mimic_max;
    public int champion_upgrade_focus_max;
    public boolean enableKingdomsConquests;
    public int conquestLogisticsLoopTime;
    public int conquestTurretCost;
    public int conquestWallCost;
    public int conquestSpawnerCost;
    public int conquestTurretUpkeepPerTurret;
    public int maxSupplyLand;
    public int conquestWallUpkeep;
    public int conquestSpawnerUpkeep;
    public int conquestLandReward;
    public int conquestCapitalReward;
    public int conquestLandAttackEmptyCost;
    public int conquestLandAttackEnemyCost;
    public int conquestLandAttackCapitalCost;
    public int conquestLandClaimCapitalCost;
    public int conquestAttackCooldown;
    public boolean canAttackCapitalInFullOccupiedLand;
    public int outpost_xpbottle_cost;
    public int structure_powercell_cost;
    public int structure_outpost_cost;
    public int structure_extractor_cost;
    public int structure_warppad_cost;
    public int structure_regulator_cost;
    public boolean force_turret_max_and_destroy_extra_turrets;
    public int turret_arrow_max;
    public int turret_nexustower_max;
    public int turret_flameturret_max;
    public int turret_pressuremine_max;
    public int turret_chemicalmine_max;
    public int turret_healingtower_max;
    public int turret_psionictotem_max;
    public int turret_soldierspawner_max;
    public int turret_hellfire_max;
    public int turret_heatbeam_max;
    public int turret_arrow_cost;
    public int turret_nexustower_cost;
    public int turret_flameturret_cost;
    public int turret_pressuremine_cost;
    public int turret_chemicalmine_cost;
    public int turret_healingtower_cost;
    public int turret_psionictotem_cost;
    public int turret_soldierspawner_cost;
    public int turret_hellfire_cost;
    public int turret_heatbeam_cost;
    public boolean turret_hit_mobs;
    public int turret_arrow_range;
    public int turret_nexustower_range;
    public int turret_flameturret_range;
    public int turret_healingtower_range;
    public int turret_psionictotem_range;
    public int turret_soldierspawner_range;
    public int turret_hellfire_range;
    public int turret_heatbeam_range;
    public int turret_arrow_damage;
    public int turret_nexustower_damage;
    public int turret_flameturret_damage;
    public int turret_pressuremine_damage;
    public int turret_chemicalmine_damage;
    public int turret_healingtower_damage;
    public int turret_psionictotem_damage;
    public int turret_soldierspawner_damage;
    public int turret_hellfire_damage;
    public int turret_heatbeam_damage;
    public int turretupgrade_simplified_cost;
    public int turretupgrade_flurry_cost;
    public int turretupgrade_concentrated_cost;
    public int turretupgrade_virulent_cost;
    public int turretupgrade_improvedhealing_cost;
    public int turretupgrade_voodoo_cost;
    public int turretupgrade_finalservice_cost;
    public int turretupgrade_hellstorm_cost;
    public int turretupgrade_unrelenting_cost;
    public boolean turretupgrade_simplified_enabled;
    public boolean turretupgrade_flurry_enabled;
    public boolean turretupgrade_concentrated_enabled;
    public boolean turretupgrade_virulent_enabled;
    public boolean turretupgrade_improvedhealing_enabled;
    public boolean turretupgrade_voodoo_enabled;
    public boolean turretupgrade_finalservice_enabled;
    public boolean turretupgrade_hellstorm_enabled;
    public boolean turretupgrade_unrelenting_enabled;
    public boolean nexusupgrades_dmg_reduc_enabled;
    public boolean nexusupgrades_regen_boost_enabled;
    public boolean nexusupgrades_dmg_boost_enabled;
    public boolean nexusupgrades_arrow_boost_enabled;
    public boolean nexusupgrades_maxmembers_enabled;
    public boolean misc_upgrades_anticreeper_enabled;
    public boolean misc_upgrades_anticreeper_protect_chests;
    public boolean misc_upgrades_antitrample_enabled;
    public boolean misc_upgrades_bombshards_enabled;
    public boolean misc_upgrades_bombshards_protect_chests;
    public boolean misc_upgrades_glory_enabled;
    public boolean misc_upgrades_nexusguard_enabled;
    public boolean misc_upgrades_psioniccore_enabled;
    public boolean champion_upgrade_health_enabled;
    public boolean champion_upgrade_speed_enabled;
    public boolean champion_upgrade_resist_enabled;
    public boolean champion_upgrade_weapon_enabled;
    public boolean champion_upgrade_duel_enabled;
    public boolean champion_upgrade_drag_enabled;
    public boolean champion_upgrade_mock_enabled;
    public boolean champion_upgrade_thor_enabled;
    public boolean champion_upgrade_damagecap_enabled;
    public boolean champion_upgrade_plow_enabled;
    public boolean champion_upgrade_aqua_enabled;
    public boolean champion_upgrade_strength_enabled;
    public boolean champion_upgrade_armor_enabled;
    public boolean champion_upgrade_reinforcements_enabled;
    public boolean champion_upgrade_mimic_enabled;
    public boolean champion_upgrade_focus_enabled;
    public boolean champion_upgrade_determination_enabled;
    public boolean structure_powercell_enabled;
    public boolean structure_outpost_enabled;
    public boolean structure_extractor_enabled;
    public boolean structure_warppad_enabled;
    public boolean structure_regulator_enabled;
    public boolean turret_arrow_enabled;
    public boolean turret_nexustower_enabled;
    public boolean turret_flameturret_enabled;
    public boolean turret_pressuremine_enabled;
    public boolean turret_chemicalmine_enabled;
    public boolean turret_healingtower_enabled;
    public boolean turret_psionictotem_enabled;
    public boolean turret_soldierspawner_enabled;
    public boolean turret_hellfire_enabled;
    public boolean turret_heatbeam_enabled;
    public List<String> cannotBuildInNonLand;
    public List<String> allowedToUseInOtherKingdomLand = new ArrayList<String>();
    public int economy_money_for_one_rp;
    public List<String> unreplaceableblocks = new ArrayList<String>();
    public boolean useWhiteList = false;
    public List<String> blacklist_items = new ArrayList<String>();
    public List<String> whitelist_items = new ArrayList<String>();
    public List<String> special_items = new ArrayList<String>();
    public int KHOMEDELAY;
    public int invite_expire_delay = 10;
    public boolean useKingdomPrefixes = true;
    public List<String> allowingNexusAccessForGameModes = new ArrayList<String>();

    KingdomsConfig(Plugin plugin) {
        this.plugin = (Kingdoms)plugin;
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
        this.saveFile = new File(plugin.getDataFolder(), "config.yml");
        if (!this.saveFile.exists()) {
            try {
                this.saveFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.saveFile);
        this.load();
        this.save();
    }

    public void load() {
        this.isPluginEnabled = this.config.getBoolean("Plugin.Enable", true);
        this.isDebugging = this.config.getBoolean("Plugin.Debug", false);
        this.isMonitoring = this.config.getBoolean("Plugin.Monitor-mode", false);
        this.allowSpecialCharactersInNamingKingdoms = this.config.getBoolean("Plugin.allowSpecialCharactersInNamingKingdoms", false);
        this.gmcUseNexus = this.config.getBoolean("gmc-can-use-nexus", true);
        this.lang = this.config.getString("Plugin.Lang", "eng");
        this.minPerBackup = this.config.getInt("minutes-per-backup", 43200);
        this.grabPlayersFromFileDB = this.config.getBoolean("DO-NOT-TOUCH.grabPlayerFromFileDB", false);
        this.grabLandFromFileDB = this.config.getBoolean("DO-NOT-TOUCH.grabLandFromFileDB", false);
        this.grabKingdomsFromFileDB = this.config.getBoolean("DO-NOT-TOUCH.grabKingdomsFromFileDB", false);
        this.grabConquestMapsFromFileDB = this.config.getBoolean("DO-NOT-TOUCH.grabConquestMapsFromFileDB", false);
        this.mysqlEnabled = this.config.getBoolean("MySql.Enabled", false);
        this.dbAddress = this.config.getString("MySql.DBAddr", "localhost");
        this.dbName = this.config.getString("MySql.DBName", "somedb");
        this.dbUser = this.config.getString("MySql.DBUser", "root");
        this.dbPassword = this.config.getString("MySql.DBPassword", "1234");
        this.landTable = this.config.getString("MySql.land-table-name", "Lands");
        this.kingdomTable = this.config.getString("MySql.kingdom-table-name", "kingdoms");
        this.playerTable = this.config.getString("MySql.player-table-name", "Players");
        this.worlds = (List)this.config.get("enabled-worlds", (Object)new ArrayList<String>(){
            {
                this.add("world");
            }
        });
        this.noRegionClaim = this.config.getBoolean("no-region-claim", true);
        this.freePvPInWarZone = this.config.getBoolean("warzone-free-pvp", false);
        this.canOpenChestInRegions = this.config.getBoolean("can-open-storage-blocks-in-other-kingdom-land", false);
        this.deniedCommandsInOtherKingdom = (List)this.config.get("denied-commands-neutral", (Object)new ArrayList<String>(){
            {
                this.add("/example");
                this.add("/example1");
            }
        });
        this.deniedCommandsInEnemyKingdom = (List)this.config.get("denied-commands-enemy", (Object)new ArrayList<String>(){
            {
                this.add("/sethome");
                this.add("/essentials:sethome");
                this.add("/derpcommand with any arguments");
            }
        });
        this.disableFlowIntoLand = this.config.getBoolean("disableFlowIntoLand", true);
        this.showLandEnterMessage = this.config.getBoolean("showLandEnterMessage", true);
        ListIterator<String> iter = this.deniedCommandsInOtherKingdom.listIterator();
        while (iter.hasNext()) {
            iter.set(iter.next().toLowerCase());
        }
        iter = this.deniedCommandsInEnemyKingdom.listIterator();
        while (iter.hasNext()) {
            iter.set(iter.next().toLowerCase());
        }
        this.canOnlyInvadeDuringMasswar = this.config.getBoolean("canOnlyInvadeDuringMasswar", false);
        this.kingdomExpireDays = this.config.getInt("kingdom-expiry-days", 999);
        this.nexusMiningAmount = this.config.getInt("nexusMiningAmount", 20);
        this.privateChestsEnabled = this.config.getBoolean("private-chests.enable-private-chests", true);
        this.privateChestsExplosionImmune = this.config.getBoolean("private-chests.explosion-immune", true);
        this.pacifistEnabled = this.config.getBoolean("allow-pacifist", false);
        this.pacifistDefaultOn = this.config.getBoolean("pacifist-default-on", false);
        this.useWorldguardSupport = this.config.getBoolean("useWorldguardSupport", true);
        this.useResidenceSupport = this.config.getBoolean("useResidenceSupport", true);
        this.useTitleAPISupport = this.config.getBoolean("useTitleAPISupport", true);
        this.useActionBarAPISupport = this.config.getBoolean("useActionBarAPISupport", true);
        this.useScoreboardStatsSupport = this.config.getBoolean("useScoreboardStatsSupport", true);
        this.usePlaceHolderAPISupport = this.config.getBoolean("usePlaceHolderAPISupport", true);
        this.useMVdWPlaceHolderAPISupport = this.config.getBoolean("useMVdWPlaceHolderAPISupport", true);
        this.useDynmapSupport = this.config.getBoolean("useDynmapSupport", true);
        this.useHolographicSupport = this.config.getBoolean("useHolographicSupport", true);
        this.protectNeutralLandFromExplosions = this.config.getBoolean("protectNeutralLandFromExplosions", false);
        this.kingdomHomeCannotBeUnclaimed = this.config.getBoolean("kingdom-home-stops-working-if-unclaimed", false);
        this.landMustBeConnected = this.config.getBoolean("land-must-be-connected", false);
        this.enableKingdomsConquests = this.config.getBoolean("conquests.enabled", false);
        this.maxSupplyLand = this.config.getInt("conquests.upkeep.max-supply-for-one-land", 100);
        this.conquestLogisticsLoopTime = this.config.getInt("conquests.logistics.time-in-minutes-to-apply-rewards-and-upkeep", 60);
        this.conquestTurretCost = this.config.getInt("conquests.costs.turret", 100);
        this.conquestWallCost = this.config.getInt("conquests.costs.wall", 200);
        this.conquestSpawnerCost = this.config.getInt("conquests.costs.spawner", 100);
        this.conquestTurretUpkeepPerTurret = this.config.getInt("conquests.upkeep.per-turret", 30);
        this.conquestWallUpkeep = this.config.getInt("conquests.upkeep.wall", 50);
        this.conquestSpawnerUpkeep = this.config.getInt("conquests.upkeep.spawner", 50);
        this.conquestLandReward = this.config.getInt("conquests.rp-rewards-per-hour.perland", 1);
        this.conquestCapitalReward = this.config.getInt("conquests.rp-rewards-per-hour.percapital", 200);
        this.conquestLandAttackEmptyCost = this.config.getInt("conquests.attack-costs.empty-land", 100);
        this.conquestLandAttackEnemyCost = this.config.getInt("conquests.attack-costs.enemy-land", 100);
        this.conquestLandAttackCapitalCost = this.config.getInt("conquests.attack-costs.enemy-capital-land", 500);
        this.conquestLandClaimCapitalCost = this.config.getInt("conquests.attack-costs.empty-capital", 500);
        this.conquestAttackCooldown = this.config.getInt("conquests.attack-cooldown-in-minutes", 30);
        this.canAttackCapitalInFullOccupiedLand = this.config.getBoolean("conquests.canAttackCapitalInFullyOccupiedLand", false);
        this.serverName = this.config.getString("Plugin.serverName", "yourServer");
        this.championThorTimer = this.config.getDouble("champion-specs.thor-delay", 5.0);
        this.dragRange = this.config.getDouble("champion-specs.drag-min-range");
        this.defaultMarkersOn = this.config.getBoolean("markers-on-by-default", true);
        this.economyEnabled = this.config.getBoolean("economy.enabled", false);
        this.items_needed_for_one_resource_point = this.config.getInt("items-needed-for-one-resource-point", 5);
        this.claimcost = this.config.getInt("claim-cost", 5);
        this.invadecost = this.config.getInt("invade-cost", 10);
        this.rpToGivePerHourEachLand = this.config.getInt("rp-to-award-per-land-every-hour", 0);
        this.backup = this.config.getBoolean("enable-auto-backup", true);
        this.beginnerKingdomShieldTime = this.config.getInt("beginner-shield.duration-in-minutes", 5);
        this.minerewardtime = this.config.getInt("mine.reward-delay-in-minutes", 1440);
        this.minerewardamt = this.config.getInt("mine.reward-amount", 100);
        this.regulatorAllowAnimalToggle = this.config.getBoolean("regulator.allow-toggling-animal-spawn", true);
        this.regulatorAllowMonsterToggle = this.config.getBoolean("regulator.allow-toggling-monster-spawn", true);
        this.minMembersOnlineForInvasion = this.config.getInt("minimum-members-online-to-be-invaded", 0);
        this.land_per_member = this.config.getInt("land-per-member", 5);
        this.maximum_land_claims = this.config.getInt("maximum-land-claims", 0);
        this.respawn_in_khome = this.config.getBoolean("respawn-in-kingdom-home", false);
        this.allowedToUseInOtherKingdomLand = (List)this.config.get("allowedToUseInOtherKingdomLand", (Object)new ArrayList<String>(){
            {
                this.add(Material.MONSTER_EGG.toString());
                this.add(Material.POTION.toString());
                this.add(Material.GOLDEN_APPLE.toString());
            }
        });
        this.unreplaceableblocks = (List)this.config.get("unreplaceableblocks", (Object)new ArrayList<String>(){
            {
                this.add(Material.BEDROCK.name());
                this.add(Material.OBSIDIAN.name());
                this.add(Material.CHEST.name());
                this.add(Material.ENDER_CHEST.name());
            }
        });
        this.nexusupgrades_dmg_reduc_cost = this.config.getInt("cost.nexusupgrades.dmg-reduc", 70);
        this.nexusupgrades_regen_boost_cost = this.config.getInt("cost.nexusupgrades.regen-boost", 70);
        this.nexusupgrades_dmg_boost_cost = this.config.getInt("cost.nexusupgrades.dmg-boost", 70);
        this.nexusupgrades_arrow_boost_cost = this.config.getInt("cost.nexusupgrades.arrow-boost", 100);
        this.nexusupgrades_maxmembers_cost = this.config.getInt("cost.nexusupgrades.maxmembers", 10);
        this.misc_upgrades_anticreeper_cost = this.config.getInt("cost.misc-upgrades.anticreeper", 20);
        this.misc_upgrades_antitrample_cost = this.config.getInt("cost.misc-upgrades.antitrample", 50);
        this.misc_upgrades_bombshards_cost = this.config.getInt("cost.misc-upgrades.bombshards", 1000);
        this.misc_upgrades_glory_cost = this.config.getInt("cost.misc-upgrades.glory", 200);
        this.misc_upgrades_nexusguard_cost = this.config.getInt("cost.misc-upgrades.nexusguard", 100);
        this.misc_upgrades_psioniccore_cost = this.config.getInt("cost.misc-upgrades.psioniccore", 500);
        this.nexusupgrades_dmg_reduc_max = this.config.getInt("max.nexusupgrades.dmg-reduc", 40);
        this.nexusupgrades_regen_boost_max = this.config.getInt("max.nexusupgrades.regen-boost", 200);
        this.nexusupgrades_dmg_boost_max = this.config.getInt("max.nexusupgrades.dmg-boost", 60);
        this.nexusupgrades_arrow_boost_max = this.config.getInt("max.nexusupgrades.arrow-boost", 60);
        this.nexusupgrades_maxmembers_max = this.config.getInt("max.nexusupgrades.maxmembers", 30);
        this.champion_upgrade_health_cost = this.config.getInt("cost.champion.health", 1);
        this.champion_upgrade_speed_cost = this.config.getInt("cost.champion.speed", 20);
        this.champion_upgrade_resist_cost = this.config.getInt("cost.champion.resist", 10);
        this.champion_upgrade_weapon_cost = this.config.getInt("cost.champion.weapon", 10);
        this.champion_upgrade_duel_cost = this.config.getInt("cost.champion.duel", 100);
        this.champion_upgrade_drag_cost = this.config.getInt("cost.champion.drag", 30);
        this.champion_upgrade_mock_cost = this.config.getInt("cost.champion.mock", 10);
        this.champion_upgrade_thor_cost = this.config.getInt("cost.champion.thor", 300);
        this.champion_upgrade_damagecap_cost = this.config.getInt("cost.champion.damagecap", 300);
        this.champion_upgrade_plow_cost = this.config.getInt("cost.champion.plow", 600);
        this.champion_upgrade_strength_cost = this.config.getInt("cost.champion.strength", 500);
        this.champion_upgrade_armor_cost = this.config.getInt("cost.champion.armor", 300);
        this.champion_upgrade_reinforcements_cost = this.config.getInt("cost.champion.reinforcements", 800);
        this.champion_upgrade_mimic_cost = this.config.getInt("cost.champion.mimic", 600);
        this.champion_upgrade_focus_cost = this.config.getInt("cost.champion.focus", 700);
        this.champion_upgrade_aqua_cost = this.config.getInt("cost.champion.aqua", 500);
        this.champion_upgrade_determination_cost = this.config.getInt("cost.champion.determination", 5);
        this.champion_upgrade_health_max = this.config.getInt("max.champion.health", 2048);
        this.champion_upgrade_determination_max = this.config.getInt("max.champion.determination", 2048);
        this.champion_upgrade_speed_max = this.config.getInt("max.champion.speed", 5);
        this.champion_upgrade_resist_max = this.config.getInt("max.champion.resist", 100);
        this.champion_upgrade_weapon_max = this.config.getInt("max.champion.weapon", 10);
        this.champion_upgrade_duel_max = this.config.getInt("max.champion.duel", 1);
        this.champion_upgrade_drag_max = this.config.getInt("max.champion.drag", 1);
        this.champion_upgrade_mock_max = this.config.getInt("max.champion.mock", 6);
        this.champion_upgrade_thor_max = this.config.getInt("max.champion.thor", 10);
        this.champion_upgrade_damagecap_max = this.config.getInt("max.champion.damagecap", 1);
        this.champion_upgrade_plow_max = this.config.getInt("max.champion.plow", 1);
        this.champion_upgrade_strength_max = this.config.getInt("max.champion.strength", 50);
        this.champion_upgrade_armor_max = this.config.getInt("max.champion.armor", 5);
        this.champion_upgrade_reinforcements_max = this.config.getInt("max.champion.reinforcements", 2);
        this.champion_upgrade_mimic_max = this.config.getInt("max.champion.mimic", 1);
        this.champion_upgrade_focus_max = this.config.getInt("max.champion.focus", 1);
        this.outpost_xpbottle_cost = this.config.getInt("cost.outpost.xpbottle", 5);
        this.structure_outpost_cost = this.config.getInt("cost.structures.outpost", 250);
        this.structure_powercell_cost = this.config.getInt("cost.structures.powercell", 250);
        this.structure_extractor_cost = this.config.getInt("cost.structures.extractor", 1000);
        this.structure_warppad_cost = this.config.getInt("cost.structures.warppad", 5000);
        this.structure_regulator_cost = this.config.getInt("cost.structures.regulator", 50);
        this.force_turret_max_and_destroy_extra_turrets = this.config.getBoolean("destroy-extra-turrets-to-enforce-max", false);
        this.turret_arrow_max = this.config.getInt("max-per-land.turrets.arrowturret", 1000);
        this.turret_nexustower_max = this.config.getInt("max-per-land.turrets.nexustower", 0);
        this.turret_flameturret_max = this.config.getInt("max-per-land.turrets.flameturret", 1000);
        this.turret_pressuremine_max = this.config.getInt("max-per-land.turrets.pressuremine", 1000);
        this.turret_chemicalmine_max = this.config.getInt("max-per-land.turrets.chemicalmine", 1000);
        this.turret_healingtower_max = this.config.getInt("max-per-land.turrets.healingstation", 1000);
        this.turret_psionictotem_max = this.config.getInt("max-per-land.turrets.psionictotem", 1000);
        this.turret_soldierspawner_max = this.config.getInt("max-per-land.turrets.soldierspawner", 1000);
        this.turret_hellfire_max = this.config.getInt("max-per-land.turrets.hellfireturret", 1000);
        this.turret_heatbeam_max = this.config.getInt("max-per-land.turrets.heatbeamturret", 1000);
        this.turret_arrow_cost = this.config.getInt("cost.turrets.arrowturret", 100);
        this.turret_nexustower_cost = this.config.getInt("cost.turrets.nexustower", 300);
        this.turret_flameturret_cost = this.config.getInt("cost.turrets.flameturret", 150);
        this.turret_pressuremine_cost = this.config.getInt("cost.turrets.pressuremine", 2);
        this.turret_chemicalmine_cost = this.config.getInt("cost.turrets.chemicalmine", 1);
        this.turret_healingtower_cost = this.config.getInt("cost.turrets.healingstation", 100);
        this.turret_psionictotem_cost = this.config.getInt("cost.turrets.psionictotem", 250);
        this.turret_soldierspawner_cost = this.config.getInt("cost.turrets.soldierspawner", 500);
        this.turret_hellfire_cost = this.config.getInt("cost.turrets.hellfireturret", 300);
        this.turret_heatbeam_cost = this.config.getInt("cost.turrets.heatbeamturret", 200);
        this.turret_hit_mobs = this.config.getBoolean("turret-specs.attack-mobs", true);
        this.turret_arrow_range = this.config.getInt("turret-specs.arrowturret.range", 8);
        this.turret_nexustower_range = this.config.getInt("turret-specs.nexustower.range", 8);
        this.turret_flameturret_range = this.config.getInt("turret-specs.flameturret.range", 8);
        this.turret_healingtower_range = this.config.getInt("turret-specs.healingstation.range", 8);
        this.turret_psionictotem_range = this.config.getInt("turret-specs.psionictotem.range", 8);
        this.turret_soldierspawner_range = this.config.getInt("turret-specs.soldierspawner.range", 8);
        this.turret_hellfire_range = this.config.getInt("turret-specs.hellfireturret.range", 8);
        this.turret_heatbeam_range = this.config.getInt("turret-specs.heatbeamturret.range", 8);
        this.turret_arrow_damage = this.config.getInt("turret-specs.arrowturret.damage", 4);
        this.turret_nexustower_damage = this.config.getInt("turret-specs.nexustower.damage", 0);
        this.turret_flameturret_damage = this.config.getInt("turret-specs.flameturret.damage", 3);
        this.turret_pressuremine_damage = this.config.getInt("turret-specs.turrets.pressuremine.blast", 2);
        this.turret_chemicalmine_damage = this.config.getInt("turret-specs.turrets.chemicalmine.poison-potency", 1);
        this.turret_healingtower_damage = this.config.getInt("turret-specs.healingstation.damage", 1);
        this.turret_psionictotem_damage = this.config.getInt("turret-specs.psionictotem.damage", 6);
        this.turret_soldierspawner_damage = this.config.getInt("turret-specs.soldierspawner.strength-level", -1);
        this.turret_hellfire_damage = this.config.getInt("turret-specs.hellfireturret.damage", 7);
        this.turret_heatbeam_damage = this.config.getInt("turret-specs.heatbeamturret.damage", 3);
        this.turretupgrade_simplified_cost = this.config.getInt("cost.turretupgrades.simplified-model", 1000);
        this.turretupgrade_flurry_cost = this.config.getInt("cost.turretupgrades.flurry", 1000);
        this.turretupgrade_concentrated_cost = this.config.getInt("cost.turretupgrades.concentrated-blast", 1000);
        this.turretupgrade_virulent_cost = this.config.getInt("cost.turretupgrades.virulent-plague", 1000);
        this.turretupgrade_improvedhealing_cost = this.config.getInt("cost.turretupgrades.improved-healing", 1000);
        this.turretupgrade_voodoo_cost = this.config.getInt("cost.turretupgrades.voodoo", 3000);
        this.turretupgrade_finalservice_cost = this.config.getInt("cost.turretupgrades.final-service", 3000);
        this.turretupgrade_hellstorm_cost = this.config.getInt("cost.turretupgrades.hellstorm", 5000);
        this.turretupgrade_unrelenting_cost = this.config.getInt("cost.turretupgrades.unrelenting-gaze", 5000);
        this.turretupgrade_simplified_enabled = this.config.getBoolean("enabled.turretupgrades.simplified-model", true);
        this.turretupgrade_flurry_enabled = this.config.getBoolean("enabled.turretupgrades.flurry", true);
        this.turretupgrade_concentrated_enabled = this.config.getBoolean("enabled.turretupgrades.concentrated-blast", true);
        this.turretupgrade_virulent_enabled = this.config.getBoolean("enabled.turretupgrades.virulent-plague", true);
        this.turretupgrade_improvedhealing_enabled = this.config.getBoolean("enabled.turretupgrades.improved-healing", true);
        this.turretupgrade_voodoo_enabled = this.config.getBoolean("enabled.turretupgrades.voodoo", true);
        this.turretupgrade_finalservice_enabled = this.config.getBoolean("enabled.turretupgrades.final-service", true);
        this.turretupgrade_hellstorm_enabled = this.config.getBoolean("enabled.turretupgrades.hellstorm", true);
        this.turretupgrade_unrelenting_enabled = this.config.getBoolean("enabled.turretupgrades.unrelenting-gaze", true);
        this.nexusupgrades_dmg_reduc_enabled = this.config.getBoolean("enable.nexus.dmgreduc", true);
        this.nexusupgrades_regen_boost_enabled = this.config.getBoolean("enable.nexus.regenboost", true);
        this.nexusupgrades_dmg_boost_enabled = this.config.getBoolean("enable.nexus.dmgboost", true);
        this.nexusupgrades_arrow_boost_enabled = this.config.getBoolean("enable.nexus.arrowboost", true);
        this.misc_upgrades_anticreeper_enabled = this.config.getBoolean("enable.misc.anticreeper.enabled", true);
        this.misc_upgrades_anticreeper_protect_chests = this.config.getBoolean("enable.misc.anticreeper.protect-storage-blocks", true);
        this.misc_upgrades_antitrample_enabled = this.config.getBoolean("enable.misc.antitrample", true);
        this.misc_upgrades_bombshards_enabled = this.config.getBoolean("enable.misc.bombshards.enabled", true);
        this.misc_upgrades_bombshards_protect_chests = this.config.getBoolean("enable.misc.bombshards.protect-storage-blocks", true);
        this.misc_upgrades_glory_enabled = this.config.getBoolean("enable.misc.glory", true);
        this.misc_upgrades_nexusguard_enabled = this.config.getBoolean("enable.misc.nexusguard", true);
        this.misc_upgrades_psioniccore_enabled = this.config.getBoolean("enable.misc.psioniccore", true);
        this.champion_upgrade_speed_enabled = this.config.getBoolean("enable.champion.speed", true);
        this.champion_upgrade_resist_enabled = this.config.getBoolean("enable.champion.resist", true);
        this.champion_upgrade_weapon_enabled = this.config.getBoolean("enable.champion.weapon", true);
        this.champion_upgrade_duel_enabled = this.config.getBoolean("enable.champion.duel", true);
        this.champion_upgrade_drag_enabled = this.config.getBoolean("enable.champion.drag", true);
        this.champion_upgrade_mock_enabled = this.config.getBoolean("enable.champion.mock", true);
        this.champion_upgrade_thor_enabled = this.config.getBoolean("enable.champion.thor", true);
        this.champion_upgrade_damagecap_enabled = this.config.getBoolean("enable.champion.damagecap", true);
        this.champion_upgrade_plow_enabled = this.config.getBoolean("enable.champion.plow", true);
        this.champion_upgrade_aqua_enabled = this.config.getBoolean("enable.champion.aqua", true);
        this.champion_upgrade_strength_enabled = this.config.getBoolean("enable.champion.strength", true);
        this.champion_upgrade_armor_enabled = this.config.getBoolean("enable.champion.armor", true);
        this.champion_upgrade_reinforcements_enabled = this.config.getBoolean("enable.champion.reinforcements", true);
        this.champion_upgrade_mimic_enabled = this.config.getBoolean("enable.champion.mimic", true);
        this.champion_upgrade_focus_enabled = this.config.getBoolean("enable.champion.focus", true);
        this.champion_upgrade_determination_enabled = this.config.getBoolean("enable.champion.determination", false);
        this.structure_powercell_enabled = this.config.getBoolean("enable.structure.powercell", true);
        this.structure_outpost_enabled = this.config.getBoolean("enable.structure.outpost", true);
        this.structure_extractor_enabled = this.config.getBoolean("enable.structure.extractor", true);
        this.structure_warppad_enabled = this.config.getBoolean("enable.structure.warppad", true);
        this.structure_regulator_enabled = this.config.getBoolean("enable.structure.regulator", true);
        this.turret_arrow_enabled = this.config.getBoolean("enable.turret.arrow", true);
        this.turret_flameturret_enabled = this.config.getBoolean("enable.turret.flameturret", true);
        this.turret_pressuremine_enabled = this.config.getBoolean("enable.turret.pressuremine", true);
        this.turret_chemicalmine_enabled = this.config.getBoolean("enable.turret.chemicalmine", true);
        this.turret_healingtower_enabled = this.config.getBoolean("enable.turret.healingtower", true);
        this.turret_psionictotem_enabled = this.config.getBoolean("enable.turret.psionictotem", true);
        this.turret_soldierspawner_enabled = this.config.getBoolean("enable.turret.soldierspawner", true);
        this.turret_hellfire_enabled = this.config.getBoolean("enable.turret.hellfire", true);
        this.turret_heatbeam_enabled = this.config.getBoolean("enable.turret.heatbeam", true);
        this.cannotBuildInNonLand = (List)this.config.get("worlds-with-no-building-in-unoccupied-land", (Object)new ArrayList<String>(){
            {
                this.add("Put");
                this.add("Worlds");
                this.add("Here");
            }
        });
        this.economy_money_for_one_rp = this.config.getInt("economy.money-needed-for-one-rp", 10);
        this.KHOMEDELAY = this.config.getInt("khome-delay", 3);
        this.invite_expire_delay = this.config.getInt("invite_expire_delay", 10);
        this.useWhiteList = this.config.getBoolean("use-whitelist", false);
        this.blacklist_items = (List)this.config.get("resource-point-trade-blacklist", new ArrayList());
        this.whitelist_items = (List)this.config.get("whitelist-items", new ArrayList());
        this.special_items = (List)this.config.get("special-item-cases", (Object)new ArrayList<String>(){
            {
                this.add("IRON_INGOT,30");
                this.add("GOLD_INGOT,20");
                this.add("EMERALD,50");
                this.add("DIAMOND,50");
            }
        });
        this.safezoneenabledtouch = (List)this.config.get("can-interact-in-safezone", (Object)new ArrayList<String>(){
            {
                this.add("ENDER_CHEST");
                this.add("WORKBENCH");
                this.add("ANVIL");
                this.add("ENCHANTMENT_TABLE");
            }
        });
        this.warzoneenabledtouch = (List)this.config.get("can-interact-in-warzone", (Object)new ArrayList<String>(){
            {
                this.add("ENDER_CHEST");
                this.add("WORKBENCH");
                this.add("ANVIL");
                this.add("ENCHANTMENT_TABLE");
            }
        });
        this.useKingdomPrefixes = this.config.getBoolean("useKingdomPrefixes", true);
        this.allowingNexusAccessForGameModes = (List)this.config.get("allowingNexusAccessForGameModes", (Object)new ArrayList<String>(){
            {
                this.add(GameMode.SURVIVAL.name());
            }
        });
    }

    public void save() {
        this.config.set("Plugin.Enable", (Object)this.isPluginEnabled);
        this.config.set("Plugin.Debug", (Object)this.isDebugging);
        this.config.set("Plugin.Monitor-mode", (Object)this.isMonitoring);
        this.config.set("Plugin.allowSpecialCharactersInNamingKingdoms", (Object)this.allowSpecialCharactersInNamingKingdoms);
        this.config.set("gmc-can-use-nexus", (Object)this.gmcUseNexus);
        this.config.set("Plugin.Lang", (Object)this.lang);
        this.config.set("minutes-per-backup", (Object)this.minPerBackup);
        this.config.set("allow-pacifist", (Object)this.pacifistEnabled);
        this.config.set("pacifist-default-on", (Object)this.pacifistDefaultOn);
        this.config.set("MySql.Enabled", (Object)this.mysqlEnabled);
        this.config.set("MySql.DBAddr", (Object)this.dbAddress);
        this.config.set("MySql.DBName", (Object)this.dbName);
        this.config.set("MySql.DBUser", (Object)this.dbUser);
        this.config.set("MySql.DBPassword", (Object)this.dbPassword);
        this.config.set("MySql.land-table-name", (Object)this.landTable);
        this.config.set("MySql.kingdom-table-name", (Object)this.kingdomTable);
        this.config.set("MySql.player-table-name", (Object)this.playerTable);
        this.config.set("DO-NOT-TOUCH.grabPlayerFromFileDB", (Object)this.grabPlayersFromFileDB);
        this.config.set("DO-NOT-TOUCH.grabLandFromFileDB", (Object)this.grabLandFromFileDB);
        this.config.set("DO-NOT-TOUCH.grabKingdomsFromFileDB", (Object)this.grabKingdomsFromFileDB);
        this.config.set("DO-NOT-TOUCH.grabConquestMapsFromFileDB", (Object)this.grabConquestMapsFromFileDB);
        this.config.set("enabled-worlds", this.worlds);
        this.config.set("no-region-claim", (Object)this.noRegionClaim);
        this.config.set("warzone-free-pvp", (Object)this.freePvPInWarZone);
        this.config.set("can-open-storage-blocks-in-other-kingdom-land", (Object)this.canOpenChestInRegions);
        this.config.set("canOnlyInvadeDuringMasswar", (Object)this.canOnlyInvadeDuringMasswar);
        this.config.set("kingdom-expiry-days", (Object)this.kingdomExpireDays);
        this.config.set("denied-commands-neutral", this.deniedCommandsInOtherKingdom);
        this.config.set("denied-commands-enemy", this.deniedCommandsInEnemyKingdom);
        this.config.set("disableFlowIntoLand", (Object)this.disableFlowIntoLand);
        this.config.set("showLandEnterMessage", (Object)this.showLandEnterMessage);
        this.config.set("nexusMiningAmount", (Object)this.nexusMiningAmount);
        this.config.set("private-chests.enable-private-chests", (Object)this.privateChestsEnabled);
        this.config.set("private-chests.explosion-immune", (Object)this.privateChestsExplosionImmune);
        this.config.set("useWorldguardSupport", (Object)this.useWorldguardSupport);
        this.config.set("useResidenceSupport", (Object)this.useResidenceSupport);
        this.config.set("useTitleAPISupport", (Object)this.useTitleAPISupport);
        this.config.set("useActionBarAPISupport", (Object)this.useActionBarAPISupport);
        this.config.set("useScoreboardStatsSupport", (Object)this.useScoreboardStatsSupport);
        this.config.set("usePlaceHolderAPISupport", (Object)this.usePlaceHolderAPISupport);
        this.config.set("useMVdWPlaceHolderAPISupport", (Object)this.useMVdWPlaceHolderAPISupport);
        this.config.set("useDynmapSupport", (Object)this.useDynmapSupport);
        this.config.set("useHolographicSupport", (Object)this.useHolographicSupport);
        this.config.set("protectNeutralLandFromExplosions", (Object)this.protectNeutralLandFromExplosions);
        this.config.set("kingdom-home-stops-working-if-unclaimed", (Object)this.kingdomHomeCannotBeUnclaimed);
        this.config.set("land-must-be-connected", (Object)this.landMustBeConnected);
        this.config.set("conquests.enabled", (Object)this.enableKingdomsConquests);
        this.config.set("conquests.upkeep.max-supply-for-one-land", (Object)this.maxSupplyLand);
        this.config.set("conquests.logistics.time-in-minutes-to-apply-rewards-and-upkeep", (Object)this.conquestLogisticsLoopTime);
        this.config.set("conquests.costs.turret", (Object)this.conquestTurretCost);
        this.config.set("conquests.costs.wall", (Object)this.conquestWallCost);
        this.config.set("conquests.costs.spawner", (Object)this.conquestSpawnerCost);
        this.config.set("conquests.upkeep.per-turret", (Object)this.conquestTurretUpkeepPerTurret);
        this.config.set("conquests.upkeep.wall", (Object)this.conquestWallUpkeep);
        this.config.set("conquests.upkeep.spawner", (Object)this.conquestSpawnerUpkeep);
        this.config.set("conquests.rp-rewards-per-hour.perland", (Object)this.conquestLandReward);
        this.config.set("conquests.rp-rewards-per-hour.percapital", (Object)this.conquestCapitalReward);
        this.config.set("conquests.attack-costs.empty-land", (Object)this.conquestLandAttackEmptyCost);
        this.config.set("conquests.attack-costs.enemy-land", (Object)this.conquestLandAttackEnemyCost);
        this.config.set("conquests.attack-costs.enemy-capital-land", (Object)this.conquestLandAttackCapitalCost);
        this.config.set("conquests.attack-costs.empty-capital", (Object)this.conquestLandClaimCapitalCost);
        this.config.set("conquests.canAttackCapitalInFullyOccupiedLand", (Object)this.canAttackCapitalInFullOccupiedLand);
        this.config.set("conquests.attack-cooldown-in-minutes", (Object)this.conquestAttackCooldown);
        this.config.set("Plugin.serverName", (Object)this.serverName);
        this.config.set("champion-specs.thor-delay", (Object)this.championThorTimer);
        this.config.set("economy.enabled", (Object)this.economyEnabled);
        this.config.set("markers-on-by-default", (Object)this.defaultMarkersOn);
        this.config.set("items-needed-for-one-resource-point", (Object)this.items_needed_for_one_resource_point);
        this.config.set("claim-cost", (Object)this.claimcost);
        this.config.set("invade-cost", (Object)this.invadecost);
        this.config.set("rp-to-award-per-land-every-hour", (Object)this.rpToGivePerHourEachLand);
        this.config.set("enable-auto-backup", (Object)this.backup);
        this.config.set("beginner-shield.duration-in-minutes", (Object)this.beginnerKingdomShieldTime);
        this.config.set("mine.reward-delay-in-minutes", (Object)this.minerewardtime);
        this.config.set("mine.reward-amount", (Object)this.minerewardamt);
        this.config.set("regulator.allow-toggling-animal-spawn", (Object)this.regulatorAllowAnimalToggle);
        this.config.set("regulator.allow-toggling-monster-spawn", (Object)this.regulatorAllowMonsterToggle);
        this.config.set("minimum-members-online-to-be-invaded", (Object)this.minMembersOnlineForInvasion);
        this.config.set("land-per-member", (Object)this.land_per_member);
        this.config.set("maximum-land-claims", (Object)this.maximum_land_claims);
        this.config.set("respawn-in-kingdom-home", (Object)this.respawn_in_khome);
        this.config.set("unreplaceableblocks", this.unreplaceableblocks);
        this.config.set("allowedToUseInOtherKingdomLand", this.allowedToUseInOtherKingdomLand);
        this.config.set("cost.nexusupgrades.dmg-reduc", (Object)this.nexusupgrades_dmg_reduc_cost);
        this.config.set("cost.nexusupgrades.regen-boost", (Object)this.nexusupgrades_regen_boost_cost);
        this.config.set("cost.nexusupgrades.dmg-boost", (Object)this.nexusupgrades_dmg_boost_cost);
        this.config.set("cost.nexusupgrades.arrow-boost", (Object)this.nexusupgrades_arrow_boost_cost);
        this.config.set("cost.nexusupgrades.maxmembers", (Object)this.nexusupgrades_maxmembers_cost);
        this.config.set("cost.misc-upgrades.anticreeper", (Object)this.misc_upgrades_anticreeper_cost);
        this.config.set("cost.misc-upgrades.antitrample", (Object)this.misc_upgrades_antitrample_cost);
        this.config.set("cost.misc-upgrades.bombshards", (Object)this.misc_upgrades_bombshards_cost);
        this.config.set("cost.misc-upgrades.glory", (Object)this.misc_upgrades_glory_cost);
        this.config.set("cost.misc-upgrades.nexusguard", (Object)this.misc_upgrades_nexusguard_cost);
        this.config.set("cost.misc-upgrades.psioniccore", (Object)this.misc_upgrades_psioniccore_cost);
        this.config.set("max.nexusupgrades.dmg-reduc", (Object)this.nexusupgrades_dmg_reduc_max);
        this.config.set("max.nexusupgrades.regen-boost", (Object)this.nexusupgrades_regen_boost_max);
        this.config.set("max.nexusupgrades.dmg-boost", (Object)this.nexusupgrades_dmg_boost_max);
        this.config.set("max.nexusupgrades.arrow-boost", (Object)this.nexusupgrades_arrow_boost_max);
        this.config.set("max.nexusupgrades.maxmembers", (Object)this.nexusupgrades_maxmembers_max);
        this.config.set("cost.champion.health", (Object)this.champion_upgrade_health_cost);
        this.config.set("cost.champion.speed", (Object)this.champion_upgrade_speed_cost);
        this.config.set("cost.champion.resist", (Object)this.champion_upgrade_resist_cost);
        this.config.set("cost.champion.weapon", (Object)this.champion_upgrade_weapon_cost);
        this.config.set("cost.champion.duel", (Object)this.champion_upgrade_duel_cost);
        this.config.set("cost.champion.drag", (Object)this.champion_upgrade_drag_cost);
        this.config.set("cost.champion.mock", (Object)this.champion_upgrade_mock_cost);
        this.config.set("cost.champion.thor", (Object)this.champion_upgrade_thor_cost);
        this.config.set("cost.champion.damagecap", (Object)this.champion_upgrade_damagecap_cost);
        this.config.set("cost.champion.plow", (Object)this.champion_upgrade_plow_cost);
        this.config.set("cost.champion.strength", (Object)this.champion_upgrade_strength_cost);
        this.config.set("cost.champion.armor", (Object)this.champion_upgrade_armor_cost);
        this.config.set("cost.champion.reinforcements", (Object)this.champion_upgrade_reinforcements_cost);
        this.config.set("cost.champion.mimic", (Object)this.champion_upgrade_mimic_cost);
        this.config.set("cost.champion.focus", (Object)this.champion_upgrade_focus_cost);
        this.config.set("cost.champion.aqua", (Object)this.champion_upgrade_aqua_cost);
        this.config.set("cost.champion.determination", (Object)this.champion_upgrade_determination_cost);
        this.config.set("cost.outpost.xpbottle", (Object)this.outpost_xpbottle_cost);
        this.config.set("cost.structures.powercell", (Object)this.structure_powercell_cost);
        this.config.set("cost.structures.outpost", (Object)this.structure_outpost_cost);
        this.config.set("cost.structures.extractor", (Object)this.structure_extractor_cost);
        this.config.set("cost.structures.warppad", (Object)this.structure_warppad_cost);
        this.config.set("cost.structures.regulator", (Object)this.structure_regulator_cost);
        this.config.set("destroy-extra-turrets-to-enforce-max", (Object)this.force_turret_max_and_destroy_extra_turrets);
        this.config.set("max-per-land.turrets.arrowturret", (Object)this.turret_arrow_max);
        this.config.set("max-per-land.turrets.nexustower", (Object)this.turret_nexustower_max);
        this.config.set("max-per-land.turrets.flameturret", (Object)this.turret_flameturret_max);
        this.config.set("max-per-land.turrets.pressuremine", (Object)this.turret_pressuremine_max);
        this.config.set("max-per-land.turrets.chemicalmine", (Object)this.turret_chemicalmine_max);
        this.config.set("max-per-land.turrets.healingstation", (Object)this.turret_healingtower_max);
        this.config.set("max-per-land.turrets.psionictotem", (Object)this.turret_psionictotem_max);
        this.config.set("max-per-land.turrets.soldierspawner", (Object)this.turret_soldierspawner_max);
        this.config.set("max-per-land.turrets.hellfireturret", (Object)this.turret_hellfire_max);
        this.config.set("max-per-land.turrets.heatbeamturret", (Object)this.turret_heatbeam_max);
        this.config.set("cost.turrets.arrowturret", (Object)this.turret_arrow_cost);
        this.config.set("cost.turrets.nexustower", (Object)this.turret_nexustower_cost);
        this.config.set("cost.turrets.flameturret", (Object)this.turret_flameturret_cost);
        this.config.set("cost.turrets.pressuremine", (Object)this.turret_pressuremine_cost);
        this.config.set("cost.turrets.chemicalmine", (Object)this.turret_chemicalmine_cost);
        this.config.set("cost.turrets.healingstation", (Object)this.turret_healingtower_cost);
        this.config.set("cost.turrets.psionictotem", (Object)this.turret_psionictotem_cost);
        this.config.set("cost.turrets.soldierspawner", (Object)this.turret_soldierspawner_cost);
        this.config.set("cost.turrets.hellfireturret", (Object)this.turret_hellfire_cost);
        this.config.set("cost.turrets.heatbeamturret", (Object)this.turret_heatbeam_cost);
        this.config.set("turret-specs.attack-mobs", (Object)this.turret_hit_mobs);
        this.config.set("turret-specs.arrowturret.range", (Object)this.turret_arrow_range);
        this.config.set("turret-specs.nexustower.range", (Object)this.turret_nexustower_range);
        this.config.set("turret-specs.flameturret.range", (Object)this.turret_flameturret_range);
        this.config.set("turret-specs.healingstation.range", (Object)this.turret_healingtower_range);
        this.config.set("turret-specs.psionictotem.range", (Object)this.turret_psionictotem_range);
        this.config.set("turret-specs.soldierspawner.range", (Object)this.turret_soldierspawner_range);
        this.config.set("turret-specs.hellfireturret.range", (Object)this.turret_hellfire_range);
        this.config.set("turret-specs.heatbeamturret.range", (Object)this.turret_heatbeam_range);
        this.config.set("turret-specs.arrowturret.damage", (Object)this.turret_arrow_damage);
        this.config.set("turret-specs.nexustower.damage", (Object)this.turret_nexustower_damage);
        this.config.set("turret-specs.flameturret.damage", (Object)this.turret_flameturret_damage);
        this.config.set("turret-specs.pressuremine.blast", (Object)this.turret_pressuremine_damage);
        this.config.set("turret-specs.chemicalmine.poison-potency", (Object)this.turret_chemicalmine_damage);
        this.config.set("turret-specs.healingstation.damage", (Object)this.turret_healingtower_damage);
        this.config.set("turret-specs.psionictotem.damage", (Object)this.turret_psionictotem_damage);
        this.config.set("turret-specs.soldierspawner.strength-level", (Object)this.turret_soldierspawner_damage);
        this.config.set("turret-specs.hellfireturret.damage", (Object)this.turret_hellfire_damage);
        this.config.set("turret-specs.heatbeamturret.damage", (Object)this.turret_heatbeam_damage);
        this.config.set("cost.turretupgrades.simplified-model", (Object)this.turretupgrade_simplified_cost);
        this.config.set("cost.turretupgrades.flurry", (Object)this.turretupgrade_flurry_cost);
        this.config.set("cost.turretupgrades.concentrated-blast", (Object)this.turretupgrade_concentrated_cost);
        this.config.set("cost.turretupgrades.virulent-plague", (Object)this.turretupgrade_virulent_cost);
        this.config.set("cost.turretupgrades.improved-healing", (Object)this.turretupgrade_improvedhealing_cost);
        this.config.set("cost.turretupgrades.voodoo", (Object)this.turretupgrade_voodoo_cost);
        this.config.set("cost.turretupgrades.final-service", (Object)this.turretupgrade_finalservice_cost);
        this.config.set("cost.turretupgrades.hellstorm", (Object)this.turretupgrade_hellstorm_cost);
        this.config.set("cost.turretupgrades.unrelenting-gaze", (Object)this.turretupgrade_unrelenting_cost);
        this.config.set("enabled.turretupgrades.simplified-model", (Object)this.turretupgrade_simplified_enabled);
        this.config.set("enabled.turretupgrades.flurry", (Object)this.turretupgrade_flurry_enabled);
        this.config.set("enabled.turretupgrades.concentrated-blast", (Object)this.turretupgrade_concentrated_enabled);
        this.config.set("enabled.turretupgrades.virulent-plague", (Object)this.turretupgrade_virulent_enabled);
        this.config.set("enabled.turretupgrades.improved-healing", (Object)this.turretupgrade_improvedhealing_enabled);
        this.config.set("enabled.turretupgrades.voodoo", (Object)this.turretupgrade_voodoo_enabled);
        this.config.set("enabled.turretupgrades.final-service", (Object)this.turretupgrade_finalservice_enabled);
        this.config.set("enabled.turretupgrades.hellstorm", (Object)this.turretupgrade_hellstorm_enabled);
        this.config.set("enabled.turretupgrades.unrelenting-gaze", (Object)this.turretupgrade_unrelenting_enabled);
        this.config.set("max.champion.health", (Object)this.champion_upgrade_health_max);
        this.config.set("max.champion.determination", (Object)this.champion_upgrade_determination_max);
        this.config.set("max.champion.speed", (Object)this.champion_upgrade_speed_max);
        this.config.set("max.champion.resist", (Object)this.champion_upgrade_resist_max);
        this.config.set("max.champion.weapon", (Object)this.champion_upgrade_weapon_max);
        this.config.set("max.champion.duel", (Object)this.champion_upgrade_duel_max);
        this.config.set("max.champion.drag", (Object)this.champion_upgrade_drag_max);
        this.config.set("max.champion.mock", (Object)this.champion_upgrade_mock_max);
        this.config.set("max.champion.thor", (Object)this.champion_upgrade_thor_max);
        this.config.set("max.champion.damagecap", (Object)this.champion_upgrade_damagecap_max);
        this.config.set("max.champion.plow", (Object)this.champion_upgrade_plow_max);
        this.config.set("max.champion.strength", (Object)this.champion_upgrade_strength_max);
        this.config.set("max.champion.armor", (Object)this.champion_upgrade_armor_max);
        this.config.set("max.champion.reinforcements", (Object)this.champion_upgrade_reinforcements_max);
        this.config.set("max.champion.mimic", (Object)this.champion_upgrade_mimic_max);
        this.config.set("max.champion.focus", (Object)this.champion_upgrade_focus_max);
        this.config.set("enable.nexus.dmgreduc", (Object)this.nexusupgrades_dmg_reduc_enabled);
        this.config.set("enable.nexus.regenboost", (Object)this.nexusupgrades_regen_boost_enabled);
        this.config.set("enable.nexus.dmgboost", (Object)this.nexusupgrades_dmg_boost_enabled);
        this.config.set("enable.nexus.arrowboost", (Object)this.nexusupgrades_arrow_boost_enabled);
        this.config.set("enable.misc.anticreeper.enabled", (Object)this.misc_upgrades_anticreeper_enabled);
        this.config.set("enable.misc.anticreeper.protect-storage-blocks", (Object)this.misc_upgrades_anticreeper_protect_chests);
        this.config.set("enable.misc.antitrample", (Object)this.misc_upgrades_antitrample_enabled);
        this.config.set("enable.misc.bombshards.enabled", (Object)this.misc_upgrades_bombshards_enabled);
        this.config.set("enable.misc.bombshards.protect-storage-blocks", (Object)this.misc_upgrades_bombshards_protect_chests);
        this.config.set("enable.misc.glory", (Object)this.misc_upgrades_glory_enabled);
        this.config.set("enable.misc.nexusguard", (Object)this.misc_upgrades_nexusguard_enabled);
        this.config.set("enable.misc.psioniccore", (Object)this.misc_upgrades_psioniccore_enabled);
        this.config.set("enable.champion.speed", (Object)this.champion_upgrade_speed_enabled);
        this.config.set("enable.champion.resist", (Object)this.champion_upgrade_resist_enabled);
        this.config.set("enable.champion.weapon", (Object)this.champion_upgrade_weapon_enabled);
        this.config.set("enable.champion.duel", (Object)this.champion_upgrade_duel_enabled);
        this.config.set("enable.champion.drag", (Object)this.champion_upgrade_drag_enabled);
        this.config.set("enable.champion.mock", (Object)this.champion_upgrade_mock_enabled);
        this.config.set("enable.champion.thor", (Object)this.champion_upgrade_thor_enabled);
        this.config.set("enable.champion.damagecap", (Object)this.champion_upgrade_damagecap_enabled);
        this.config.set("enable.champion.plow", (Object)this.champion_upgrade_plow_enabled);
        this.config.set("enable.champion.aqua", (Object)this.champion_upgrade_aqua_enabled);
        this.config.set("enable.champion.strength", (Object)this.champion_upgrade_strength_enabled);
        this.config.set("enable.champion.armor", (Object)this.champion_upgrade_armor_enabled);
        this.config.set("enable.champion.reinforcements", (Object)this.champion_upgrade_reinforcements_enabled);
        this.config.set("enable.champion.mimic", (Object)this.champion_upgrade_mimic_enabled);
        this.config.set("enable.champion.focus", (Object)this.champion_upgrade_focus_enabled);
        this.config.set("enable.champion.determination", (Object)this.champion_upgrade_determination_enabled);
        this.config.set("enable.structure.powercell", (Object)this.structure_powercell_enabled);
        this.config.set("enable.structure.outpost", (Object)this.structure_outpost_enabled);
        this.config.set("enable.structure.extractor", (Object)this.structure_extractor_enabled);
        this.config.set("enable.structure.warppad", (Object)this.structure_warppad_enabled);
        this.config.set("enable.structure.regulator", (Object)this.structure_regulator_enabled);
        this.config.set("enable.turret.arrow", (Object)this.turret_arrow_enabled);
        this.config.set("enable.turret.flameturret", (Object)this.turret_flameturret_enabled);
        this.config.set("enable.turret.pressuremine", (Object)this.turret_pressuremine_enabled);
        this.config.set("enable.turret.chemicalmine", (Object)this.turret_chemicalmine_enabled);
        this.config.set("enable.turret.healingtower", (Object)this.turret_healingtower_enabled);
        this.config.set("enable.turret.psionictotem", (Object)this.turret_psionictotem_enabled);
        this.config.set("enable.turret.soldierspawner", (Object)this.turret_soldierspawner_enabled);
        this.config.set("enable.turret.hellfire", (Object)this.turret_hellfire_enabled);
        this.config.set("enable.turret.heatbeam", (Object)this.turret_heatbeam_enabled);
        this.config.set("worlds-with-no-building-in-unoccupied-land", this.cannotBuildInNonLand);
        this.config.set("economy.money-needed-for-one-rp", (Object)this.economy_money_for_one_rp);
        this.config.set("use-whitelist", (Object)this.useWhiteList);
        this.config.set("resource-point-trade-blacklist", this.blacklist_items);
        this.config.set("whitelist-items", this.whitelist_items);
        this.config.set("special-item-cases", this.special_items);
        this.config.set("can-interact-in-safezone", this.safezoneenabledtouch);
        this.config.set("can-interact-in-warzone", this.warzoneenabledtouch);
        this.config.set("khome-delay", (Object)this.KHOMEDELAY);
        this.config.set("invite_expire_delay", (Object)this.invite_expire_delay);
        this.config.set("useKingdomPrefixes", (Object)this.useKingdomPrefixes);
        this.config.set("allowingNexusAccessForGameModes", this.allowingNexusAccessForGameModes);
        try {
            this.config.save(this.saveFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        try {
            this.config.load(this.saveFile);
            this.config.save(this.saveFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }
}

