/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.player;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.kingdoms.constants.ChatChannel;
import org.kingdoms.constants.Pioneer;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.KChestSign;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.player.Challenger;
import org.kingdoms.constants.player.Confirmable;
import org.kingdoms.constants.player.KSignModifier;
import org.kingdoms.constants.player.Markable;
import org.kingdoms.constants.player.Member;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.constants.player.PrivateChat;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KingdomPlayer
extends OfflineKingdomPlayer
implements KSignModifier,
Pioneer,
Challenger,
Member,
PrivateChat,
Markable,
Confirmable {
    private transient Player player = null;
    private transient Kingdom kingdom = null;
    private boolean isKMapOn = false;
    private transient SimpleChunkLocation loc;
    private transient boolean isAdminMode = false;
    private transient Location loginLocation;
    private transient boolean creatingKingdom = false;
    private transient Entity champion = null;
    transient SimpleChunkLocation fightZone = null;
    private transient Kingdom invited;
    private transient ChatChannel channel = ChatChannel.PUBLIC;
    private transient Queue<Location> blocks = new LinkedList<Location>();
    private transient long lastDisplayTime = 0L;
    private transient List<String> isConfirmed = new ArrayList<String>();
    private transient KChestSign modifyingSign = null;

    private KingdomPlayer() {
    }

    public KingdomPlayer(Player player) {
        super(player.getUniqueId());
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public Kingdom getKingdom() {
        if (this.kingdom == null && this.kingdomName != null) {
            this.kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(this.kingdomName);
        }
        return this.kingdom;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setKingdom(Kingdom kingdom) {
        this.kingdom = kingdom;
        super.setKingdomName(kingdom == null ? null : kingdom.getKingdomName());
    }

    public void sendMessage(String message) {
        this.player.sendMessage(String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Plugin_Display)) + " " + ChatColor.GRAY + message);
    }

    public void sendMessage(LanguageSupport.Languages lang) {
        String message = Kingdoms.getLang().parseFirstString(lang);
        this.sendMessage(message);
    }

    public boolean isKMapOn() {
        return this.isKMapOn;
    }

    public void setKMapOn(boolean isKMapOn) {
        this.isKMapOn = isKMapOn;
    }

    public SimpleChunkLocation getLoc() {
        return new SimpleChunkLocation(this.getPlayer().getLocation().getChunk());
    }

    public boolean isAdminMode() {
        return this.isAdminMode;
    }

    public void setAdminMode(boolean boo) {
        this.isAdminMode = boo;
    }

    public Location getLoginLocation() {
        return this.loginLocation;
    }

    public void setLoginLocation(Location loginLocation) {
        this.loginLocation = loginLocation;
    }

    @Override
    public boolean isProcessing() {
        return this.creatingKingdom;
    }

    @Override
    public void setProcessing(boolean bool) {
        this.creatingKingdom = bool;
    }

    @Override
    public Entity getChampionPlayerFightingWith() {
        return this.champion;
    }

    @Override
    public void setChampionPlayerFightingWith(Entity champion) {
        this.champion = champion;
    }

    @Override
    public SimpleChunkLocation getFightZone() {
        return this.fightZone;
    }

    @Override
    public void setInvadingChunk(SimpleChunkLocation loc) {
        this.fightZone = loc;
    }

    @Override
    public Kingdom getInvited() {
        return this.invited;
    }

    @Override
    public void setInvited(Kingdom kingdom) {
        this.invited = kingdom;
    }

    @Override
    public ChatChannel getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(ChatChannel channel) {
        this.channel = channel;
    }

    @Override
    public Queue<Location> getLastMarkedChunk() {
        return this.blocks;
    }

    @Override
    public Long getLastDisplayTime() {
        return this.lastDisplayTime;
    }

    @Override
    public void setLastDisplayTime(Long time) {
        this.lastDisplayTime = time;
    }

    @Override
    public boolean resetAllConfirmation() {
        if (this.isConfirmed.isEmpty()) {
            return false;
        }
        this.isConfirmed.clear();
        return true;
    }

    @Override
    public boolean isConfirmed(String key) {
        return this.isConfirmed.remove(key);
    }

    @Override
    public void setConfirmed(String key) {
        this.isConfirmed.add(key);
    }

    @Override
    public KChestSign getModifyingSign() {
        return this.modifyingSign;
    }

    @Override
    public void setModifyingSign(KChestSign sign) {
        this.modifyingSign = sign;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getUuid().hashCode() + (this.rank == null ? 0 : this.rank.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KingdomPlayer other = (KingdomPlayer)obj;
        return !(this.player == null ? other.player != null : !this.player.getUniqueId().equals(other.player.getUniqueId()));
    }
}

