/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.conquest;

import java.util.ArrayList;
import java.util.HashMap;
import org.kingdoms.constants.conquest.ConquestMap;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.game.ConquestManager;
import org.kingdoms.manager.game.GameManagement;

public class ConquestLand {
    public String map;
    public int x;
    public int y;
    private HashMap<Integer, Integer> turrets = new HashMap<Integer, Integer>(){
        {
            this.put(1, 0);
            this.put(2, 0);
            this.put(3, 0);
            this.put(4, 0);
        }
    };
    private int walllevel = 0;
    private int spawnerlevel = 0;
    private String owner;
    private int supplylevel;
    public boolean isUnderSiege;

    public String getDataID() {
        return String.valueOf(this.map) + "," + this.x + "," + this.y;
    }

    public ConquestLand(String id) {
        this.supplylevel = Kingdoms.config.maxSupplyLand;
        this.isUnderSiege = false;
        String[] split = id.replaceAll("_tmp", "").split(",");
        this.map = split[0];
        this.x = Integer.parseInt(split[1]);
        this.y = Integer.parseInt(split[2]);
    }

    public ConquestLand(ConquestMap conquest, int x, int y) {
        this.supplylevel = Kingdoms.config.maxSupplyLand;
        this.isUnderSiege = false;
        this.map = conquest.name;
        this.x = x;
        this.y = y;
    }

    public int getUpKeepAmount() {
        int upkeep = 0;
        for (int level : this.turrets.values()) {
            if (level <= 0) continue;
            upkeep += Kingdoms.config.conquestTurretUpkeepPerTurret;
        }
        if (this.walllevel > 0) {
            upkeep += Kingdoms.config.conquestWallUpkeep;
        }
        if (this.spawnerlevel > 0) {
            upkeep += Kingdoms.config.conquestSpawnerUpkeep;
        }
        return upkeep;
    }

    public static ConquestLand getLandAt(ConquestMap map, int x, int y) {
        for (ConquestLand land : map.lands) {
            if (land.x != x || land.y != y) continue;
            return land;
        }
        return null;
    }

    public Integer getTurretLevelAtSlot(int slot) {
        if (this.turrets.containsKey(slot)) {
            return this.turrets.get(slot);
        }
        return null;
    }

    public void setTurretLevelAtSlot(int slot, int level) {
        this.turrets.put(slot, level);
    }

    public void sellTurret(int slot) {
        this.turrets.put(slot, 0);
    }

    public int getWalllevel() {
        return this.walllevel;
    }

    public int getSpawnerlevel() {
        return this.spawnerlevel;
    }

    public void setWalllevel(int walllevel) {
        this.walllevel = walllevel;
    }

    public void setSpawnerlevel(int spawnerlevel) {
        this.spawnerlevel = spawnerlevel;
    }

    public String getOwner() {
        Kingdoms.getManagers();
        if (GameManagement.getKingdomManager().getOrLoadKingdom(this.owner) == null) {
            return null;
        }
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean isCapital() {
        if (this.x == 0 && this.y == 0) {
            return true;
        }
        if (this.x == 5 && this.y == 0) {
            return true;
        }
        if (this.x == 0 && this.y == 5) {
            return true;
        }
        return this.x == 5 && this.y == 5;
    }

    public int getSupplylevel() {
        return this.supplylevel;
    }

    public void setSupplylevel(int supplylevel) {
        this.supplylevel = supplylevel;
        if (this.supplylevel < 0) {
            this.supplylevel = 0;
        }
    }

    public boolean anyCloseBy(Kingdom k) {
        int x = -1;
        while (x <= 1) {
            int z = -1;
            while (z <= 1) {
                if (x != 0 || z != 0) {
                    ConquestLand land;
                    int newx = this.x - x;
                    int newz = this.y - z;
                    if (newx <= 5 && newx >= 0 && newz <= 5 && newz >= 0 && (land = ConquestLand.getLandAt(ConquestManager.maps.get(this.map), newx, newz)).getOwner() != null && land.getOwner().equals(k.getKingdomName())) {
                        return true;
                    }
                }
                ++z;
            }
            ++x;
        }
        return false;
    }

    public boolean canBeAttackedBy(OfflineKingdom kingdom) {
        for (ConquestLand land : this.getSurrounding()) {
            if (land.getOwner() == null || land.isEncircled() || !land.getOwner().equals(kingdom.getKingdomName())) continue;
            return true;
        }
        return false;
    }

    public boolean isEncircled() {
        if (this.getOwner() == null) {
            return false;
        }
        if (this.isCapital()) {
            return false;
        }
        if (this.isNotSurroundedByOwnedLand()) {
            return true;
        }
        for (ConquestLand land : this.getSurrounding()) {
            if (land.getOwner() == null || !land.getOwner().equals(this.getOwner())) continue;
            if (land.isCapital() && land.getOwner() != null && land.getOwner().equals(this.getOwner())) {
                return false;
            }
            for (ConquestLand subland : land.getSurrounding()) {
                if (subland.getOwner() == null || !subland.getOwner().equals(this.getOwner())) continue;
                if (subland.isCapital() && subland.getOwner() != null && subland.getOwner().equals(this.getOwner())) {
                    return false;
                }
                for (ConquestLand subsubland : subland.getSurrounding()) {
                    if (subsubland.getOwner() == null || !subsubland.getOwner().equals(this.getOwner())) continue;
                    if (subsubland.isCapital() && subsubland.getOwner() != null && subsubland.getOwner().equals(this.getOwner())) {
                        return false;
                    }
                    for (ConquestLand subsubsubland : subsubland.getSurrounding()) {
                        if (subsubsubland.getOwner() == null || !subsubsubland.getOwner().equals(this.getOwner())) continue;
                        if (subsubsubland.isCapital() && subsubsubland.getOwner() != null && subsubsubland.getOwner().equals(this.getOwner())) {
                            return false;
                        }
                        for (ConquestLand subsubsubsubland : subsubsubland.getSurrounding()) {
                            if (subsubsubsubland.getOwner() == null || !subsubsubsubland.getOwner().equals(this.getOwner())) continue;
                            if (subsubsubsubland.isCapital() && subsubsubsubland.getOwner() != null && subsubsubsubland.getOwner().equals(this.getOwner())) {
                                return false;
                            }
                            for (ConquestLand subsubsubsubsubland : subsubsubsubland.getSurrounding()) {
                                if (subsubsubsubsubland.getOwner() == null || !subsubsubsubsubland.getOwner().equals(this.getOwner()) || !subsubsubsubsubland.isCapital() || subsubsubsubsubland.getOwner() == null || !subsubsubsubsubland.getOwner().equals(this.getOwner())) continue;
                                return false;
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    public ArrayList<ConquestLand> getSurrounding() {
        ArrayList<ConquestLand> list = new ArrayList<ConquestLand>();
        int x = -1;
        while (x <= 1) {
            int z = -1;
            while (z <= 1) {
                int newx = this.x - x;
                int newz = this.y - z;
                if (newx <= 5 && newx >= 0 && newz <= 5 && newz >= 0 && (newx != this.x || newz != this.y)) {
                    ConquestLand land = ConquestLand.getLandAt(ConquestManager.maps.get(this.map), newx, newz);
                    list.add(land);
                }
                ++z;
            }
            ++x;
        }
        return list;
    }

    public boolean isNotSurroundedByOwnedLand() {
        if (this.isCapital()) {
            return false;
        }
        if (this.owner == null) {
            return false;
        }
        if (this.owner != null) {
            int x = -1;
            while (x <= 1) {
                int z = -1;
                while (z <= 1) {
                    ConquestLand land;
                    int newx = this.x - x;
                    int newz = this.y - z;
                    if (newx <= 5 && newx >= 0 && newz <= 5 && newz >= 0 && (newx != this.x || newz != this.y) && (land = ConquestLand.getLandAt(ConquestManager.maps.get(this.map), newx, newz)).getOwner() != null && land.getOwner().equals(this.getOwner())) {
                        return false;
                    }
                    ++z;
                }
                ++x;
            }
        }
        return true;
    }
}

