/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.generallib.strings.utils.EnglishChecker;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandSetlore
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return -1;
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.setlore");
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        if (kp.getKingdom() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!kp.getRank().isHigherOrEqualTo(Rank.KING)) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", "King"));
            return;
        }
        String lore = "";
        for (String str : args) {
            lore = String.valueOf(lore) + str + " ";
        }
        if (lore.length() > 30) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Setlore_Lore_Too_Long));
            return;
        }
        if (!EnglishChecker.isVailedLore((String)lore)) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Setlore_Invalid_Word));
            return;
        }
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Setlore_Success).replaceAll("%lore%", lore));
        kingdom.setKingdomLore(lore);
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Setlore);
    }
}

