/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandSethome
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 0;
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.sethome");
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        if (kp.getKingdom() == null) {
            Kingdoms.getInstance();
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getSethome())) {
            Kingdoms.getInstance();
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getSethome().toString()));
            return;
        }
        Land land = GameManagement.getLandManager().getOrLoadLand(kp.getLoc());
        if (land.getOwner() != null && land.getOwner().equals(kp.getKingdom().getKingdomName())) {
            kingdom.setHome_loc(kp.getPlayer().getLocation());
            Kingdoms.getInstance();
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Sethome_Success).replaceAll("%coords%", new SimpleLocation(kingdom.getHome_loc()).toString()));
        } else {
            Kingdoms.getInstance();
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Sethome_Not_On_Land));
        }
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Sethome);
    }
}

