/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandKing
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.king");
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer comittee = GameManagement.getPlayerManager().getSession(user);
        if (comittee.getKingdom() == null) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        Kingdom kingdom = comittee.getKingdom();
        if (!comittee.getRank().isHigherOrEqualTo(Rank.KING)) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", "King"));
            return;
        }
        String targetName = args.poll();
        OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)targetName);
        if (targetPlayer == null) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_Found));
            return;
        }
        OfflineKingdomPlayer target = GameManagement.getPlayerManager().getOfflineKingdomPlayer(targetPlayer.getUniqueId());
        if (target == null) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_Found));
            return;
        }
        if (!target.getKingdomName().equals(comittee.getKingdom().getKingdomName())) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_Found));
            return;
        }
        if (target.getRank() == Rank.KING) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Already_A_King));
            return;
        }
        comittee.setRank(Rank.ALL);
        if (target.isOnline()) {
            KingdomPlayer otarget = (KingdomPlayer)target;
            if (otarget.getKingdom() == null) {
                comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            if (!otarget.getKingdom().equals(kingdom)) {
                comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            otarget.setRank(Rank.KING);
        } else {
            if (target.getKingdomName() == null) {
                comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            if (!target.getKingdomName().equals(kingdom.getKingdomName())) {
                comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            target.setRank(Rank.KING);
        }
        kingdom.setKing(targetPlayer.getUniqueId());
        kingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Success_Broadcast).replaceAll("%player%", targetPlayer.getName()), true);
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_King);
    }
}

