/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.events.KingdomMemberLeaveEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandKick
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.kick");
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public synchronized void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer comittee = GameManagement.getPlayerManager().getSession(user);
        if (comittee.getKingdom() == null) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        Kingdom kingdom = comittee.getKingdom();
        if (!comittee.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getInvite())) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getInvite().toString()));
            return;
        }
        String targetName = args.poll();
        if (targetName.equals(user.getName())) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Kick_Cannot_Kick_Yourself));
            return;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)targetName);
        if (player == null) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Kick_Member_Not_Found));
            return;
        }
        if (!kingdom.getMembersList().contains(player.getUniqueId())) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Kick_Member_Not_In_Kingdom));
            return;
        }
        OfflineKingdomPlayer target = GameManagement.getPlayerManager().getOfflineKingdomPlayer(player);
        if (target.getRank().isHigherThan(comittee.getRank())) {
            comittee.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Kick_Rank_Error));
            return;
        }
        if (target.isOnline()) {
            target = target.getKingdomPlayer();
        }
        kingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Kick_Broadcast).replaceAll("%kicker%", user.getName()).replaceAll("%victim%", target.getName()), true);
        if (target.isOnline()) {
            target.getKingdomPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Kick_Message));
        }
        Bukkit.getPluginManager().callEvent((Event)new KingdomMemberLeaveEvent(target, target.getKingdomName()));
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Kick);
    }
}

