/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.task.DelayedDeclineOfferTask;

public class KCommandInvite
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.invite");
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer offerer = GameManagement.getPlayerManager().getSession(user);
        if (offerer.getKingdom() == null) {
            offerer.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        Kingdom kingdom = offerer.getKingdom();
        if (!offerer.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getInvite())) {
            offerer.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getInvite().toString()));
            return;
        }
        if (kingdom.getMembersList().size() == kingdom.getMaxMember()) {
            offerer.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Kingdom_Too_Many_Members));
            return;
        }
        String targetName = args.poll();
        Player player = Bukkit.getPlayer((String)targetName);
        if (player == null) {
            offerer.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invite_Player_Not_Online_Error));
            return;
        }
        KingdomPlayer target = GameManagement.getPlayerManager().getSession(player);
        if (target.getKingdom() != null) {
            offerer.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invite_Player_Is_In_Another_Kingdom_Error));
            return;
        }
        if (target.getInvited() != null) {
            offerer.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invite_Player_Has_Offer_Error));
            return;
        }
        target.setInvited(kingdom);
        offerer.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invite_Success).replaceAll("%player%", targetName));
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.getInstance(), (Runnable)new DelayedDeclineOfferTask(target), (long)Kingdoms.config.invite_expire_delay * 20L);
        target.sendMessage(ChatColor.GOLD + "===========================================");
        target.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invite_Text).replaceAll("%inviter%", user.getName()).replaceAll("%kingdom%", kingdom.getKingdomName()));
        target.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invite_Text2));
        target.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invite_Text3));
        Kingdoms.getLang().addInteger(Kingdoms.config.invite_expire_delay);
        target.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invite_Text4));
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Invite);
    }
}

