/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import org.bukkit.EntityEffect;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandInvade
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 0;
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.invade");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        final KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        if (kingdom.isNeutral()) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Neutral_Cannot_Invade));
            return;
        }
        if (kingdom.isShieldUp() && !Cooldown.isInCooldown(kp.getUuid(), "invadeshield")) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Shield_Up_Invade_Warning).replaceAll("%time%", "" + kingdom.getShieldTimeLeft()));
            Cooldown cd = new Cooldown(kp.getUuid(), "invadeshield", 5);
            cd.start();
            return;
        }
        if (kingdom.isShieldUp()) {
            kingdom.removeShield();
        }
        if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getInvade())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getInvade().toString()));
            return;
        }
        Kingdoms.getManagers();
        if (!GameManagement.getMasswarManager().isMassWarOn() && Kingdoms.config.canOnlyInvadeDuringMasswar) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Can_Only_Invade_During_Mass_War));
            return;
        }
        final Land land = GameManagement.getLandManager().getOrLoadLand(kp.getLoc());
        String owner = land.getOwner();
        if (owner == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invade_No_Occupant_Error));
            return;
        }
        if (owner.equalsIgnoreCase("safezone") || owner.equalsIgnoreCase("warzone")) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invade_SafeWarZone_Error));
            return;
        }
        if (owner.equals(kingdom.getKingdomName())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invade_Land_Ownded_Error));
            return;
        }
        Kingdoms.getManagers();
        Kingdom target = GameManagement.getKingdomManager().getOrLoadKingdom(owner);
        if (target == null) {
            return;
        }
        if (target.getOnlineMembers().size() < Kingdoms.config.minMembersOnlineForInvasion && target.getMembersList().size() >= Kingdoms.config.minMembersOnlineForInvasion) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invade_Kingdom_Owner_Not_Enough_Online).replaceAll("%number%", "" + Kingdoms.config.minMembersOnlineForInvasion));
            return;
        }
        if (target.isShieldUp()) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Cannot_Invade_Shielded).replaceAll("%time%", "" + target.getShieldTimeLeft()));
            return;
        }
        Kingdoms.getManagers();
        if (GameManagement.getKingdomManager().getOfflineKingdom(owner).isNeutral()) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Neutral_Cannot_Be_Invaded));
            return;
        }
        if (kingdom.getLand() >= Kingdoms.config.land_per_member * kingdom.getMembersList().size()) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Members_Needed).replaceAll("%amount%", "" + Kingdoms.config.land_per_member * kingdom.getMembersList().size()).replaceAll("%members%", "" + kingdom.getMembersList().size()));
            return;
        }
        if (Kingdoms.config.maximum_land_claims > 0 && kingdom.getLand() >= Kingdoms.config.maximum_land_claims) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Land_Reached));
            return;
        }
        final SimpleLocation loc = new SimpleLocation(kp.getPlayer().getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        if (!GameManagement.getStructureManager().isInvadeable(kp, chunk)) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invade_Powercell_Present_Error));
            return;
        }
        int cost = Kingdoms.config.invadecost;
        if (GameManagement.getMasswarManager().isMassWarOn()) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invade_MassWar_Boost));
        } else if (kingdom.getResourcepoints() >= cost) {
            kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
        } else {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + Kingdoms.config.invadecost));
            return;
        }
        if (kingdom.isAllianceWith(target) && target.isAllianceWith(kingdom)) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invade_Cannot_Ally));
            return;
        }
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invade_Commence));
        kingdom.setHasInvaded(true);
        kingdom.setNeutral(false);
        new BukkitRunnable(){

            public void run() {
                Kingdom target = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
                if (target != null) {
                    Kingdoms.getLang().addString(land.getLoc().toString());
                    target.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Invade_Warning), true);
                }
                Entity e = GameManagement.getChampionManager().startFight(loc, kp);
                if (!kp.getPlayer().isOp()) {
                    kp.getPlayer().setAllowFlight(false);
                }
                if (e != null) {
                    e.playEffect(EntityEffect.FIREWORK_EXPLODE);
                    e.playEffect(EntityEffect.VILLAGER_ANGRY);
                    e.playEffect(EntityEffect.VILLAGER_HAPPY);
                    e.playEffect(EntityEffect.VILLAGER_HEART);
                }
            }
        }.runTaskLater((Plugin)Kingdoms.getInstance(), 40L);
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Invade);
    }

    private static class Cooldown {
        private static Map<String, Cooldown> cooldowns = new HashMap<String, Cooldown>();
        private long start;
        private final int timeInSeconds;
        private final UUID id;
        private final String cooldownName;

        public Cooldown(UUID id, String cooldownName, int timeInSeconds) {
            this.id = id;
            this.cooldownName = cooldownName;
            this.timeInSeconds = timeInSeconds;
        }

        public static boolean isInCooldown(UUID id, String cooldownName) {
            if (Cooldown.getTimeLeft(id, cooldownName) >= 1) {
                return true;
            }
            Cooldown.stop(id, cooldownName);
            return false;
        }

        private static void stop(UUID id, String cooldownName) {
            cooldowns.remove(id + cooldownName);
        }

        private static Cooldown getCooldown(UUID id, String cooldownName) {
            return cooldowns.get(String.valueOf(id.toString()) + cooldownName);
        }

        public static int getTimeLeft(UUID id, String cooldownName) {
            Cooldown cooldown = Cooldown.getCooldown(id, cooldownName);
            int f = -1;
            if (cooldown != null) {
                long now = System.currentTimeMillis();
                long cooldownTime = cooldown.start;
                int totalTime = cooldown.timeInSeconds;
                int r = (int)(now - cooldownTime) / 1000;
                f = (r - totalTime) * -1;
            }
            return f;
        }

        public void start() {
            this.start = System.currentTimeMillis();
            cooldowns.put(String.valueOf(this.id.toString()) + this.cooldownName, this);
        }
    }
}

