/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Allegiance;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomAllegianceChangeEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandEnemy
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 2;
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.enemy");
    }

    @Override
    public String[] getUsage() {
        String[] str = new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Enemy), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Neutral)};
        return str;
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        if (kp.getKingdom() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getAlly())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getAlly().toString()));
            return;
        }
        String sel = args.poll();
        String targetName = args.poll();
        Kingdom target = GameManagement.getKingdomManager().getOrLoadKingdom(targetName);
        if (target == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Ally_Kingdom_Doesnt_Exist_Error).replaceAll("%kingdom%", kingdom.getKingdomName()));
            return;
        }
        switch (sel) {
            case "add": {
                Allegiance oldAllegiance = Allegiance.NEUTRAL;
                if (kingdom.isAllianceWith(target)) {
                    oldAllegiance = Allegiance.ALLY;
                }
                KingdomAllegianceChangeEvent kace = new KingdomAllegianceChangeEvent(kingdom, target, oldAllegiance, Allegiance.ENEMY);
                Bukkit.getPluginManager().callEvent((Event)kace);
                kingdom.enemyKingdom(target);
                target.enemyKingdom(kingdom);
                target.sendAnnouncement(kp, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Enemy_Success).replaceAll("%kingdom%", kingdom.getKingdomName()), false);
                kingdom.sendAnnouncement(kp, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Enemy_Success).replaceAll("%kingdom%", target.getKingdomName()), false);
                break;
            }
            case "break": {
                if (!kingdom.getEnemiesList().contains(target.getKingdomName())) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Enemy_Kingdom_Not_Enemy).replaceAll("%kingdom%", target.getKingdomName()));
                    return;
                }
                KingdomAllegianceChangeEvent kace = new KingdomAllegianceChangeEvent(kingdom, target, Allegiance.ENEMY, Allegiance.NEUTRAL);
                Bukkit.getPluginManager().callEvent((Event)kace);
                kingdom.getEnemiesList().remove(target.getKingdomName());
                kingdom.sendAnnouncement(kp, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Enemy_Break_Success).replaceAll("%kingdom%", target.getKingdomName()), false);
                if (!GameManagement.getKingdomManager().isOnline(target.getKingdomName())) break;
                kingdom.getOnlineEnemies().remove(target);
                break;
            }
            default: {
                user.sendMessage(this.getUsage());
            }
        }
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Enemy_Description);
    }
}

