/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandDemote
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.decline");
    }

    @Override
    public String[] getUsage() {
        return new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Demote_Usage1)};
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Demote_Description);
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        if (kp.getKingdom() == null) {
            Kingdoms.getInstance();
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!kp.getRank().isHigherOrEqualTo(Rank.KING)) {
            Kingdoms.getInstance();
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", "King"));
            return;
        }
        String targetName = args.poll();
        OfflinePlayer targetP = Bukkit.getOfflinePlayer((String)targetName);
        if (targetP == null) {
            Kingdoms.getInstance();
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Mod_Member_Not_Found));
            return;
        }
        OfflineKingdomPlayer target = GameManagement.getPlayerManager().getOfflineKingdomPlayer(targetP);
        if (target.getKingdomName() == null || !target.getKingdomName().equals(kingdom.getKingdomName())) {
            Kingdoms.getInstance();
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Mod_Player_Not_In));
            return;
        }
        if (target.getRank() != Rank.MODS) {
            Kingdoms.getInstance();
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Mod_Member_Not_Mod));
            return;
        }
        Kingdoms.getInstance();
        kp.sendMessage(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Demote_Broadcast).replaceAll("%player%", target.getName()));
        kp.getKingdom().sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Demote_Broadcast).replaceAll("%player%", target.getName()), true);
        target.setRank(Rank.ALL);
    }
}

