/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.generallib.strings.utils.EnglishChecker;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandCreateKingdom
extends KCommandBase {
    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.create");
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        final KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom != null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Create_Already_In_Kingdom_Error).replaceAll("%kingdom%", kingdom.getKingdomName()));
            return;
        }
        final String kingdomName = args.poll();
        if (!EnglishChecker.isEnglish((String)kingdomName) && !Kingdoms.config.allowSpecialCharactersInNamingKingdoms) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Create_Invalid_Name_Error));
            return;
        }
        if (kingdomName.equalsIgnoreCase("safezone") || kingdomName.equalsIgnoreCase("warzone")) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Create_Banned_Name));
            return;
        }
        if (kingdomName.length() > 12) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Create_Name_Too_Long_Error));
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (GameManagement.getKingdomManager().hasKingdom(kingdomName)) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Create_Name_Exists));
                    return;
                }
                if (GameManagement.getKingdomManager().createNewKingdom(kingdomName, kp)) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Create_Success));
                } else {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Previous_Request_Processing));
                }
            }
        }.runTaskAsynchronously((Plugin)Kingdoms.getInstance());
    }

    @Override
    public String[] getUsage() {
        return new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Usage_Create)};
    }

    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Create);
    }
}

