/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Allegiance;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomAllegianceChangeEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandAlly
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 2;
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.ally");
    }

    @Override
    public String[] getUsage() {
        String[] str = new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Ally), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Neutral)};
        return str;
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        if (kp.getKingdom() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Ally_No_Kingdom_Error));
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getAlly())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getAlly().name()));
            return;
        }
        String sel = args.poll();
        String targetName = args.poll();
        Kingdom target = GameManagement.getKingdomManager().getOrLoadKingdom(targetName);
        if (target == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Ally_Kingdom_Doesnt_Exist_Error).replaceAll("%kingdom%", targetName));
            return;
        }
        switch (sel) {
            case "add": {
                if (kingdom.getAlliesList().contains(target.getKingdomName())) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Ally_Kingdom_Already_Ally_Error).replaceAll("%kingdom%", target.getKingdomName()));
                    return;
                }
                if (kingdom.getEnemiesList().contains(target.getKingdomName())) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Ally_Kingdom_Is_Enemy_Error).replaceAll("%kingdom%", target.getKingdomName()));
                    return;
                }
                kingdom.getAlliesList().add(target.getKingdomName());
                kingdom.sendAnnouncement(kp, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Ally_Success).replaceAll("%kingdom%", target.getKingdomName()), false);
                if (kingdom.isAllianceWith(target)) {
                    Allegiance oldAllegiance = Allegiance.NEUTRAL;
                    if (kingdom.isEnemyWith(target)) {
                        oldAllegiance = Allegiance.ENEMY;
                    }
                    KingdomAllegianceChangeEvent kace = new KingdomAllegianceChangeEvent(kingdom, target, oldAllegiance, Allegiance.ALLY);
                    Bukkit.getPluginManager().callEvent((Event)kace);
                    target.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Get_Ally).replaceAll("%kingdom%", kingdom.getKingdomName()), true);
                    kingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Get_Ally).replaceAll("%kingdom%", target.getKingdomName()), true);
                }
                if (!GameManagement.getKingdomManager().isOnline(kingdom.getKingdomName())) break;
                kingdom.getOnlineAllies().add(target);
                break;
            }
            case "break": {
                if (!kingdom.getAlliesList().contains(target.getKingdomName())) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Ally_Kingdom_Not_Ally_Error).replaceAll("%kingdom%", target.getKingdomName()));
                    return;
                }
                KingdomAllegianceChangeEvent kace = new KingdomAllegianceChangeEvent(kingdom, target, Allegiance.ALLY, Allegiance.NEUTRAL);
                Bukkit.getPluginManager().callEvent((Event)kace);
                kingdom.getAlliesList().remove(target.getKingdomName());
                kingdom.sendAnnouncement(kp, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Ally_Break).replaceAll("%kingdom%", target.getKingdomName()), false);
                target.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Ally_Get_Break).replaceAll("%kingdom%", kingdom.getKingdomName()), true);
                if (!GameManagement.getKingdomManager().isOnline(kingdom.getKingdomName())) break;
                kingdom.getOnlineAllies().remove(target);
                break;
            }
            default: {
                user.sendMessage(this.getUsage());
            }
        }
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Ally_Description);
    }
}

