/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandAdminKing
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 2;
    }

    @Override
    public String[] getUsage() {
        return new String[]{ChatColor.GOLD + "/k admin king [name] [kingdom]" + ChatColor.GRAY + " - " + ChatColor.WHITE + "[name] for player name; [kingdom] for kingdom name"};
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Admin_King);
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.admin")) {
            return true;
        }
        return sender.hasPermission("kingdoms.admin.king");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
        ConsoleCommandSender user = Bukkit.getConsoleSender();
        String targetName = args.poll();
        String targetKName = args.poll();
        if (targetName == null || targetKName == null) {
            user.sendMessage("player name or kingdom name cannot be null.");
            return;
        }
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)targetName);
        if (op == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_Found));
            return;
        }
        OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(op);
        if (okp == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_Found));
            return;
        }
        if (okp.getKingdomName() == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_In_A_Kingdom));
            return;
        }
        OfflineKingdom ok = GameManagement.getKingdomManager().getOfflineKingdom(targetKName);
        if (ok == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Kingdom_Not_Found));
            return;
        }
        if (okp.isOnline()) {
            KingdomPlayer kp = okp.getKingdomPlayer();
            Kingdom kingdom = ok.getKingdom();
            if (kp.getKingdom() == null) {
                user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            if (!kp.getKingdom().equals(kingdom)) {
                user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            OfflineKingdomPlayer previousKing = GameManagement.getPlayerManager().getOfflineKingdomPlayer(kingdom.getKing());
            if (previousKing.isOnline()) {
                previousKing.getKingdomPlayer().setRank(Rank.ALL);
            } else {
                previousKing.setRank(Rank.ALL);
            }
            kingdom.setKing(kp.getUuid());
            kp.setRank(Rank.KING);
        } else {
            if (okp.getKingdomName() == null) {
                user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            if (!okp.getKingdomName().equals(ok.getKingdomName())) {
                user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            if (ok.isOnline()) {
                Kingdom kingdom = ok.getKingdom();
                OfflineKingdomPlayer previousKing = GameManagement.getPlayerManager().getOfflineKingdomPlayer(kingdom.getKing());
                if (previousKing.isOnline()) {
                    previousKing.getKingdomPlayer().setRank(Rank.ALL);
                } else {
                    previousKing.setRank(Rank.ALL);
                }
                kingdom.setKing(okp.getUuid());
                okp.setRank(Rank.KING);
            } else {
                OfflineKingdomPlayer previousKing = GameManagement.getPlayerManager().getOfflineKingdomPlayer(ok.getKing());
                if (previousKing.isOnline()) {
                    previousKing.getKingdomPlayer().setRank(Rank.ALL);
                } else {
                    previousKing.setRank(Rank.ALL);
                }
                ok.setKing(okp.getUuid());
                okp.setRank(Rank.KING);
            }
        }
        user.sendMessage(String.valueOf(okp.getName()) + " is now [" + (Object)((Object)okp.getRank()) + "]");
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player p, Queue<String> args) {
        String targetName = args.poll();
        String targetKName = args.poll();
        KingdomPlayer user = GameManagement.getPlayerManager().getSession(p);
        if (targetName == null || targetKName == null) {
            user.sendMessage("player name or kingdom name cannot be null.");
            return;
        }
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)targetName);
        if (op == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_Found));
            return;
        }
        OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(op);
        if (okp == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_Found));
            return;
        }
        if (okp.getKingdomName() == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_In_A_Kingdom));
            return;
        }
        OfflineKingdom ok = GameManagement.getKingdomManager().getOfflineKingdom(targetKName);
        if (ok == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Kingdom_Not_Found));
            return;
        }
        Kingdoms.logDebug((String)("okp.isOnline() " + okp.isOnline()));
        if (okp.isOnline()) {
            KingdomPlayer kp = okp.getKingdomPlayer();
            Kingdom kingdom = ok.getKingdom();
            if (kp.getKingdom() == null) {
                user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            if (!kp.getKingdom().equals(kingdom)) {
                user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            OfflineKingdomPlayer previousKing = GameManagement.getPlayerManager().getOfflineKingdomPlayer(kingdom.getKing());
            if (previousKing.isOnline()) {
                previousKing.getKingdomPlayer().setRank(Rank.ALL);
            } else {
                previousKing.setRank(Rank.ALL);
            }
            kingdom.setKing(kp.getUuid());
            kp.setRank(Rank.KING);
        } else {
            if (okp.getKingdomName() == null) {
                user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            if (!okp.getKingdomName().equals(ok.getKingdomName())) {
                user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_King_Member_Not_A_Member));
                return;
            }
            if (ok.isOnline()) {
                Kingdom kingdom = ok.getKingdom();
                if (!ok.getKing().equals(okp.getUuid())) {
                    OfflineKingdomPlayer previousKing = GameManagement.getPlayerManager().getOfflineKingdomPlayer(kingdom.getKing());
                    if (previousKing.isOnline()) {
                        previousKing.getKingdomPlayer().setRank(Rank.ALL);
                    } else {
                        previousKing.setRank(Rank.ALL);
                    }
                }
                kingdom.setKing(okp.getUuid());
            } else {
                if (!ok.getKing().equals(okp.getUuid())) {
                    OfflineKingdomPlayer previousKing = GameManagement.getPlayerManager().getOfflineKingdomPlayer(ok.getKing());
                    if (previousKing.isOnline()) {
                        previousKing.getKingdomPlayer().setRank(Rank.ALL);
                    } else {
                        previousKing.setRank(Rank.ALL);
                    }
                }
                ok.setKing(okp.getUuid());
            }
            okp.setRank(Rank.KING);
        }
        user.sendMessage(String.valueOf(okp.getName()) + " is now [" + (Object)((Object)okp.getRank()) + "]");
    }
}

