/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Queue;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.events.KingdomMemberJoinEvent;
import org.kingdoms.events.KingdomMemberLeaveEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandAdminJoin
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 2;
    }

    @Override
    public String[] getUsage() {
        return new String[]{ChatColor.GOLD + "/k admin join [name] [kingdom]" + ChatColor.GRAY + " - " + ChatColor.WHITE + "[name] for target player;[kingdom] for kingdom name"};
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.command_Help_Admin_Join);
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.admin")) {
            return true;
        }
        return sender.hasPermission("kingdoms.admin.join");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
        ConsoleCommandSender user = Bukkit.getConsoleSender();
        String targetName = args.poll();
        String targetKName = args.poll();
        if (targetName == null || targetKName == null) {
            String[] stringArray = this.getUsage();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String usage = stringArray[n2];
                user.sendMessage(usage);
                ++n2;
            }
            return;
        }
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)targetName);
        if (op == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Join_Member_Not_Found));
            return;
        }
        OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(op);
        if (okp == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Join_Member_Not_Found));
            return;
        }
        OfflineKingdom ok = GameManagement.getKingdomManager().getOfflineKingdom(targetKName);
        if (ok == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Join_Kingdom_Not_Found));
            return;
        }
        if (okp.isOnline()) {
            KingdomPlayer kp = okp.getKingdomPlayer();
            Kingdom joining = ok.getKingdom();
            OfflineKingdom previous = GameManagement.getKingdomManager().getOfflineKingdom(okp.getKingdomName());
            if (previous.isOnline()) {
                Kingdom oprevious = previous.getKingdom();
                Bukkit.getPluginManager().callEvent((Event)new KingdomMemberLeaveEvent(okp, oprevious.getKingdomName()));
            } else {
                previous.getMembersList().remove(okp.getName());
            }
            if (kp.getKingdom() != null) {
                Bukkit.getPluginManager().callEvent((Event)new KingdomMemberLeaveEvent(kp, kp.getKingdomName()));
            }
            Bukkit.getPluginManager().callEvent((Event)new KingdomMemberJoinEvent(kp, joining));
        } else {
            if (okp.getKingdomName() != null) {
                OfflineKingdom previous = GameManagement.getKingdomManager().getOfflineKingdom(okp.getKingdomName());
                if (previous.isOnline()) {
                    Kingdom oprevious = previous.getKingdom();
                    Bukkit.getPluginManager().callEvent((Event)new KingdomMemberLeaveEvent(okp, oprevious.getKingdomName()));
                } else {
                    previous.getMembersList().remove(okp.getName());
                }
            }
            if (ok.isOnline()) {
                Kingdom joining = ok.getKingdom();
                Bukkit.getPluginManager().callEvent((Event)new KingdomMemberJoinEvent(okp, joining));
            } else {
                ok.getMembersList().add(okp.getUuid());
                okp.setKingdomName(ok.getKingdomName());
            }
        }
        user.sendMessage(String.valueOf(okp.getName()) + " is now in [" + okp.getKingdomName() + "]");
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player p, Queue<String> args) {
        String targetName = args.poll();
        String targetKName = args.poll();
        KingdomPlayer user = GameManagement.getPlayerManager().getSession(p);
        if (targetName == null || targetKName == null) {
            user.sendMessage("player name or kingdom name cannot be null.");
            return;
        }
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)targetName);
        if (op == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Join_Member_Not_Found));
            return;
        }
        OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(op);
        if (okp == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Join_Member_Not_Found));
            return;
        }
        OfflineKingdom ok = GameManagement.getKingdomManager().getOfflineKingdom(targetKName);
        if (ok == null) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Join_Kingdom_Not_Found));
            return;
        }
        if (okp.getRank() == Rank.KING) {
            Kingdoms.getLang().addString(okp.getKingdomName());
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Join_King_Warning));
        }
        Kingdoms.logDebug((String)("okp.isOnline() " + okp.isOnline()));
        if (okp.isOnline()) {
            KingdomPlayer kp = okp.getKingdomPlayer();
            Kingdom joining = ok.getKingdom();
            Kingdoms.logDebug((String)("kp " + kp));
            Kingdoms.logDebug((String)("joining " + joining));
            if (kp.getKingdom() != null) {
                Bukkit.getPluginManager().callEvent((Event)new KingdomMemberLeaveEvent(kp, kp.getKingdomName()));
            }
            kp.setRank(Rank.ALL);
            kp.setKingdom(joining);
            Bukkit.getPluginManager().callEvent((Event)new KingdomMemberJoinEvent(kp, joining));
        } else {
            Kingdoms.logDebug((String)("okp.getKingdomName() " + okp.getKingdomName()));
            if (okp.getKingdomName() != null) {
                OfflineKingdom previous = GameManagement.getKingdomManager().getOfflineKingdom(okp.getKingdomName());
                Kingdoms.logDebug((String)("previous.isOnline() " + previous.isOnline()));
                if (previous.isOnline()) {
                    Kingdom oprevious = previous.getKingdom();
                    Bukkit.getPluginManager().callEvent((Event)new KingdomMemberLeaveEvent(okp, oprevious.getKingdomName()));
                } else {
                    previous.getMembersList().remove(okp.getName());
                }
            }
            Kingdoms.logDebug((String)("ok.isOnline() " + ok.isOnline()));
            if (ok.isOnline()) {
                Kingdom joining = ok.getKingdom();
                okp.setKingdomName(joining.getKingdomName());
                Bukkit.getPluginManager().callEvent((Event)new KingdomMemberJoinEvent(okp, joining));
            } else {
                okp.setKingdomName(ok.getKingdomName());
                ok.getMembersList().add(okp.getUuid());
            }
        }
        user.sendMessage(String.valueOf(okp.getName()) + " is now in [" + okp.getKingdomName() + "]");
    }
}

