/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.NamingException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.generallib.database.Database;
import org.generallib.database.tasks.DatabaseTransferTask;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.game.GameManagement;

public class KCommandAdminImport
extends KCommandBase {
    Set<String> dbTypes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER){
        {
            this.add("mysql");
            this.add("file");
        }
    };

    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public String[] getUsage() {
        return new String[]{"db types : " + this.dbTypes, "USAGE:", "If you type [/k admin import file], Data will be copied from your file database to your sql database.", "If you type [/k admin import sql], Data will be copied from your sql database to your file database."};
    }

    @Override
    public String getDescription() {
        return "/k admin import <from>";
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        return sender.hasPermission("kingdoms.admin");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
        String fromName = args.poll();
        if (!this.dbTypes.contains(fromName)) {
            Kingdoms.logInfo((String)("Invalid db type -- " + fromName));
            return;
        }
        ArrayList<Object> pairs = new ArrayList<Object>();
        if (fromName.equalsIgnoreCase("mysql")) {
            try {
                pairs.add(GameManagement.getPlayerManager().getTransferPair((Database<OfflineKingdomPlayer>)GameManagement.getPlayerManager().createMysqlDB()));
                pairs.add(GameManagement.getKingdomManager().getTransferPair((Database<OfflineKingdom>)GameManagement.getKingdomManager().createMysqlDB()));
                pairs.add(GameManagement.getLandManager().getTransferPair((Database<Land>)GameManagement.getLandManager().createMysqlDB()));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException | NamingException e) {
                e.printStackTrace();
            }
        } else {
            pairs.add(GameManagement.getPlayerManager().getTransferPair((Database<OfflineKingdomPlayer>)GameManagement.getPlayerManager().createFileDB()));
            pairs.add(GameManagement.getKingdomManager().getTransferPair((Database<OfflineKingdom>)GameManagement.getKingdomManager().createFileDB()));
            pairs.add(GameManagement.getLandManager().getTransferPair((Database<Land>)GameManagement.getLandManager().createFileDB()));
        }
        new Thread((Runnable)new DatabaseTransferTask((Plugin)Kingdoms.getInstance(), pairs)).start();
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
    }
}

